/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import b.a.lb;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationListener;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.AlternativeJreClassFinder;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.JvmSteppingCommandProvider;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.SimpleStackFrameContext;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.reference.SoftReference;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.Alarm;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.AbstractDebuggerSession;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerSession
implements AbstractDebuggerSession {
    private static final Logger m;
    private final MyDebuggerStateManager e;
    private volatile boolean f;
    private volatile int k;
    private DebuggerSessionState b;
    private final String o;
    private final DebugProcessImpl h;
    private final DebugEnvironment i;
    private final GlobalSearchScope j;
    private Sdk l;
    private final Sdk d;
    private final DebuggerContextImpl g;
    private final AtomicReference<ThreadReferenceProxyImpl> p;
    private final AtomicReference<ThreadReferenceProxyImpl> n;
    private final Alarm c;
    private boolean a;
    private static final long q;

    public boolean isSteppingThrough(ThreadReferenceProxyImpl threadProxy) {
        return Comparing.equal((Object)this.p.get(), (Object)threadProxy);
    }

    public void setSteppingThrough(ThreadReferenceProxyImpl threadProxy) {
        this.p.set(threadProxy);
    }

    public void clearSteppingThrough() {
        this.p.set(null);
        this.resetIgnoreStepFiltersFlag();
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope globalSearchScope = this.j;
        if (globalSearchScope == null) {
            DebuggerSession.a(0);
        }
        return globalSearchScope;
    }

    public Sdk getAlternativeJre() {
        return this.l;
    }

    public void setAlternativeJre(Sdk sdk) {
        this.l = sdk;
        ((AlternativeJreClassFinder)((Object)Extensions.findExtension((ExtensionPointName)PsiElementFinder.EP_NAME, (AreaInstance)this.getProject(), AlternativeJreClassFinder.class))).clearCache();
    }

    public Sdk getRunJre() {
        return this.d;
    }

    public DebugEnvironment getDebugEnvironment() {
        return this.i;
    }

    public boolean isModifiedClassesScanRequired() {
        return this.a;
    }

    public void setModifiedClassesScanRequired(boolean modifiedClassesScanRequired) {
        this.a = modifiedClassesScanRequired;
    }

    static DebuggerSession create(@NotNull DebugProcessImpl debugProcess, DebugEnvironment environment) throws ExecutionException {
        if (debugProcess == null) {
            DebuggerSession.a(1);
        }
        DebuggerSession debuggerSession = new DebuggerSession(environment.getSessionName(), debugProcess, environment);
        try {
            debuggerSession.b();
        }
        catch (ExecutionException executionException) {
            debuggerSession.dispose();
            throw executionException;
        }
        return debuggerSession;
    }

    private DebuggerSession(String sessionName, @NotNull DebugProcessImpl debugProcess, DebugEnvironment environment) {
        if (debugProcess == null) {
            DebuggerSession.a(2);
        }
        this.k = 0;
        this.b = null;
        this.p = new AtomicReference();
        this.n = new AtomicReference();
        this.c = new Alarm();
        this.a = false;
        this.o = sessionName;
        this.h = debugProcess;
        this.g = DebuggerContextImpl.createDebuggerContext(this, null, null, null);
        this.e = new MyDebuggerStateManager();
        this.b = new DebuggerSessionState(State.STOPPED, null);
        this.h.addDebugProcessListener(new MyDebugProcessListener(debugProcess));
        this.h.addEvaluationListener(new MyEvaluationListener());
        ValueLookupManager.getInstance((Project)this.getProject()).startListening();
        this.i = environment;
        this.j = environment.getSearchScope();
        this.l = environment.getAlternativeJre();
        this.d = environment.getRunJre();
    }

    @NotNull
    public DebuggerStateManager getContextManager() {
        MyDebuggerStateManager myDebuggerStateManager = this.e;
        if (myDebuggerStateManager == null) {
            DebuggerSession.a(3);
        }
        return myDebuggerStateManager;
    }

    public Project getProject() {
        return this.getProcess().getProject();
    }

    public String getSessionName() {
        return this.o;
    }

    @NotNull
    public DebugProcessImpl getProcess() {
        DebugProcessImpl debugProcessImpl = this.h;
        if (debugProcessImpl == null) {
            DebuggerSession.a(4);
        }
        return debugProcessImpl;
    }

    public State getState() {
        return this.b.myState;
    }

    public String getStateDescription() {
        long l2 = q ^ 0x6C2D0BDBEF96L;
        if (this.b.myDescription != null) {
            return this.b.myDescription;
        }
        switch (this.b.myState) {
            case STOPPED: {
                return DebuggerBundle.message((String)"status.debug.stopped", (Object[])new Object[0]);
            }
            case RUNNING: {
                return DebuggerBundle.message((String)"status.app.running", (Object[])new Object[0]);
            }
            case WAITING_ATTACH: {
                RemoteConnection remoteConnection = this.getProcess().getConnection();
                return DebuggerBundle.message((String)(remoteConnection.isServerMode() ? "status.listening" : "status.connecting"), (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(remoteConnection)});
            }
            case PAUSED: {
                return DebuggerBundle.message((String)"status.paused", (Object[])new Object[0]);
            }
            case WAIT_EVALUATION: {
                return DebuggerBundle.message((String)"status.waiting.evaluation.result", (Object[])new Object[0]);
            }
            case DISPOSED: {
                return DebuggerBundle.message((String)"status.debug.stopped", (Object[])new Object[0]);
            }
        }
        return null;
    }

    private void a(DebugProcessImpl.ResumeCommand resumeCommand, Event event) {
        this.n.set(this.getContextManager().getContext().getThreadProxy());
        this.getContextManager().setState(this.g, State.WAIT_EVALUATION, event, null);
        this.h.getManagerThread().schedule(resumeCommand);
    }

    public void stepOut(int stepSize) {
        JvmSteppingCommandProvider jvmSteppingCommandProvider;
        SuspendContextImpl suspendContextImpl = this.a();
        DebugProcessImpl.ResumeCommand resumeCommand = null;
        JvmSteppingCommandProvider[] jvmSteppingCommandProviderArray = (JvmSteppingCommandProvider[])JvmSteppingCommandProvider.EP_NAME.getExtensions();
        int n2 = jvmSteppingCommandProviderArray.length;
        for (int i10 = 0; i10 < n2 && (resumeCommand = (jvmSteppingCommandProvider = jvmSteppingCommandProviderArray[i10]).getStepOutCommand(suspendContextImpl, stepSize)) == null; ++i10) {
        }
        if (resumeCommand == null) {
            resumeCommand = this.h.createStepOutCommand(suspendContextImpl, stepSize);
        }
        this.setSteppingThrough(resumeCommand.getContextThread());
        this.a(resumeCommand, Event.STEP);
    }

    public void stepOut() {
        this.stepOut(-2);
    }

    public void stepOver(boolean ignoreBreakpoints, int stepSize) {
        JvmSteppingCommandProvider jvmSteppingCommandProvider;
        SuspendContextImpl suspendContextImpl = this.a();
        DebugProcessImpl.ResumeCommand resumeCommand = null;
        JvmSteppingCommandProvider[] jvmSteppingCommandProviderArray = (JvmSteppingCommandProvider[])JvmSteppingCommandProvider.EP_NAME.getExtensions();
        int n2 = jvmSteppingCommandProviderArray.length;
        for (int i10 = 0; i10 < n2 && (resumeCommand = (jvmSteppingCommandProvider = jvmSteppingCommandProviderArray[i10]).getStepOverCommand(suspendContextImpl, ignoreBreakpoints, stepSize)) == null; ++i10) {
        }
        if (resumeCommand == null) {
            resumeCommand = this.h.createStepOverCommand(suspendContextImpl, ignoreBreakpoints, stepSize);
        }
        this.setSteppingThrough(resumeCommand.getContextThread());
        this.a(resumeCommand, Event.STEP);
    }

    public void stepOver(boolean ignoreBreakpoints) {
        this.stepOver(ignoreBreakpoints, -2);
    }

    public void stepInto(boolean ignoreFilters, @Nullable MethodFilter smartStepFilter, int stepSize) {
        JvmSteppingCommandProvider jvmSteppingCommandProvider;
        SuspendContextImpl suspendContextImpl = this.a();
        DebugProcessImpl.ResumeCommand resumeCommand = null;
        JvmSteppingCommandProvider[] jvmSteppingCommandProviderArray = (JvmSteppingCommandProvider[])JvmSteppingCommandProvider.EP_NAME.getExtensions();
        int n2 = jvmSteppingCommandProviderArray.length;
        for (int i10 = 0; i10 < n2 && (resumeCommand = (jvmSteppingCommandProvider = jvmSteppingCommandProviderArray[i10]).getStepIntoCommand(suspendContextImpl, ignoreFilters, smartStepFilter, stepSize)) == null; ++i10) {
        }
        if (resumeCommand == null) {
            resumeCommand = this.h.createStepIntoCommand(suspendContextImpl, ignoreFilters, smartStepFilter, stepSize);
        }
        this.setSteppingThrough(resumeCommand.getContextThread());
        this.a(resumeCommand, Event.STEP);
    }

    public void stepInto(boolean ignoreFilters, @Nullable MethodFilter smartStepFilter) {
        this.stepInto(ignoreFilters, smartStepFilter, -2);
    }

    public void runToCursor(@NotNull XSourcePosition position, boolean ignoreBreakpoints) {
        long l2 = q ^ 0x4CDE3AC5B564L;
        if (position == null) {
            DebuggerSession.a(5);
        }
        try {
            DebugProcessImpl.ResumeCommand resumeCommand = this.h.createRunToCursorCommand(this.a(), position, ignoreBreakpoints);
            this.setSteppingThrough(resumeCommand.getContextThread());
            this.a(resumeCommand, Event.STEP);
        }
        catch (EvaluateException evaluateException) {
            Messages.showErrorDialog((String)evaluateException.getMessage(), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"RunToCursor")));
        }
    }

    public void resume() {
        SuspendContextImpl suspendContextImpl = this.a();
        if (suspendContextImpl != null) {
            this.clearSteppingThrough();
            this.a(this.h.createResumeCommand(suspendContextImpl), Event.RESUME);
        }
    }

    public void resetIgnoreStepFiltersFlag() {
        this.k = 0;
    }

    public void setIgnoreStepFiltersFlag(int currentStackFrameCount) {
        this.k = this.k <= 0 ? currentStackFrameCount : Math.min(this.k, currentStackFrameCount);
    }

    public boolean shouldIgnoreSteppingFilters() {
        return this.k > 0;
    }

    public void pause() {
        this.h.getManagerThread().schedule(this.h.createPauseCommand());
    }

    public void showExecutionPoint() {
        this.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(this, this.a()), State.PAUSED, Event.REFRESH, null);
    }

    public void refresh(boolean refreshWithStack) {
        State state = this.getState();
        DebuggerContextImpl debuggerContextImpl = this.e.getContext();
        DebuggerContextImpl debuggerContextImpl2 = DebuggerContextImpl.createDebuggerContext(this, debuggerContextImpl.getSuspendContext(), debuggerContextImpl.getThreadProxy(), debuggerContextImpl.getFrameProxy());
        this.e.setState(debuggerContextImpl2, state, refreshWithStack ? Event.REFRESH_WITH_STACK : Event.REFRESH, null);
    }

    public void dispose() {
        this.getProcess().dispose();
        this.clearSteppingThrough();
        this.n.set(null);
        DebuggerInvocationUtil.swingInvokeLater(this.getProject(), () -> {
            this.e.setState(this.g, State.DISPOSED, Event.DISPOSE, null);
            this.e.dispose();
        });
    }

    public boolean isStopped() {
        return this.getState() == State.STOPPED;
    }

    public boolean isAttached() {
        return !this.isStopped() && this.getState() != State.WAITING_ATTACH;
    }

    public boolean isPaused() {
        return this.getState() == State.PAUSED;
    }

    public boolean isConnecting() {
        return this.getState() == State.WAITING_ATTACH;
    }

    public boolean isEvaluating() {
        return this.f;
    }

    public boolean isRunning() {
        return this.getState() == State.RUNNING && !this.getProcess().getProcessHandler().isProcessTerminated();
    }

    private SuspendContextImpl a() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.getContextManager().getContext().getSuspendContext();
    }

    private void b() throws ExecutionException {
        long l2 = q ^ 0x4B38A7B3E919L;
        RemoteConnection remoteConnection = this.i.getRemoteConnection();
        this.h.attachVirtualMachine(this.i, this);
        this.getContextManager().setState(this.g, State.WAITING_ATTACH, Event.START_WAIT_ATTACH, DebuggerBundle.message((String)"status.waiting.attach", (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(remoteConnection)}));
    }

    public static void switchContext(@NotNull SuspendContextImpl suspendContext) {
        if (suspendContext == null) {
            DebuggerSession.a(6);
        }
        final DebugProcessImpl debugProcessImpl = suspendContext.getDebugProcess();
        debugProcessImpl.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContext){
            private static final long e = lb.a(-2730876551751256043L, 3481510856856937266L, MethodHandles.lookup().lookupClass()).a(255691317829028L);

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.b(0);
                }
                DebuggerSession debuggerSession = debugProcessImpl.getSession();
                DebuggerContextImpl debuggerContextImpl = DebuggerContextUtil.createDebuggerContext(debuggerSession, suspendContext);
                DebuggerInvocationUtil.invokeLater(debugProcessImpl.getProject(), () -> debuggerSession.getContextManager().setState(debuggerContextImpl, State.PAUSED, Event.PAUSE, null));
            }

            private static /* synthetic */ void b(int n2) {
                long l2 = e ^ 0x56EDA399A089L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/impl/DebuggerSession$1", "contextAction"));
            }
        });
    }

    private static String a(DebuggerContextImpl debuggerContextImpl) {
        long l2 = q ^ 0x144D9D065CB4L;
        SuspendContextImpl suspendContextImpl = debuggerContextImpl.getSuspendContext();
        if (suspendContextImpl != null && debuggerContextImpl.getThreadProxy() != suspendContextImpl.getThread()) {
            return DebuggerBundle.message((String)"status.paused.in.another.thread", (Object[])new Object[0]);
        }
        return null;
    }

    public static boolean enableBreakpointsDuringEvaluation() {
        long l2 = q ^ 0x2BF9E64B69D4L;
        return Registry.is((String)"debugger.enable.breakpoints.during.evaluation");
    }

    public void sessionResumed() {
        XDebugSession xDebugSession = this.getXDebugSession();
        if (xDebugSession != null) {
            xDebugSession.sessionResumed();
        }
    }

    @Nullable
    public XDebugSession getXDebugSession() {
        JavaDebugProcess javaDebugProcess = this.h.getXdebugProcess();
        return javaDebugProcess != null ? javaDebugProcess.getSession() : null;
    }

    static {
        q = lb.a(-4317380171499816597L, 7262945849361174448L, MethodHandles.lookup().lookupClass()).a(166459202767361L);
        long l2 = q ^ 0x7F78BA7FC13DL;
        m = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerSession");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = q ^ 0x3E82EB02CF2FL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/DebuggerSession";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/DebuggerSession";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcess";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runToCursor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "switchContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyEvaluationListener
    implements EvaluationListener {
        private MyEvaluationListener() {
        }

        @Override
        public void evaluationStarted(SuspendContextImpl context) {
            DebuggerSession.this.f = true;
        }

        @Override
        public void evaluationFinished(SuspendContextImpl context) {
            DebuggerSession.this.f = false;
        }
    }

    private static class BreakpointReachedNotificationListener
    extends NotificationListener.Adapter {
        private final WeakReference<SuspendContextImpl> a;
        private static final long b = lb.a(4561333103354885426L, -2237011606907767006L, MethodHandles.lookup().lookupClass()).a(129660635884223L);

        BreakpointReachedNotificationListener(SuspendContextImpl suspendContext) {
            this.a = new WeakReference<SuspendContextImpl>(suspendContext);
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e10) {
            if (notification == null) {
                BreakpointReachedNotificationListener.a(0);
            }
            if (e10 == null) {
                BreakpointReachedNotificationListener.a(1);
            }
            notification.hideBalloon();
            SuspendContextImpl suspendContextImpl = (SuspendContextImpl)((Object)SoftReference.dereference(this.a));
            if (suspendContextImpl != null) {
                DebuggerSession.switchContext(suspendContextImpl);
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = b ^ 0x500953D329D9L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/impl/DebuggerSession$BreakpointReachedNotificationListener";
            objectArray[2] = "hyperlinkActivated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyDebugProcessListener
    extends DebugProcessAdapterImpl {
        private final DebugProcessImpl a;
        private static final long b = lb.a(6622618527596486240L, 2029054268058894336L, MethodHandles.lookup().lookupClass()).a(219467587302206L);

        MyDebugProcessListener(DebugProcessImpl debugProcess) {
            this.a = debugProcess;
        }

        public void connectorIsReady() {
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> {
                long l2 = b ^ 0x387C2F09163AL;
                RemoteConnection remoteConnection = this.a.getConnection();
                String string = DebuggerBundle.message((String)(remoteConnection.isServerMode() ? "status.listening" : "status.connecting"), (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(remoteConnection)});
                DebuggerSession.this.getContextManager().setState(DebuggerSession.this.g, State.WAITING_ATTACH, Event.START_WAIT_ATTACH, string);
            });
        }

        @Override
        public void paused(SuspendContextImpl suspendContext) {
            SourcePosition sourcePosition;
            Object object;
            Collection<ThreadReferenceProxyImpl> collection;
            Object object2;
            Object object3;
            long l2 = b ^ 0x1621B1DECFCBL;
            m.debug("paused");
            Object object4 = suspendContext.getThread();
            if (!this.a(suspendContext)) {
                this.c();
                object3 = suspendContext.getThread();
                if (object3 != null && !(object2 = DebuggerUtilsEx.getEventDescriptors(suspendContext)).isEmpty()) {
                    XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"status.breakpoint.reached.in.thread", (Object[])new Object[]{((ThreadReferenceProxyImpl)object3).name()}), DebuggerBundle.message((String)"status.breakpoint.reached.in.thread.switch", (Object[])new Object[0]), NotificationType.INFORMATION, (NotificationListener)new BreakpointReachedNotificationListener(suspendContext)).notify(DebuggerSession.this.getProject());
                }
                if (((SuspendManagerImpl)this.a.getSuspendManager()).getPausedContexts().size() > 1) {
                    return;
                }
                object4 = (ThreadReferenceProxyImpl)DebuggerSession.this.p.get();
            } else {
                DebuggerSession.this.setSteppingThrough((ThreadReferenceProxyImpl)object4);
            }
            if (object4 == null) {
                m.assertTrue(suspendContext.getSuspendPolicy() == 2);
                object2 = DebuggerSession.this.getProcess().getSuspendManager().getPausedContext();
                if (object2 != null) {
                    object4 = ((SuspendContextImpl)((Object)object2)).getThread();
                }
                if (object4 == null) {
                    collection = DebuggerSession.this.getProcess().getVirtualMachineProxy().allThreads();
                    object = (ThreadReferenceProxyImpl)DebuggerSession.this.n.get();
                    if (object != null && collection.contains(object)) {
                        object4 = object;
                    } else {
                        for (ThreadReferenceProxyImpl threadReferenceProxyImpl : collection) {
                            if (!ThreadState.isEDT((String)threadReferenceProxyImpl.name())) continue;
                            object4 = threadReferenceProxyImpl;
                            break;
                        }
                        if (object4 == null) {
                            for (ThreadReferenceProxyImpl threadReferenceProxyImpl : collection) {
                                object4 = threadReferenceProxyImpl;
                                try {
                                    if (((ThreadReferenceProxyImpl)object4).status() != 1 || ((ThreadReferenceProxyImpl)object4).frameCount() <= 0) continue;
                                    break;
                                }
                                catch (EvaluateException evaluateException) {
                                }
                            }
                        }
                    }
                }
                collection = null;
                if (object4 != null) {
                    try {
                        while (!((ThreadReferenceProxyImpl)object4).isSuspended()) {
                            TimeoutUtil.sleep((long)10L);
                        }
                        collection = ((ThreadReferenceProxyImpl)object4).frameCount() > 0 ? ((ThreadReferenceProxyImpl)object4).frame(0) : null;
                    }
                    catch (ObjectCollectedException objectCollectedException) {
                        collection = null;
                    }
                    catch (EvaluateException evaluateException) {
                        collection = null;
                        m.error((Throwable)evaluateException);
                    }
                }
                object3 = new SimpleStackFrameContext((StackFrameProxy)collection, this.a);
            } else {
                object3 = suspendContext;
            }
            if (object4 != null) {
                try {
                    int n2 = ((ThreadReferenceProxyImpl)object4).frameCount();
                    if (n2 == 0 || n2 <= DebuggerSession.this.k) {
                        DebuggerSession.this.resetIgnoreStepFiltersFlag();
                    }
                }
                catch (EvaluateException evaluateException) {
                    m.info((Throwable)evaluateException);
                    DebuggerSession.this.resetIgnoreStepFiltersFlag();
                }
            }
            if ((sourcePosition = ContextUtil.getSourcePosition((StackFrameContext)object3)) != null) {
                collection = DebuggerUtilsEx.getEventDescriptors(suspendContext);
                object = suspendContext.getDebugProcess().getRequestsManager();
                PsiFile psiFile = sourcePosition.getFile();
                boolean bl2 = psiFile instanceof PsiCompiledElement;
                for (Pair pair2 : collection) {
                    String string;
                    Breakpoint breakpoint = (Breakpoint)pair2.getFirst();
                    if (!(breakpoint instanceof LineBreakpoint)) continue;
                    SourcePosition sourcePosition2 = ((BreakpointWithHighlighter)breakpoint).getSourcePosition();
                    if (sourcePosition2 == null || !bl2 && sourcePosition2.getLine() != sourcePosition.getLine()) {
                        ((RequestManagerImpl)object).deleteRequest(breakpoint);
                        ((RequestManagerImpl)object).setInvalid(breakpoint, DebuggerBundle.message((String)"error.invalid.breakpoint.source.changed", (Object[])new Object[0]));
                        breakpoint.updateUI();
                        continue;
                    }
                    if (!bl2) continue;
                    sourcePosition = sourcePosition2;
                    StackFrameProxy stackFrameProxy = object3.getFrameProxy();
                    try {
                        string = stackFrameProxy != null ? stackFrameProxy.location().declaringType().name() : "";
                    }
                    catch (EvaluateException evaluateException) {
                        string = "";
                    }
                    ((RequestManagerImpl)object).setInvalid(breakpoint, DebuggerBundle.message((String)"error.invalid.breakpoint.source.not.found", (Object[])new Object[]{string}));
                    breakpoint.updateUI();
                }
            }
            collection = DebuggerContextImpl.createDebuggerContext(DebuggerSession.this, suspendContext, (ThreadReferenceProxyImpl)object4, null);
            if (suspendContext.getThread() == object4) {
                ((DebuggerContextImpl)((Object)collection)).setPositionCache(sourcePosition);
            }
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> DebuggerSession.this.getContextManager().setState((DebuggerContextImpl)((Object)collection), State.PAUSED, Event.PAUSE, DebuggerSession.a(collection)));
        }

        private boolean a(SuspendContextImpl suspendContextImpl) {
            ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
            if (threadReferenceProxyImpl == null || suspendContextImpl.getSuspendPolicy() == 2 || DebuggerSession.this.isSteppingThrough(threadReferenceProxyImpl)) {
                return true;
            }
            SuspendContextImpl suspendContextImpl2 = DebuggerSession.this.getContextManager().getContext().getSuspendContext();
            if (suspendContextImpl2 == null) {
                return DebuggerSession.this.p.get() == null;
            }
            if (DebuggerSession.enableBreakpointsDuringEvaluation()) {
                ThreadReferenceProxyImpl threadReferenceProxyImpl2 = suspendContextImpl2.getThread();
                return threadReferenceProxyImpl2 == null || Comparing.equal((Object)threadReferenceProxyImpl2.getThreadReference(), (Object)threadReferenceProxyImpl.getThreadReference());
            }
            return false;
        }

        @Override
        public void resumed(SuspendContextImpl suspendContext) {
            SuspendContextImpl suspendContextImpl = DebuggerSession.this.getProcess().getSuspendManager().getPausedContext();
            ThreadReferenceProxyImpl threadReferenceProxyImpl = null;
            if (suspendContextImpl != null && suspendContext != null && suspendContext.getSuspendPolicy() == 1 && DebuggerSession.this.isSteppingThrough(suspendContext.getThread())) {
                threadReferenceProxyImpl = suspendContext.getThread();
            }
            DebuggerContextImpl debuggerContextImpl = suspendContextImpl != null ? DebuggerContextImpl.createDebuggerContext(DebuggerSession.this, suspendContextImpl, threadReferenceProxyImpl != null ? threadReferenceProxyImpl : suspendContextImpl.getThread(), null) : null;
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> {
                if (debuggerContextImpl != null) {
                    DebuggerSession.this.getContextManager().setState(debuggerContextImpl, State.PAUSED, Event.CONTEXT, DebuggerSession.a(debuggerContextImpl));
                } else {
                    DebuggerSession.this.getContextManager().setState(DebuggerSession.this.g, State.RUNNING, Event.CONTEXT, null);
                }
            });
        }

        @Override
        public void processAttached(DebugProcessImpl process2) {
            long l2 = b ^ 0x7A00B6B4E19EL;
            String string = DebuggerBundle.message((String)"status.connected", (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(process2.getConnection())});
            process2.printToConsole(string + "\n");
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> DebuggerSession.this.getContextManager().setState(DebuggerSession.this.g, State.RUNNING, Event.ATTACHED, string));
        }

        public void attachException(RunProfileState state, ExecutionException exception, RemoteConnection remoteConnection) {
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> {
                long l2 = b ^ 0x2A311C37FC7BL;
                String string = "";
                if (state instanceof RemoteState) {
                    string = DebuggerBundle.message((String)"status.connect.failed", (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(remoteConnection)});
                }
                string = string + exception.getMessage();
                DebuggerSession.this.getContextManager().setState(DebuggerSession.this.g, State.STOPPED, Event.DETACHED, string);
            });
        }

        @Override
        public void processDetached(DebugProcessImpl debugProcess, boolean closedByUser) {
            ProcessHandler processHandler;
            long l2 = b ^ 0x1231AF51C880L;
            if (!closedByUser && (processHandler = debugProcess.getProcessHandler()) != null) {
                processHandler.notifyTextAvailable(DebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(debugProcess.getConnection())}) + "\n", ProcessOutputTypes.SYSTEM);
            }
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> {
                long l2 = b ^ 0x4124206CE90FL;
                DebuggerSession.this.getContextManager().setState(DebuggerSession.this.g, State.STOPPED, Event.DETACHED, DebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{DebuggerUtilsImpl.getConnectionDisplayName(debugProcess.getConnection())}));
            });
            DebuggerSession.this.clearSteppingThrough();
        }

        public void threadStarted(@NotNull DebugProcess proc, ThreadReference thread) {
            if (proc == null) {
                MyDebugProcessListener.b(0);
            }
            this.c();
        }

        public void threadStopped(@NotNull DebugProcess proc, ThreadReference thread) {
            DebugProcessImpl debugProcessImpl;
            if (proc == null) {
                MyDebugProcessListener.b(1);
            }
            this.c();
            ThreadReferenceProxyImpl threadReferenceProxyImpl = (ThreadReferenceProxyImpl)DebuggerSession.this.p.get();
            if (threadReferenceProxyImpl != null && threadReferenceProxyImpl.getThreadReference() == thread) {
                DebuggerSession.this.clearSteppingThrough();
            }
            if ((debugProcessImpl = (DebugProcessImpl)proc).getRequestsManager().getFilterThread() == thread) {
                DebuggerManagerEx.getInstanceEx(proc.getProject()).getBreakpointManager().applyThreadFilter(debugProcessImpl, null);
            }
        }

        private void c() {
            DebuggerSession.this.c.cancelAllRequests();
            DebuggerSession.this.c.addRequest(() -> {
                DebuggerStateManager debuggerStateManager = DebuggerSession.this.getContextManager();
                debuggerStateManager.fireStateChanged(debuggerStateManager.getContext(), Event.THREADS_REFRESH);
            }, 100, ModalityState.NON_MODAL);
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            long l2 = b ^ 0x7FC9FF1CC3DL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "proc";
            objectArray2[1] = "com/intellij/debugger/impl/DebuggerSession$MyDebugProcessListener";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "threadStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "threadStopped";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DebuggerSessionState {
        final State myState;
        final String myDescription;

        DebuggerSessionState(State state, String description) {
            this.myState = state;
            this.myDescription = description;
        }
    }

    private class MyDebuggerStateManager
    extends DebuggerStateManager {
        private DebuggerContextImpl b;
        private static final long c = lb.a(-1656701804940773251L, -6092380475537318148L, MethodHandles.lookup().lookupClass()).a(159318882660796L);

        MyDebuggerStateManager() {
            this.b = DebuggerSession.this.g;
        }

        @Override
        @NotNull
        public DebuggerContextImpl getContext() {
            DebuggerContextImpl debuggerContextImpl = this.b;
            if (debuggerContextImpl == null) {
                MyDebuggerStateManager.b(0);
            }
            return debuggerContextImpl;
        }

        @Override
        public void setState(final @NotNull DebuggerContextImpl context, State state, Event event, String description) {
            if (context == null) {
                MyDebuggerStateManager.b(1);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            DebuggerSession debuggerSession = context.getDebuggerSession();
            m.assertTrue(debuggerSession == DebuggerSession.this || debuggerSession == null);
            final Runnable runnable = () -> {
                long l2 = c ^ 0x17EAE196EB58L;
                if (context == null) {
                    MyDebuggerStateManager.b(2);
                }
                m.assertTrue(this.b.isInitialised());
                this.b = context;
                if (m.isDebugEnabled()) {
                    m.debug("DebuggerSession state = " + (Object)((Object)state) + ", event = " + (Object)((Object)event));
                }
                DebuggerSession.this.f = false;
                DebuggerSession.this.b = new DebuggerSessionState(state, description);
                this.fireStateChanged(context, event);
            };
            if (context.getSuspendContext() == null) {
                runnable.run();
            } else {
                DebuggerSession.this.getProcess().getManagerThread().schedule(new SuspendContextCommandImpl(context.getSuspendContext()){
                    private static final long e = lb.a(-6774473250592169514L, 7779740600768405298L, MethodHandles.lookup().lookupClass()).a(112675433107034L);

                    @Override
                    public PrioritizedTask.Priority getPriority() {
                        return PrioritizedTask.Priority.HIGH;
                    }

                    @Override
                    public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                        if (suspendContext == null) {
                            1.b(0);
                        }
                        context.initCaches();
                        DebuggerInvocationUtil.swingInvokeLater(DebuggerSession.this.getProject(), runnable);
                    }

                    private static /* synthetic */ void b(int n2) {
                        long l2 = e ^ 0xD054FEA002L;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/impl/DebuggerSession$MyDebuggerStateManager$1", "contextAction"));
                    }
                });
            }
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x54E37C79B338L;
            switch (n2) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/impl/DebuggerSession$MyDebuggerStateManager";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContext";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/impl/DebuggerSession$MyDebuggerStateManager";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$setState$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class Event
    extends Enum<Event> {
        public static final /* enum */ Event ATTACHED;
        public static final /* enum */ Event DETACHED;
        public static final /* enum */ Event RESUME;
        public static final /* enum */ Event STEP;
        public static final /* enum */ Event PAUSE;
        public static final /* enum */ Event REFRESH;
        public static final /* enum */ Event CONTEXT;
        public static final /* enum */ Event START_WAIT_ATTACH;
        public static final /* enum */ Event DISPOSE;
        public static final /* enum */ Event REFRESH_WITH_STACK;
        public static final /* enum */ Event THREADS_REFRESH;
        private static final /* synthetic */ Event[] a;

        public static Event[] values() {
            return (Event[])a.clone();
        }

        public static Event valueOf(String name2) {
            return Enum.valueOf(Event.class, name2);
        }

        static {
            long l2 = lb.a(3953183183341621239L, 4136535510200750488L, MethodHandles.lookup().lookupClass()).a(224464804940375L) ^ 0x2C8789828014L;
            ATTACHED = new Event();
            DETACHED = new Event();
            RESUME = new Event();
            STEP = new Event();
            PAUSE = new Event();
            REFRESH = new Event();
            CONTEXT = new Event();
            START_WAIT_ATTACH = new Event();
            DISPOSE = new Event();
            REFRESH_WITH_STACK = new Event();
            THREADS_REFRESH = new Event();
            a = new Event[]{ATTACHED, DETACHED, RESUME, STEP, PAUSE, REFRESH, CONTEXT, START_WAIT_ATTACH, DISPOSE, REFRESH_WITH_STACK, THREADS_REFRESH};
        }
    }

    public static final class State
    extends Enum<State> {
        public static final /* enum */ State STOPPED;
        public static final /* enum */ State RUNNING;
        public static final /* enum */ State WAITING_ATTACH;
        public static final /* enum */ State PAUSED;
        public static final /* enum */ State WAIT_EVALUATION;
        public static final /* enum */ State DISPOSED;
        private static final /* synthetic */ State[] a;

        public static State[] values() {
            return (State[])a.clone();
        }

        public static State valueOf(String name2) {
            return Enum.valueOf(State.class, name2);
        }

        static {
            long l2 = lb.a(-4710595733091242565L, 8065404171764666386L, MethodHandles.lookup().lookupClass()).a(18788277076064L) ^ 0x691ED945E42L;
            STOPPED = new State();
            RUNNING = new State();
            WAITING_ATTACH = new State();
            PAUSED = new State();
            WAIT_EVALUATION = new State();
            DISPOSED = new State();
            a = new State[]{STOPPED, RUNNING, WAITING_ATTACH, PAUSED, WAIT_EVALUATION, DISPOSED};
        }
    }
}

