/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import b.a.lb;
import com.intellij.application.options.CodeStyle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.SourcePositionHighlighter;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactoryContextWrapper;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.execution.filters.ExceptionFilters;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.content.Content;
import com.intellij.unscramble.ThreadDumpPanel;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.DocumentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerUtilsEx
extends DebuggerUtils {
    private static final Logger d;
    private static Set<String> f;
    private static int b;
    private static int c;
    private static final String a = "Dump";
    private static final Key<Map<String, String>> e;
    public static final Comparator<Method> LAMBDA_ORDINAL_COMPARATOR;
    private static final long h;

    public static List<CodeFragmentFactory> getCodeFragmentFactories(@Nullable PsiElement context) {
        DefaultCodeFragmentFactory defaultCodeFragmentFactory = DefaultCodeFragmentFactory.getInstance();
        CodeFragmentFactory[] codeFragmentFactoryArray = (CodeFragmentFactory[])ApplicationManager.getApplication().getExtensions(CodeFragmentFactory.EXTENSION_POINT_NAME);
        ArrayList<CodeFragmentFactory> arrayList = new ArrayList<CodeFragmentFactory>(codeFragmentFactoryArray.length);
        if (codeFragmentFactoryArray.length > 0) {
            for (CodeFragmentFactory codeFragmentFactory : codeFragmentFactoryArray) {
                if (codeFragmentFactory == defaultCodeFragmentFactory || !codeFragmentFactory.isContextAccepted(context)) continue;
                arrayList.add(codeFragmentFactory);
            }
        }
        arrayList.add(defaultCodeFragmentFactory);
        return arrayList;
    }

    public static PsiMethod findPsiMethod(PsiFile file, int offset) {
        PsiElement psiElement = null;
        while (offset >= 0 && (psiElement = file.findElementAt(offset)) == null) {
            --offset;
        }
        while (psiElement != null) {
            if (psiElement instanceof PsiClass || psiElement instanceof PsiLambdaExpression) {
                return null;
            }
            if (psiElement instanceof PsiMethod) {
                return (PsiMethod)psiElement;
            }
            psiElement = psiElement.getParent();
        }
        return null;
    }

    public static boolean isAssignableFrom(@NotNull String baseQualifiedName, @NotNull ReferenceType checkedType) {
        long l2 = h ^ 0x3CED7A53CD0BL;
        if (baseQualifiedName == null) {
            DebuggerUtilsEx.a(0);
        }
        if (checkedType == null) {
            DebuggerUtilsEx.a(1);
        }
        if ("java.lang.Object".equals(baseQualifiedName)) {
            return true;
        }
        return DebuggerUtilsEx.getSuperClass(baseQualifiedName, checkedType) != null;
    }

    public static ReferenceType getSuperClass(@NotNull String baseQualifiedName, @NotNull ReferenceType checkedType) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (baseQualifiedName == null) {
            DebuggerUtilsEx.a(2);
        }
        if (checkedType == null) {
            DebuggerUtilsEx.a(3);
        }
        if (baseQualifiedName.equals(checkedType.name())) {
            return checkedType;
        }
        if (checkedType instanceof ClassType) {
            object4 = (ClassType)checkedType;
            object3 = object4.superclass();
            if (object3 != null && (object2 = DebuggerUtilsEx.getSuperClass(baseQualifiedName, (ReferenceType)object3)) != null) {
                return object2;
            }
            object2 = object4.allInterfaces();
            object = object2.iterator();
            while (object.hasNext()) {
                InterfaceType interfaceType = (InterfaceType)object.next();
                ReferenceType referenceType = DebuggerUtilsEx.getSuperClass(baseQualifiedName, interfaceType);
                if (referenceType == null) continue;
                return referenceType;
            }
        }
        if (checkedType instanceof InterfaceType) {
            object4 = ((InterfaceType)checkedType).superinterfaces();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (InterfaceType)object3.next();
                object = DebuggerUtilsEx.getSuperClass(baseQualifiedName, (ReferenceType)object2);
                if (object == null) continue;
                return object;
            }
        }
        return null;
    }

    public static boolean valuesEqual(Value val1, Value val2) {
        if (val1 == null) {
            return val2 == null;
        }
        if (val2 == null) {
            return false;
        }
        if (val1 instanceof StringReference && val2 instanceof StringReference) {
            return ((StringReference)val1).value().equals(((StringReference)val2).value());
        }
        return val1.equals(val2);
    }

    public static String getValueOrErrorAsString(EvaluationContext evaluationContext, Value value) {
        try {
            return DebuggerUtilsEx.getValueAsString((EvaluationContext)evaluationContext, (Value)value);
        }
        catch (EvaluateException evaluateException) {
            return evaluateException.getMessage();
        }
    }

    public static boolean isCharOrInteger(Value value) {
        return value instanceof CharValue || DebuggerUtilsEx.isInteger((Value)value);
    }

    public static boolean isCharOrIntegerArray(Value value) {
        if (value == null) {
            return false;
        }
        if (f == null) {
            f = new HashSet<String>();
            f.add("C");
            f.add("B");
            f.add("S");
            f.add("I");
            f.add("J");
        }
        String string = value.type().signature();
        int n2 = 0;
        while (string.charAt(n2) == '[') {
            ++n2;
        }
        if (n2 == 0) {
            return false;
        }
        string = string.substring(n2);
        return f.contains(string);
    }

    public static ClassFilter create(Element element) throws InvalidDataException {
        ClassFilter classFilter = new ClassFilter();
        DefaultJDOMExternalizer.readExternal((Object)classFilter, (Element)element);
        return classFilter;
    }

    private static boolean a(ClassFilter classFilter, String string) {
        if (!classFilter.isEnabled()) {
            return false;
        }
        try {
            if (classFilter.matches(string)) {
                return true;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            d.debug((Throwable)patternSyntaxException);
        }
        return false;
    }

    public static boolean isFiltered(@NotNull String qName, ClassFilter[] classFilters) {
        if (qName == null) {
            DebuggerUtilsEx.a(4);
        }
        return DebuggerUtilsEx.isFiltered(qName, Arrays.asList(classFilters));
    }

    public static boolean isFiltered(@NotNull String qName, List<? extends ClassFilter> classFilters) {
        if (qName == null) {
            DebuggerUtilsEx.a(5);
        }
        if (qName.indexOf(91) != -1) {
            return false;
        }
        return classFilters.stream().anyMatch(classFilter -> {
            if (qName == null) {
                DebuggerUtilsEx.a(31);
            }
            return DebuggerUtilsEx.a(classFilter, qName);
        });
    }

    public static int getEnabledNumber(ClassFilter[] classFilters) {
        return (int)Arrays.stream(classFilters).filter(ClassFilter::isEnabled).count();
    }

    public static ClassFilter[] readFilters(List<? extends Element> children2) {
        if (ContainerUtil.isEmpty(children2)) {
            return ClassFilter.EMPTY_ARRAY;
        }
        ClassFilter[] classFilterArray = new ClassFilter[children2.size()];
        int n2 = children2.size();
        for (int i10 = 0; i10 < n2; ++i10) {
            try {
                classFilterArray[i10] = DebuggerUtilsEx.create(children2.get(i10));
                continue;
            }
            catch (InvalidDataException invalidDataException) {
                d.error((Throwable)invalidDataException);
            }
        }
        return classFilterArray;
    }

    public static void writeFilters(Element parentNode, @NonNls String tagName, ClassFilter[] filters) throws WriteExternalException {
        for (ClassFilter classFilter : filters) {
            Element element = new Element(tagName);
            parentNode.addContent(element);
            DefaultJDOMExternalizer.writeExternal((Object)classFilter, (Element)element);
        }
    }

    public static boolean filterEquals(ClassFilter[] filters1, ClassFilter[] filters2) {
        if (filters1.length != filters2.length) {
            return false;
        }
        HashSet hashSet = new HashSet(Math.max((int)((float)filters1.length / 0.75f) + 1, 16));
        HashSet hashSet2 = new HashSet(Math.max((int)((float)filters2.length / 0.75f) + 1, 16));
        Collections.addAll(hashSet, filters1);
        Collections.addAll(hashSet2, filters2);
        return hashSet2.equals(hashSet);
    }

    private static boolean b(List<? extends Element> list2, List<? extends Element> list3) {
        if (list2 == null) {
            return list3 == null;
        }
        if (list3 == null) {
            return false;
        }
        if (list2.size() != list3.size()) {
            return false;
        }
        Iterator<? extends Element> iterator = list2.iterator();
        for (Element element : list3) {
            Element element2 = iterator.next();
            if (DebuggerUtilsEx.elementsEqual(element2, element)) continue;
            return false;
        }
        return true;
    }

    private static boolean a(List<? extends Attribute> list2, List<? extends Attribute> list3) {
        if (list2 == null) {
            return list3 == null;
        }
        if (list3 == null) {
            return false;
        }
        if (list2.size() != list3.size()) {
            return false;
        }
        Iterator<? extends Attribute> iterator = list2.iterator();
        for (Attribute attribute : list3) {
            Attribute attribute2 = iterator.next();
            if (Comparing.equal((String)attribute2.getName(), (String)attribute.getName()) && Comparing.equal((String)attribute2.getValue(), (String)attribute.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean elementsEqual(Element e12, Element e22) {
        if (e12 == null) {
            return e22 == null;
        }
        if (!Comparing.equal((String)e12.getName(), (String)e22.getName())) {
            return false;
        }
        if (!DebuggerUtilsEx.b(e12.getChildren(), e22.getChildren())) {
            return false;
        }
        return DebuggerUtilsEx.a(e12.getAttributes(), e22.getAttributes());
    }

    public static boolean externalizableEqual(JDOMExternalizable e12, JDOMExternalizable e22) {
        long l2 = h ^ 0x4DF787907960L;
        Element element = new Element("root");
        Element element2 = new Element("root");
        try {
            e12.writeExternal(element);
        }
        catch (WriteExternalException writeExternalException) {
            d.debug((Throwable)writeExternalException);
        }
        try {
            e22.writeExternal(element2);
        }
        catch (WriteExternalException writeExternalException) {
            d.debug((Throwable)writeExternalException);
        }
        return DebuggerUtilsEx.elementsEqual(element, element2);
    }

    @NotNull
    public static List<Pair<Breakpoint, Event>> getEventDescriptors(@Nullable SuspendContextImpl suspendContext) {
        EventSet eventSet;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (suspendContext != null && !ContainerUtil.isEmpty((Collection)(eventSet = suspendContext.getEventSet()))) {
            List list2 = ContainerUtil.newSmartList();
            for (Event event : eventSet) {
                Requestor requestor = RequestManagerImpl.findRequestor(event.request());
                if (!(requestor instanceof Breakpoint)) continue;
                list2.add(Pair.create((Object)((Breakpoint)requestor), (Object)event));
            }
            List list3 = list2;
            if (list3 == null) {
                DebuggerUtilsEx.a(6);
            }
            return list3;
        }
        List<Pair<Breakpoint, Event>> list4 = Collections.emptyList();
        if (list4 == null) {
            DebuggerUtilsEx.a(7);
        }
        return list4;
    }

    public static TextWithImports getEditorText(Editor editor) {
        if (editor == null) {
            return null;
        }
        Project project2 = editor.getProject();
        if (project2 == null) {
            return null;
        }
        String string = editor.getSelectionModel().getSelectedText();
        if (string == null) {
            TextWithImports textWithImports;
            EditorTextProvider editorTextProvider;
            PsiElement psiElement;
            int n2 = editor.getCaretModel().getOffset();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            if (psiFile != null && (psiElement = psiFile.findElementAt(n2)) != null && (editorTextProvider = (EditorTextProvider)EditorTextProvider.EP.forLanguage(psiElement.getLanguage())) != null && (textWithImports = editorTextProvider.getEditorText(psiElement)) != null) {
                return textWithImports;
            }
        } else {
            return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, string);
        }
        return null;
    }

    public static void addThreadDump(Project project2, List<ThreadState> threads2, RunnerLayoutUi ui, DebuggerSession session) {
        long l2 = h ^ 0x17DF227E1696L;
        TextConsoleBuilder textConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project2);
        textConsoleBuilder.filters(ExceptionFilters.getFilters((GlobalSearchScope)session.getSearchScope()));
        ConsoleView consoleView = textConsoleBuilder.getConsole();
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        consoleView.allowHeavyFilters();
        ThreadDumpPanel threadDumpPanel = new ThreadDumpPanel(project2, consoleView, defaultActionGroup, threads2);
        String string = "Dump #" + c;
        Content content = ui.createContent(string, (JComponent)threadDumpPanel, string, null, null);
        content.putUserData(RunnerContentUi.LIGHTWEIGHT_CONTENT_MARKER, (Object)Boolean.TRUE);
        content.setCloseable(true);
        content.setDescription("Thread Dump");
        ui.addContent(content);
        ui.selectAndFocus(content, true, true);
        ++b;
        ++c;
        Disposer.register((Disposable)content, (Disposable)new Disposable(){

            public void dispose() {
                b--;
                if (b == 0) {
                    c = 1;
                }
            }
        });
        Disposer.register((Disposable)content, (Disposable)consoleView);
        ui.selectAndFocus(content, true, false);
        if (threads2.size() > 0) {
            threadDumpPanel.selectStackFrame(0);
        }
    }

    @Deprecated
    public static void keep(Value value, EvaluationContext context) {
        context.keep(value);
    }

    public static StringReference mirrorOfString(@NotNull String s2, VirtualMachineProxyImpl virtualMachineProxy, EvaluationContext context) throws EvaluateException {
        if (s2 == null) {
            DebuggerUtilsEx.a(8);
        }
        return (StringReference)context.computeAndKeep(() -> {
            if (s2 == null) {
                DebuggerUtilsEx.a(30);
            }
            return virtualMachineProxy.mirrorOf(s2);
        });
    }

    public static ArrayReference mirrorOfArray(@NotNull ArrayType arrayType, int dimension, EvaluationContext context) throws EvaluateException {
        if (arrayType == null) {
            DebuggerUtilsEx.a(9);
        }
        return (ArrayReference)context.computeAndKeep(() -> {
            if (arrayType == null) {
                DebuggerUtilsEx.a(29);
            }
            return context.getDebugProcess().newInstance(arrayType, dimension);
        });
    }

    public abstract DebuggerTreeNode getSelectedNode(DataContext var1);

    public abstract EvaluatorBuilder getEvaluatorBuilder();

    @NotNull
    public static CodeFragmentFactory getCodeFragmentFactory(@Nullable PsiElement context, @Nullable FileType fileType) {
        DefaultCodeFragmentFactory defaultCodeFragmentFactory = DefaultCodeFragmentFactory.getInstance();
        if (fileType == null) {
            if (context == null) {
                DefaultCodeFragmentFactory defaultCodeFragmentFactory2 = defaultCodeFragmentFactory;
                if (defaultCodeFragmentFactory2 == null) {
                    DebuggerUtilsEx.a(10);
                }
                return defaultCodeFragmentFactory2;
            }
            CodeFragmentFactory[] codeFragmentFactoryArray = context.getContainingFile();
            fileType = codeFragmentFactoryArray != null ? codeFragmentFactoryArray.getFileType() : null;
        }
        for (CodeFragmentFactory codeFragmentFactory : (CodeFragmentFactory[])ApplicationManager.getApplication().getExtensions(CodeFragmentFactory.EXTENSION_POINT_NAME)) {
            if (codeFragmentFactory == defaultCodeFragmentFactory || fileType != null && !codeFragmentFactory.getFileType().equals(fileType) || !codeFragmentFactory.isContextAccepted(context)) continue;
            CodeFragmentFactory codeFragmentFactory2 = codeFragmentFactory;
            if (codeFragmentFactory2 == null) {
                DebuggerUtilsEx.a(11);
            }
            return codeFragmentFactory2;
        }
        DefaultCodeFragmentFactory defaultCodeFragmentFactory3 = defaultCodeFragmentFactory;
        if (defaultCodeFragmentFactory3 == null) {
            DebuggerUtilsEx.a(12);
        }
        return defaultCodeFragmentFactory3;
    }

    @NotNull
    public static CodeFragmentFactory findAppropriateCodeFragmentFactory(TextWithImports text2, PsiElement context) {
        CodeFragmentFactory codeFragmentFactory = (CodeFragmentFactory)ReadAction.compute(() -> DebuggerUtilsEx.getCodeFragmentFactory(context, text2.getFileType()));
        CodeFragmentFactoryContextWrapper codeFragmentFactoryContextWrapper = new CodeFragmentFactoryContextWrapper(codeFragmentFactory);
        if (codeFragmentFactoryContextWrapper == null) {
            DebuggerUtilsEx.a(13);
        }
        return codeFragmentFactoryContextWrapper;
    }

    public static String methodKey(Method m2) {
        return m2.declaringType().name() + '.' + m2.name() + m2.signature();
    }

    public static String methodNameWithArguments(Method m2) {
        long l2 = h ^ 0x5B9434F38BE1L;
        return m2.name() + "(" + StringUtil.join(m2.argumentTypeNames(), StringUtil::getShortName, (String)", ") + ")";
    }

    public static String methodName(Method m2) {
        return DebuggerUtilsEx.methodName(DebuggerUtilsEx.signatureToName(m2.declaringType().signature()), m2.name(), m2.signature());
    }

    public static String methodName(final String className, final String methodName, String signature) {
        long l2 = h ^ 0x6E49DE45D5C2L;
        try {
            return new SigReader(signature){

                @Override
                String getMethodName() {
                    return methodName;
                }

                @Override
                String getClassName() {
                    return className;
                }
            }.getSignature();
        }
        catch (Exception exception) {
            if (d.isDebugEnabled()) {
                d.debug("Internal error : unknown signature" + signature);
            }
            return className + "." + methodName;
        }
    }

    public static String signatureToName(String s2) {
        return new SigReader(s2).getSignature();
    }

    @Nullable
    public static List<Location> allLineLocations(Method method) {
        try {
            return method.allLineLocations();
        }
        catch (AbsentInformationException absentInformationException) {
            return null;
        }
    }

    @Nullable
    public static List<Location> allLineLocations(ReferenceType cls) {
        try {
            return cls.allLineLocations();
        }
        catch (AbsentInformationException absentInformationException) {
            return null;
        }
        catch (ObjectCollectedException objectCollectedException) {
            return Collections.emptyList();
        }
    }

    public static int getLineNumber(Location location, boolean zeroBased) {
        try {
            return location.lineNumber() - (zeroBased ? 1 : 0);
        }
        catch (IllegalArgumentException | InternalError throwable) {
            return -1;
        }
    }

    public static String getSourceName(Location location, Function<? super Throwable, String> defaultName) {
        try {
            return location.sourceName();
        }
        catch (AbsentInformationException | InternalError throwable) {
            return defaultName.apply(throwable);
        }
    }

    public static boolean isVoid(@NotNull Method method) {
        long l2 = h ^ 0x66D4BB174EF2L;
        if (method == null) {
            DebuggerUtilsEx.a(14);
        }
        return "void".equals(method.returnTypeName());
    }

    @Nullable
    public static Method getMethod(Location location) {
        try {
            return location.method();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            d.info((Throwable)illegalArgumentException);
            return null;
        }
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, double value) {
        if (PsiType.DOUBLE.getName().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        if (PsiType.FLOAT.getName().equals(expectedType)) {
            return vm.mirrorOf((float)value);
        }
        if (PsiType.LONG.getName().equals(expectedType)) {
            return vm.mirrorOf((long)value);
        }
        if (PsiType.INT.getName().equals(expectedType)) {
            return vm.mirrorOf((int)value);
        }
        if (PsiType.SHORT.getName().equals(expectedType)) {
            return vm.mirrorOf((short)value);
        }
        if (PsiType.BYTE.getName().equals(expectedType)) {
            return vm.mirrorOf((byte)value);
        }
        if (PsiType.CHAR.getName().equals(expectedType)) {
            return vm.mirrorOf((char)value);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, long value) {
        if (PsiType.LONG.getName().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        if (PsiType.INT.getName().equals(expectedType)) {
            return vm.mirrorOf((int)value);
        }
        if (PsiType.SHORT.getName().equals(expectedType)) {
            return vm.mirrorOf((short)value);
        }
        if (PsiType.BYTE.getName().equals(expectedType)) {
            return vm.mirrorOf((byte)value);
        }
        if (PsiType.CHAR.getName().equals(expectedType)) {
            return vm.mirrorOf((char)value);
        }
        if (PsiType.DOUBLE.getName().equals(expectedType)) {
            return vm.mirrorOf((double)value);
        }
        if (PsiType.FLOAT.getName().equals(expectedType)) {
            return vm.mirrorOf((float)value);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, boolean value) {
        if (PsiType.BOOLEAN.getName().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, char value) {
        if (PsiType.CHAR.getName().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        if (PsiType.LONG.getName().equals(expectedType)) {
            return vm.mirrorOf((long)value);
        }
        if (PsiType.INT.getName().equals(expectedType)) {
            return vm.mirrorOf((int)value);
        }
        if (PsiType.SHORT.getName().equals(expectedType)) {
            return vm.mirrorOf((short)value);
        }
        if (PsiType.BYTE.getName().equals(expectedType)) {
            return vm.mirrorOf((byte)value);
        }
        if (PsiType.DOUBLE.getName().equals(expectedType)) {
            return vm.mirrorOf((double)value);
        }
        if (PsiType.FLOAT.getName().equals(expectedType)) {
            return vm.mirrorOf((float)value);
        }
        return null;
    }

    public static String truncateString(String str) {
        if (str.length() > 1005) {
            return str.substring(0, 1005);
        }
        return str;
    }

    public static String getThreadStatusText(int statusId) {
        long l2 = h ^ 0x3E845DCA3105L;
        switch (statusId) {
            case 3: {
                return DebuggerBundle.message((String)"status.thread.monitor", (Object[])new Object[0]);
            }
            case 5: {
                return DebuggerBundle.message((String)"status.thread.not.started", (Object[])new Object[0]);
            }
            case 1: {
                return DebuggerBundle.message((String)"status.thread.running", (Object[])new Object[0]);
            }
            case 2: {
                return DebuggerBundle.message((String)"status.thread.sleeping", (Object[])new Object[0]);
            }
            case -1: {
                return DebuggerBundle.message((String)"status.thread.unknown", (Object[])new Object[0]);
            }
            case 4: {
                return DebuggerBundle.message((String)"status.thread.wait", (Object[])new Object[0]);
            }
            case 0: {
                return DebuggerBundle.message((String)"status.thread.zombie", (Object[])new Object[0]);
            }
        }
        return DebuggerBundle.message((String)"status.thread.undefined", (Object[])new Object[0]);
    }

    public static String prepareValueText(String text2, Project project2) {
        text2 = StringUtil.unquoteString((String)text2);
        text2 = StringUtil.unescapeStringCharacters((String)text2);
        int n2 = CodeStyle.getSettings((Project)project2).getTabSize((FileType)StdFileTypes.JAVA);
        if (n2 < 0) {
            n2 = 0;
        }
        return text2.replace("\t", StringUtil.repeat((String)" ", (int)n2));
    }

    public static void setAlternativeSourceUrl(String className, String source, Project project2) {
        ConcurrentHashMap<String, String> concurrentHashMap = (ConcurrentHashMap<String, String>)project2.getUserData(e);
        if (concurrentHashMap == null) {
            concurrentHashMap = new ConcurrentHashMap<String, String>();
            project2.putUserData(e, concurrentHashMap);
        }
        concurrentHashMap.put(className, source);
    }

    @Nullable
    public static String getAlternativeSourceUrl(@Nullable String className, Project project2) {
        Map map2 = (Map)project2.getUserData(e);
        return map2 != null ? (String)map2.get(className) : null;
    }

    @Nullable
    public static XSourcePosition toXSourcePosition(@Nullable SourcePosition position) {
        if (position != null) {
            VirtualFile virtualFile = position.getFile().getVirtualFile();
            if (virtualFile == null) {
                virtualFile = position.getFile().getOriginalFile().getVirtualFile();
            }
            if (virtualFile != null) {
                return new JavaXSourcePosition(position, virtualFile);
            }
        }
        return null;
    }

    @Nullable
    public static SourcePosition toSourcePosition(@Nullable XSourcePosition position, Project project2) {
        if (position != null) {
            if (position instanceof JavaXSourcePosition) {
                return ((JavaXSourcePosition)position).b;
            }
            PsiFile psiFile = DebuggerUtilsEx.getPsiFile(position, project2);
            if (psiFile != null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)position.getLine());
            }
        }
        return null;
    }

    @Nullable
    public static TextRange intersectWithLine(@Nullable TextRange range, @Nullable PsiFile file, int line) {
        Document document;
        if (range != null && file != null && (document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file)) != null) {
            range = range.intersection(DocumentUtil.getLineTextRange((Document)document, (int)line));
        }
        return range;
    }

    @Nullable
    public static PsiFile getPsiFile(@Nullable XSourcePosition position, Project project2) {
        VirtualFile virtualFile;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (position != null && (virtualFile = position.getFile()).isValid()) {
            return PsiManager.getInstance((Project)project2).findFile(virtualFile);
        }
        return null;
    }

    @Nullable
    public static PsiElement findElementAt(@Nullable PsiFile file, int offset) {
        return file != null ? file.findElementAt(offset) : null;
    }

    public static String getLocationMethodQName(@NotNull Location location) {
        if (location == null) {
            DebuggerUtilsEx.a(15);
        }
        StringBuilder stringBuilder = new StringBuilder();
        ReferenceType referenceType = location.declaringType();
        if (referenceType != null) {
            stringBuilder.append(referenceType.name()).append('.');
        }
        stringBuilder.append(location.method().name());
        return stringBuilder.toString();
    }

    private static PsiElement a(PsiElement psiElement) {
        PsiElement psiElement2 = psiElement.getNextSibling();
        if (psiElement2 != null) {
            return psiElement2;
        }
        if ((psiElement = psiElement.getParent()) != null) {
            return DebuggerUtilsEx.a(psiElement);
        }
        return null;
    }

    public static boolean isLambdaClassName(String typeName) {
        return DebuggerUtilsEx.getLambdaBaseClassName(typeName) != null;
    }

    @Nullable
    public static String getLambdaBaseClassName(String typeName) {
        long l2 = h ^ 0x1AA6247A8397L;
        return StringUtil.substringBefore((String)typeName, (String)"$$Lambda$");
    }

    public static boolean isLambdaName(@Nullable String name2) {
        long l2 = h ^ 0x2112FA488658L;
        return !StringUtil.isEmpty((String)name2) && name2.startsWith("lambda$");
    }

    public static boolean isLambda(@Nullable Method method) {
        return method != null && DebuggerUtilsEx.isLambdaName(method.name());
    }

    public static int getLambdaOrdinal(@NotNull String name2) {
        if (name2 == null) {
            DebuggerUtilsEx.a(16);
        }
        return StringUtil.parseInt((String)StringUtil.substringAfterLast((String)name2, (String)"$"), (int)-1);
    }

    public static List<PsiLambdaExpression> collectLambdas(@NotNull SourcePosition position, final boolean onlyOnTheLine) {
        PsiElement psiElement;
        if (position == null) {
            DebuggerUtilsEx.a(17);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile psiFile = position.getFile();
        final int n2 = position.getLine();
        final Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        if (document == null || n2 >= document.getLineCount()) {
            return Collections.emptyList();
        }
        PsiElement psiElement2 = position.getElementAt();
        if (psiElement2 == null) {
            return Collections.emptyList();
        }
        TextRange textRange = DocumentUtil.getLineTextRange((Document)document, (int)n2);
        while ((psiElement = psiElement2.getParent()) != null && psiElement.getTextOffset() >= textRange.getStartOffset()) {
            psiElement2 = psiElement;
        }
        psiElement = new SmartList();
        JavaRecursiveElementVisitor javaRecursiveElementVisitor = new JavaRecursiveElementVisitor((List)psiElement){
            final /* synthetic */ List val$lambdas;
            {
                this.val$lambdas = list2;
            }

            public void visitLambdaExpression(PsiLambdaExpression expression) {
                super.visitLambdaExpression(expression);
                if (!onlyOnTheLine || DebuggerUtilsEx.getFirstElementOnTheLine(expression, document, n2) != null) {
                    this.val$lambdas.add(expression);
                }
            }
        };
        psiElement2.accept((PsiElementVisitor)javaRecursiveElementVisitor);
        PsiElement psiElement3 = DebuggerUtilsEx.a(psiElement2);
        while (psiElement3 != null && DebuggerUtilsEx.intersects(textRange, psiElement3)) {
            psiElement3.accept((PsiElementVisitor)javaRecursiveElementVisitor);
            psiElement3 = DebuggerUtilsEx.a(psiElement3);
        }
        psiElement3 = DebuggerUtilsEx.getContainingMethod(psiElement2);
        if (psiElement3 instanceof PsiLambdaExpression && !psiElement.contains(psiElement3)) {
            psiElement.add((PsiLambdaExpression)psiElement3);
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement getBody(PsiElement method) {
        if (method instanceof PsiParameterListOwner) {
            return ((PsiParameterListOwner)method).getBody();
        }
        if (method instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)method).getBody();
        }
        return null;
    }

    @NotNull
    public static PsiParameter[] getParameters(PsiElement method) {
        if (method instanceof PsiParameterListOwner) {
            PsiParameter[] psiParameterArray = ((PsiParameterListOwner)method).getParameterList().getParameters();
            if (psiParameterArray == null) {
                DebuggerUtilsEx.a(18);
            }
            return psiParameterArray;
        }
        if (PsiParameter.EMPTY_ARRAY == null) {
            DebuggerUtilsEx.a(19);
        }
        return PsiParameter.EMPTY_ARRAY;
    }

    public static boolean evaluateBoolean(ExpressionEvaluator evaluator, EvaluationContextImpl context) throws EvaluateException {
        long l2 = h ^ 0x3C593EB2561EL;
        Object object = UnBoxingEvaluator.unbox(evaluator.evaluate((EvaluationContext)context), context);
        if (!(object instanceof BooleanValue)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.boolean.expected", (Object[])new Object[0]));
        }
        return ((BooleanValue)object).booleanValue();
    }

    public static boolean intersects(@NotNull TextRange range, @NotNull PsiElement elem) {
        TextRange textRange;
        if (range == null) {
            DebuggerUtilsEx.a(20);
        }
        if (elem == null) {
            DebuggerUtilsEx.a(21);
        }
        return (textRange = elem.getTextRange()) != null && textRange.intersects(range);
    }

    @Nullable
    public static PsiElement getFirstElementOnTheLine(PsiLambdaExpression lambda2, Document document, int line) {
        PsiStatement[] psiStatementArray;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TextRange textRange = DocumentUtil.getLineTextRange((Document)document, (int)line);
        if (!DebuggerUtilsEx.intersects(textRange, (PsiElement)lambda2)) {
            return null;
        }
        PsiElement psiElement = lambda2.getBody();
        if (psiElement == null || !DebuggerUtilsEx.intersects(textRange, psiElement)) {
            return null;
        }
        if (psiElement instanceof PsiCodeBlock && (psiStatementArray = ((PsiCodeBlock)psiElement).getStatements()).length > 0) {
            for (PsiStatement psiStatement : psiStatementArray) {
                if (textRange.contains(psiStatement.getTextOffset())) {
                    return psiStatement;
                }
                if (!DebuggerUtilsEx.intersects(textRange, (PsiElement)psiStatement)) continue;
                for (PsiElement psiElement2 : SyntaxTraverser.psiTraverser((PsiElement)psiStatement)) {
                    if (!textRange.contains(psiElement2.getTextOffset())) continue;
                    return psiElement2;
                }
            }
            return null;
        }
        return psiElement;
    }

    public static boolean inTheMethod(@NotNull SourcePosition pos, @NotNull PsiElement method) {
        PsiElement psiElement;
        if (pos == null) {
            DebuggerUtilsEx.a(22);
        }
        if (method == null) {
            DebuggerUtilsEx.a(23);
        }
        if ((psiElement = pos.getElementAt()) == null) {
            return false;
        }
        return Comparing.equal((Object)DebuggerUtilsEx.getContainingMethod(psiElement), (Object)method);
    }

    public static boolean inTheSameMethod(@NotNull SourcePosition pos1, @NotNull SourcePosition pos2) {
        if (pos1 == null) {
            DebuggerUtilsEx.a(24);
        }
        if (pos2 == null) {
            DebuggerUtilsEx.a(25);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiElement psiElement = pos1.getElementAt();
        PsiElement psiElement2 = pos2.getElementAt();
        if (psiElement == null) {
            return psiElement2 == null;
        }
        if (psiElement2 != null) {
            PsiElement psiElement3 = DebuggerUtilsEx.getContainingMethod(psiElement);
            PsiElement psiElement4 = DebuggerUtilsEx.getContainingMethod(psiElement2);
            return Comparing.equal((Object)psiElement3, (Object)psiElement4);
        }
        return false;
    }

    public static boolean methodMatches(@NotNull PsiMethod psiMethod, String className, String name2, String signature, DebugProcessImpl process2) {
        if (psiMethod == null) {
            DebuggerUtilsEx.a(26);
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        try {
            return psiClass != null && Objects.equals(JVMNameUtil.getClassVMName(psiClass), className) && JVMNameUtil.getJVMMethodName(psiMethod).equals(name2) && JVMNameUtil.getJVMSignature(psiMethod).getName(process2).equals(signature);
        }
        catch (EvaluateException evaluateException) {
            d.debug((Throwable)evaluateException);
            return false;
        }
    }

    @Nullable
    public static PsiElement getContainingMethod(@Nullable PsiElement elem) {
        return PsiTreeUtil.getContextOfType((PsiElement)elem, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class, PsiClassInitializer.class});
    }

    @Nullable
    public static PsiElement getContainingMethod(@Nullable SourcePosition position) {
        if (position == null) {
            return null;
        }
        return DebuggerUtilsEx.getContainingMethod(position.getElementAt());
    }

    public static void disableCollection(ObjectReference reference) {
        try {
            reference.disableCollection();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static void enableCollection(ObjectReference reference) {
        try {
            reference.enableCollection();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static int bytecodeToSourceLine(PsiFile psiFile, int originalLine) {
        int n2;
        LineNumbersMapping lineNumbersMapping;
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null && (lineNumbersMapping = (LineNumbersMapping)virtualFile.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY)) != null && (n2 = lineNumbersMapping.bytecodeToSource(originalLine + 1)) > -1) {
            return n2 - 1;
        }
        return -1;
    }

    public static boolean isInLibraryContent(@Nullable VirtualFile file, @NotNull Project project2) {
        if (project2 == null) {
            DebuggerUtilsEx.a(27);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (project2 == null) {
                DebuggerUtilsEx.a(28);
            }
            if (file == null) {
                return true;
            }
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
            return projectFileIndex.isInLibraryClasses(file) || projectFileIndex.isInLibrarySource(file);
        });
    }

    public static boolean isInJavaSession(AnActionEvent e10) {
        Project project2;
        XDebugSession xDebugSession = (XDebugSession)e10.getData(XDebugSession.DATA_KEY);
        if (xDebugSession == null && (project2 = e10.getProject()) != null) {
            xDebugSession = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
        }
        return xDebugSession != null && xDebugSession.getDebugProcess() instanceof JavaDebugProcess;
    }

    static {
        h = lb.a(-4963195878109172315L, 7963701886076851634L, MethodHandles.lookup().lookupClass()).a(91630884105034L);
        long l2 = h ^ 0x7DF5BD9F4747L;
        d = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerUtilsEx");
        b = 0;
        c = 1;
        e = Key.create((String)"DEBUGGER_ALTERNATIVE_SOURCE_MAPPING");
        LAMBDA_ORDINAL_COMPARATOR = Comparator.comparingInt(method -> DebuggerUtilsEx.getLambdaOrdinal(method.name()));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0x1249DF907FDEL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseQualifiedName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedType";
                break;
            }
            case 4: 
            case 5: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/DebuggerUtilsEx";
                break;
            }
            case 8: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 9: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos1";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos2";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/DebuggerUtilsEx";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventDescriptors";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeFragmentFactory";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findAppropriateCodeFragmentFactory";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableFrom";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFiltered";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mirrorOfString";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mirrorOfArray";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isVoid";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLocationMethodQName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaOrdinal";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectLambdas";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "inTheMethod";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "inTheSameMethod";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "methodMatches";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isInLibraryContent";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isInLibraryContent$5";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$mirrorOfArray$2";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$mirrorOfString$1";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isFiltered$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JavaXSourcePosition
    implements XSourcePosition,
    ExecutionPointHighlighter.HighlighterProvider {
        private final SourcePosition b;
        @NotNull
        private final VirtualFile a;
        private static final long c = lb.a(-8212655309320382553L, -6406374211091944271L, MethodHandles.lookup().lookupClass()).a(225538604725810L);

        JavaXSourcePosition(@NotNull SourcePosition sourcePosition, @NotNull VirtualFile file) {
            if (sourcePosition == null) {
                JavaXSourcePosition.a(0);
            }
            if (file == null) {
                JavaXSourcePosition.a(1);
            }
            this.b = sourcePosition;
            this.a = file;
        }

        public int getLine() {
            return this.b.getLine();
        }

        public int getOffset() {
            return this.b.getOffset();
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.a;
            if (virtualFile == null) {
                JavaXSourcePosition.a(2);
            }
            return virtualFile;
        }

        @NotNull
        public Navigatable createNavigatable(@NotNull Project project2) {
            if (project2 == null) {
                JavaXSourcePosition.a(3);
            }
            OpenFileDescriptor openFileDescriptor = XSourcePositionImpl.doCreateOpenFileDescriptor((Project)project2, (XSourcePosition)this);
            if (openFileDescriptor == null) {
                JavaXSourcePosition.a(4);
            }
            return openFileDescriptor;
        }

        @Nullable
        public TextRange getHighlightRange() {
            return DebuggerUtilsEx.intersectWithLine(SourcePositionHighlighter.getHighlightRangeFor((SourcePosition)this.b), this.b.getFile(), this.getLine());
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x38DB5CB6B64EL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourcePosition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/impl/DebuggerUtilsEx$JavaXSourcePosition";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/impl/DebuggerUtilsEx$JavaXSourcePosition";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNavigatable";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createNavigatable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SigReader {
        final String buffer;
        int pos = 0;
        private static final long a = lb.a(668894153114692699L, -1851855738236462269L, MethodHandles.lookup().lookupClass()).a(164526561030123L);

        SigReader(String s2) {
            this.buffer = s2;
        }

        int get() {
            return this.buffer.charAt(this.pos++);
        }

        int peek() {
            return this.buffer.charAt(this.pos);
        }

        boolean eof() {
            return this.buffer.length() <= this.pos;
        }

        @NonNls
        String getSignature() {
            long l2 = a ^ 0xC2EB6D0113BL;
            if (this.eof()) {
                return "";
            }
            switch (this.get()) {
                case 90: {
                    return "boolean";
                }
                case 66: {
                    return "byte";
                }
                case 67: {
                    return "char";
                }
                case 83: {
                    return "short";
                }
                case 73: {
                    return "int";
                }
                case 74: {
                    return "long";
                }
                case 70: {
                    return "float";
                }
                case 68: {
                    return "double";
                }
                case 86: {
                    return "void";
                }
                case 76: {
                    int n2 = this.pos;
                    this.pos = this.buffer.indexOf(59, n2) + 1;
                    d.assertTrue(this.pos > 0);
                    return this.buffer.substring(n2, this.pos - 1).replace('/', '.');
                }
                case 91: {
                    return this.getSignature() + "[]";
                }
                case 40: {
                    StringBuilder stringBuilder = new StringBuilder("(");
                    String string = "";
                    while (this.peek() != 41) {
                        stringBuilder.append(string);
                        stringBuilder.append(this.getSignature());
                        string = ", ";
                    }
                    this.get();
                    stringBuilder.append(")");
                    return this.getSignature() + " " + this.getClassName() + "." + this.getMethodName() + " " + stringBuilder;
                }
            }
            return null;
        }

        String getMethodName() {
            return "";
        }

        String getClassName() {
            return "";
        }
    }
}

