/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import b.a.lb;
import com.intellij.debugger.impl.EventQueue;
import com.intellij.debugger.impl.EventQueueClosedException;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.ConcurrencyUtil;
import com.sun.jdi.VMDisconnectedException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;

public abstract class InvokeThread<E extends PrioritizedTask> {
    private static final Logger c;
    private static final ThreadLocal<WorkerThreadRequest> b;
    protected final Project myProject;
    protected final EventQueue<E> myEvents;
    private volatile WorkerThreadRequest a = null;
    private static final long g;

    public InvokeThread(Project project2) {
        this.myProject = project2;
        this.myEvents = new EventQueue(PrioritizedTask.Priority.values().length);
        this.startNewWorkerThread();
    }

    protected abstract void processEvent(E var1);

    protected void startNewWorkerThread() {
        WorkerThreadRequest workerThreadRequest;
        this.a = workerThreadRequest = new WorkerThreadRequest(this);
        workerThreadRequest.setRequestFuture(ApplicationManager.getApplication().executeOnPooledThread(workerThreadRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(@NotNull WorkerThreadRequest workerThreadRequest) {
        block21: {
            long l2 = g ^ 0x3A8FC6F017BAL;
            if (workerThreadRequest == null) {
                InvokeThread.a(0);
            }
            try {
                DumbService.getInstance((Project)this.myProject).setAlternativeResolveEnabled(true);
                while (true) {
                    try {
                        while (true) {
                            if (workerThreadRequest.isStopRequested()) {
                                break block21;
                            }
                            WorkerThreadRequest workerThreadRequest2 = this.getCurrentRequest();
                            if (workerThreadRequest2 != workerThreadRequest) {
                                InvokeThread.a(new IllegalStateException("Expected " + workerThreadRequest + " instead of " + workerThreadRequest2));
                                break block21;
                            }
                            this.processEvent((PrioritizedTask)this.myEvents.get());
                        }
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                    }
                    catch (EventQueueClosedException eventQueueClosedException) {
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        if (runtimeException.getCause() instanceof InterruptedException) {
                            break;
                        }
                        InvokeThread.a(runtimeException);
                        continue;
                    }
                    catch (Throwable throwable) {
                        InvokeThread.a(throwable);
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (workerThreadRequest == this.getCurrentRequest()) {
                    for (PrioritizedTask prioritizedTask : this.myEvents.clearQueue()) {
                        try {
                            this.processEvent(prioritizedTask);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                c.debug("Request " + this.toString() + " exited");
                DumbService.getInstance((Project)this.myProject).setAlternativeResolveEnabled(false);
            }
        }
    }

    private static void a(Throwable throwable) {
        try {
            c.error(throwable);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    protected static InvokeThread currentThread() {
        WorkerThreadRequest workerThreadRequest = InvokeThread.getCurrentThreadRequest();
        return workerThreadRequest != null ? workerThreadRequest.getOwner() : null;
    }

    public boolean schedule(@Async.Schedule E r2) {
        long l2 = g ^ 0xA7C8B0F5B43L;
        if (c.isDebugEnabled()) {
            c.debug("schedule " + r2 + " in " + this);
        }
        return this.myEvents.put(r2, r2.getPriority().ordinal());
    }

    public boolean pushBack(E r2) {
        long l2 = g ^ 0x42CE0E7BA819L;
        if (c.isDebugEnabled()) {
            c.debug("pushBack " + r2 + " in " + this);
        }
        return this.myEvents.pushBack(r2, r2.getPriority().ordinal());
    }

    protected void switchToRequest(WorkerThreadRequest newRequest) {
        long l2 = g ^ 0x1553351D8895L;
        WorkerThreadRequest workerThreadRequest = InvokeThread.getCurrentThreadRequest();
        c.assertTrue(workerThreadRequest != null);
        this.a = newRequest;
        if (c.isDebugEnabled()) {
            c.debug("Closing " + workerThreadRequest + " new request = " + newRequest);
        }
        workerThreadRequest.requestStop();
    }

    public WorkerThreadRequest getCurrentRequest() {
        return this.a;
    }

    public static WorkerThreadRequest getCurrentThreadRequest() {
        return b.get();
    }

    public void close() {
        long l2 = g ^ 0x990B25B0951L;
        this.myEvents.close();
        c.debug("Closing evaluation");
    }

    static {
        g = lb.a(542506140007343825L, 2310967026697766241L, MethodHandles.lookup().lookupClass()).a(119717407399281L);
        long l2 = g ^ 0x6194BC069FCL;
        c = Logger.getInstance((String)"#com.intellij.debugger.impl.InvokeThread");
        b = new ThreadLocal();
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = g ^ 0x76E733913EB0L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadRequest", "com/intellij/debugger/impl/InvokeThread", "run"));
    }

    public static final class WorkerThreadRequest<E extends PrioritizedTask>
    implements Runnable {
        private final InvokeThread<E> a;
        private volatile Future<?> c;
        private volatile boolean b = false;
        private static final long d = lb.a(-335598563779102327L, 1182305115042430133L, MethodHandles.lookup().lookupClass()).a(94972321502828L);

        WorkerThreadRequest(InvokeThread<E> owner2) {
            this.a = owner2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l2 = d ^ 0x3D466A5035CFL;
            WorkerThreadRequest workerThreadRequest = this;
            synchronized (workerThreadRequest) {
                while (this.c == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            b.set(this);
            try {
                ConcurrencyUtil.runUnderThreadName((String)"DebuggerManagerThread", () -> ((InvokeThread)this.a).a(this));
            }
            finally {
                b.set(null);
                boolean bl2 = Thread.interrupted();
            }
        }

        public void requestStop() {
            Future<?> future = this.c;
            assert (future != null);
            this.b = true;
            future.cancel(true);
        }

        public boolean isStopRequested() {
            Future<?> future = this.c;
            assert (future != null);
            return this.b || future.isCancelled() || future.isDone();
        }

        public void join() throws InterruptedException, ExecutionException {
            assert (this.c != null);
            try {
                this.c.get();
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }

        public void join(long timeout) throws InterruptedException, ExecutionException {
            assert (this.c != null);
            try {
                this.c.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException | TimeoutException exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void setRequestFuture(Future<?> requestFuture) {
            WorkerThreadRequest workerThreadRequest = this;
            synchronized (workerThreadRequest) {
                this.c = requestFuture;
                this.notifyAll();
            }
        }

        public InvokeThread<E> getOwner() {
            return this.a;
        }

        public boolean isDone() {
            assert (this.c != null);
            return this.c.isDone() && b.get() == null;
        }
    }
}

