/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.JdiProxy;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import gnu.trove.THashMap;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackFrameProxyImpl
extends JdiProxy
implements StackFrameProxy {
    private static final Logger e;
    private final ThreadReferenceProxyImpl j;
    private final int h;
    private int d;
    private StackFrame i;
    private ObjectReference b;
    private ClassLoaderReference c;
    private ThreeState f;
    private Map<LocalVariable, Value> g;
    private static final long k;

    public StackFrameProxyImpl(@NotNull ThreadReferenceProxyImpl threadProxy, @NotNull StackFrame frame, int fromBottomIndex) {
        if (threadProxy == null) {
            StackFrameProxyImpl.b(0);
        }
        if (frame == null) {
            StackFrameProxyImpl.b(1);
        }
        super(threadProxy.getVirtualMachine());
        this.d = -1;
        this.f = ThreeState.UNSURE;
        this.j = threadProxy;
        this.h = fromBottomIndex;
        this.i = frame;
    }

    public boolean isObsolete() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.f != ThreeState.UNSURE) {
            return this.f.toBoolean();
        }
        Throwable throwable = null;
        for (int i10 = 0; i10 < 2; ++i10) {
            try {
                Method method = DebuggerUtilsEx.getMethod(this.location());
                boolean bl2 = this.getVirtualMachine().canRedefineClasses() && (method == null || method.isObsolete());
                this.f = ThreeState.fromBoolean((boolean)bl2);
                return bl2;
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throwable = invalidStackFrameException;
                this.clearCaches();
                continue;
            }
            catch (InternalException internalException) {
                if (internalException.errorCode() == 23) {
                    this.f = ThreeState.YES;
                    return true;
                }
                throw internalException;
            }
        }
        throw new EvaluateException(throwable.getMessage(), throwable);
    }

    @Override
    public boolean isValid() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!super.isValid()) {
            return false;
        }
        try {
            if (this.i != null) {
                this.i.location();
            }
            return true;
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            return false;
        }
    }

    @Override
    protected void clearCaches() {
        long l2 = k ^ 0xE6CB59C42EDL;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (e.isDebugEnabled()) {
            e.debug("caches cleared " + super.toString());
        }
        this.d = -1;
        this.i = null;
        this.f = ThreeState.UNSURE;
        this.b = null;
        this.c = null;
        this.g = null;
    }

    public StackFrame getStackFrame() throws EvaluateException {
        long l2 = k ^ 0xA2A8953FC4BL;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.i == null) {
            try {
                ThreadReference threadReference = this.j.getThreadReference();
                this.i = threadReference.frame(this.getFrameIndex());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new EvaluateException(indexOutOfBoundsException.getMessage(), (Throwable)indexOutOfBoundsException);
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.thread.collected", (Object[])new Object[0]));
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)incompatibleThreadStateException);
            }
        }
        return this.i;
    }

    public int getFrameIndex() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.d == -1) {
            int n2 = this.j.frameCount();
            if (this.h > n2) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)new IncompatibleThreadStateException());
            }
            this.d = n2 - this.h;
        }
        return this.d;
    }

    @NotNull
    public VirtualMachineProxyImpl getVirtualMachine() {
        VirtualMachineProxyImpl virtualMachineProxyImpl = (VirtualMachineProxyImpl)this.myTimer;
        if (virtualMachineProxyImpl == null) {
            StackFrameProxyImpl.b(2);
        }
        return virtualMachineProxyImpl;
    }

    public Location location() throws EvaluateException {
        Throwable throwable = null;
        for (int i10 = 0; i10 < 2; ++i10) {
            try {
                return this.getStackFrame().location();
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throwable = invalidStackFrameException;
                this.clearCaches();
                continue;
            }
        }
        throw new EvaluateException(throwable.getMessage(), throwable);
    }

    @NotNull
    public ThreadReferenceProxyImpl threadProxy() {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = this.j;
        if (threadReferenceProxyImpl == null) {
            StackFrameProxyImpl.b(3);
        }
        return threadReferenceProxyImpl;
    }

    @NonNls
    public String toString() {
        long l2 = k ^ 0x2FA9DB9CD888L;
        try {
            return "StackFrameProxyImpl: " + this.getStackFrame().toString();
        }
        catch (EvaluateException evaluateException) {
            return "StackFrameProxyImpl: " + evaluateException.getMessage() + "; frameFromBottom = " + this.h + " threadName = " + this.threadProxy().name();
        }
    }

    @Nullable
    public ObjectReference thisObject() throws EvaluateException {
        long l2 = k ^ 0x63A3AC44670CL;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        try {
            for (int i10 = 0; i10 < 2; ++i10) {
                try {
                    if (this.b == null) {
                        this.b = this.getStackFrame().thisObject();
                    }
                    break;
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    this.clearCaches();
                    continue;
                }
            }
        }
        catch (InternalException internalException) {
            if (internalException.errorCode() != 23 && internalException.errorCode() != 35) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)internalException);
            }
            e.info("Exception while getting this object", (Throwable)internalException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            e.info("Exception while getting this object", (Throwable)illegalArgumentException);
        }
        catch (Exception exception) {
            if (!this.getVirtualMachine().canBeModified()) {
                e.debug((Throwable)exception);
            }
            throw exception;
        }
        return this.b;
    }

    @NotNull
    public List<LocalVariableProxyImpl> visibleVariables() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable throwable = null;
        for (int i10 = 0; i10 < 2; ++i10) {
            ArrayList<LocalVariableProxyImpl> arrayList;
            try {
                List<LocalVariable> list2 = this.getStackFrame().visibleVariables();
                ArrayList<LocalVariableProxyImpl> arrayList2 = new ArrayList<LocalVariableProxyImpl>(list2.size());
                for (LocalVariable localVariable : list2) {
                    e.assertTrue(localVariable != null);
                    arrayList2.add(new LocalVariableProxyImpl(this, localVariable));
                }
                arrayList = arrayList2;
            }
            catch (InvalidStackFrameException | IllegalArgumentException runtimeException) {
                throwable = runtimeException;
                this.clearCaches();
                continue;
            }
            catch (AbsentInformationException absentInformationException) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)absentInformationException);
            }
            if (arrayList == null) {
                StackFrameProxyImpl.b(4);
            }
            return arrayList;
        }
        throw new EvaluateException(throwable.getMessage(), throwable);
    }

    public LocalVariableProxyImpl visibleVariableByName(String name2) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        LocalVariable localVariable = this.visibleVariableByNameInt(name2);
        return localVariable != null ? new LocalVariableProxyImpl(this, localVariable) : null;
    }

    @Nullable
    public Value visibleValueByName(@NotNull String name2) throws EvaluateException {
        LocalVariable localVariable;
        if (name2 == null) {
            StackFrameProxyImpl.b(5);
        }
        return (localVariable = this.visibleVariableByNameInt(name2)) != null ? this.getValue(new LocalVariableProxyImpl(this, localVariable)) : null;
    }

    protected LocalVariable visibleVariableByNameInt(String name2) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable throwable = null;
        for (int i10 = 0; i10 < 2; ++i10) {
            try {
                return this.getStackFrame().visibleVariableByName(name2);
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                try {
                    throwable = invalidStackFrameException;
                    this.clearCaches();
                    continue;
                }
                catch (AbsentInformationException | InvalidStackFrameException exception) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
                }
            }
        }
        throw new EvaluateException(throwable.getMessage(), throwable);
    }

    public Value getValue(LocalVariableProxyImpl localVariable) throws EvaluateException {
        long l2 = k ^ 0x422E5935B26L;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable throwable = null;
        for (int i10 = 0; i10 < 2; ++i10) {
            try {
                Map<LocalVariable, Value> map2 = this.a();
                LocalVariable localVariable2 = localVariable.getVariable();
                if (map2.containsKey(localVariable2)) {
                    return map2.get(localVariable2);
                }
                return this.getStackFrame().getValue(localVariable2);
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throwable = invalidStackFrameException;
                this.clearCaches();
                continue;
            }
            catch (InconsistentDebugInfoException inconsistentDebugInfoException) {
                this.clearCaches();
                throw EvaluateExceptionUtil.INCONSISTEND_DEBUG_INFO;
            }
            catch (InternalException internalException) {
                if (internalException.errorCode() == 35 || internalException.errorCode() == 101) {
                    throw new EvaluateException(DebuggerBundle.message((String)"error.corrupt.debug.info", (Object[])new Object[]{internalException.getMessage()}), (Throwable)internalException);
                }
                throw internalException;
            }
            catch (Exception exception) {
                if (!this.getVirtualMachine().canBeModified()) {
                    e.debug((Throwable)exception);
                    throw new EvaluateException("Debug data corrupted");
                }
                throw exception;
            }
        }
        throw new EvaluateException(throwable.getMessage(), throwable);
    }

    @NotNull
    public List<Value> getArgumentValues() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable throwable = null;
        for (int i10 = 0; i10 < 2; ++i10) {
            List list2;
            try {
                StackFrame stackFrame = this.getStackFrame();
                list2 = stackFrame != null ? ContainerUtil.notNullize(stackFrame.getArgumentValues()) : Collections.emptyList();
            }
            catch (InternalException internalException) {
                if (internalException.errorCode() == 32) {
                    List<Value> list3 = Collections.emptyList();
                    if (list3 == null) {
                        StackFrameProxyImpl.b(7);
                    }
                    return list3;
                }
                throw internalException;
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throwable = invalidStackFrameException;
                this.clearCaches();
                continue;
            }
            if (list2 == null) {
                StackFrameProxyImpl.b(6);
            }
            return list2;
        }
        throw new EvaluateException(throwable.getMessage(), throwable);
    }

    private Map<LocalVariable, Value> a() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.g == null) {
            try {
                StackFrame stackFrame = this.getStackFrame();
                this.g = new THashMap(stackFrame.getValues(stackFrame.visibleVariables()));
            }
            catch (AbsentInformationException absentInformationException) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)absentInformationException);
            }
            catch (InternalException internalException) {
                if (internalException.errorCode() == 35 || internalException.errorCode() == 101) {
                    e.info((Throwable)internalException);
                    this.g = new THashMap();
                }
                throw internalException;
            }
            catch (Exception exception) {
                if (!this.getVirtualMachine().canBeModified()) {
                    e.debug((Throwable)exception);
                    this.g = new THashMap();
                }
                throw exception;
            }
        }
        return this.g;
    }

    public void setValue(LocalVariableProxyImpl localVariable, Value value) throws EvaluateException, ClassNotLoadedException, InvalidTypeException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable throwable = null;
        for (int i10 = 0; i10 < 2; ++i10) {
            try {
                LocalVariable localVariable2 = localVariable.getVariable();
                StackFrame stackFrame = this.getStackFrame();
                stackFrame.setValue(localVariable2, value instanceof ObjectReference ? (ObjectReference)value : value);
                if (this.g != null) {
                    this.g.put(localVariable2, stackFrame.getValue(localVariable2));
                }
                return;
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throwable = invalidStackFrameException;
                this.clearCaches();
                continue;
            }
        }
        throw new EvaluateException(throwable.getMessage(), throwable);
    }

    public int hashCode() {
        return 31 * this.j.hashCode() + this.h;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StackFrameProxyImpl)) {
            return false;
        }
        StackFrameProxyImpl stackFrameProxyImpl = (StackFrameProxyImpl)obj;
        if (stackFrameProxyImpl == this) {
            return true;
        }
        return this.h == stackFrameProxyImpl.h && this.j.equals(stackFrameProxyImpl.j);
    }

    public boolean isLocalVariableVisible(LocalVariableProxyImpl var) throws EvaluateException {
        try {
            return var.getVariable().isVisible(this.getStackFrame());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public ClassLoaderReference getClassLoader() throws EvaluateException {
        if (this.c == null) {
            this.c = this.location().declaringType().classLoader();
        }
        return this.c;
    }

    public boolean isBottom() {
        return this.h == 1;
    }

    public int getIndexFromBottom() {
        return this.h;
    }

    static {
        k = lb.a(2959503974047235281L, -3083245566210079507L, MethodHandles.lookup().lookupClass()).a(263879574817862L);
        long l2 = k ^ 0x5CAF2824BA1BL;
        e = Logger.getInstance((String)"#com.intellij.debugger.jdi.StackFrameProxyImpl");
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = k ^ 0x1EF5C705C438L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadProxy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/StackFrameProxyImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/StackFrameProxyImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMachine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "threadProxy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "visibleVariables";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentValues";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visibleValueByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

