/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import b.a.lb;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.tracking.ConstructorInstancesTracker;
import com.intellij.debugger.memory.tracking.TrackerForNewInstances;
import com.intellij.debugger.memory.ui.InstancesWindow;
import com.intellij.debugger.memory.ui.JavaReferenceInfo;
import com.intellij.debugger.memory.ui.JavaTypeInfo;
import com.intellij.debugger.memory.utils.LowestPriorityCommand;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.Requestor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.memory.component.InstancesTracker;
import com.intellij.xdebugger.memory.event.InstancesTrackerListener;
import com.intellij.xdebugger.memory.tracking.TrackingType;
import com.intellij.xdebugger.memory.ui.ClassesFilteredViewBase;
import com.intellij.xdebugger.memory.ui.ClassesTable;
import com.intellij.xdebugger.memory.ui.InstancesWindowBase;
import com.intellij.xdebugger.memory.ui.TypeInfo;
import com.intellij.xdebugger.memory.utils.InstancesProvider;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.ClassPrepareRequest;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassesFilteredView
extends ClassesFilteredViewBase {
    private static final Logger e;
    public static final DataKey<InstancesProvider> NEW_INSTANCES_PROVIDER_KEY;
    private final InstancesTracker a;
    private final AtomicBoolean d;
    private final Map<ReferenceType, ConstructorInstancesTracker> c;
    private final XDebugSessionListener b;
    private static final long f;

    public ClassesFilteredView(final @NotNull XDebugSession debugSession, final @NotNull DebugProcessImpl debugProcess, final @NotNull InstancesTracker tracker) {
        if (debugSession == null) {
            ClassesFilteredView.a(0);
        }
        if (debugProcess == null) {
            ClassesFilteredView.a(1);
        }
        if (tracker == null) {
            ClassesFilteredView.a(2);
        }
        super(debugSession);
        this.d = new AtomicBoolean(false);
        this.c = new ConcurrentHashMap<ReferenceType, ConstructorInstancesTracker>();
        final DebuggerManagerThreadImpl debuggerManagerThreadImpl = debugProcess.getManagerThread();
        this.a = tracker;
        final InstancesTrackerListener instancesTrackerListener = new InstancesTrackerListener(){
            private static final long a = lb.a(3327445420399936601L, -6385789981807235759L, MethodHandles.lookup().lookupClass()).a(209907613614162L);

            public void classChanged(@NotNull String name2, final @NotNull TrackingType type) {
                ClassesTable classesTable;
                TypeInfo typeInfo;
                if (name2 == null) {
                    1.a(0);
                }
                if (type == null) {
                    1.a(1);
                }
                if ((typeInfo = (classesTable = ClassesFilteredView.this.getTable()).getClassByName(name2)) == null) {
                    return;
                }
                final ReferenceType referenceType = ((JavaTypeInfo)typeInfo).getReferenceType();
                if (referenceType != null) {
                    final boolean bl2 = ClassesFilteredView.this.d.get();
                    debuggerManagerThreadImpl.schedule(new DebuggerCommandImpl(){

                        @Override
                        protected void action() {
                            ClassesFilteredView.this.a(debugSession, debugProcess, referenceType, type, bl2);
                        }
                    });
                }
                classesTable.repaint();
            }

            public void classRemoved(@NotNull String name2) {
                ClassesTable classesTable;
                TypeInfo typeInfo;
                if (name2 == null) {
                    1.a(2);
                }
                if ((typeInfo = (classesTable = ClassesFilteredView.this.getTable()).getClassByName(name2)) == null) {
                    return;
                }
                JavaTypeInfo javaTypeInfo = (JavaTypeInfo)typeInfo;
                if (ClassesFilteredView.this.c.containsKey(javaTypeInfo.getReferenceType())) {
                    ConstructorInstancesTracker constructorInstancesTracker = (ConstructorInstancesTracker)ClassesFilteredView.this.c.remove(javaTypeInfo.getReferenceType());
                    Disposer.dispose((Disposable)constructorInstancesTracker);
                    classesTable.getRowSorter().allRowsChanged();
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                long l2 = a ^ 0x37F8D43E9228L;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "classChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "classRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        debugSession.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                ClassesFilteredView.this.a.removeTrackerListener(instancesTrackerListener);
            }
        });
        debugProcess.addDebugProcessListener(new DebugProcessListener(){
            private static final long a = lb.a(6806243946399067550L, -1552622725147280305L, MethodHandles.lookup().lookupClass()).a(87205476504844L);

            public void processAttached(@NotNull DebugProcess process2) {
                if (process2 == null) {
                    3.a(0);
                }
                debugProcess.removeDebugProcessListener(this);
                debuggerManagerThreadImpl.invoke(new DebuggerCommandImpl(){
                    private static final long c = lb.a(2418208948175543492L, -4953467807564823911L, MethodHandles.lookup().lookupClass()).a(232366483965171L);

                    @Override
                    protected void action() {
                        boolean bl2 = ClassesFilteredView.this.d.get();
                        VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcess.getVirtualMachineProxy();
                        if (!virtualMachineProxyImpl.canBeModified()) {
                            return;
                        }
                        tracker.getTrackedClasses().forEach((string, trackingType) -> {
                            List<ReferenceType> list2;
                            if (debugSession == null) {
                                1.a(0);
                            }
                            if (debugProcess == null) {
                                1.a(1);
                            }
                            if ((list2 = virtualMachineProxyImpl.classesByName((String)string)).isEmpty()) {
                                this.a(string, debugSession, debugProcess, trackingType);
                            } else {
                                for (ReferenceType referenceType : list2) {
                                    ClassesFilteredView.this.a(debugSession, debugProcess, referenceType, trackingType, bl2);
                                }
                            }
                        });
                        tracker.addTrackerListener(instancesTrackerListener);
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        long l2 = c ^ 0x2382AB5458CAL;
                        Object[] objectArray2 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "debugSession";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "debugProcess";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView$3$1";
                        objectArray[2] = "lambda$action$0";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            private void a(@NotNull String string, final @NotNull XDebugSession xDebugSession, final @NotNull DebugProcessImpl debugProcessImpl, final @NotNull TrackingType trackingType) {
                long l2 = a ^ 0x4ED46A364694L;
                if (string == null) {
                    3.a(1);
                }
                if (xDebugSession == null) {
                    3.a(2);
                }
                if (debugProcessImpl == null) {
                    3.a(3);
                }
                if (trackingType == null) {
                    3.a(4);
                }
                ClassPrepareRequestor classPrepareRequestor = new ClassPrepareRequestor(){

                    public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                        debugProcessImpl.getRequestsManager().deleteRequest((Requestor)this);
                        ClassesFilteredView.this.a(xDebugSession, debugProcessImpl, referenceType, trackingType, ClassesFilteredView.this.d.get());
                    }
                };
                ClassPrepareRequest classPrepareRequest = debugProcessImpl.getRequestsManager().createClassPrepareRequest(classPrepareRequestor, string);
                if (classPrepareRequest != null) {
                    classPrepareRequest.enable();
                } else {
                    e.warn("Cannot create a 'class prepare' request. Class " + string + " not tracked.");
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                long l2 = a ^ 0x4D3ECAC7C10L;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "process";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "className";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView$3";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processAttached";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "trackWhenPrepared";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.b = new XDebugSessionListener(){

            public void sessionResumed() {
                ClassesFilteredView.this.c.values().forEach(ConstructorInstancesTracker::obsolete);
            }

            public void sessionStopped() {
                ClassesFilteredView.this.c.values().forEach(Disposer::dispose);
                ClassesFilteredView.this.c.clear();
            }
        };
        ClassesTable classesTable = this.getTable();
        classesTable.addMouseMotionListener((MouseMotionListener)new MyMouseMotionListener());
        classesTable.addMouseListener((MouseListener)new MyOpenNewInstancesListener());
        new MyDoubleClickListener().installOn((Component)classesTable);
    }

    private void a(@NotNull XDebugSession xDebugSession, @NotNull DebugProcessImpl debugProcessImpl, @NotNull ReferenceType referenceType, @NotNull TrackingType trackingType, boolean bl2) {
        if (xDebugSession == null) {
            ClassesFilteredView.a(3);
        }
        if (debugProcessImpl == null) {
            ClassesFilteredView.a(4);
        }
        if (referenceType == null) {
            ClassesFilteredView.a(5);
        }
        if (trackingType == null) {
            ClassesFilteredView.a(6);
        }
        e.assertTrue(DebuggerManager.getInstance((Project)this.myProject).isDebuggerManagerThread());
        if (!debugProcessImpl.getVirtualMachineProxy().canBeModified()) {
            return;
        }
        if (trackingType == TrackingType.CREATION) {
            ConstructorInstancesTracker constructorInstancesTracker = this.c.getOrDefault(referenceType, null);
            if (constructorInstancesTracker != null) {
                Disposer.dispose((Disposable)constructorInstancesTracker);
            }
            ConstructorInstancesTracker constructorInstancesTracker2 = new ConstructorInstancesTracker(referenceType, xDebugSession, this.a);
            constructorInstancesTracker2.setBackgroundMode(!this.myIsActive);
            if (bl2) {
                constructorInstancesTracker2.enable();
            } else {
                constructorInstancesTracker2.disable();
            }
            this.c.put(referenceType, constructorInstancesTracker2);
        }
    }

    protected void scheduleUpdateClassesCommand(XSuspendContext context) {
        SuspendContextImpl suspendContextImpl = (SuspendContextImpl)context;
        suspendContextImpl.getDebugProcess().getManagerThread().schedule(new MyUpdateClassesCommand(suspendContextImpl));
    }

    @Nullable
    protected TrackerForNewInstances getStrategy(@NotNull TypeInfo ref) {
        if (ref == null) {
            ClassesFilteredView.a(7);
        }
        JavaTypeInfo javaTypeInfo = (JavaTypeInfo)ref;
        return this.c.getOrDefault(javaTypeInfo.getReferenceType(), null);
    }

    protected InstancesWindowBase getInstancesWindow(@NotNull TypeInfo ref, XDebugSession debugSession) {
        if (ref == null) {
            ClassesFilteredView.a(8);
        }
        return new InstancesWindow(debugSession, n2 -> {
            if (ref == null) {
                ClassesFilteredView.a(12);
            }
            return ref.getInstances(n2);
        }, ref.name());
    }

    protected void doActivate() {
        this.c.values().forEach(constructorInstancesTracker -> constructorInstancesTracker.setBackgroundMode(false));
        super.doActivate();
    }

    protected void doPause() {
        super.doPause();
        this.c.values().forEach(constructorInstancesTracker -> constructorInstancesTracker.setBackgroundMode(true));
    }

    public void dispose() {
        this.c.clear();
    }

    public Object getData(@NotNull String dataId) {
        TrackerForNewInstances trackerForNewInstances;
        TypeInfo typeInfo;
        if (dataId == null) {
            ClassesFilteredView.a(9);
        }
        if (NEW_INSTANCES_PROVIDER_KEY.is(dataId) && (typeInfo = this.getTable().getSelectedClass()) != null && (trackerForNewInstances = this.getStrategy(typeInfo)) != null && trackerForNewInstances.isReady()) {
            List<ObjectReference> list2 = trackerForNewInstances.getNewInstances();
            return n2 -> list2.stream().map(JavaReferenceInfo::new).collect(Collectors.toList());
        }
        return null;
    }

    @Nullable
    protected XDebugSessionListener getAdditionalSessionListener() {
        return this.b;
    }

    public void setActive(final boolean active, @NotNull DebuggerManagerThreadImpl managerThread) {
        if (managerThread == null) {
            ClassesFilteredView.a(10);
        }
        if (this.myIsActive == active) {
            return;
        }
        this.myIsActive = active;
        managerThread.schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() {
                if (active) {
                    ClassesFilteredView.this.doActivate();
                } else {
                    ClassesFilteredView.this.doPause();
                }
            }
        });
    }

    private void a() {
        this.c.values().forEach(ConstructorInstancesTracker::commitTracked);
    }

    private boolean a(@NotNull MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            ClassesFilteredView.a(11);
        }
        ClassesTable classesTable = this.getTable();
        int n2 = classesTable.columnAtPoint(mouseEvent.getPoint());
        int n3 = classesTable.rowAtPoint(mouseEvent.getPoint());
        if (n2 == -1 || n3 == -1 || classesTable.convertColumnIndexToModel(n2) != 2) {
            return false;
        }
        int n4 = classesTable.convertRowIndexToModel(n3);
        JavaTypeInfo javaTypeInfo = (JavaTypeInfo)classesTable.getModel().getValueAt(n4, 0);
        ConstructorInstancesTracker constructorInstancesTracker = this.c.getOrDefault(javaTypeInfo.getReferenceType(), null);
        return constructorInstancesTracker != null && constructorInstancesTracker.isReady() && constructorInstancesTracker.getCount() > 0;
    }

    static {
        f = lb.a(-438625098299628823L, 1021873775310671645L, MethodHandles.lookup().lookupClass()).a(30951751141126L);
        long l2 = f ^ 0x540566693657L;
        e = Logger.getInstance(ClassesFilteredView.class);
        NEW_INSTANCES_PROVIDER_KEY = DataKey.create((String)"ClassesTable.NewInstances");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = f ^ 0x526B9FBF99C2L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSession";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managerThread";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "trackClass";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getStrategy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstancesWindow";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "setActive";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isShowNewInstancesEvent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getInstancesWindow$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyUpdateClassesCommand
    extends LowestPriorityCommand {
        private static final long e = lb.a(2521897066848596329L, 5957933110183236297L, MethodHandles.lookup().lookupClass()).a(150054387413449L);

        MyUpdateClassesCommand(SuspendContextImpl suspendContext) {
            super(suspendContext);
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContext) {
            if (suspendContext == null) {
                MyUpdateClassesCommand.b(0);
            }
            this.a();
            VirtualMachineProxyImpl virtualMachineProxyImpl = suspendContext.getDebugProcess().getVirtualMachineProxy();
            List<ReferenceType> list2 = virtualMachineProxyImpl.allClasses();
            ClassesTable classesTable = ClassesFilteredView.this.getTable();
            if (!list2.isEmpty()) {
                VirtualMachine virtualMachine = list2.get(0).virtualMachine();
                if (virtualMachine.canGetInstanceInfo()) {
                    Map<TypeInfo, Long> map2 = this.a(list2, virtualMachine);
                    ApplicationManager.getApplication().invokeLater(() -> classesTable.updateContent(map2));
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> classesTable.updateClassesOnly(JavaTypeInfo.wrap(list2)));
                }
            }
            ApplicationManager.getApplication().invokeLater(() -> classesTable.setBusy(false));
            ClassesFilteredView.this.viewUpdated();
        }

        private void a() {
            if (!ClassesFilteredView.this.d.get()) {
                ClassesFilteredView.this.c.values().forEach(ConstructorInstancesTracker::enable);
                ClassesFilteredView.this.d.set(true);
            } else {
                ClassesFilteredView.this.a();
            }
        }

        private Map<TypeInfo, Long> a(@NotNull List<ReferenceType> list2, @NotNull VirtualMachine virtualMachine) {
            long l2 = e ^ 0x143A7CBE88E1L;
            if (list2 == null) {
                MyUpdateClassesCommand.b(1);
            }
            if (virtualMachine == null) {
                MyUpdateClassesCommand.b(2);
            }
            int n2 = DebuggerUtils.isAndroidVM((VirtualMachine)virtualMachine) ? 500 : Integer.MAX_VALUE;
            int n3 = list2.size();
            LinkedHashMap<TypeInfo, Long> linkedHashMap = new LinkedHashMap<TypeInfo, Long>();
            int n4 = 0;
            int n5 = Math.min(n2, n3);
            while (n4 != n3) {
                int n6;
                List<ReferenceType> list3 = list2.subList(n4, n5);
                long l3 = System.nanoTime();
                long[] lArray = virtualMachine.instanceCounts(list3);
                long l5 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l3);
                for (n6 = 0; n6 < list3.size(); ++n6) {
                    linkedHashMap.put(new JavaTypeInfo(list3.get(n6)), lArray[n6]);
                }
                n6 = (int)Math.min(0.5 * (double)l5, MAX_DELAY_MILLIS);
                ClassesFilteredView.this.mySingleAlarm.setDelay(n6);
                e.debug(String.format("Instances query time = %d ms. Count of classes = %d", l5, list3.size()));
                n4 = n5;
                n5 = Math.min(n5 + n2, n3);
            }
            return linkedHashMap;
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = e ^ 0x4DE4BF83D36CL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspendContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vm";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView$MyUpdateClassesCommand";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contextAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInstancesCounts";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyDoubleClickListener
    extends DoubleClickListener {
        private MyDoubleClickListener() {
        }

        protected boolean onDoubleClick(MouseEvent event) {
            if (!ClassesFilteredView.this.a(event)) {
                ClassesFilteredView.this.handleClassSelection(ClassesFilteredView.this.getTable().getSelectedClass());
                return true;
            }
            return false;
        }
    }

    private class MyMouseMotionListener
    implements MouseMotionListener {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e10) {
        }

        @Override
        public void mouseMoved(MouseEvent e10) {
            ClassesTable classesTable = ClassesFilteredView.this.getTable();
            if (classesTable.isInClickableMode()) {
                return;
            }
            if (ClassesFilteredView.this.a(e10)) {
                classesTable.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                classesTable.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class MyOpenNewInstancesListener
    extends MouseAdapter {
        private static final long a = lb.a(8652726595875967048L, -3814918867313151568L, MethodHandles.lookup().lookupClass()).a(95745123685273L);

        private MyOpenNewInstancesListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e10) {
            long l2 = a ^ 0xD22261ABE2FL;
            if (e10.getClickCount() != 1 || e10.getButton() != 1 || !ClassesFilteredView.this.a(e10)) {
                return;
            }
            TypeInfo typeInfo = ClassesFilteredView.this.getTable().getSelectedClass();
            ReferenceType referenceType = typeInfo != null ? ((JavaTypeInfo)typeInfo).getReferenceType() : null;
            TrackerForNewInstances trackerForNewInstances = referenceType == null ? null : ClassesFilteredView.this.getStrategy(typeInfo);
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)ClassesFilteredView.this.myProject).getCurrentSession();
            if (trackerForNewInstances != null && xDebugSession != null) {
                DebugProcess debugProcess = DebuggerManager.getInstance((Project)ClassesFilteredView.this.myProject).getDebugProcess(xDebugSession.getDebugProcess().getProcessHandler());
                MemoryViewDebugProcessData memoryViewDebugProcessData = (MemoryViewDebugProcessData)debugProcess.getUserData(MemoryViewDebugProcessData.KEY);
                if (memoryViewDebugProcessData != null) {
                    List<ObjectReference> list2 = trackerForNewInstances.getNewInstances();
                    memoryViewDebugProcessData.getTrackedStacks().pinStacks(referenceType);
                    InstancesWindow instancesWindow = new InstancesWindow(xDebugSession, n2 -> list2.stream().map(JavaReferenceInfo::new).collect(Collectors.toList()), referenceType.name());
                    Disposer.register((Disposable)instancesWindow.getDisposable(), () -> memoryViewDebugProcessData.getTrackedStacks().unpinStacks(referenceType));
                    instancesWindow.show();
                } else {
                    e.warn("MemoryViewDebugProcessData not found in debug session user data");
                }
            }
        }
    }
}

