/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.utils;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMStackFrameInfoProvider;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.LocalVariablesUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.CaptureConfigurable;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XStringValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackFrameItem {
    private static final Logger e;
    private static final List<XNamedValue> d;
    private static final List<XNamedValue> b;
    public static final XDebuggerTreeNodeHyperlink CAPTURE_SETTINGS_OPENER;
    private final Location c;
    private final List<XNamedValue> a;
    private static final long g;

    public StackFrameItem(@NotNull Location location, List<XNamedValue> variables) {
        if (location == null) {
            StackFrameItem.a(0);
        }
        this.c = location;
        this.a = variables;
    }

    @NotNull
    public String path() {
        String string = this.c.declaringType().name();
        if (string == null) {
            StackFrameItem.a(1);
        }
        return string;
    }

    @NotNull
    public String method() {
        String string = this.c.method().name();
        if (string == null) {
            StackFrameItem.a(2);
        }
        return string;
    }

    public int line() {
        return DebuggerUtilsEx.getLineNumber(this.c, false);
    }

    @NotNull
    public static List<StackFrameItem> createFrames(@NotNull SuspendContextImpl suspendContext, boolean withVars) throws EvaluateException {
        ThreadReferenceProxyImpl threadReferenceProxyImpl;
        long l2 = g ^ 0x7B9C322FF3F8L;
        if (suspendContext == null) {
            StackFrameItem.a(3);
        }
        if ((threadReferenceProxyImpl = suspendContext.getThread()) != null) {
            List<StackFrameProxyImpl> list2 = threadReferenceProxyImpl.forceFrames();
            ArrayList<StackFrameItem> arrayList = new ArrayList<StackFrameItem>(list2.size());
            for (StackFrameProxyImpl stackFrameProxyImpl : list2) {
                try {
                    Iterator<LocalVariableProxyImpl> iterator;
                    Location location;
                    List<XNamedValue> list3;
                    block24: {
                        list3 = null;
                        location = stackFrameProxyImpl.location();
                        Method method = location.method();
                        if (withVars) {
                            if (!DebuggerSettings.getInstance().CAPTURE_VARIABLES) {
                                list3 = d;
                            } else if (method.isNative() || method.isBridge() || DebuggerUtils.isSynthetic((TypeComponent)method)) {
                                list3 = b;
                            } else {
                                list3 = new ArrayList<XNamedValue>();
                                try {
                                    iterator = stackFrameProxyImpl.thisObject();
                                    if (iterator != null) {
                                        list3.add(StackFrameItem.a((Value)((Object)iterator), "this", VariableItem.VarType.OBJECT));
                                    }
                                }
                                catch (EvaluateException evaluateException) {
                                    e.debug((Throwable)evaluateException);
                                }
                                try {
                                    for (LocalVariableProxyImpl localVariableProxyImpl : stackFrameProxyImpl.visibleVariables()) {
                                        try {
                                            VariableItem.VarType varType = localVariableProxyImpl.getVariable().isArgument() ? VariableItem.VarType.PARAM : VariableItem.VarType.OBJECT;
                                            list3.add(StackFrameItem.a(stackFrameProxyImpl.getValue(localVariableProxyImpl), localVariableProxyImpl.name(), varType));
                                        }
                                        catch (EvaluateException evaluateException) {
                                            e.debug((Throwable)evaluateException);
                                        }
                                    }
                                }
                                catch (EvaluateException evaluateException) {
                                    if (evaluateException.getCause() instanceof AbsentInformationException) {
                                        list3.add(JavaStackFrame.LOCAL_VARIABLES_INFO_UNAVAILABLE_MESSAGE_NODE);
                                        try {
                                            for (Map.Entry<DecompiledLocalVariable, Value> entry : LocalVariablesUtil.fetchValues(stackFrameProxyImpl, suspendContext.getDebugProcess(), false).entrySet()) {
                                                list3.add(StackFrameItem.a(entry.getValue(), entry.getKey().getDisplayName(), VariableItem.VarType.PARAM));
                                            }
                                        }
                                        catch (Exception exception) {
                                            e.info((Throwable)exception);
                                            break block24;
                                        }
                                    }
                                    e.debug((Throwable)evaluateException);
                                }
                            }
                        }
                    }
                    iterator = new StackFrameItem(location, list3);
                    arrayList.add((StackFrameItem)((Object)iterator));
                    List<StackFrameItem> object2 = StackCapturingLineBreakpoint.getRelatedStack(stackFrameProxyImpl, suspendContext);
                    if (ContainerUtil.isEmpty(object2)) continue;
                    arrayList.add(null);
                    arrayList.addAll(object2);
                    break;
                }
                catch (EvaluateException evaluateException) {
                    e.debug((Throwable)evaluateException);
                }
            }
            ArrayList<StackFrameItem> arrayList2 = arrayList;
            if (arrayList2 == null) {
                StackFrameItem.a(4);
            }
            return arrayList2;
        }
        List<StackFrameItem> list2 = Collections.emptyList();
        if (list2 == null) {
            StackFrameItem.a(5);
        }
        return list2;
    }

    private static VariableItem a(Value value, String string, VariableItem.VarType varType) {
        long l2 = g ^ 0x69A4708ECEA1L;
        String string2 = null;
        String string3 = "null";
        if (value instanceof ObjectReference) {
            string3 = value instanceof StringReference ? ((StringReference)value).value() : "";
            string2 = value.type().name() + "@" + ((ObjectReference)value).uniqueID();
        } else if (value != null) {
            string3 = value.toString();
        }
        return new VariableItem(string, string2, string3, varType);
    }

    public String toString() {
        return this.c.toString();
    }

    public CapturedStackFrame createFrame(DebugProcessImpl debugProcess) {
        return new CapturedStackFrame(debugProcess, this);
    }

    static {
        g = lb.a(-5714161416085372632L, -6809499148506909248L, MethodHandles.lookup().lookupClass()).a(263468632059682L);
        long l2 = g ^ 0x42926ED0B25DL;
        e = Logger.getInstance(StackFrameItem.class);
        d = Collections.singletonList(JavaStackFrame.createMessageNode(DebuggerBundle.message((String)"message.node.local.variables.capture.disabled", (Object[])new Object[0]), null));
        b = Collections.singletonList(JavaStackFrame.createMessageNode(DebuggerBundle.message((String)"message.node.local.variables.not.captured", (Object[])new Object[0]), XDebuggerUIConstants.INFORMATION_MESSAGE_ICON));
        CAPTURE_SETTINGS_OPENER = new XDebuggerTreeNodeHyperlink(" settings"){

            public void onClick(MouseEvent event) {
                ShowSettingsUtil.getInstance().showSettingsDialog((Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(event.getComponent())), CaptureConfigurable.class);
                event.consume();
            }
        };
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0xC3DC7A7E1F3L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/utils/StackFrameItem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/utils/StackFrameItem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "path";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "method";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrames";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFrames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CapturedStackFrame
    extends XStackFrame
    implements JVMStackFrameInfoProvider,
    XDebuggerFramesList.ItemWithSeparatorAbove {
        private static final String a;
        private final XSourcePosition d;
        private final boolean i;
        private final boolean e;
        private final String b;
        private final String h;
        private final int g;
        private final List<XNamedValue> f;
        private volatile boolean c;
        private static final long j;

        public CapturedStackFrame(DebugProcessImpl debugProcess, StackFrameItem item) {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            this.b = item.path();
            this.h = item.method();
            this.g = item.line();
            this.f = item.a;
            Location location = item.c;
            this.d = DebuggerUtilsEx.toXSourcePosition(debugProcess.getPositionManager().getSourcePosition(location));
            this.i = DebuggerUtils.isSynthetic((TypeComponent)location.method());
            this.e = DebuggerUtilsEx.isInLibraryContent(this.d != null ? this.d.getFile() : null, debugProcess.getProject());
        }

        @Nullable
        public XSourcePosition getSourcePosition() {
            return this.d;
        }

        @Override
        public boolean isSynthetic() {
            return this.i;
        }

        @Override
        public boolean isInLibraryContent() {
            return this.e;
        }

        public void customizePresentation(@NotNull ColoredTextContainer component) {
            long l2 = j ^ 0x6ED9C2D6CE0AL;
            if (component == null) {
                CapturedStackFrame.a(0);
            }
            component.setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)6)));
            component.append(String.format("%s:%d", this.h, this.g), this.a());
            ThreadsViewSettings threadsViewSettings = ThreadsViewSettings.getInstance();
            if (threadsViewSettings.SHOW_CLASS_NAME) {
                component.append(String.format(", %s", StringUtil.getShortName((String)this.b)), this.a());
                String string = StringUtil.getPackageName((String)this.b);
                if (threadsViewSettings.SHOW_PACKAGE_NAME && !string.trim().isEmpty()) {
                    component.append(String.format(" (%s)", string), SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
                }
            }
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            long l2 = j ^ 0x3DB43C706DEFL;
            if (node == null) {
                CapturedStackFrame.a(1);
            }
            XValueChildrenList xValueChildrenList = XValueChildrenList.EMPTY;
            if (this.f == d) {
                node.setMessage(DebuggerBundle.message((String)"message.node.local.variables.capture.disabled", (Object[])new Object[0]), null, SimpleTextAttributes.REGULAR_ATTRIBUTES, CAPTURE_SETTINGS_OPENER);
            } else if (this.f != null) {
                xValueChildrenList = new XValueChildrenList(this.f.size());
                this.f.forEach(arg_0 -> ((XValueChildrenList)xValueChildrenList).add(arg_0));
            }
            node.addChildren(xValueChildrenList, true);
        }

        private SimpleTextAttributes a() {
            if (this.isSynthetic() || this.isInLibraryContent()) {
                return SimpleTextAttributes.GRAYED_ATTRIBUTES;
            }
            return SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }

        public String getCaptionAboveOf() {
            return a;
        }

        public boolean hasSeparatorAbove() {
            return this.c;
        }

        public void setWithSeparator(boolean withSeparator) {
            this.c = withSeparator;
        }

        public String toString() {
            long l2 = j ^ 0x27DC6ADC2616L;
            if (this.d != null) {
                return this.d.getFile().getName() + ":" + (this.d.getLine() + 1);
            }
            return "<position unknown>";
        }

        static {
            j = lb.a(5735185273281054229L, 6064204225678191925L, MethodHandles.lookup().lookupClass()).a(56238156092465L);
            long l2 = j ^ 0x336097D5C3EBL;
            a = DebuggerBundle.message((String)"frame.panel.async.stacktrace", (Object[])new Object[0]);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = j ^ 0x679D8D646A93L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/memory/utils/StackFrameItem$CapturedStackFrame";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizePresentation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeChildren";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VariableItem
    extends XNamedValue {
        private final String c;
        private final String a;
        private final VarType b;
        private static final long d = lb.a(926129221879179664L, -1382629924786496519L, MethodHandles.lookup().lookupClass()).a(4814952279188L);

        VariableItem(String name2, String type, String value, VarType varType) {
            super(name2);
            this.c = type;
            this.a = value;
            this.b = varType;
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            Icon icon;
            long l2 = d ^ 0x1D18C2250F19L;
            if (node == null) {
                VariableItem.a(0);
            }
            if (place == null) {
                VariableItem.a(1);
            }
            final ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
            final String string = Registry.is((String)"debugger.showTypes") ? classRenderer.renderTypeName(this.c) : null;
            Icon icon2 = icon = this.b == VarType.PARAM ? PlatformIcons.PARAMETER_ICON : AllIcons.Debugger.Value;
            if (this.c != null && this.c.startsWith("java.lang.String@")) {
                node.setPresentation(icon, (XValuePresentation)new XStringValuePresentation(this.a){

                    @Nullable
                    public String getType() {
                        return classRenderer.SHOW_STRINGS_TYPE ? string : null;
                    }
                }, false);
                return;
            }
            node.setPresentation(icon, string, this.a, false);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = d ^ 0x43C29643BC03L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "place";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/memory/utils/StackFrameItem$VariableItem";
            objectArray[2] = "computePresentation";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static final class VarType
        extends Enum<VarType> {
            public static final /* enum */ VarType PARAM;
            public static final /* enum */ VarType OBJECT;
            private static final /* synthetic */ VarType[] a;

            public static VarType[] values() {
                return (VarType[])a.clone();
            }

            public static VarType valueOf(String name2) {
                return Enum.valueOf(VarType.class, name2);
            }

            static {
                long l2 = lb.a(4513024642447021688L, 663533958888556104L, MethodHandles.lookup().lookupClass()).a(149056376908515L) ^ 0x5EC8F05471D8L;
                PARAM = new VarType();
                OBJECT = new VarType();
                a = new VarType[]{PARAM, OBJECT};
            }
        }
    }
}

