/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import b.a.lb;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DebuggerSettings", storages={@Storage(value="debugger.xml")})
public class DebuggerSettings
implements Cloneable,
PersistentStateComponent<Element> {
    private static final Logger e;
    public static final int SOCKET_TRANSPORT = 0;
    public static final int SHMEM_TRANSPORT = 1;
    @NonNls
    public static final String SUSPEND_ALL = "SuspendAll";
    @NonNls
    public static final String SUSPEND_THREAD = "SuspendThread";
    @NonNls
    public static final String SUSPEND_NONE = "SuspendNone";
    @NonNls
    public static final String RUN_HOTSWAP_ALWAYS = "RunHotswapAlways";
    @NonNls
    public static final String RUN_HOTSWAP_NEVER = "RunHotswapNever";
    @NonNls
    public static final String RUN_HOTSWAP_ASK = "RunHotswapAsk";
    @NonNls
    public static final String EVALUATE_FINALLY_ALWAYS = "EvaluateFinallyAlways";
    @NonNls
    public static final String EVALUATE_FINALLY_NEVER = "EvaluateFinallyNever";
    @NonNls
    public static final String EVALUATE_FINALLY_ASK = "EvaluateFinallyAsk";
    private static final ClassFilter[] b;
    public boolean TRACING_FILTERS_ENABLED = true;
    public int DEBUGGER_TRANSPORT;
    public boolean FORCE_CLASSIC_VM = true;
    public boolean DISABLE_JIT;
    public boolean SHOW_ALTERNATIVE_SOURCE = true;
    public boolean HOTSWAP_IN_BACKGROUND = true;
    public boolean SKIP_SYNTHETIC_METHODS = true;
    public boolean SKIP_CONSTRUCTORS;
    public boolean SKIP_GETTERS;
    public boolean SKIP_CLASSLOADERS = true;
    public String RUN_HOTSWAP_AFTER_COMPILE = "RunHotswapAsk";
    public boolean COMPILE_BEFORE_HOTSWAP = true;
    public boolean HOTSWAP_HANG_WARNING_ENABLED = false;
    public volatile boolean WATCH_RETURN_VALUES = false;
    public volatile boolean AUTO_VARIABLES_MODE = false;
    public volatile boolean KILL_PROCESS_IMMEDIATELY = false;
    public volatile boolean ALWAYS_DEBUG = true;
    public String EVALUATE_FINALLY_ON_POP_FRAME = "EvaluateFinallyAsk";
    public boolean RESUME_ONLY_CURRENT_THREAD = false;
    private ClassFilter[] a = b;
    public boolean INSTRUMENTING_AGENT = true;
    private List<CapturePoint> f = new ArrayList<CapturePoint>();
    public boolean CAPTURE_VARIABLES;
    private final EventDispatcher<CapturePointsSettingsListener> d = EventDispatcher.create(CapturePointsSettingsListener.class);
    private Map<String, ContentState> c = new LinkedHashMap();
    private static final long g;

    @Transient
    public ClassFilter[] getSteppingFilters() {
        ClassFilter[] classFilterArray = new ClassFilter[this.a.length];
        for (int i10 = 0; i10 < classFilterArray.length; ++i10) {
            classFilterArray[i10] = this.a[i10].clone();
        }
        return classFilterArray;
    }

    public static DebuggerSettings getInstance() {
        return (DebuggerSettings)ServiceManager.getService(DebuggerSettings.class);
    }

    public void setSteppingFilters(ClassFilter[] steppingFilters) {
        this.a = steppingFilters != null ? steppingFilters : ClassFilter.EMPTY_ARRAY;
    }

    @Nullable
    public Element getState() {
        long l2 = g ^ 0x68CD6DCD96CFL;
        Element element = XmlSerializer.serialize((Object)this, (SerializationFilter)new SkipDefaultsSerializationFilter());
        if (!Arrays.equals(b, this.a)) {
            DebuggerUtilsEx.writeFilters(element, "filter", this.a);
        }
        for (ContentState contentState : this.c.values()) {
            Element element2;
            if (!contentState.write(element2 = new Element("content"))) continue;
            element.addContent(element2);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        long l2 = g ^ 0x6A17315C2DA6L;
        if (state == null) {
            DebuggerSettings.a(0);
        }
        XmlSerializer.deserializeInto((Object)this, (Element)state);
        List list2 = state.getChildren("filter");
        if (list2.isEmpty()) {
            this.setSteppingFilters(b);
        } else {
            this.setSteppingFilters(DebuggerUtilsEx.readFilters(list2));
        }
        this.c.clear();
        for (Element element : state.getChildren("content")) {
            ContentState contentState = new ContentState(element);
            this.c.put(contentState.getType(), contentState);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DebuggerSettings)) {
            return false;
        }
        DebuggerSettings debuggerSettings = (DebuggerSettings)obj;
        return this.TRACING_FILTERS_ENABLED == debuggerSettings.TRACING_FILTERS_ENABLED && this.DEBUGGER_TRANSPORT == debuggerSettings.DEBUGGER_TRANSPORT && StringUtil.equals((CharSequence)this.EVALUATE_FINALLY_ON_POP_FRAME, (CharSequence)debuggerSettings.EVALUATE_FINALLY_ON_POP_FRAME) && this.FORCE_CLASSIC_VM == debuggerSettings.FORCE_CLASSIC_VM && this.DISABLE_JIT == debuggerSettings.DISABLE_JIT && this.SHOW_ALTERNATIVE_SOURCE == debuggerSettings.SHOW_ALTERNATIVE_SOURCE && this.KILL_PROCESS_IMMEDIATELY == debuggerSettings.KILL_PROCESS_IMMEDIATELY && this.ALWAYS_DEBUG == debuggerSettings.ALWAYS_DEBUG && this.HOTSWAP_IN_BACKGROUND == debuggerSettings.HOTSWAP_IN_BACKGROUND && this.SKIP_SYNTHETIC_METHODS == debuggerSettings.SKIP_SYNTHETIC_METHODS && this.SKIP_CLASSLOADERS == debuggerSettings.SKIP_CLASSLOADERS && this.SKIP_CONSTRUCTORS == debuggerSettings.SKIP_CONSTRUCTORS && this.SKIP_GETTERS == debuggerSettings.SKIP_GETTERS && this.RESUME_ONLY_CURRENT_THREAD == debuggerSettings.RESUME_ONLY_CURRENT_THREAD && this.COMPILE_BEFORE_HOTSWAP == debuggerSettings.COMPILE_BEFORE_HOTSWAP && this.HOTSWAP_HANG_WARNING_ENABLED == debuggerSettings.HOTSWAP_HANG_WARNING_ENABLED && Objects.equals(this.RUN_HOTSWAP_AFTER_COMPILE, debuggerSettings.RUN_HOTSWAP_AFTER_COMPILE) && DebuggerUtilsEx.filterEquals(this.a, debuggerSettings.a) && this.f.equals(((DebuggerSettings)obj).f);
    }

    public DebuggerSettings clone() {
        try {
            DebuggerSettings debuggerSettings = (DebuggerSettings)super.clone();
            debuggerSettings.c = new HashMap<String, ContentState>();
            for (Map.Entry<String, ContentState> entry : this.c.entrySet()) {
                debuggerSettings.c.put(entry.getKey(), entry.getValue().clone());
            }
            debuggerSettings.a = new ClassFilter[this.a.length];
            for (int i10 = 0; i10 < this.a.length; ++i10) {
                debuggerSettings.a[i10] = this.a[i10].clone();
            }
            debuggerSettings.f = this.cloneCapturePoints();
            return debuggerSettings;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            e.error((Throwable)cloneNotSupportedException);
            return null;
        }
    }

    List<CapturePoint> cloneCapturePoints() {
        try {
            ArrayList<CapturePoint> arrayList = new ArrayList<CapturePoint>(this.f.size());
            for (CapturePoint capturePoint : this.f) {
                arrayList.add(capturePoint.clone());
            }
            return arrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            e.error((Throwable)cloneNotSupportedException);
            return Collections.emptyList();
        }
    }

    @XCollection(propertyElementName="capture-points")
    public List<CapturePoint> getCapturePoints() {
        return this.f;
    }

    public void setCapturePoints(List<CapturePoint> capturePoints) {
        this.f = capturePoints;
        ((CapturePointsSettingsListener)this.d.getMulticaster()).capturePointsChanged();
    }

    public void addCapturePointsSettingsListener(CapturePointsSettingsListener listener, Disposable disposable) {
        this.d.addListener((EventListener)listener, disposable);
    }

    static {
        g = lb.a(-2467588387433280452L, -2389932683833789166L, MethodHandles.lookup().lookupClass()).a(8331702088724L);
        long l2 = g ^ 0x52DD96125C2CL;
        e = Logger.getInstance(DebuggerSettings.class);
        b = new ClassFilter[]{new ClassFilter("com.sun.*"), new ClassFilter("java.*"), new ClassFilter("javax.*"), new ClassFilter("org.omg.*"), new ClassFilter("sun.*"), new ClassFilter("jdk.internal.*"), new ClassFilter("junit.*"), new ClassFilter("com.intellij.rt.*"), new ClassFilter("com.yourkit.runtime.*"), new ClassFilter("com.springsource.loaded.*"), new ClassFilter("org.springsource.loaded.*"), new ClassFilter("javassist.*"), new ClassFilter("org.apache.webbeans.*"), new ClassFilter("com.ibm.ws.*")};
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = g ^ 0x9DB19A8D0BAL;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/debugger/settings/DebuggerSettings", "loadState"));
    }

    public static interface CapturePointsSettingsListener
    extends EventListener {
        public void capturePointsChanged();
    }

    public static class ContentState
    implements Cloneable {
        private final String b;
        private boolean c;
        private String e;
        private double g;
        private boolean d;
        private boolean a;
        private boolean f;
        private static final long h = lb.a(-2513506332532721828L, -1299402752343458223L, MethodHandles.lookup().lookupClass()).a(204679951771266L);

        public ContentState(String type) {
            this.b = type;
        }

        public ContentState(Element element) {
            long l2 = h ^ 0x68FADE5C9B2FL;
            this.b = element.getAttributeValue("type");
            this.c = Boolean.parseBoolean(element.getAttributeValue("minimized"));
            this.f = Boolean.parseBoolean(element.getAttributeValue("maximized"));
            this.e = element.getAttributeValue("selected");
            String string = element.getAttributeValue("split");
            if (string != null) {
                this.g = Double.valueOf(string);
            }
            this.d = Boolean.parseBoolean(element.getAttributeValue("detached"));
            this.a = !"false".equalsIgnoreCase(element.getAttributeValue("horizontal"));
        }

        public boolean write(Element element) {
            long l2 = h ^ 0x36B738BED5D4L;
            element.setAttribute("type", this.b);
            element.setAttribute("minimized", Boolean.valueOf(this.c).toString());
            element.setAttribute("maximized", Boolean.valueOf(this.f).toString());
            if (this.e != null) {
                element.setAttribute("selected", this.e);
            }
            element.setAttribute("split", Double.toString(this.g));
            element.setAttribute("detached", Boolean.valueOf(this.d).toString());
            element.setAttribute("horizontal", Boolean.valueOf(this.a).toString());
            return true;
        }

        public String getType() {
            return this.b;
        }

        public String getSelectedTab() {
            return this.e;
        }

        public boolean isMinimized() {
            return this.c;
        }

        public void setMinimized(boolean minimized) {
            this.c = minimized;
        }

        public void setMaximized(boolean maximized) {
            this.f = maximized;
        }

        public boolean isMaximized() {
            return this.f;
        }

        public void setSelectedTab(String selectedTab) {
            this.e = selectedTab;
        }

        public void setSplitProportion(double splitProportion) {
            this.g = splitProportion;
        }

        public double getSplitProportion(double defaultValue) {
            return this.g <= 0.0 || this.g >= 1.0 ? defaultValue : this.g;
        }

        public void setDetached(boolean detached) {
            this.d = detached;
        }

        public boolean isDetached() {
            return this.d;
        }

        public boolean isHorizontalToolbar() {
            return this.a;
        }

        public void setHorizontalToolbar(boolean horizontalToolbar) {
            this.a = horizontalToolbar;
        }

        public ContentState clone() throws CloneNotSupportedException {
            return (ContentState)super.clone();
        }
    }
}

