/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.RendererConfiguration;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.CompoundTypeRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.HexRenderer;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererSettingsListener;
import com.intellij.debugger.ui.tree.render.PrimitiveRenderer;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.InternalIterator;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NodeRendererSettings", storages={@Storage(value="debugger.xml"), @Storage(value="debugger.renderers.xml", deprecated=true)})
public class NodeRendererSettings
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String g = "Reference renderer";
    @NonNls
    public static final String RENDERER_TAG = "Renderer";
    @NonNls
    private static final String m = "ID";
    private final EventDispatcher<NodeRendererSettingsListener> d;
    private final RendererConfiguration c;
    private final PrimitiveRenderer e;
    private final ArrayRenderer k;
    private final ClassRenderer l;
    private final HexRenderer b;
    private final ToStringRenderer f;
    private final NodeRenderer[] h;
    @NonNls
    private static final String i = "HEX_VIEW_ENABLED";
    @NonNls
    private static final String j = "ALTERNATIVE_COLLECTION_VIEW_ENABLED";
    @NonNls
    private static final String a = "CustomRenderers";
    private static final long n = lb.a(7460536981995883313L, -1306793971529209109L, MethodHandles.lookup().lookupClass()).a(9298207604105L);

    public NodeRendererSettings() {
        long l2 = n ^ 0x7549BD6CAD52L;
        this.d = EventDispatcher.create(NodeRendererSettingsListener.class);
        this.c = new RendererConfiguration(this);
        this.e = new PrimitiveRenderer();
        this.k = new ArrayRenderer();
        this.l = new ClassRenderer();
        this.b = new HexRenderer();
        this.f = new ToStringRenderer();
        this.h = new NodeRenderer[]{this.createCompoundReferenceRenderer("Map", "java.util.Map", NodeRendererSettings.a(" size = ", "size()", null), NodeRendererSettings.a("entrySet().toArray()", "!isEmpty()", this.k)), this.createCompoundReferenceRenderer("Map.Entry", "java.util.Map$Entry", new MapEntryLabelRenderer(), NodeRendererSettings.createEnumerationChildrenRenderer(new String[][]{{"key", "getKey()"}, {"value", "getValue()"}})), new ListObjectRenderer(this, this.k), this.createCompoundReferenceRenderer("Collection", "java.util.Collection", NodeRendererSettings.a(" size = ", "size()", null), NodeRendererSettings.a("toArray()", "!isEmpty()", this.k))};
        this.b.setEnabled(false);
        this.setAlternateCollectionViewsEnabled(true);
    }

    public static NodeRendererSettings getInstance() {
        return (NodeRendererSettings)ServiceManager.getService(NodeRendererSettings.class);
    }

    public void setAlternateCollectionViewsEnabled(boolean enabled) {
        for (NodeRenderer nodeRenderer : this.h) {
            nodeRenderer.setEnabled(enabled);
        }
    }

    public boolean areAlternateCollectionViewsEnabled() {
        return this.h[0].isEnabled();
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof NodeRendererSettings)) {
            return false;
        }
        return DebuggerUtilsEx.elementsEqual(this.getState(), ((NodeRendererSettings)o2).getState());
    }

    public void addListener(NodeRendererSettingsListener listener, Disposable disposable) {
        this.d.addListener((EventListener)listener, disposable);
    }

    public Element getState() {
        long l2 = n ^ 0x548F0FC3FFF1L;
        Element element = new Element("state");
        if (this.b.isEnabled()) {
            JDOMExternalizerUtil.writeField((Element)element, (String)i, (String)"true");
        }
        if (!this.areAlternateCollectionViewsEnabled()) {
            JDOMExternalizerUtil.writeField((Element)element, (String)j, (String)"false");
        }
        try {
            this.a(this.f, element);
            this.a(this.l, element);
            this.a(this.e, element);
            if (this.c.getRendererCount() > 0) {
                Element element2 = new Element(a);
                element.addContent(element2);
                this.c.writeExternal(element2);
            }
        }
        catch (WriteExternalException writeExternalException) {
            // empty catch block
        }
        return element;
    }

    private void a(@NotNull Renderer renderer, @NotNull Element element) {
        Element element2;
        if (renderer == null) {
            NodeRendererSettings.a(0);
        }
        if (element == null) {
            NodeRendererSettings.a(1);
        }
        if ((element2 = this.writeRenderer(renderer)).getContentSize() == 0 && element2.getAttributes().size() <= 1) {
            return;
        }
        element.addContent(element2);
    }

    public void loadState(@NotNull Element root2) {
        String string;
        String string2;
        long l2 = n ^ 0x2C597C32792DL;
        if (root2 == null) {
            NodeRendererSettings.a(2);
        }
        if ((string2 = JDOMExternalizerUtil.readField((Element)root2, (String)i)) != null) {
            this.b.setEnabled(Boolean.parseBoolean(string2));
        }
        if ((string = JDOMExternalizerUtil.readField((Element)root2, (String)j)) != null) {
            this.setAlternateCollectionViewsEnabled(Boolean.parseBoolean(string));
        }
        for (Element element : root2.getChildren(RENDERER_TAG)) {
            String string3 = element.getAttributeValue(m);
            if (string3 == null) continue;
            try {
                if ("ToStringRenderer".equals(string3)) {
                    this.f.readExternal(element);
                    if (this.f.isEnabled()) continue;
                    this.f.setEnabled(true);
                    this.f.setOnDemand(true);
                    continue;
                }
                if ("ClassRenderer".equals(string3)) {
                    this.l.readExternal(element);
                    continue;
                }
                if (!"PrimitiveRenderer".equals(string3)) continue;
                this.e.readExternal(element);
            }
            catch (InvalidDataException invalidDataException) {}
        }
        Element element = root2.getChild(a);
        if (element != null) {
            this.c.readExternal(element);
        }
        ((NodeRendererSettingsListener)this.d.getMulticaster()).renderersChanged();
    }

    public RendererConfiguration getCustomRenderers() {
        return this.c;
    }

    public PrimitiveRenderer getPrimitiveRenderer() {
        return this.e;
    }

    public ArrayRenderer getArrayRenderer() {
        return this.k;
    }

    public ClassRenderer getClassRenderer() {
        return this.l;
    }

    public HexRenderer getHexRenderer() {
        return this.b;
    }

    public ToStringRenderer getToStringRenderer() {
        return this.f;
    }

    public NodeRenderer[] getAlternateCollectionRenderers() {
        return this.h;
    }

    public void fireRenderersChanged() {
        ((NodeRendererSettingsListener)this.d.getMulticaster()).renderersChanged();
    }

    public List<NodeRenderer> getAllRenderers() {
        ArrayList<NodeRenderer> arrayList = new ArrayList<NodeRenderer>();
        this.c.iterateRenderers((InternalIterator<NodeRenderer>)((InternalIterator)nodeRenderer -> {
            arrayList.add((NodeRenderer)nodeRenderer);
            return true;
        }));
        Collections.addAll(arrayList, NodeRenderer.EP_NAME.getExtensions());
        arrayList.add(this.b);
        arrayList.add(this.e);
        Collections.addAll(arrayList, this.h);
        arrayList.add(this.f);
        arrayList.add(this.k);
        arrayList.add(this.l);
        return arrayList;
    }

    public Renderer readRenderer(Element root2) throws InvalidDataException {
        long l2 = n ^ 0x1F14044F356DL;
        if (root2 == null) {
            return null;
        }
        if (!RENDERER_TAG.equals(root2.getName())) {
            throw new InvalidDataException("Cannot read renderer - tag name is not 'Renderer'");
        }
        String string = root2.getAttributeValue(m);
        if (string == null) {
            throw new InvalidDataException("unknown renderer ID: " + string);
        }
        Renderer renderer = this.createRenderer(string);
        if (renderer == null) {
            throw new InvalidDataException("unknown renderer ID: " + string);
        }
        renderer.readExternal(root2);
        return renderer;
    }

    @NotNull
    public Element writeRenderer(Renderer renderer) throws WriteExternalException {
        long l2 = n ^ 0x514191C51E1L;
        Element element = new Element(RENDERER_TAG);
        if (renderer != null) {
            element.setAttribute(m, renderer.getUniqueId());
            renderer.writeExternal(element);
        }
        Element element2 = element;
        if (element2 == null) {
            NodeRendererSettings.a(3);
        }
        return element2;
    }

    public Renderer createRenderer(String rendererId) {
        long l2 = n ^ 0x40024D9B6655L;
        if ("ClassRenderer".equals(rendererId)) {
            return this.l;
        }
        if ("ArrayRenderer".equals(rendererId)) {
            return this.k;
        }
        if ("PrimitiveRenderer".equals(rendererId)) {
            return this.e;
        }
        if ("HexRenderer".equals(rendererId)) {
            return this.b;
        }
        if (rendererId.equals("ExpressionChildrenRenderer")) {
            return new ExpressionChildrenRenderer();
        }
        if (rendererId.equals("LabelRenderer")) {
            return new LabelRenderer();
        }
        if (rendererId.equals("EnumerationChildrenRenderer")) {
            return new EnumerationChildrenRenderer();
        }
        if (rendererId.equals("ToStringRenderer")) {
            return this.f;
        }
        if (rendererId.equals("CompoundNodeRenderer") || rendererId.equals(g)) {
            return this.createCompoundReferenceRenderer("unnamed", "java.lang.Object", null, null);
        }
        if (rendererId.equals("CompoundTypeRenderer")) {
            return this.createCompoundTypeRenderer("unnamed", "java.lang.Object", null, null);
        }
        return null;
    }

    public CompoundTypeRenderer createCompoundTypeRenderer(@NonNls String rendererName, @NonNls String className, ValueLabelRenderer labelRenderer, ChildrenRenderer childrenRenderer) {
        CompoundTypeRenderer compoundTypeRenderer = new CompoundTypeRenderer(this, rendererName, labelRenderer, childrenRenderer);
        compoundTypeRenderer.setClassName(className);
        return compoundTypeRenderer;
    }

    public CompoundReferenceRenderer createCompoundReferenceRenderer(@NonNls String rendererName, @NonNls String className, ValueLabelRenderer labelRenderer, ChildrenRenderer childrenRenderer) {
        CompoundReferenceRenderer compoundReferenceRenderer = new CompoundReferenceRenderer(this, rendererName, labelRenderer, childrenRenderer);
        compoundReferenceRenderer.setClassName(className);
        return compoundReferenceRenderer;
    }

    private static ExpressionChildrenRenderer a(String string, String string2, ArrayRenderer arrayRenderer) {
        ExpressionChildrenRenderer expressionChildrenRenderer = NodeRendererSettings.createExpressionChildrenRenderer(string, string2);
        expressionChildrenRenderer.setPredictedRenderer(arrayRenderer);
        return expressionChildrenRenderer;
    }

    public static ExpressionChildrenRenderer createExpressionChildrenRenderer(@NonNls String expressionText, @NonNls String childrenExpandableText) {
        ExpressionChildrenRenderer expressionChildrenRenderer = new ExpressionChildrenRenderer();
        expressionChildrenRenderer.setChildrenExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expressionText, "", (FileType)StdFileTypes.JAVA));
        if (childrenExpandableText != null) {
            expressionChildrenRenderer.setChildrenExpandable(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, childrenExpandableText, "", (FileType)StdFileTypes.JAVA));
        }
        return expressionChildrenRenderer;
    }

    public static EnumerationChildrenRenderer createEnumerationChildrenRenderer(@NonNls String[][] expressions) {
        EnumerationChildrenRenderer enumerationChildrenRenderer = new EnumerationChildrenRenderer();
        if (expressions != null && expressions.length > 0) {
            ArrayList<EnumerationChildrenRenderer.ChildInfo> arrayList = new ArrayList<EnumerationChildrenRenderer.ChildInfo>(expressions.length);
            for (String[] stringArray : expressions) {
                arrayList.add(new EnumerationChildrenRenderer.ChildInfo(stringArray[0], new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, stringArray[1], "", (FileType)StdFileTypes.JAVA), false));
            }
            enumerationChildrenRenderer.setChildren(arrayList);
        }
        return enumerationChildrenRenderer;
    }

    private static LabelRenderer a(final @NonNls String string, @NonNls String string2, final @NonNls String string3) {
        LabelRenderer labelRenderer = new LabelRenderer(){

            @Override
            public String calcLabel(ValueDescriptor descriptor2, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) throws EvaluateException {
                String string2 = super.calcLabel(descriptor2, evaluationContext, labelListener);
                if (string == null && string3 == null) {
                    return string2;
                }
                if (string != null && string3 != null) {
                    return string + string2 + string3;
                }
                if (string != null) {
                    return string + string2;
                }
                return string2 + string3;
            }
        };
        labelRenderer.setLabelExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, string2, "", (FileType)StdFileTypes.JAVA));
        return labelRenderer;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = n ^ 0x59DB83946036L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/settings/NodeRendererSettings";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/settings/NodeRendererSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "writeRenderer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addRendererIfNotDefault";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DescriptorUpdater
    implements DescriptorLabelListener {
        private final ValueDescriptor b;
        @Nullable
        private ValueDescriptorImpl a;
        @Nullable
        private ValueDescriptorImpl d;
        private final DescriptorLabelListener c;
        private static final long e = lb.a(8650034108357776405L, -1787286285637142052L, MethodHandles.lookup().lookupClass()).a(98487491847583L);

        private DescriptorUpdater(ValueDescriptor descriptor2, DescriptorLabelListener delegate) {
            this.b = descriptor2;
            this.c = delegate;
        }

        public void setKeyDescriptor(@Nullable ValueDescriptorImpl keyDescriptor) {
            this.a = keyDescriptor;
        }

        public void setValueDescriptor(@Nullable ValueDescriptorImpl valueDescriptor) {
            this.d = valueDescriptor;
        }

        @Override
        public void labelChanged() {
            this.b.setValueLabel(DescriptorUpdater.constructLabelText(DescriptorUpdater.a(this.a), DescriptorUpdater.a(this.d)));
            this.c.labelChanged();
        }

        static String constructLabelText(String keylabel, String valueLabel) {
            long l2 = e ^ 0xE069E232638L;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('\"').append(keylabel).append("\" -> ");
            if (!StringUtil.isEmpty((String)valueLabel)) {
                stringBuilder.append('\"').append(valueLabel).append('\"');
            }
            return stringBuilder.toString();
        }

        private static String a(ValueDescriptorImpl valueDescriptorImpl) {
            long l2 = e ^ 0x4B920EAA5147L;
            return valueDescriptorImpl == null ? "null" : valueDescriptorImpl.getValueLabel();
        }
    }

    private static class ListObjectRenderer
    extends CompoundReferenceRenderer {
        private static final long e = lb.a(-4986935841196501380L, 8112182727296002960L, MethodHandles.lookup().lookupClass()).a(239429910179006L);

        ListObjectRenderer(NodeRendererSettings rendererSettings, ArrayRenderer arrayRenderer) {
            long l2 = e ^ 0x3565E98A666CL;
            super(rendererSettings, "List", NodeRendererSettings.a(" size = ", "size()", null), NodeRendererSettings.a("toArray()", "!isEmpty()", arrayRenderer));
            this.setClassName("java.util.List");
        }

        @Override
        public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
            long l2 = e ^ 0x3BC4ADF5D0E4L;
            LOG.assertTrue(node.getDescriptor() instanceof ArrayElementDescriptorImpl);
            try {
                return this.getChildValueExpression("this.get(" + ((ArrayElementDescriptorImpl)node.getDescriptor()).getIndex() + ")", node, context);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                return super.getChildValueExpression(node, context);
            }
        }
    }

    private static class MapEntryLabelRenderer
    extends ReferenceRenderer
    implements ValueLabelRenderer {
        private static final Computable<String> d;
        private final MyCachedEvaluator c;
        private final MyCachedEvaluator b;
        private static final long e;

        private MapEntryLabelRenderer() {
            long l2 = e ^ 0x3E579C39F253L;
            super("java.util.Map$Entry");
            this.c = new MyCachedEvaluator();
            this.b = new MyCachedEvaluator();
            this.c.setReferenceExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "this.getKey()", "", (FileType)StdFileTypes.JAVA));
            this.b.setReferenceExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "this.getValue()", "", (FileType)StdFileTypes.JAVA));
        }

        @Override
        public Icon calcValueIcon(ValueDescriptor descriptor2, EvaluationContext evaluationContext, DescriptorLabelListener listener) {
            return null;
        }

        @Override
        public String calcLabel(ValueDescriptor descriptor2, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
            DescriptorUpdater descriptorUpdater = new DescriptorUpdater(descriptor2, listener);
            Value value = descriptor2.getValue();
            Pair<Computable<String>, ValueDescriptorImpl> pair2 = this.a(evaluationContext, value, this.c, descriptorUpdater);
            Pair<Computable<String>, ValueDescriptorImpl> pair3 = this.a(evaluationContext, value, this.b, descriptorUpdater);
            descriptorUpdater.setKeyDescriptor((ValueDescriptorImpl)pair2.second);
            descriptorUpdater.setValueDescriptor((ValueDescriptorImpl)pair3.second);
            return DescriptorUpdater.constructLabelText((String)((Computable)pair2.first).compute(), (String)((Computable)pair3.first).compute());
        }

        private Pair<Computable<String>, ValueDescriptorImpl> a(EvaluationContext evaluationContext, Value value, MyCachedEvaluator myCachedEvaluator, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
            Value value2 = this.a(evaluationContext, value, myCachedEvaluator);
            if (value2 != null) {
                WatchItemDescriptor watchItemDescriptor = new WatchItemDescriptor(evaluationContext.getProject(), myCachedEvaluator.getReferenceExpression(), value2);
                watchItemDescriptor.setShowIdLabel(false);
                return new Pair(() -> {
                    watchItemDescriptor.updateRepresentation((EvaluationContextImpl)evaluationContext, descriptorLabelListener);
                    return watchItemDescriptor.getValueLabel();
                }, (Object)watchItemDescriptor);
            }
            return new Pair(d, null);
        }

        @Override
        public String getUniqueId() {
            long l2 = e ^ 0x551DF61A6E10L;
            return "MapEntry renderer";
        }

        private Value a(EvaluationContext evaluationContext, Value value, MyCachedEvaluator myCachedEvaluator) throws EvaluateException {
            long l2 = e ^ 0x5839C2248EF7L;
            DebugProcess debugProcess = evaluationContext.getDebugProcess();
            if (value == null) {
                return null;
            }
            try {
                ExpressionEvaluator expressionEvaluator = myCachedEvaluator.getEvaluator(debugProcess.getProject());
                if (!debugProcess.isAttached()) {
                    throw EvaluateExceptionUtil.PROCESS_EXITED;
                }
                EvaluationContext evaluationContext2 = evaluationContext.createEvaluationContext(value);
                return expressionEvaluator.evaluate(evaluationContext2);
            }
            catch (EvaluateException evaluateException) {
                throw new EvaluateException(DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + " " + evaluateException.getMessage(), (Throwable)evaluateException);
            }
        }

        static {
            e = lb.a(115261745546524666L, 4797427547050312410L, MethodHandles.lookup().lookupClass()).a(238466436883118L);
            d = () -> {
                long l2 = e ^ 0x672D5F66E0C8L;
                return "null";
            };
        }

        private class MyCachedEvaluator
        extends CachedEvaluator {
            private MyCachedEvaluator() {
            }

            @Override
            protected String getClassName() {
                return MapEntryLabelRenderer.this.getClassName();
            }

            @Override
            public ExpressionEvaluator getEvaluator(Project project2) throws EvaluateException {
                return super.getEvaluator(project2);
            }
        }
    }
}

