/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.settings.FieldDataBinding;
import java.lang.reflect.Field;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.NonNls;

public class ToggleButtonBinding
extends FieldDataBinding {
    private final JToggleButton b;

    public ToggleButtonBinding(@NonNls String dataFieldName, JToggleButton checkBox) {
        super(dataFieldName);
        this.b = checkBox;
    }

    @Override
    public void doLoadData(Object from, Field field) throws IllegalAccessException {
        Boolean bl2 = (Boolean)field.get(from);
        this.b.setSelected(bl2);
    }

    @Override
    public void doSaveData(Object to, Field field) throws IllegalAccessException {
        field.set(to, this.b.isSelected());
    }

    @Override
    protected boolean isModified(Object obj, Field field) throws IllegalAccessException {
        Boolean bl2 = (Boolean)field.get(obj);
        return this.b.isSelected() != bl2.booleanValue();
    }
}

