/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.util.PairFunction;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;

public class JavaLineBreakpointType
extends JavaLineBreakpointTypeBase<JavaLineBreakpointProperties> {
    private static final long a = lb.a(-8412110689349421285L, 4829960295538263903L, MethodHandles.lookup().lookupClass()).a(81411058079716L);

    public JavaLineBreakpointType() {
        long l2 = a ^ 0x3EB288F8C8F2L;
        super("java-line", DebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]));
    }

    protected JavaLineBreakpointType(@NonNls @NotNull String id2, @Nls @NotNull String title) {
        if (id2 == null) {
            JavaLineBreakpointType.b(0);
        }
        if (title == null) {
            JavaLineBreakpointType.b(1);
        }
        super(id2, title);
    }

    protected String getHelpID() {
        long l2 = a ^ 0x22CCD10D87E3L;
        return "debugging.lineBreakpoint";
    }

    public String getDisplayName() {
        long l2 = a ^ 0x5AB778028746L;
        return DebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]);
    }

    public List<XBreakpointGroupingRule<XLineBreakpoint<JavaLineBreakpointProperties>, ?>> getGroupingRules() {
        return XDebuggerUtil.getInstance().getGroupingByFileRuleAsList();
    }

    @Nullable
    public JavaLineBreakpointProperties createProperties() {
        return new JavaLineBreakpointProperties();
    }

    @NotNull
    public JavaLineBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            JavaLineBreakpointType.b(2);
        }
        JavaLineBreakpointProperties javaLineBreakpointProperties = new JavaLineBreakpointProperties();
        if (javaLineBreakpointProperties == null) {
            JavaLineBreakpointType.b(3);
        }
        return javaLineBreakpointProperties;
    }

    @Override
    @NotNull
    public Breakpoint<JavaLineBreakpointProperties> createJavaBreakpoint(Project project2, XBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        LineBreakpoint<JavaLineBreakpointProperties> lineBreakpoint = new LineBreakpoint<JavaLineBreakpointProperties>(project2, (XBreakpoint)breakpoint);
        if (lineBreakpoint == null) {
            JavaLineBreakpointType.b(4);
        }
        return lineBreakpoint;
    }

    public int getPriority() {
        return 100;
    }

    @NotNull
    public List<JavaBreakpointVariant> computeVariants(@NotNull Project project2, @NotNull XSourcePosition position) {
        SourcePosition sourcePosition;
        if (project2 == null) {
            JavaLineBreakpointType.b(5);
        }
        if (position == null) {
            JavaLineBreakpointType.b(6);
        }
        if ((sourcePosition = DebuggerUtilsEx.toSourcePosition(position, project2)) == null) {
            List<JavaBreakpointVariant> list2 = Collections.emptyList();
            if (list2 == null) {
                JavaLineBreakpointType.b(7);
            }
            return list2;
        }
        List<PsiLambdaExpression> list3 = DebuggerUtilsEx.collectLambdas(sourcePosition, true);
        if (list3.isEmpty()) {
            List<JavaBreakpointVariant> list4 = Collections.emptyList();
            if (list4 == null) {
                JavaLineBreakpointType.b(8);
            }
            return list4;
        }
        PsiElement psiElement = DebuggerUtilsEx.getContainingMethod(sourcePosition);
        if (list3.contains(psiElement) && list3.size() == 1) {
            List<JavaBreakpointVariant> list5 = Collections.emptyList();
            if (list5 == null) {
                JavaLineBreakpointType.b(9);
            }
            return list5;
        }
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(sourcePosition.getFile());
        if (document == null) {
            List<JavaBreakpointVariant> list6 = Collections.emptyList();
            if (list6 == null) {
                JavaLineBreakpointType.b(10);
            }
            return list6;
        }
        SmartList smartList = new SmartList();
        if (!(psiElement instanceof PsiLambdaExpression)) {
            smartList.add(new LineJavaBreakpointVariant(position, psiElement, -1));
        }
        int n2 = 0;
        for (PsiLambdaExpression psiLambdaExpression : list3) {
            PsiElement psiElement2 = DebuggerUtilsEx.getFirstElementOnTheLine(psiLambdaExpression, document, position.getLine());
            XSourcePositionImpl xSourcePositionImpl = XSourcePositionImpl.createByElement((PsiElement)psiElement2);
            if (xSourcePositionImpl == null) continue;
            if (psiLambdaExpression == psiElement) {
                smartList.add(0, new LineJavaBreakpointVariant((XSourcePosition)xSourcePositionImpl, (PsiElement)psiLambdaExpression, n2++));
                continue;
            }
            smartList.add(new LambdaJavaBreakpointVariant((XSourcePosition)xSourcePositionImpl, (PsiElement)psiLambdaExpression, n2++));
        }
        smartList.add(new JavaBreakpointVariant(position));
        SmartList smartList2 = smartList;
        if (smartList2 == null) {
            JavaLineBreakpointType.b(11);
        }
        return smartList2;
    }

    public boolean matchesPosition(@NotNull LineBreakpoint<?> breakpoint, @NotNull SourcePosition position) {
        Object p2;
        if (breakpoint == null) {
            JavaLineBreakpointType.b(12);
        }
        if (position == null) {
            JavaLineBreakpointType.b(13);
        }
        if ((p2 = breakpoint.getProperties()) instanceof JavaLineBreakpointProperties) {
            if (!(breakpoint instanceof RunToCursorBreakpoint) && ((JavaLineBreakpointProperties)((Object)p2)).getLambdaOrdinal() == null) {
                return true;
            }
            PsiElement psiElement = this.getContainingMethod(breakpoint);
            if (psiElement == null) {
                return false;
            }
            return DebuggerUtilsEx.inTheMethod(position, psiElement);
        }
        return true;
    }

    @Nullable
    public PsiElement getContainingMethod(@NotNull LineBreakpoint<?> breakpoint) {
        Integer n2;
        SourcePosition sourcePosition;
        if (breakpoint == null) {
            JavaLineBreakpointType.b(14);
        }
        if ((sourcePosition = breakpoint.getSourcePosition()) == null) {
            return null;
        }
        Object p2 = breakpoint.getProperties();
        if (p2 instanceof JavaLineBreakpointProperties && !(breakpoint instanceof RunToCursorBreakpoint) && (n2 = ((JavaLineBreakpointProperties)((Object)p2)).getLambdaOrdinal()) > -1) {
            List<PsiLambdaExpression> list2 = DebuggerUtilsEx.collectLambdas(sourcePosition, true);
            if (n2 < list2.size()) {
                return (PsiElement)list2.get(n2);
            }
        }
        return DebuggerUtilsEx.getContainingMethod(sourcePosition);
    }

    @Nullable
    public TextRange getHighlightRange(XLineBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        PsiElement psiElement;
        Breakpoint breakpoint2;
        Integer n2 = JavaLineBreakpointType.a(breakpoint);
        if (n2 != null && (breakpoint2 = BreakpointManager.getJavaBreakpoint(breakpoint)) instanceof LineBreakpoint && (psiElement = this.getContainingMethod((LineBreakpoint)breakpoint2)) != null) {
            return DebuggerUtilsEx.intersectWithLine(psiElement.getTextRange(), psiElement.getContainingFile(), breakpoint.getLine());
        }
        return null;
    }

    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        SourcePosition sourcePosition;
        Integer n2;
        if (breakpoint == null) {
            JavaLineBreakpointType.b(15);
        }
        if ((n2 = JavaLineBreakpointType.a(breakpoint)) != null && n2 > -1 && (sourcePosition = JavaLineBreakpointType.a((XLineBreakpointImpl)breakpoint)) != null) {
            return DebuggerUtilsEx.toXSourcePosition(new PositionManagerImpl.JavaSourcePosition(sourcePosition, n2));
        }
        return null;
    }

    @Nullable
    private static Integer a(XBreakpoint<JavaLineBreakpointProperties> xBreakpoint) {
        JavaLineBreakpointProperties javaLineBreakpointProperties = (JavaLineBreakpointProperties)xBreakpoint.getProperties();
        return javaLineBreakpointProperties != null ? javaLineBreakpointProperties.getLambdaOrdinal() : null;
    }

    @Nullable
    private static SourcePosition a(XLineBreakpointImpl xLineBreakpointImpl) {
        PsiFile psiFile;
        VirtualFile virtualFile = xLineBreakpointImpl.getFile();
        if (virtualFile != null && (psiFile = PsiManager.getInstance((Project)xLineBreakpointImpl.getProject()).findFile(virtualFile)) != null) {
            return SourcePosition.createFromLine((PsiFile)psiFile, (int)xLineBreakpointImpl.getLine());
        }
        return null;
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project2) {
        if (file == null) {
            JavaLineBreakpointType.b(16);
        }
        if (project2 == null) {
            JavaLineBreakpointType.b(17);
        }
        return JavaLineBreakpointType.canPutAtElement(file, line, project2, (PairFunction<? super PsiElement, ? super Document, Boolean>)((PairFunction)(psiElement, document) -> {
            if (project2 == null) {
                JavaLineBreakpointType.b(18);
            }
            if (psiElement instanceof PsiField) {
                PsiExpression psiExpression = ((PsiField)psiElement).getInitializer();
                if (psiExpression != null && !PsiType.NULL.equals((Object)psiExpression.getType())) {
                    Object object = JavaPsiFacade.getInstance((Project)project2).getConstantEvaluationHelper().computeConstantExpression((PsiElement)psiExpression);
                    return object == null;
                }
                return false;
            }
            if (psiElement instanceof PsiMethod) {
                PsiStatement[] psiStatementArray;
                PsiCodeBlock psiCodeBlock = ((PsiMethod)psiElement).getBody();
                if (psiCodeBlock != null && (psiStatementArray = psiCodeBlock.getStatements()).length > 0 && document.getLineNumber(psiStatementArray[0].getTextOffset()) == line) {
                    return true;
                }
                return false;
            }
            return true;
        }));
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x7AA252A8C0ABL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType";
                break;
            }
            case 5: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createBreakpointProperties";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaBreakpoint";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVariants";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointProperties";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeVariants";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "matchesPosition";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getContainingMethod";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSourcePosition";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$canPutAt$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class LambdaJavaBreakpointVariant
    extends ExactJavaBreakpointVariant {
        private static final long e = lb.a(-6441141992680052257L, 2288454224810154883L, MethodHandles.lookup().lookupClass()).a(222179546608353L);

        public LambdaJavaBreakpointVariant(@NotNull XSourcePosition position, PsiElement element, Integer lambdaOrdinal) {
            if (position == null) {
                LambdaJavaBreakpointVariant.c(0);
            }
            if (element == null) {
                LambdaJavaBreakpointVariant.c(1);
            }
            super(position, element, lambdaOrdinal);
        }

        @Override
        public Icon getIcon() {
            return AllIcons.Debugger.LambdaBreakpoint;
        }

        private static /* synthetic */ void c(int n2) {
            Object[] objectArray;
            long l2 = e ^ 0x4E66568F1F02L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "position";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$LambdaJavaBreakpointVariant";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class LineJavaBreakpointVariant
    extends ExactJavaBreakpointVariant {
        private static final long e = lb.a(-5242221383994941095L, 8613007961080997541L, MethodHandles.lookup().lookupClass()).a(157658288632328L);

        public LineJavaBreakpointVariant(@Nullable XSourcePosition position, PsiElement element, Integer lambdaOrdinal) {
            if (position == null) {
                LineJavaBreakpointVariant.c(0);
            }
            super(position, element, lambdaOrdinal);
        }

        @Override
        @NotNull
        public String getText() {
            long l2 = e ^ 0x79B350F95520L;
            if ("Line" == null) {
                LineJavaBreakpointVariant.c(1);
            }
            return "Line";
        }

        @Override
        public Icon getIcon() {
            return AllIcons.Debugger.Db_set_breakpoint;
        }

        private static /* synthetic */ void c(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = e ^ 0x3FAF78383FD2L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$LineJavaBreakpointVariant";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$LineJavaBreakpointVariant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class ExactJavaBreakpointVariant
    extends JavaBreakpointVariant {
        private final PsiElement b;
        private final Integer a;
        private static final long c = lb.a(439175875320269685L, 6980960045105888552L, MethodHandles.lookup().lookupClass()).a(261358291941479L);

        public ExactJavaBreakpointVariant(@Nullable XSourcePosition position, PsiElement element, Integer lambdaOrdinal) {
            if (position == null) {
                ExactJavaBreakpointVariant.b(0);
            }
            super(position);
            this.b = element;
            this.a = lambdaOrdinal;
        }

        public Icon getIcon() {
            return this.b != null ? this.b.getIcon(0) : AllIcons.Debugger.Db_set_breakpoint;
        }

        @NotNull
        public String getText() {
            long l2 = c ^ 0x46926AEE3930L;
            String string = this.b != null ? StringUtil.shortenTextWithEllipsis((String)this.b.getText(), (int)100, (int)0) : "Line";
            if (string == null) {
                ExactJavaBreakpointVariant.b(1);
            }
            return string;
        }

        public TextRange getHighlightRange() {
            if (this.b != null) {
                return DebuggerUtilsEx.intersectWithLine(this.b.getTextRange(), this.b.getContainingFile(), this.mySourcePosition.getLine());
            }
            return null;
        }

        @NotNull
        public JavaLineBreakpointProperties createProperties() {
            JavaLineBreakpointProperties javaLineBreakpointProperties = (JavaLineBreakpointProperties)super.createProperties();
            assert (javaLineBreakpointProperties != null);
            javaLineBreakpointProperties.setLambdaOrdinal(this.a);
            JavaLineBreakpointProperties javaLineBreakpointProperties2 = javaLineBreakpointProperties;
            if (javaLineBreakpointProperties2 == null) {
                ExactJavaBreakpointVariant.b(2);
            }
            return javaLineBreakpointProperties2;
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x24C58F7511D9L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$ExactJavaBreakpointVariant";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$ExactJavaBreakpointVariant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createProperties";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class JavaBreakpointVariant
    extends XLineBreakpointType.XLineBreakpointAllVariant {
        private static final long d = lb.a(-8716428111271578533L, 6408023934605668691L, MethodHandles.lookup().lookupClass()).a(1950333845680L);

        public JavaBreakpointVariant(XSourcePosition position) {
            if (position == null) {
                JavaBreakpointVariant.a(0);
            }
            super((XLineBreakpointType)JavaLineBreakpointType.this, position);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = d ^ 0x146D6AADACE7L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$JavaBreakpointVariant", "<init>"));
        }
    }
}

