/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class LineBreakpoint<P extends JavaBreakpointProperties>
extends BreakpointWithHighlighter<P> {
    static final Logger LOG;
    @NonNls
    public static final Key<LineBreakpoint> CATEGORY;
    private static final Pattern j;
    private static final long u;

    protected LineBreakpoint(Project project2, XBreakpoint xBreakpoint) {
        super(project2, xBreakpoint);
    }

    @Override
    protected Icon getDisabledIcon(boolean isMuted) {
        if (DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this) != null) {
            return isMuted ? AllIcons.Debugger.Db_muted_dep_line_breakpoint : AllIcons.Debugger.Db_dep_line_breakpoint;
        }
        return null;
    }

    @Override
    protected Icon getVerifiedIcon(boolean isMuted) {
        return XDebuggerUtilImpl.getVerifiedIcon((XBreakpoint)this.myXBreakpoint);
    }

    @Override
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        return new LayeredIcon(new Icon[]{isMuted ? AllIcons.Debugger.Db_muted_breakpoint : AllIcons.Debugger.Db_set_breakpoint, AllIcons.General.WarningDecorator});
    }

    @Override
    public Key<LineBreakpoint> getCategory() {
        return CATEGORY;
    }

    @Override
    protected void createOrWaitPrepare(DebugProcessImpl debugProcess, String classToBeLoaded) {
        if (this.a(debugProcess, classToBeLoaded)) {
            super.createOrWaitPrepare(debugProcess, classToBeLoaded);
        }
    }

    @Override
    protected void createRequestForPreparedClass(DebugProcessImpl debugProcess, ReferenceType classType) {
        long l2 = u ^ 0x329E066647A4L;
        if (!((Boolean)ReadAction.compute(() -> this.a(debugProcess, classType.name()))).booleanValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(classType.name() + " is out of debug-process scope, breakpoint request won't be created for line " + this.getLineIndex());
            }
            return;
        }
        try {
            List<Location> list2 = debugProcess.getPositionManager().locationsOfLine(classType, this.getSourcePosition());
            if (!list2.isEmpty()) {
                list2 = ((StreamEx)((StreamEx)StreamEx.of(list2).peek(location -> {
                    long l2 = u ^ 0x272603AD1906L;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found location [codeIndex=" + location.codeIndex() + "] for reference type " + classType.name() + " at line " + this.getLineIndex() + "; isObsolete: " + (debugProcess.getVirtualMachineProxy().versionHigher("1.4") && location.method().isObsolete()));
                    }
                })).filter(location -> this.acceptLocation(debugProcess, classType, (Location)location))).toList();
                list2 = MethodBytecodeUtil.removeSameLineLocations(list2);
                for (Location location2 : list2) {
                    LineBreakpoint.createLocationBreakpointRequest(this, location2, debugProcess);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Created breakpoint request for reference type " + classType.name() + " at line " + this.getLineIndex() + "; codeIndex=" + location2.codeIndex());
                }
            } else if (DebuggerUtilsEx.allLineLocations(classType) == null) {
                debugProcess.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.no.line.info", (Object[])new Object[]{classType.name()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No line number info in " + classType.name());
                }
            } else {
                debugProcess.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.no.executable.code", (Object[])new Object[]{this.getLineIndex() + 1, classType.name()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No locations of type " + classType.name() + " found at line " + this.getLineIndex());
                }
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ClassNotPreparedException: " + classNotPreparedException.getMessage());
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ObjectCollectedException: " + objectCollectedException.getMessage());
            }
        }
        catch (Exception exception) {
            LOG.info((Throwable)exception);
        }
        this.updateUI();
    }

    private static boolean a(ReferenceType referenceType) {
        if (referenceType instanceof ClassType) {
            return j.matcher(referenceType.name()).matches();
        }
        return false;
    }

    protected boolean acceptLocation(DebugProcessImpl debugProcess, ReferenceType classType, Location loc) {
        Method method = loc.method();
        if (LineBreakpoint.a(classType) && (method.isConstructor() && loc.codeIndex() == 0L || method.isBridge())) {
            return false;
        }
        SourcePosition sourcePosition = debugProcess.getPositionManager().getSourcePosition(loc);
        if (sourcePosition == null) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            JavaLineBreakpointType javaLineBreakpointType = this.getXBreakpointType();
            if (javaLineBreakpointType == null) {
                return true;
            }
            return javaLineBreakpointType.matchesPosition(this, sourcePosition);
        });
    }

    @Nullable
    protected JavaLineBreakpointType getXBreakpointType() {
        XBreakpointType xBreakpointType = this.myXBreakpoint.getType();
        if (xBreakpointType instanceof JavaLineBreakpointType) {
            return (JavaLineBreakpointType)xBreakpointType;
        }
        return null;
    }

    private boolean a(DebugProcessImpl debugProcessImpl, String string) {
        long l2 = u ^ 0x54E0D47D8FD5L;
        SourcePosition sourcePosition = this.getSourcePosition();
        if (sourcePosition != null) {
            VirtualFile virtualFile = sourcePosition.getFile().getVirtualFile();
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            if (virtualFile != null && projectFileIndex.isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.SOURCES)) {
                if (debugProcessImpl.getSearchScope().contains(virtualFile)) {
                    return true;
                }
                Collection<VirtualFile> collection = this.a(string, debugProcessImpl.getSearchScope(), projectFileIndex);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found " + (collection == null ? "null" : Integer.valueOf(collection.size())) + " candidate containing files for class " + string);
                }
                if (collection == null) {
                    return true;
                }
                if (LOG.isDebugEnabled()) {
                    GlobalSearchScope globalSearchScope = debugProcessImpl.getSearchScope();
                    boolean bl2 = globalSearchScope.contains(virtualFile);
                    List list2 = ContainerUtil.map((Object[])JavaPsiFacade.getInstance((Project)this.myProject).findClasses(string, globalSearchScope), psiClass -> psiClass.getContainingFile().getVirtualFile());
                    List list3 = ContainerUtil.map((Object[])JavaPsiFacade.getInstance((Project)this.myProject).findClasses(string, (GlobalSearchScope)new EverythingGlobalScope(this.myProject)), psiClass -> psiClass.getContainingFile().getVirtualFile());
                    VirtualFile virtualFile2 = projectFileIndex.getContentRootForFile(virtualFile);
                    Module module2 = projectFileIndex.getModuleForFile(virtualFile);
                    LOG.debug("Did not find '" + string + "' in " + globalSearchScope + "; contains=" + bl2 + "; contentRoot=" + virtualFile2 + "; module = " + module2 + "; all files in index are: " + list2 + "; all possible files are: " + list3);
                }
                return false;
            }
        }
        return true;
    }

    @Nullable
    private Collection<VirtualFile> a(String string, GlobalSearchScope globalSearchScope, ProjectFileIndex projectFileIndex) {
        int n2 = string.indexOf("$");
        String string2 = n2 >= 0 ? string.substring(0, n2) : string;
        return (Collection)ReadAction.compute(() -> {
            long l2 = u ^ 0x6910336E4460L;
            PsiClass[] psiClassArray = JavaPsiFacade.getInstance((Project)this.myProject).findClasses(string2, globalSearchScope);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found " + psiClassArray.length + " classes " + string2 + " in scope " + globalSearchScope);
            }
            if (psiClassArray.length == 0) {
                return null;
            }
            ArrayList<StringBuilder> arrayList = new ArrayList<StringBuilder>(psiClassArray.length);
            for (PsiClass psiClass : psiClassArray) {
                StringBuilder stringBuilder;
                PsiFile psiFile = psiClass.getContainingFile();
                if (LOG.isDebugEnabled()) {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("Checking class ").append(psiClass.getQualifiedName());
                    stringBuilder.append("\n\t").append("PsiFile=").append(psiFile);
                    if (psiFile != null) {
                        VirtualFile virtualFile = psiFile.getVirtualFile();
                        stringBuilder.append("\n\t").append("VirtualFile=").append(virtualFile);
                        if (virtualFile != null) {
                            stringBuilder.append("\n\t").append("isInSourceContent=").append(projectFileIndex.isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.SOURCES));
                        }
                    }
                    LOG.debug(stringBuilder.toString());
                }
                if (psiFile == null) {
                    return null;
                }
                stringBuilder = psiFile.getVirtualFile();
                if (stringBuilder == null || !projectFileIndex.isUnderSourceRootOfType((VirtualFile)stringBuilder, JavaModuleSourceRootTypes.SOURCES)) {
                    return null;
                }
                arrayList.add(stringBuilder);
            }
            return arrayList;
        });
    }

    @Override
    public String getShortName() {
        return this.a(false, 30);
    }

    @Override
    public String getDisplayName() {
        return this.a(true, -1);
    }

    private String a(boolean bl2, int n2) {
        long l2 = u ^ 0x719617E9A47L;
        if (this.isValid()) {
            boolean bl3;
            int n3 = this.getLineIndex() + 1;
            String string = this.getClassName();
            boolean bl4 = string != null && string.length() > 0;
            String string2 = this.getMethodName();
            String string3 = string2 != null ? string2 + "()" : null;
            boolean bl5 = bl3 = string3 != null && string3.length() > 0;
            if (bl4 || bl3) {
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl6 = this.getFileName().equals(string);
                String string4 = null;
                if (bl4) {
                    int n4;
                    int n5 = string.lastIndexOf(".");
                    if (n5 >= 0 && !bl6) {
                        string4 = string.substring(0, n5);
                        string = string.substring(n5 + 1);
                    }
                    if (n2 != -1 && string.length() + (bl3 ? string3.length() : 0) > n2 + 3 && (n4 = n2 - (bl3 ? string3.length() : 0)) > 0 && n4 < string.length()) {
                        string = string.substring(string.length() - n4);
                        stringBuilder.append("...");
                    }
                    stringBuilder.append(string);
                }
                if (bl3) {
                    if (bl6) {
                        stringBuilder.append(":");
                    } else if (bl4) {
                        stringBuilder.append(".");
                    }
                    stringBuilder.append(string3);
                }
                if (bl2 && string4 != null) {
                    stringBuilder.append(" (").append(string4).append(")");
                }
                return DebuggerBundle.message((String)"line.breakpoint.display.name.with.class.or.method", (Object[])new Object[]{n3, stringBuilder.toString()});
            }
            return DebuggerBundle.message((String)"line.breakpoint.display.name", (Object[])new Object[]{n3});
        }
        return DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
    }

    @Nullable
    private static String a(PsiFile psiFile, int n2) {
        if (n2 < 0 || psiFile instanceof JspFile) {
            return null;
        }
        if (psiFile instanceof PsiClassOwner) {
            return (String)ReadAction.compute(() -> {
                PsiMethod psiMethod = DebuggerUtilsEx.findPsiMethod(psiFile, n2);
                return psiMethod != null ? psiMethod.getName() : null;
            });
        }
        return null;
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        long l2 = u ^ 0x55B6530A7E73L;
        Location location = event.location();
        String string = DebuggerUtilsEx.getSourceName(location, throwable -> this.getFileName());
        return DebuggerBundle.message((String)"status.line.breakpoint.reached", (Object[])new Object[]{DebuggerUtilsEx.getLocationMethodQName(location), string, this.getLineIndex() + 1});
    }

    @Override
    public PsiElement getEvaluationElement() {
        return ContextUtil.getContextElement(this.getSourcePosition());
    }

    public static LineBreakpoint create(@NotNull Project project2, XBreakpoint xBreakpoint) {
        if (project2 == null) {
            LineBreakpoint.c(0);
        }
        LineBreakpoint lineBreakpoint = new LineBreakpoint(project2, xBreakpoint);
        return (LineBreakpoint)lineBreakpoint.init();
    }

    public static boolean canAddLineBreakpoint(Project project2, Document document, int lineIndex) {
        if (lineIndex < 0 || lineIndex >= document.getLineCount()) {
            return false;
        }
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(project2).getBreakpointManager();
        LineBreakpoint lineBreakpoint = breakpointManager.findBreakpoint(document, document.getLineStartOffset(lineIndex), CATEGORY);
        if (lineBreakpoint != null) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        boolean[] blArray = new boolean[]{false};
        XDebuggerUtil.getInstance().iterateLine(project2, document, lineIndex, psiElement -> {
            PsiStatement[] psiStatementArray;
            PsiCodeBlock psiCodeBlock;
            int n3;
            if (psiElement instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiComment.class, (boolean)false) != null) {
                return true;
            }
            PsiElement psiElement2 = psiElement;
            while (psiElement != null && ((n3 = psiElement.getTextOffset()) < 0 || document.getLineNumber(n3) == lineIndex)) {
                psiElement2 = psiElement;
                psiElement = psiElement.getParent();
            }
            blArray[0] = psiElement2 instanceof PsiMethod && psiElement2.getTextRange().getEndOffset() >= document.getLineEndOffset(lineIndex) ? ((psiCodeBlock = ((PsiMethod)psiElement2).getBody()) == null ? false : (psiStatementArray = psiCodeBlock.getStatements()).length > 0 && document.getLineNumber(psiStatementArray[0].getTextOffset()) == lineIndex) : true;
            return false;
        });
        return blArray[0];
    }

    @Nullable
    public String getMethodName() {
        SourcePosition sourcePosition = this.getSourcePosition();
        if (sourcePosition != null) {
            return LineBreakpoint.a(sourcePosition.getFile(), sourcePosition.getOffset());
        }
        return null;
    }

    static {
        u = lb.a(8226711366537587704L, 3902466134361244561L, MethodHandles.lookup().lookupClass()).a(198215016814784L);
        long l2 = u ^ 0x7188499E8AA5L;
        LOG = Logger.getInstance(LineBreakpoint.class);
        CATEGORY = BreakpointCategory.lookup("line_breakpoints");
        j = Pattern.compile(".*\\$\\d*$");
    }

    private static /* synthetic */ void c(int n2) {
        long l2 = u ^ 0x7B4CA79D3EB1L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/LineBreakpoint", "create"));
    }
}

