/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import b.a.lb;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.LambdaMethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StepIntoBreakpoint
extends RunToCursorBreakpoint {
    private static final Logger n;
    @NotNull
    private final BreakpointStepMethodFilter p;
    @Nullable
    private RequestHint o;
    private static final long w;

    protected StepIntoBreakpoint(@NotNull Project project2, @NotNull SourcePosition pos, @NotNull BreakpointStepMethodFilter filter) {
        if (project2 == null) {
            StepIntoBreakpoint.f(0);
        }
        if (pos == null) {
            StepIntoBreakpoint.f(1);
        }
        if (filter == null) {
            StepIntoBreakpoint.f(2);
        }
        super(project2, pos, false);
        this.p = filter;
    }

    @Override
    protected void createRequestForPreparedClass(DebugProcessImpl debugProcess, ReferenceType classType) {
        long l2 = w ^ 0x6BF325FF8772L;
        try {
            int n2;
            CompoundPositionManager compoundPositionManager = debugProcess.getPositionManager();
            List<Location> list2 = compoundPositionManager.locationsOfLine(classType, this.myCustomPosition);
            if (list2.isEmpty() && (n2 = this.p.getLastStatementLine()) >= 0) {
                int n3 = this.myCustomPosition.getLine() + 1;
                while (n3 <= n2 && list2.isEmpty()) {
                    list2 = compoundPositionManager.locationsOfLine(classType, SourcePosition.createFromLine((PsiFile)this.myCustomPosition.getFile(), (int)n3++));
                }
            }
            if (!list2.isEmpty()) {
                MultiMap multiMap = new MultiMap();
                for (Location location : list2) {
                    if (!this.acceptLocation(debugProcess, classType, location)) continue;
                    multiMap.putValue((Object)location.method(), (Object)location);
                }
                Object object = null;
                int n4 = multiMap.size();
                if (n4 == 1) {
                    object = (Location)multiMap.values().iterator().next();
                } else if (this.p instanceof LambdaMethodFilter) {
                    LambdaMethodFilter lambdaMethodFilter = (LambdaMethodFilter)this.p;
                    if (lambdaMethodFilter.getLambdaOrdinal() < n4) {
                        Method[] methodArray = multiMap.keySet().toArray(new Method[n4]);
                        Arrays.sort(methodArray, DebuggerUtilsEx.LAMBDA_ORDINAL_COMPARATOR);
                        object = (Location)multiMap.get((Object)methodArray[lambdaMethodFilter.getLambdaOrdinal()]).iterator().next();
                    }
                } else if (n4 > 0) {
                    object = (Location)multiMap.values().iterator().next();
                }
                StepIntoBreakpoint.createLocationBreakpointRequest(this, (Location)object, debugProcess);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            if (n.isDebugEnabled()) {
                n.debug("ClassNotPreparedException: " + classNotPreparedException.getMessage());
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            if (n.isDebugEnabled()) {
                n.debug("ObjectCollectedException: " + objectCollectedException.getMessage());
            }
        }
        catch (Exception exception) {
            n.info((Throwable)exception);
        }
    }

    @Override
    protected boolean acceptLocation(DebugProcessImpl debugProcess, ReferenceType classType, Location loc) {
        try {
            return this.p.locationMatches(debugProcess, loc);
        }
        catch (EvaluateException evaluateException) {
            n.info((Throwable)evaluateException);
            return true;
        }
    }

    @Nullable
    protected static StepIntoBreakpoint create(@NotNull Project project2, @NotNull BreakpointStepMethodFilter filter) {
        SourcePosition sourcePosition;
        if (project2 == null) {
            StepIntoBreakpoint.f(3);
        }
        if (filter == null) {
            StepIntoBreakpoint.f(4);
        }
        if ((sourcePosition = filter.getBreakpointPosition()) != null) {
            StepIntoBreakpoint stepIntoBreakpoint = new StepIntoBreakpoint(project2, sourcePosition, filter);
            stepIntoBreakpoint.init();
            return stepIntoBreakpoint;
        }
        return null;
    }

    @Override
    public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
        SuspendContextImpl suspendContextImpl;
        boolean bl2 = super.processLocatableEvent(action, event);
        if (bl2 && this.o != null && this.o.isResetIgnoreFilters() && (suspendContextImpl = action.getSuspendContext()) != null) {
            DebugProcessImpl debugProcessImpl = suspendContextImpl.getDebugProcess();
            debugProcessImpl.checkPositionNotFiltered(suspendContextImpl.getThread(), (Consumer<List<ClassFilter>>)((Consumer)list2 -> debugProcessImpl.getSession().resetIgnoreStepFiltersFlag()));
        }
        return bl2;
    }

    public void setRequestHint(RequestHint hint) {
        this.o = hint;
    }

    static {
        w = lb.a(5271695557686581702L, 2631940239533019228L, MethodHandles.lookup().lookupClass()).a(4963047693135L);
        long l2 = w ^ 0x5B8884F9499CL;
        n = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint");
    }

    private static /* synthetic */ void f(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = w ^ 0xEBF46BFF015L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/breakpoints/StepIntoBreakpoint";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

