/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadGroupDescriptorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.xdebugger.XDebuggerBundle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class ThreadsDebuggerTree
extends DebuggerTree {
    private static final Logger g;
    private static final long i;

    public ThreadsDebuggerTree(Project project2) {
        long l2 = i ^ 0x315F8DFF7289L;
        super(project2);
        this.getEmptyText().setText(XDebuggerBundle.message((String)"debugger.threads.not.available", (Object[])new Object[0]));
    }

    @Override
    protected NodeManagerImpl createNodeManager(Project project2) {
        return new NodeManagerImpl(project2, this){
            private static final long i = lb.a(-6566456227244995942L, -6988666442180415577L, MethodHandles.lookup().lookupClass()).a(246529330726785L);

            @Override
            public String getContextKey(StackFrameProxyImpl frame) {
                long l2 = i ^ 0x29BD543D0EC2L;
                return "ThreadsView";
            }
        };
    }

    @Override
    protected boolean isExpandable(DebuggerTreeNodeImpl node) {
        NodeDescriptorImpl nodeDescriptorImpl = node.getDescriptor();
        if (nodeDescriptorImpl instanceof StackFrameDescriptorImpl) {
            return false;
        }
        return nodeDescriptorImpl.isExpandable();
    }

    @Override
    protected void build(DebuggerContextImpl context) {
        DebuggerSession.State state;
        long l2 = i ^ 0x7B0EB510C6EFL;
        DebuggerSession debuggerSession = context.getDebuggerSession();
        RefreshThreadsTreeCommand refreshThreadsTreeCommand = new RefreshThreadsTreeCommand(debuggerSession);
        DebuggerSession.State state2 = state = debuggerSession != null ? debuggerSession.getState() : DebuggerSession.State.DISPOSED;
        if (ApplicationManager.getApplication().isUnitTestMode() || state == DebuggerSession.State.PAUSED || state == DebuggerSession.State.RUNNING) {
            this.showMessage(MessageDescriptor.EVALUATING);
            context.getDebugProcess().getManagerThread().schedule(refreshThreadsTreeCommand);
        } else {
            this.showMessage(debuggerSession != null ? debuggerSession.getStateDescription() : DebuggerBundle.message((String)"status.debug.stopped", (Object[])new Object[0]));
        }
    }

    static {
        i = lb.a(9122154537497306344L, 1073401300907401434L, MethodHandles.lookup().lookupClass()).a(69073620146143L);
        long l2 = i ^ 0x2DAC8103B68EL;
        g = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.ThreadsDebuggerTree");
    }

    private class RefreshThreadsTreeCommand
    extends DebuggerCommandImpl {
        private final DebuggerSession c;

        RefreshThreadsTreeCommand(DebuggerSession session) {
            this.c = session;
        }

        @Override
        protected void action() {
            boolean bl2;
            Object object;
            ArrayList<Object> arrayList;
            DebuggerTreeNodeImpl debuggerTreeNodeImpl = ThreadsDebuggerTree.this.getNodeFactory().getDefaultNode();
            DebugProcessImpl debugProcessImpl = this.c.getProcess();
            if (!debugProcessImpl.isAttached()) {
                return;
            }
            DebuggerContextImpl debuggerContextImpl = this.c.getContextManager().getContext();
            SuspendContextImpl suspendContextImpl = debuggerContextImpl.getSuspendContext();
            ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl != null ? suspendContextImpl.getThread() : null;
            boolean bl3 = ThreadsViewSettings.getInstance().SHOW_THREAD_GROUPS;
            try {
                Object object2;
                Object object3;
                ThreadReferenceProxyImpl threadReferenceProxyImpl2 = ThreadsViewSettings.getInstance().SHOW_CURRENT_THREAD ? threadReferenceProxyImpl : null;
                arrayList = debugProcessImpl.getVirtualMachineProxy();
                object = suspendContextImpl != null ? ThreadsDebuggerTree.this.getDebuggerContext().createEvaluationContext() : null;
                NodeManagerImpl nodeManagerImpl = ThreadsDebuggerTree.this.getNodeFactory();
                if (bl3) {
                    object3 = null;
                    if (threadReferenceProxyImpl2 != null) {
                        object3 = threadReferenceProxyImpl2.threadGroupProxy();
                        if (object3 != null) {
                            for (object2 = ((ThreadGroupReferenceProxyImpl)object3).parent(); object2 != null; object2 = ((ThreadGroupReferenceProxyImpl)object2).parent()) {
                                object3 = object2;
                            }
                        }
                        if (object3 != null) {
                            debuggerTreeNodeImpl.add(nodeManagerImpl.createNode(nodeManagerImpl.getThreadGroupDescriptor(null, (ThreadGroupReferenceProxyImpl)object3), (EvaluationContext)object));
                        } else {
                            debuggerTreeNodeImpl.add(nodeManagerImpl.createNode(nodeManagerImpl.getThreadDescriptor(null, threadReferenceProxyImpl2), (EvaluationContext)object));
                        }
                    }
                    for (ThreadGroupReferenceProxyImpl objectReferenceProxyImpl : ((VirtualMachineProxyImpl)((Object)arrayList)).topLevelThreadGroups()) {
                        if (objectReferenceProxyImpl == object3) continue;
                        DebuggerTreeNodeImpl debuggerTreeNodeImpl2 = nodeManagerImpl.createNode(nodeManagerImpl.getThreadGroupDescriptor(null, objectReferenceProxyImpl), (EvaluationContext)object);
                        debuggerTreeNodeImpl.add(debuggerTreeNodeImpl2);
                    }
                } else {
                    if (threadReferenceProxyImpl2 != null) {
                        debuggerTreeNodeImpl.insert(nodeManagerImpl.createNode(nodeManagerImpl.getThreadDescriptor(null, threadReferenceProxyImpl2), (EvaluationContext)object), 0);
                    }
                    object3 = new ArrayList<ThreadReferenceProxyImpl>(((VirtualMachineProxyImpl)((Object)arrayList)).allThreads());
                    object3.sort(ThreadReferenceProxyImpl.ourComparator);
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        ThreadReferenceProxyImpl threadReferenceProxyImpl3 = (ThreadReferenceProxyImpl)object2.next();
                        if (threadReferenceProxyImpl3.equals(threadReferenceProxyImpl2)) continue;
                        debuggerTreeNodeImpl.add(nodeManagerImpl.createNode(nodeManagerImpl.getThreadDescriptor(null, threadReferenceProxyImpl3), (EvaluationContext)object));
                    }
                }
            }
            catch (Exception exception) {
                debuggerTreeNodeImpl.add(MessageDescriptor.DEBUG_INFO_UNAVAILABLE);
                g.debug((Throwable)exception);
            }
            boolean bl4 = bl2 = threadReferenceProxyImpl != null;
            if (bl2 && bl3) {
                arrayList = new ArrayList<Object>();
                for (object = threadReferenceProxyImpl.threadGroupProxy(); object != null; object = ((ThreadGroupReferenceProxyImpl)object).parent()) {
                    arrayList.add(object);
                }
                Collections.reverse(arrayList);
            } else {
                arrayList = Collections.emptyList();
            }
            DebuggerInvocationUtil.swingInvokeLater(ThreadsDebuggerTree.this.getProject(), () -> {
                ThreadsDebuggerTree.this.getMutableModel().setRoot(debuggerTreeNodeImpl);
                ThreadsDebuggerTree.this.treeChanged();
                if (bl2) {
                    this.a(arrayList, threadReferenceProxyImpl, true);
                }
            });
        }

        private void a(final List<ThreadGroupReferenceProxyImpl> list2, final ThreadReferenceProxyImpl threadReferenceProxyImpl, final boolean bl2) {
            g.assertTrue(SwingUtilities.isEventDispatchThread());
            class MyTreeModelAdapter
            extends TreeModelAdapter {
                MyTreeModelAdapter() {
                }

                private void a(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
                    Enumeration enumeration = debuggerTreeNodeImpl.children();
                    while (enumeration.hasMoreElements()) {
                        DebuggerTreeNodeImpl debuggerTreeNodeImpl2 = (DebuggerTreeNodeImpl)enumeration.nextElement();
                        this.b(debuggerTreeNodeImpl2);
                    }
                }

                private void b(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
                    if (list2.size() == 0) {
                        if (debuggerTreeNodeImpl.getDescriptor() instanceof ThreadDescriptorImpl && ((ThreadDescriptorImpl)debuggerTreeNodeImpl.getDescriptor()).getThreadReference() == threadReferenceProxyImpl) {
                            this.a();
                            TreePath treePath = new TreePath(debuggerTreeNodeImpl.getPath());
                            ThreadsDebuggerTree.this.setSelectionPath(treePath);
                            if (bl2 && !ThreadsDebuggerTree.this.isExpanded(treePath)) {
                                ThreadsDebuggerTree.this.expandPath(treePath);
                            }
                        }
                    } else if (debuggerTreeNodeImpl.getDescriptor() instanceof ThreadGroupDescriptorImpl && ((ThreadGroupDescriptorImpl)debuggerTreeNodeImpl.getDescriptor()).getThreadGroupReference() == list2.get(0)) {
                        list2.remove(0);
                        ThreadsDebuggerTree.this.expandPath(new TreePath(debuggerTreeNodeImpl.getPath()));
                    }
                }

                private void a() {
                    MyTreeModelAdapter myTreeModelAdapter = this;
                    SwingUtilities.invokeLater(() -> ThreadsDebuggerTree.this.getModel().removeTreeModelListener((TreeModelListener)((Object)myTreeModelAdapter)));
                }

                public void treeStructureChanged(TreeModelEvent event) {
                    if (event.getPath().length <= 1) {
                        this.a();
                        return;
                    }
                    this.a((DebuggerTreeNodeImpl)event.getTreePath().getLastPathComponent());
                }
            }
            MyTreeModelAdapter myTreeModelAdapter = new MyTreeModelAdapter();
            myTreeModelAdapter.a((DebuggerTreeNodeImpl)ThreadsDebuggerTree.this.getModel().getRoot());
            ThreadsDebuggerTree.this.getModel().addTreeModelListener((TreeModelListener)((Object)myTreeModelAdapter));
        }
    }
}

