/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import b.a.lb;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.lang.invoke.MethodHandles;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;

public class TipManager
implements Disposable,
PopupMenuListener {
    private volatile boolean k = false;
    private boolean c;
    private MyAwtPreprocessor m;
    private MouseEvent a;
    boolean myInsideComponent;
    private JComponent e;
    private Popup j;
    private final TipFactory h;
    private final JComponent f;
    private MouseListener b = new MyMouseListener();
    private MouseMotionListener i = new MyMouseMotionListener();
    private FrameStateListener d = new MyFrameStateListener();
    private final Alarm g = new Alarm();
    private final Alarm l = new Alarm();
    private static final long n = lb.a(-8718310937197797530L, -4997361592784607257L, MethodHandles.lookup().lookupClass()).a(232399668738994L);

    private boolean a(MouseEvent mouseEvent) {
        if (this.e != null) {
            if (!this.e.isShowing()) {
                this.hideTooltip(true);
                return false;
            }
            Component component = mouseEvent.getComponent();
            if (component == null) {
                return false;
            }
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, component);
            Rectangle rectangle = this.e.getBounds();
            Point point2 = this.e.getLocationOnScreen();
            rectangle.setLocation(point2.x, point2.y);
            return rectangle.contains(point);
        }
        return false;
    }

    public JPopupMenu registerPopup(JPopupMenu menu) {
        menu.addPopupMenuListener(this);
        return menu;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e10) {
        this.c = true;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e10) {
        this.a(e10);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e10) {
        this.a(e10);
    }

    private void a(PopupMenuEvent popupMenuEvent) {
        this.c = false;
        if (popupMenuEvent.getSource() instanceof JPopupMenu) {
            ((JPopupMenu)popupMenuEvent.getSource()).removePopupMenuListener(this);
        }
    }

    private boolean b(MouseEvent mouseEvent) {
        Rectangle rectangle = this.f.getVisibleRect();
        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.f);
        return rectangle.contains(point);
    }

    private void b(InputEvent inputEvent, boolean bl2) {
        this.g.cancelAllRequests();
        this.l.cancelAllRequests();
        this.g.addRequest(() -> {
            if (!this.k && !this.c) {
                this.c(inputEvent, bl2);
            }
        }, bl2 ? XDebuggerSettingsManager.getInstance().getDataViewSettings().getValueLookupDelay() : 10);
    }

    private void c(InputEvent inputEvent, boolean bl2) {
        long l2 = n ^ 0x5D5B796F300FL;
        if (bl2 && !Registry.is((String)"debugger.valueTooltipAutoShow")) {
            return;
        }
        MouseEvent mouseEvent = null;
        JComponent jComponent = null;
        if (inputEvent instanceof MouseEvent) {
            mouseEvent = (MouseEvent)inputEvent;
        } else if (inputEvent instanceof KeyEvent) {
            mouseEvent = this.h.createTooltipEvent(this.a);
        }
        MouseEvent mouseEvent2 = null;
        if (mouseEvent != null) {
            mouseEvent2 = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, this.f);
            jComponent = this.h.createToolTip(mouseEvent2);
        }
        if (jComponent == null || bl2 && !this.h.isFocusOwner()) {
            this.hideTooltip(false);
            return;
        }
        if (jComponent == this.e) {
            if (!bl2) {
                this.hideTooltip(true);
                return;
            }
            return;
        }
        this.hideTooltip(true);
        if (this.f.isShowing()) {
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            Point point = mouseEvent2.getPoint();
            Component component = mouseEvent2.getComponent();
            if (component != null) {
                SwingUtilities.convertPointToScreen(point, component);
            }
            this.j = popupFactory.getPopup(this.f, jComponent, point.x, point.y);
            this.myInsideComponent = false;
            this.j.show();
            this.e = jComponent;
        }
    }

    public void hideTooltip() {
        this.hideTooltip(true);
    }

    public void hideTooltip(boolean now) {
        if (this.j == null) {
            return;
        }
        if (now) {
            this.l.cancelAllRequests();
            this.j.hide();
            this.j = null;
            this.e = null;
        } else {
            this.l.addRequest(() -> {
                if (this.myInsideComponent) {
                    this.hideTooltip(true);
                }
            }, 100);
        }
    }

    public TipManager(JComponent component, TipFactory factory2) {
        this.h = factory2;
        this.f = component;
        new UiNotifyConnector.Once((Component)component, new Activatable(){

            public void showNotify() {
                TipManager.this.b();
            }

            public void hideNotify() {
            }
        });
        final HideTooltipAction hideTooltipAction = new HideTooltipAction();
        hideTooltipAction.registerCustomShortcutSet(CommonShortcuts.ESCAPE, this.f);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                hideTooltipAction.unregisterCustomShortcutSet(TipManager.this.f);
            }
        });
    }

    private void b() {
        if (this.k) {
            return;
        }
        IdeGlassPane ideGlassPane = IdeGlassPaneUtil.find((Component)this.f);
        assert (ideGlassPane != null);
        ideGlassPane.addMousePreprocessor(this.b, (Disposable)this);
        ideGlassPane.addMouseMotionPreprocessor(this.i, (Disposable)this);
        this.m = new MyAwtPreprocessor();
        Toolkit.getDefaultToolkit().addAWTEventListener(this.m, 56L);
        FrameStateManager.getInstance().addListener(this.d);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this);
        this.hideTooltip(true);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.m);
        this.k = true;
        this.g.cancelAllRequests();
        this.b = null;
        this.i = null;
        FrameStateManager.getInstance().removeListener(this.d);
        this.d = null;
    }

    private class MyAwtPreprocessor
    implements AWTEventListener {
        private MyAwtPreprocessor() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event.getID() == 503) {
                this.a(event);
            } else if (event.getID() == 501 || event.getID() == 502) {
                this.b((MouseEvent)event);
            } else if (event instanceof KeyEvent) {
                this.a((KeyEvent)event);
            }
        }

        private void b(MouseEvent mouseEvent) {
            if (TipManager.this.e == null) {
                return;
            }
            if (this.a(mouseEvent) && UIUtil.isCloseClick((MouseEvent)mouseEvent)) {
                TipManager.this.hideTooltip(true);
            }
        }

        private void a(KeyEvent keyEvent) {
            if (KeymapUtil.isTooltipRequest((KeyEvent)keyEvent)) {
                TipManager.this.b(keyEvent, false);
            } else if (keyEvent.getID() == 401) {
                TipManager.this.a = null;
            }
        }

        private void a(AWTEvent aWTEvent) {
            MouseEvent mouseEvent;
            if (TipManager.this.e == null) {
                return;
            }
            if (aWTEvent.getID() == 503 && this.a(mouseEvent = (MouseEvent)aWTEvent)) {
                TipManager.this.l.cancelAllRequests();
            }
        }

        private boolean a(MouseEvent mouseEvent) {
            return TipManager.this.e == mouseEvent.getComponent() || SwingUtilities.isDescendingFrom(mouseEvent.getComponent(), TipManager.this.e);
        }
    }

    private class HideTooltipAction
    extends AnAction {
        private static final long a = lb.a(1814058621081565796L, -4498542040007275145L, MethodHandles.lookup().lookupClass()).a(223141085952757L);

        private HideTooltipAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                HideTooltipAction.a(0);
            }
            TipManager.this.hideTooltip(true);
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                HideTooltipAction.a(1);
            }
            e10.getPresentation().setEnabled(TipManager.this.j != null);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x42011F99C0EFL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/debugger/ui/impl/TipManager$HideTooltipAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter
    implements Weighted {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e10) {
            TipManager.this.a = e10;
            if (!TipManager.this.f.isShowing()) {
                return;
            }
            TipManager.this.myInsideComponent = true;
            if (TipManager.this.e == null) {
                if (TipManager.this.b(e10)) {
                    TipManager.this.b(e10, true);
                }
            } else if (!TipManager.this.a(e10)) {
                TipManager.this.b(e10, true);
            }
        }

        public double getWeight() {
            return 0.0;
        }
    }

    private class MyFrameStateListener
    implements FrameStateListener {
        private MyFrameStateListener() {
        }

        public void onFrameDeactivated() {
            TipManager.this.hideTooltip(true);
        }
    }

    private class MyMouseListener
    extends MouseAdapter
    implements Weighted {
        private MyMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent e10) {
            TipManager.this.myInsideComponent = false;
        }

        @Override
        public void mousePressed(MouseEvent e10) {
            if (TipManager.this.myInsideComponent) {
                TipManager.this.hideTooltip(true);
            }
        }

        public double getWeight() {
            return 0.0;
        }

        @Override
        public void mouseEntered(MouseEvent e10) {
            TipManager.this.myInsideComponent = true;
        }
    }

    public static interface TipFactory {
        public JComponent createToolTip(MouseEvent var1);

        public MouseEvent createTooltipEvent(MouseEvent var1);

        public boolean isFocusOwner();
    }
}

