/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.tree;

import com.intellij.debugger.ui.impl.tree.TreeBuilderNode;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class TreeBuilder
implements TreeModel {
    private final Object a;
    private TreeBuilderNode c;
    private final EventDispatcher<TreeModelListener> b = EventDispatcher.create(TreeModelListener.class);

    protected TreeBuilder(Object userObject) {
        this.a = userObject;
    }

    public Object getUserObject() {
        return this.a;
    }

    public abstract void buildChildren(TreeBuilderNode var1);

    public abstract boolean isExpandable(TreeBuilderNode var1);

    public void setRoot(TreeBuilderNode root2) {
        this.c = root2;
    }

    @Override
    public Object getRoot() {
        return this.c;
    }

    @Override
    public int getChildCount(Object parent) {
        return ((TreeBuilderNode)parent).getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((TreeBuilderNode)node).isLeaf();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l2) {
        this.b.addListener((EventListener)l2);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l2) {
        this.b.removeListener((EventListener)l2);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((TreeBuilderNode)parent).getChildAt(index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((TreeBuilderNode)parent).getIndex((TreeNode)child);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        TreeBuilderNode treeBuilderNode = (TreeBuilderNode)path.getLastPathComponent();
        treeBuilderNode.setUserObject(newValue);
        this.nodeChanged(treeBuilderNode);
    }

    public void nodeChanged(TreeNode node) {
        TreeModelEvent treeModelEvent = null;
        TreeNode treeNode = node.getParent();
        if (treeNode != null) {
            int n2 = treeNode.getIndex(node);
            treeModelEvent = new TreeModelEvent((Object)this, this.getPathToRoot(treeNode, 0), new int[]{n2}, new Object[]{node});
        } else if (node == this.getRoot()) {
            treeModelEvent = new TreeModelEvent((Object)this, this.getPathToRoot(node, 0), null, null);
        }
        if (treeModelEvent != null) {
            ((TreeModelListener)this.b.getMulticaster()).treeNodesChanged(treeModelEvent);
        }
    }

    public void nodeStructureChanged(TreeNode node) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, this.getPathToRoot(node, 0), null, null);
        ((TreeModelListener)this.b.getMulticaster()).treeStructureChanged(treeModelEvent);
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] treeNodeArray;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            treeNodeArray = new TreeNode[depth];
        } else {
            treeNodeArray = aNode == this.c ? new TreeNode[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            treeNodeArray[treeNodeArray.length - depth] = aNode;
        }
        return treeNodeArray;
    }

    public void removeNodeFromParent(TreeBuilderNode node) {
        TreeBuilderNode treeBuilderNode = (TreeBuilderNode)node.getParent();
        if (treeBuilderNode != null) {
            treeBuilderNode.remove(node);
        }
    }
}

