/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import b.a.lb;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.jdi.LocalVariableProxy;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.impl.descriptors.data.ArgValueData;
import com.intellij.debugger.impl.descriptors.data.ArrayItemData;
import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.DescriptorKey;
import com.intellij.debugger.impl.descriptors.data.DisplayKey;
import com.intellij.debugger.impl.descriptors.data.FieldData;
import com.intellij.debugger.impl.descriptors.data.LocalData;
import com.intellij.debugger.impl.descriptors.data.MethodReturnValueData;
import com.intellij.debugger.impl.descriptors.data.StackFrameData;
import com.intellij.debugger.impl.descriptors.data.StaticData;
import com.intellij.debugger.impl.descriptors.data.StaticFieldData;
import com.intellij.debugger.impl.descriptors.data.ThisData;
import com.intellij.debugger.impl.descriptors.data.ThreadData;
import com.intellij.debugger.impl.descriptors.data.ThreadGroupData;
import com.intellij.debugger.impl.descriptors.data.ThrownExceptionValueData;
import com.intellij.debugger.impl.descriptors.data.WatchItemData;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.ArgumentValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.DescriptorTree;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MarkedDescriptorTree;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadGroupDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.UserExpressionDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeDescriptorFactoryImpl
implements NodeDescriptorFactory {
    private static final Logger b;
    private DescriptorTree a = new DescriptorTree(true);
    private DescriptorTreeSearcher c;
    private DescriptorTreeSearcher d;
    protected final Project myProject;
    private static final long j;

    public NodeDescriptorFactoryImpl(Project project2) {
        this.myProject = project2;
        this.c = new DescriptorTreeSearcher(new MarkedDescriptorTree());
        this.d = new DisplayDescriptorTreeSearcher(new MarkedDescriptorTree());
    }

    public void dispose() {
        this.a.clear();
        this.c.clear();
        this.d.clear();
    }

    @NotNull
    public <T extends NodeDescriptor> T getDescriptor(NodeDescriptor parent, DescriptorData<T> key) {
        T t2 = key.createDescriptor(this.myProject);
        T t3 = this.findDescriptor(parent, t2, key);
        if (t3 != null && t3.getClass() == t2.getClass()) {
            t2.setAncestor(t3);
        } else {
            T t4 = this.findDisplayDescriptor(parent, t2, key.getDisplayKey());
            if (t4 != null) {
                t2.displayAs(t4);
            }
        }
        this.a.addChild(parent, (NodeDescriptor)t2);
        T t5 = t2;
        if (t5 == null) {
            NodeDescriptorFactoryImpl.a(0);
        }
        return t5;
    }

    @Nullable
    protected <T extends NodeDescriptor> T findDisplayDescriptor(NodeDescriptor parent, T descriptor2, DisplayKey<T> key) {
        return this.d.search(parent, descriptor2, key);
    }

    @Nullable
    protected <T extends NodeDescriptor> T findDescriptor(NodeDescriptor parent, T descriptor2, DescriptorData<T> key) {
        return this.c.search(parent, descriptor2, key);
    }

    public DescriptorTree getCurrentHistoryTree() {
        return this.a;
    }

    public void deriveHistoryTree(DescriptorTree tree2, StackFrameContext context) {
        this.deriveHistoryTree(tree2, context.getFrameProxy());
    }

    public void deriveHistoryTree(DescriptorTree tree2, StackFrameProxy frameProxy) {
        final MarkedDescriptorTree markedDescriptorTree = new MarkedDescriptorTree();
        final MarkedDescriptorTree markedDescriptorTree2 = new MarkedDescriptorTree();
        tree2.dfst(new DescriptorTree.DFSTWalker(){

            @Override
            public void visit(NodeDescriptor parent, NodeDescriptor child) {
                DescriptorData<NodeDescriptor> descriptorData = DescriptorData.getDescriptorData(child);
                markedDescriptorTree.addChild(parent, child, descriptorData);
                markedDescriptorTree2.addChild(parent, child, descriptorData.getDisplayKey());
            }
        });
        this.c = new DescriptorTreeSearcher(markedDescriptorTree);
        this.d = new DisplayDescriptorTreeSearcher(markedDescriptorTree2);
        this.a = NodeDescriptorFactoryImpl.a(frameProxy, tree2);
    }

    private static DescriptorTree a(StackFrameProxy stackFrameProxy, DescriptorTree descriptorTree) {
        int n2 = -1;
        int n3 = -1;
        if (stackFrameProxy != null) {
            try {
                ThreadReferenceProxy threadReferenceProxy = stackFrameProxy.threadProxy();
                n2 = threadReferenceProxy.frameCount();
                n3 = stackFrameProxy.getFrameIndex();
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        boolean bl2 = !descriptorTree.frameIdEquals(n2, n3);
        DescriptorTree descriptorTree2 = new DescriptorTree(bl2);
        descriptorTree2.setFrameId(n2, n3);
        return descriptorTree2;
    }

    @Override
    public ArrayElementDescriptorImpl getArrayItemDescriptor(NodeDescriptor parent, ArrayReference array, int index) {
        return this.getDescriptor(parent, new ArrayItemData(array, index));
    }

    @Override
    @NotNull
    public FieldDescriptorImpl getFieldDescriptor(NodeDescriptor parent, ObjectReference objRef, Field field) {
        DescriptorData descriptorData;
        long l2 = j ^ 0x20045D612A7DL;
        if (objRef == null) {
            if (!field.isStatic()) {
                b.error("Object reference is null for non-static field: " + field);
            }
            descriptorData = new StaticFieldData(field);
        } else {
            descriptorData = new FieldData(objRef, field);
        }
        FieldDescriptorImpl fieldDescriptorImpl = this.getDescriptor(parent, descriptorData);
        if (fieldDescriptorImpl == null) {
            NodeDescriptorFactoryImpl.a(1);
        }
        return fieldDescriptorImpl;
    }

    @Override
    public LocalVariableDescriptorImpl getLocalVariableDescriptor(NodeDescriptor parent, LocalVariableProxy local) {
        return this.getDescriptor(parent, new LocalData((LocalVariableProxyImpl)local));
    }

    public ArgumentValueDescriptorImpl getArgumentValueDescriptor(NodeDescriptor parent, DecompiledLocalVariable variable, Value value) {
        return this.getDescriptor(parent, new ArgValueData(variable, value));
    }

    public StackFrameDescriptorImpl getStackFrameDescriptor(@Nullable NodeDescriptorImpl parent, @NotNull StackFrameProxyImpl frameProxy) {
        if (frameProxy == null) {
            NodeDescriptorFactoryImpl.a(2);
        }
        return this.getDescriptor(parent, new StackFrameData(frameProxy));
    }

    public StaticDescriptorImpl getStaticDescriptor(NodeDescriptorImpl parent, ReferenceType refType) {
        return this.getDescriptor(parent, new StaticData(refType));
    }

    public ValueDescriptorImpl getThisDescriptor(NodeDescriptorImpl parent, Value value) {
        return this.getDescriptor(parent, new ThisData());
    }

    public ValueDescriptorImpl getMethodReturnValueDescriptor(NodeDescriptorImpl parent, Method method, Value value) {
        return this.getDescriptor(parent, new MethodReturnValueData(method, value));
    }

    public ValueDescriptorImpl getThrownExceptionObjectDescriptor(NodeDescriptorImpl parent, ObjectReference exceptionObject) {
        return this.getDescriptor(parent, new ThrownExceptionValueData(exceptionObject));
    }

    public ThreadDescriptorImpl getThreadDescriptor(NodeDescriptorImpl parent, ThreadReferenceProxyImpl thread) {
        return this.getDescriptor(parent, new ThreadData(thread));
    }

    public ThreadGroupDescriptorImpl getThreadGroupDescriptor(NodeDescriptorImpl parent, ThreadGroupReferenceProxyImpl group2) {
        return this.getDescriptor(parent, new ThreadGroupData(group2));
    }

    @Override
    public UserExpressionDescriptor getUserExpressionDescriptor(NodeDescriptor parent, DescriptorData<UserExpressionDescriptor> data) {
        return this.getDescriptor(parent, data);
    }

    public WatchItemDescriptor getWatchItemDescriptor(NodeDescriptor parent, TextWithImports text2, @Nullable Value value) {
        return this.getDescriptor(parent, new WatchItemData(text2, value));
    }

    static {
        j = lb.a(7935229817364752267L, 9174565505822953599L, MethodHandles.lookup().lookupClass()).a(263603461316000L);
        long l2 = j ^ 0x72B40FE2E047L;
        b = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.watch.NodeDescriptorFactoryImpl");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = j ^ 0x67A86DE75795L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/impl/watch/NodeDescriptorFactoryImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameProxy";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/impl/watch/NodeDescriptorFactoryImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStackFrameDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DisplayDescriptorTreeSearcher
    extends DescriptorTreeSearcher {
        DisplayDescriptorTreeSearcher(MarkedDescriptorTree descriptorTree) {
            super(descriptorTree);
        }

        @Override
        protected NodeDescriptor getSearched(NodeDescriptor parent) {
            NodeDescriptor nodeDescriptor = super.getSearched(parent);
            if (nodeDescriptor == null) {
                return NodeDescriptorFactoryImpl.this.c.getSearched(parent);
            }
            return nodeDescriptor;
        }
    }

    private static class DescriptorTreeSearcher {
        private final MarkedDescriptorTree b;
        private final HashMap<NodeDescriptor, NodeDescriptor> a = new HashMap();

        DescriptorTreeSearcher(MarkedDescriptorTree descriptorTree) {
            this.b = descriptorTree;
        }

        @Nullable
        public <T extends NodeDescriptor> T search(NodeDescriptor parent, T descriptor2, DescriptorKey<T> key) {
            T t2;
            if (parent == null) {
                t2 = this.b.getChild(null, key);
            } else {
                NodeDescriptor nodeDescriptor = this.getSearched(parent);
                t2 = nodeDescriptor != null ? this.b.getChild(nodeDescriptor, key) : null;
                Object v0 = t2;
            }
            if (t2 != null) {
                this.a.put(descriptor2, (NodeDescriptor)t2);
            }
            return t2;
        }

        protected NodeDescriptor getSearched(NodeDescriptor parent) {
            return this.a.get(parent);
        }

        public void clear() {
            this.a.clear();
            this.b.clear();
        }
    }
}

