/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.overhead;

import b.a.lb;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.debugger.ui.overhead.OverheadTimings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Function;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverheadView
extends BorderLayoutPanel
implements Disposable,
DataProvider {
    @NotNull
    private final DebugProcessImpl e;
    static final EnabledColumnInfo ENABLED_COLUMN;
    static final NameColumnInfo NAME_COLUMN;
    private final TableView<OverheadProducer> b;
    private final ListTableModel<OverheadProducer> c;
    private final MergingUpdateQueue d;
    private Runnable a;
    private static final long f;

    public OverheadView(final @NotNull DebugProcessImpl process2) {
        long l2 = f ^ 0x4FFBF13140E0L;
        if (process2 == null) {
            OverheadView.a(0);
        }
        this.e = process2;
        this.c = new ListTableModel(new ColumnInfo[]{ENABLED_COLUMN, NAME_COLUMN, new TimingColumnInfo("Hits", overheadProducer -> OverheadTimings.getHits(this.e, overheadProducer)), new TimingColumnInfo("Time (ms)", overheadProducer -> OverheadTimings.getTime(this.e, overheadProducer))}, new ArrayList<OverheadProducer>(OverheadTimings.getProducers(process2)), 3, SortOrder.DESCENDING);
        this.c.setSortable(true);
        this.b = new TableView(this.c);
        this.addToCenter(ScrollPaneFactory.createScrollPane(this.b));
        TableUtil.setupCheckboxColumn((TableColumn)this.b.getColumnModel().getColumn(0));
        this.d = new MergingUpdateQueue("OverheadView", 500, true, null, (Disposable)this);
        this.d.setPassThrough(false);
        OverheadTimings.addListener(new OverheadTimings.OverheadTimingsListener(){

            @Override
            public void timingAdded(final OverheadProducer o2) {
                OverheadView.this.d.queue(new Update(o2){

                    public void run() {
                        int n2 = OverheadView.this.c.indexOf((Object)o2);
                        if (n2 != -1) {
                            OverheadView.this.c.fireTableRowsUpdated(n2, n2);
                            return;
                        }
                        OverheadView.this.c.setItems(new ArrayList<OverheadProducer>(OverheadTimings.getProducers(process2)));
                    }
                });
            }

            @Override
            public void excessiveOverheadDetected() {
                if (OverheadView.this.a != null) {
                    DebuggerUIUtil.invokeLater((Runnable)OverheadView.this.a);
                }
            }
        }, process2);
        new DumbAwareAction("Toggle"){
            private static final long a = lb.a(5908955214244052363L, -1941159988435350200L, MethodHandles.lookup().lookupClass()).a(6774976429494L);

            public void update(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    2.a(0);
                }
                e10.getPresentation().setEnabled(OverheadView.this.b.getSelectedRowCount() == 1);
            }

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    2.a(1);
                }
                OverheadView.this.b.getSelection().forEach(overheadProducer -> overheadProducer.setEnabled(!overheadProducer.isEnabled()));
                OverheadView.this.b.repaint();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x1A25761F65C7L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/debugger/ui/overhead/OverheadView$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), this.b);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e10) {
                OverheadView.this.a().findFirst().ifPresent(navigatable -> navigatable.navigate(true));
                return true;
            }
        }.installOn(this.b);
    }

    private StreamEx<Navigatable> a() {
        return StreamEx.of((Collection)this.b.getSelection()).select(Breakpoint.class).map(Breakpoint::getXBreakpoint).nonNull().map(XBreakpoint::getNavigatable).nonNull();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Navigatable[] navigatableArray;
        if (dataId == null) {
            OverheadView.a(1);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId) && (navigatableArray = (Navigatable[])this.a().toArray(Navigatable.class)).length > 0) {
            return navigatableArray;
        }
        return null;
    }

    public void dispose() {
    }

    public void setBouncer(Runnable bouncer) {
        this.a = bouncer;
    }

    static {
        f = lb.a(-4168193640966183044L, 1731742185062670792L, MethodHandles.lookup().lookupClass()).a(72661311919269L);
        ENABLED_COLUMN = new EnabledColumnInfo();
        NAME_COLUMN = new NameColumnInfo();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = f ^ 0x2FF182EAC36L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/overhead/OverheadView";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TimingColumnInfo
    extends ColumnInfo<OverheadProducer, OverheadProducer> {
        private final Function<OverheadProducer, Long> a;
        private static final long b = lb.a(2448171571576209763L, 1262839107495804189L, MethodHandles.lookup().lookupClass()).a(109737458223607L);

        TimingColumnInfo(@NotNull String name2, Function<OverheadProducer, Long> getter) {
            if (name2 == null) {
                TimingColumnInfo.a(0);
            }
            super(name2);
            this.a = getter;
        }

        @Nullable
        public OverheadProducer valueOf(OverheadProducer aspects) {
            return aspects;
        }

        public Class<?> getColumnClass() {
            return OverheadProducer.class;
        }

        @Nullable
        public TableCellRenderer getRenderer(OverheadProducer producer) {
            return new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (value instanceof OverheadProducer) {
                        OverheadProducer overheadProducer = (OverheadProducer)value;
                        Long l2 = (Long)a.apply(overheadProducer);
                        this.append(l2 != null ? String.valueOf(l2) : "", overheadProducer.isEnabled() ? SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            };
        }

        @Nullable
        public Comparator<OverheadProducer> getComparator() {
            return Comparator.comparing(overheadProducer -> {
                Long l2 = this.a.apply((OverheadProducer)overheadProducer);
                return l2 != null ? l2 : Long.MAX_VALUE;
            });
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x2127A3C72539L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/debugger/ui/overhead/OverheadView$TimingColumnInfo", "<init>"));
        }
    }

    private static class NameColumnInfo
    extends ColumnInfo<OverheadProducer, OverheadProducer> {
        private static final long a = lb.a(-929611290256634441L, -3823394797605546784L, MethodHandles.lookup().lookupClass()).a(189655251353836L);

        NameColumnInfo() {
            long l2 = a ^ 0x4EC0F916918EL;
            super("Name");
        }

        @Nullable
        public OverheadProducer valueOf(OverheadProducer aspects) {
            return aspects;
        }

        public Class<?> getColumnClass() {
            return OverheadProducer.class;
        }

        @Nullable
        public TableCellRenderer getRenderer(OverheadProducer producer) {
            return new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (value instanceof OverheadProducer) {
                        OverheadProducer overheadProducer = (OverheadProducer)value;
                        if (!overheadProducer.isEnabled()) {
                            SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
                            overheadProducer.customizeRenderer(simpleColoredComponent);
                            simpleColoredComponent.iterator().forEachRemaining(string -> this.append((String)string, SimpleTextAttributes.GRAYED_ATTRIBUTES));
                            this.setIcon(simpleColoredComponent.getIcon());
                        } else {
                            overheadProducer.customizeRenderer((SimpleColoredComponent)this);
                        }
                    }
                    this.setTransparentIconBackground(true);
                }
            };
        }
    }

    private static class EnabledColumnInfo
    extends ColumnInfo<OverheadProducer, Boolean> {
        EnabledColumnInfo() {
            super("");
        }

        public Class<?> getColumnClass() {
            return Boolean.class;
        }

        @Nullable
        public Boolean valueOf(OverheadProducer item) {
            return item.isEnabled();
        }

        public boolean isCellEditable(OverheadProducer item) {
            return true;
        }

        public void setValue(OverheadProducer item, Boolean value) {
            item.setEnabled(value);
        }
    }
}

