/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.ArrayAction;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.memory.utils.ErrorsValueGroup;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.ViewsGeneralSettings;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class ArrayRenderer
extends NodeRendererImpl {
    private static final Logger c;
    @NonNls
    public static final String UNIQUE_ID = "ArrayRenderer";
    public int START_INDEX;
    public int END_INDEX;
    public int ENTRIES_LIMIT;
    private boolean b;
    private static final long e;

    public ArrayRenderer() {
        long l2 = e ^ 0x4268CA985525L;
        super("unnamed", true);
        this.START_INDEX = 0;
        this.END_INDEX = Integer.MAX_VALUE;
        this.ENTRIES_LIMIT = 100;
        this.b = false;
    }

    @Override
    public String getUniqueId() {
        long l2 = e ^ 0x753D5AD0DE79L;
        return UNIQUE_ID;
    }

    @Override
    @NonNls
    public String getName() {
        long l2 = e ^ 0x4F3E2730C972L;
        return "Array";
    }

    @Override
    public void setName(String text2) {
        c.assertTrue(false);
    }

    @Override
    public ArrayRenderer clone() {
        return (ArrayRenderer)super.clone();
    }

    @Override
    public String calcLabel(ValueDescriptor descriptor2, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
        return ClassRenderer.calcLabel(descriptor2);
    }

    public void setForced(boolean forced) {
        this.b = forced;
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        long l2 = e ^ 0x19B3245C9E8EL;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        NodeManagerImpl nodeManagerImpl = (NodeManagerImpl)builder.getNodeManager();
        NodeDescriptorFactory nodeDescriptorFactory = builder.getDescriptorManager();
        ArrayReference arrayReference = (ArrayReference)value;
        int n2 = arrayReference.length();
        if (n2 > 0) {
            int n3;
            if (!this.b) {
                builder.initChildrenArrayRenderer(this, n2);
            }
            if (this.ENTRIES_LIMIT <= 0) {
                this.ENTRIES_LIMIT = 1;
            }
            int n4 = 0;
            boolean bl2 = false;
            int n5 = Math.min(n2 - 1, this.END_INDEX);
            if (n2 > this.START_INDEX) {
                for (n3 = this.START_INDEX; n3 <= n5; ++n3) {
                    if (ViewsGeneralSettings.getInstance().HIDE_NULL_ARRAY_ELEMENTS && ArrayRenderer.a(arrayReference, n3)) {
                        bl2 = true;
                        continue;
                    }
                    DebuggerTreeNodeImpl debuggerTreeNodeImpl = nodeManagerImpl.createNode(nodeDescriptorFactory.getArrayItemDescriptor(builder.getParentDescriptor(), arrayReference, n3), evaluationContext);
                    builder.addChildren(Collections.singletonList(debuggerTreeNodeImpl), false);
                    if (++n4 >= this.ENTRIES_LIMIT) break;
                }
            }
            builder.addChildren(Collections.emptyList(), true);
            if (n4 == 0) {
                if (this.START_INDEX == 0 && n2 - 1 <= this.END_INDEX) {
                    builder.setMessage(DebuggerBundle.message((String)"message.node.all.elements.null", (Object[])new Object[0]), null, SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
                } else {
                    builder.setMessage(DebuggerBundle.message((String)"message.node.all.array.elements.null", (Object[])new Object[]{this.START_INDEX, this.END_INDEX}), null, SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
                }
            } else {
                if (bl2) {
                    builder.setMessage(DebuggerBundle.message((String)"message.node.elements.null.hidden", (Object[])new Object[0]), null, SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
                }
                if (!this.b && n3 < n5) {
                    builder.tooManyChildren(n5 - n3);
                }
            }
        }
    }

    private static boolean a(ArrayReference arrayReference, int n2) {
        try {
            return ArrayElementDescriptorImpl.getArrayElement(arrayReference, n2) == null;
        }
        catch (EvaluateException evaluateException) {
            return false;
        }
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) {
        long l2 = e ^ 0x47970BE8DF3DL;
        c.assertTrue(node.getDescriptor() instanceof ArrayElementDescriptorImpl, (Object)node.getDescriptor().getClass().getName());
        ArrayElementDescriptorImpl arrayElementDescriptorImpl = (ArrayElementDescriptorImpl)node.getDescriptor();
        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)node.getProject());
        try {
            LanguageLevel languageLevel = LanguageLevelProjectExtension.getInstance((Project)node.getProject()).getLanguageLevel();
            return psiElementFactory.createExpressionFromText("this[" + arrayElementDescriptorImpl.getIndex() + "]", (PsiElement)psiElementFactory.getArrayClass(languageLevel));
        }
        catch (IncorrectOperationException incorrectOperationException) {
            c.error((Throwable)incorrectOperationException);
            return null;
        }
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return value instanceof ArrayReference && ((ArrayReference)value).length() > 0;
    }

    @Override
    public boolean isApplicable(Type type) {
        return type instanceof ArrayType;
    }

    static {
        e = lb.a(5475681861035164097L, -3576357582598327490L, MethodHandles.lookup().lookupClass()).a(160729071004850L);
        long l2 = e ^ 0x506F8497E3ABL;
        c = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.ArrayRenderer");
    }

    public static class Filtered
    extends ArrayRenderer {
        private final XExpression d;
        public static final XDebuggerTreeNodeHyperlink FILTER_HYPERLINK;
        private static final long f;

        public Filtered(XExpression expression) {
            this.d = expression;
        }

        public XExpression getExpression() {
            return this.d;
        }

        @Override
        public void buildChildren(Value value, ChildrenBuilder builder, final EvaluationContext evaluationContext) {
            ArrayReference arrayReference;
            int n2;
            long l2 = f ^ 0x71A5159DC657L;
            DebuggerManagerThreadImpl.assertIsManagerThread();
            NodeManagerImpl nodeManagerImpl = (NodeManagerImpl)builder.getNodeManager();
            NodeDescriptorFactory nodeDescriptorFactory = builder.getDescriptorManager();
            builder.setMessage(DebuggerBundle.message((String)"message.node.filtered", (Object[])new Object[0]) + " " + this.d.getExpression(), AllIcons.General.Filter, SimpleTextAttributes.REGULAR_ATTRIBUTES, FILTER_HYPERLINK);
            if (this.ENTRIES_LIMIT <= 0) {
                this.ENTRIES_LIMIT = 1;
            }
            if ((n2 = (arrayReference = (ArrayReference)value).length()) > 0) {
                builder.initChildrenArrayRenderer(this, n2);
                CachedEvaluator cachedEvaluator = new CachedEvaluator(){

                    @Override
                    protected String getClassName() {
                        return ((ArrayType)arrayReference.type()).componentTypeName();
                    }

                    @Override
                    protected PsiElement overrideContext(PsiElement context) {
                        return ContextUtil.getContextElement((StackFrameContext)evaluationContext);
                    }
                };
                cachedEvaluator.setReferenceExpression(TextWithImportsImpl.fromXExpression(this.d));
                int n3 = 0;
                if (n2 - 1 >= this.START_INDEX) {
                    ErrorsValueGroup errorsValueGroup = null;
                    for (int i10 = this.START_INDEX; i10 < n2; ++i10) {
                        try {
                            if (!DebuggerUtilsEx.evaluateBoolean(cachedEvaluator.getEvaluator(evaluationContext.getProject()), (EvaluationContextImpl)evaluationContext.createEvaluationContext(arrayReference.getValue(i10)))) continue;
                            DebuggerTreeNodeImpl debuggerTreeNodeImpl = nodeManagerImpl.createNode(nodeDescriptorFactory.getArrayItemDescriptor(builder.getParentDescriptor(), arrayReference, i10), evaluationContext);
                            builder.addChildren(Collections.singletonList(debuggerTreeNodeImpl), false);
                            ++n3;
                            continue;
                        }
                        catch (EvaluateException evaluateException) {
                            if (errorsValueGroup == null) {
                                errorsValueGroup = new ErrorsValueGroup();
                                builder.addChildren(XValueChildrenList.bottomGroup((XValueGroup)errorsValueGroup), false);
                            }
                            JavaValue javaValue = JavaValue.create(null, (ValueDescriptorImpl)((Object)nodeDescriptorFactory.getArrayItemDescriptor(builder.getParentDescriptor(), arrayReference, i10)), (EvaluationContextImpl)evaluationContext, nodeManagerImpl, false);
                            errorsValueGroup.addErrorValue(evaluateException.getMessage(), javaValue);
                        }
                    }
                }
                builder.addChildren(Collections.emptyList(), true);
            }
        }

        static {
            f = lb.a(-4838191176946704682L, 1490372170943707558L, MethodHandles.lookup().lookupClass()).a(261737561792368L);
            long l2 = f ^ 0xA999E010D74L;
            FILTER_HYPERLINK = new XDebuggerTreeNodeHyperlink(" clear"){

                public void onClick(MouseEvent e10) {
                    TreeNode treeNode;
                    XDebuggerTree xDebuggerTree = (XDebuggerTree)e10.getSource();
                    TreePath treePath = xDebuggerTree.getPathForLocation(e10.getX(), e10.getY());
                    if (treePath != null && (treeNode = ((TreeNode)treePath.getLastPathComponent()).getParent()) instanceof XValueNodeImpl) {
                        XValueNodeImpl xValueNodeImpl = (XValueNodeImpl)treeNode;
                        ArrayAction.setArrayRenderer(NodeRendererSettings.getInstance().getArrayRenderer(), xValueNodeImpl, DebuggerManagerEx.getInstanceEx(xDebuggerTree.getProject()).getContext());
                    }
                    e10.consume();
                }
            };
        }
    }
}

