/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import b.a.lb;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundNodeRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.debugger.ui.tree.render.TypeRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.debugger.ui.tree.render.b;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CompoundTypeRenderer
extends CompoundNodeRenderer {
    @NonNls
    public static final String UNIQUE_ID = "CompoundTypeRenderer";
    protected static final Logger LOG;
    private static final AutoToStringRenderer d;
    private static final long h;

    public CompoundTypeRenderer(NodeRendererSettings rendererSettings, String name2, ValueLabelRenderer labelRenderer, ChildrenRenderer childrenRenderer) {
        long l2 = h ^ 0x4A9C7931DC4FL;
        super(rendererSettings, name2, labelRenderer, childrenRenderer);
        this.myProperties.setClassName("java.lang.Object");
        LOG.assertTrue(labelRenderer == null || labelRenderer instanceof TypeRenderer);
        LOG.assertTrue(childrenRenderer == null || childrenRenderer instanceof TypeRenderer);
    }

    @Override
    public void setLabelRenderer(ValueLabelRenderer labelRenderer) {
        ValueLabelRenderer valueLabelRenderer = this.getLabelRenderer();
        super.setLabelRenderer(this.isBaseRenderer(labelRenderer) ? null : labelRenderer);
        ValueLabelRenderer valueLabelRenderer2 = this.getLabelRenderer();
        if (valueLabelRenderer != valueLabelRenderer2 && valueLabelRenderer2 instanceof TypeRenderer) {
            ((TypeRenderer)((Object)valueLabelRenderer2)).setClassName(this.getClassName());
        }
    }

    @Override
    public void setChildrenRenderer(ChildrenRenderer childrenRenderer) {
        ChildrenRenderer childrenRenderer2 = this.getChildrenRenderer();
        super.setChildrenRenderer(this.isBaseRenderer(childrenRenderer) ? null : childrenRenderer);
        ChildrenRenderer childrenRenderer3 = this.getChildrenRenderer();
        if (childrenRenderer2 != childrenRenderer3 && childrenRenderer3 instanceof TypeRenderer) {
            ((TypeRenderer)((Object)childrenRenderer3)).setClassName(this.getClassName());
        }
    }

    @Override
    public ChildrenRenderer getChildrenRenderer() {
        ChildrenRenderer childrenRenderer = super.getChildrenRenderer();
        return childrenRenderer != null ? childrenRenderer : this.a();
    }

    private NodeRenderer a() {
        String string = this.getClassName();
        if (TypeConversionUtil.isPrimitive((String)string)) {
            return this.myRendererSettings.getPrimitiveRenderer();
        }
        return string.endsWith("]") ? this.myRendererSettings.getArrayRenderer() : d;
    }

    @Override
    public ValueLabelRenderer getLabelRenderer() {
        ValueLabelRenderer valueLabelRenderer = super.getLabelRenderer();
        return valueLabelRenderer != null ? valueLabelRenderer : this.a();
    }

    private ChildrenRenderer b() {
        NodeRenderer nodeRenderer = this.a();
        ChildrenRenderer childrenRenderer = super.getChildrenRenderer();
        return childrenRenderer == nodeRenderer ? null : childrenRenderer;
    }

    private ValueLabelRenderer c() {
        NodeRenderer nodeRenderer = this.a();
        ValueLabelRenderer valueLabelRenderer = super.getLabelRenderer();
        return valueLabelRenderer == nodeRenderer ? null : valueLabelRenderer;
    }

    @Override
    public boolean isApplicable(Type type) {
        if (DebuggerUtils.instanceOf((Type)type, (String)this.getClassName())) {
            return super.isApplicable(type);
        }
        return false;
    }

    @Override
    public String getUniqueId() {
        long l2 = h ^ 0x487A236B73A5L;
        return UNIQUE_ID;
    }

    public void setClassName(@NotNull String name2) {
        Renderer renderer;
        if (name2 == null) {
            CompoundTypeRenderer.b(0);
        }
        this.myProperties.setClassName(name2);
        if (this.c() != null && (renderer = super.getLabelRenderer()) instanceof TypeRenderer) {
            ((TypeRenderer)renderer).setClassName(name2);
        }
        if (this.b() != null && (renderer = super.getChildrenRenderer()) instanceof TypeRenderer) {
            ((TypeRenderer)renderer).setClassName(name2);
        }
    }

    @NotNull
    public String getClassName() {
        String string = this.myProperties.getClassName();
        if (string == null) {
            CompoundTypeRenderer.b(1);
        }
        return string;
    }

    protected final PsiElement getContext(Project project2, DebuggerContext context) {
        DebugProcess debugProcess = context.getDebugProcess();
        GlobalSearchScope globalSearchScope = debugProcess != null ? debugProcess.getSearchScope() : GlobalSearchScope.allScope((Project)project2);
        return DebuggerUtils.findClass((String)this.getClassName(), (Project)project2, (GlobalSearchScope)globalSearchScope);
    }

    protected final PsiElement getChildValueExpression(String text2, DebuggerTreeNode node, DebuggerContext context) {
        Project project2 = node.getProject();
        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        return psiElementFactory.createExpressionFromText(text2, this.getContext(project2, context));
    }

    public boolean isBaseRenderer(Renderer renderer) {
        return renderer == d || renderer == this.myRendererSettings.getClassRenderer() || renderer == this.myRendererSettings.getPrimitiveRenderer() || renderer == this.myRendererSettings.getArrayRenderer();
    }

    @Override
    public boolean hasOverhead() {
        return true;
    }

    static {
        h = lb.a(5722225918819535289L, 4984964443306568991L, MethodHandles.lookup().lookupClass()).a(272632787537859L);
        long l2 = h ^ 0x39ECB53B99DFL;
        LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer");
        d = new AutoToStringRenderer(null);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0x24834D087B3BL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/tree/render/CompoundTypeRenderer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/tree/render/CompoundTypeRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setClassName";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AutoToStringRenderer
    extends ToStringRenderer {
        private static final long e = lb.a(-4480251236511623117L, -7127943896075789368L, MethodHandles.lookup().lookupClass()).a(247419473710785L);

        private AutoToStringRenderer() {
        }

        @Override
        public String getUniqueId() {
            long l2 = e ^ 0x765454325BAFL;
            return "AutoToString";
        }

        @Override
        public boolean isApplicable(Type type) {
            return type instanceof ReferenceType;
        }

        @Override
        public boolean isOnDemand(EvaluationContext evaluationContext, ValueDescriptor valueDescriptor) {
            return NodeRendererSettings.getInstance().getToStringRenderer().isOnDemand(evaluationContext, valueDescriptor);
        }

        @Override
        public String calcLabel(ValueDescriptor descriptor2, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
            NodeRendererSettings nodeRendererSettings = NodeRendererSettings.getInstance();
            ToStringRenderer toStringRenderer = nodeRendererSettings.getToStringRenderer();
            if (toStringRenderer.isEnabled() && toStringRenderer.isApplicable(descriptor2.getType())) {
                return toStringRenderer.calcLabel(descriptor2, evaluationContext, listener);
            }
            return nodeRendererSettings.getClassRenderer().calcLabel(descriptor2, evaluationContext, listener);
        }

        /* synthetic */ AutoToStringRenderer(b x0) {
            this();
        }
    }
}

