/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import b.a.lb;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.descriptors.data.UserExpressionData;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.UserExpressionDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundNodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.TypeRenderer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class EnumerationChildrenRenderer
extends TypeRenderer
implements ChildrenRenderer {
    @NonNls
    public static final String UNIQUE_ID = "EnumerationChildrenRenderer";
    private boolean b;
    private List<ChildInfo> c;
    @NonNls
    public static final String APPEND_DEFAULT_NAME = "AppendDefault";
    @NonNls
    public static final String CHILDREN_EXPRESSION = "ChildrenExpression";
    @NonNls
    public static final String CHILD_NAME = "Name";
    @NonNls
    public static final String CHILD_ONDEMAND = "OnDemand";
    private static final long d = lb.a(-1700601743035986740L, -2180697296176999119L, MethodHandles.lookup().lookupClass()).a(20551324843266L);

    public EnumerationChildrenRenderer() {
        this(new ArrayList<ChildInfo>());
    }

    public EnumerationChildrenRenderer(List<ChildInfo> children2) {
        this.c = children2;
    }

    public void setAppendDefaultChildren(boolean appendDefaultChildren) {
        this.b = appendDefaultChildren;
    }

    public boolean isAppendDefaultChildren() {
        return this.b;
    }

    @Override
    public String getUniqueId() {
        long l2 = d ^ 0x45E59E7B79BCL;
        return UNIQUE_ID;
    }

    @Override
    public EnumerationChildrenRenderer clone() {
        return (EnumerationChildrenRenderer)super.clone();
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        long l2 = d ^ 0x73B63E4227B8L;
        super.readExternal(element);
        this.c.clear();
        this.b = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)APPEND_DEFAULT_NAME));
        List list2 = element.getChildren(CHILDREN_EXPRESSION);
        for (Element element2 : list2) {
            String string = element2.getAttributeValue(CHILD_NAME);
            TextWithImports textWithImports = DebuggerUtils.getInstance().readTextWithImports((Element)element2.getChildren().get(0));
            boolean bl2 = Boolean.parseBoolean(element2.getAttributeValue(CHILD_ONDEMAND));
            this.c.add(new ChildInfo(string, textWithImports, bl2));
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        long l2 = d ^ 0x7EF37B1645F2L;
        super.writeExternal(element);
        if (this.b) {
            JDOMExternalizerUtil.writeField((Element)element, (String)APPEND_DEFAULT_NAME, (String)"true");
        }
        for (ChildInfo childInfo : this.c) {
            Element element2 = new Element(CHILDREN_EXPRESSION);
            element2.setAttribute(CHILD_NAME, childInfo.myName);
            if (childInfo.myOnDemand) {
                element2.setAttribute(CHILD_ONDEMAND, "true");
            }
            element2.addContent(DebuggerUtils.getInstance().writeTextWithImports(childInfo.myExpression));
            element.addContent(element2);
        }
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        NodeManager nodeManager = builder.getNodeManager();
        NodeDescriptorFactory nodeDescriptorFactory = builder.getDescriptorManager();
        ArrayList<DebuggerTreeNode> arrayList = new ArrayList<DebuggerTreeNode>();
        int n2 = 0;
        for (ChildInfo childInfo : this.c) {
            UserExpressionData userExpressionData = new UserExpressionData((ValueDescriptorImpl)builder.getParentDescriptor(), this.getClassName(), childInfo.myName, childInfo.myExpression);
            userExpressionData.setEnumerationIndex(n2++);
            UserExpressionDescriptor userExpressionDescriptor = nodeDescriptorFactory.getUserExpressionDescriptor(builder.getParentDescriptor(), userExpressionData);
            if (childInfo.myOnDemand) {
                userExpressionDescriptor.putUserData(OnDemandRenderer.ON_DEMAND_CALCULATED, false);
            }
            arrayList.add(nodeManager.createNode(userExpressionDescriptor, evaluationContext));
        }
        builder.addChildren(arrayList, !this.b);
        if (this.b) {
            DebugProcessImpl.getDefaultRenderer(value).buildChildren(value, builder, evaluationContext);
        }
    }

    @Override
    public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        return ((ValueDescriptor)node.getDescriptor()).getDescriptorEvaluation(context);
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return this.c.size() > 0 || this.b && DebugProcessImpl.getDefaultRenderer(value).isExpandable(value, evaluationContext, parentDescriptor);
    }

    public List<ChildInfo> getChildren() {
        return this.c;
    }

    public void setChildren(List<ChildInfo> children2) {
        this.c = children2;
    }

    @Nullable
    public static EnumerationChildrenRenderer getCurrent(ValueDescriptorImpl valueDescriptor) {
        ChildrenRenderer childrenRenderer;
        Renderer renderer = valueDescriptor.getLastRenderer();
        if (renderer instanceof CompoundNodeRenderer && NodeRendererSettings.getInstance().getCustomRenderers().contains((NodeRenderer)renderer) && (childrenRenderer = ((CompoundNodeRenderer)renderer).getChildrenRenderer()) instanceof EnumerationChildrenRenderer) {
            return (EnumerationChildrenRenderer)childrenRenderer;
        }
        return null;
    }

    public static class ChildInfo
    implements Cloneable {
        public String myName;
        public TextWithImports myExpression;
        public boolean myOnDemand;

        public ChildInfo(String name2, TextWithImports expression, boolean onDemand) {
            this.myName = name2;
            this.myExpression = expression;
            this.myOnDemand = onDemand;
        }
    }
}

