/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import b.a.lb;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.HexRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.CharValue;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VoidType;
import java.lang.invoke.MethodHandles;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class PrimitiveRenderer
extends NodeRendererImpl {
    @NonNls
    public static final String UNIQUE_ID = "PrimitiveRenderer";
    public boolean SHOW_HEX_VALUE;
    private static final long b = lb.a(853006699530333770L, -1464387769778884078L, MethodHandles.lookup().lookupClass()).a(100356854486550L);

    public PrimitiveRenderer() {
        long l2 = b ^ 0x5A14F8CF01B0L;
        super("Primitive");
        this.SHOW_HEX_VALUE = false;
    }

    @Override
    public String getUniqueId() {
        long l2 = b ^ 0x6F874031368BL;
        return UNIQUE_ID;
    }

    @Override
    public void setName(String text2) {
    }

    @Override
    public final boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean isApplicable(Type type) {
        return type == null || type instanceof PrimitiveType || type instanceof VoidType;
    }

    @Override
    public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) {
        long l2 = b ^ 0x4CA629070390L;
        Value value = valueDescriptor.getValue();
        if (value == null) {
            return "null";
        }
        if (value instanceof PrimitiveValue) {
            if (value instanceof CharValue) {
                StringBuilder stringBuilder = new StringBuilder();
                PrimitiveRenderer.appendCharValue((CharValue)value, stringBuilder);
                if (this.SHOW_HEX_VALUE) {
                    PrimitiveRenderer.a((CharValue)value, stringBuilder);
                } else {
                    stringBuilder.append(' ').append(((PrimitiveValue)value).longValue());
                }
                return stringBuilder.toString();
            }
            if (this.SHOW_HEX_VALUE) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(value.toString());
                PrimitiveRenderer.a((PrimitiveValue)value, stringBuilder);
                return stringBuilder.toString();
            }
            return value.toString();
        }
        return DebuggerBundle.message((String)"label.undefined", (Object[])new Object[0]);
    }

    static void appendCharValue(CharValue value, StringBuilder buf) {
        buf.append('\'');
        String string = value.toString();
        StringUtil.escapeStringCharacters((int)string.length(), (String)string, (String)"'", (StringBuilder)buf);
        buf.append('\'');
    }

    private static void a(PrimitiveValue primitiveValue, StringBuilder stringBuilder) {
        long l2 = b ^ 0x41138A75B66DL;
        if (NodeRendererSettings.getInstance().getHexRenderer().isApplicable(primitiveValue.type())) {
            stringBuilder.append(" (");
            HexRenderer.appendHexValue(primitiveValue, stringBuilder);
            stringBuilder.append(')');
        }
    }

    public boolean isShowHexValue() {
        return this.SHOW_HEX_VALUE;
    }

    public void setShowHexValue(boolean show) {
        this.SHOW_HEX_VALUE = show;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        long l2 = b ^ 0x4E81A0A096DFL;
        super.writeExternal(element);
        if (this.SHOW_HEX_VALUE) {
            JDOMExternalizerUtil.writeField((Element)element, (String)"SHOW_HEX_VALUE", (String)"true");
        }
    }
}

