/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.selection;

import com.intellij.designer.designSurface.DecorationLayer;
import com.intellij.designer.designSurface.selection.ResizePoint;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.designSurface.tools.ResizeTracker;
import com.intellij.designer.model.RadComponent;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.Nullable;

public class DirectionResizePoint
extends ResizePoint {
    protected int myDirection;
    private final Object d;
    protected double myXSeparator;
    protected double myYSeparator;
    private final String e;

    public DirectionResizePoint(int direction, Object type, @Nullable String description) {
        this.a(direction);
        this.d = type;
        this.e = description;
    }

    public DirectionResizePoint(Color color, Color border, int direction, Object type, @Nullable String description) {
        super(color, border);
        this.a(direction);
        this.d = type;
        this.e = description;
    }

    private void a(int n2) {
        this.myDirection = n2;
        int n3 = this.myDirection & 0xC;
        this.myXSeparator = n3 == 4 ? 0.0 : (n3 == 8 ? 1.0 : 0.5);
        int n4 = this.myDirection & 3;
        this.myYSeparator = n4 == 1 ? 0.0 : (n4 == 2 ? 1.0 : 0.5);
    }

    public DirectionResizePoint move(double xSeparator, double ySeparator) {
        this.myXSeparator = xSeparator;
        this.myYSeparator = ySeparator;
        return this;
    }

    public int getDirection() {
        return this.myDirection;
    }

    @Override
    public Object getType() {
        return this.d;
    }

    @Override
    protected InputTool createTool(RadComponent component) {
        return new ResizeTracker(this.myDirection, this.d, this.e);
    }

    @Override
    protected Point getLocation(DecorationLayer layer, RadComponent component) {
        Rectangle rectangle = this.getBounds(layer, component);
        int n2 = (this.getSize() + 1) / 2;
        int n3 = rectangle.x + (int)((double)rectangle.width * this.myXSeparator) - n2;
        int n4 = rectangle.y + (int)((double)rectangle.height * this.myYSeparator) - n2;
        return new Point(n3, n4);
    }

    protected Rectangle getBounds(DecorationLayer layer, RadComponent component) {
        return component.getBounds(layer);
    }
}

