/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.selection;

import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.DecorationLayer;
import com.intellij.designer.designSurface.tools.DragTracker;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class NonResizeSelectionDecorator
extends ComponentDecorator {
    protected final Color myColor;
    private final int a;
    private final BasicStroke b;

    public NonResizeSelectionDecorator(Color color, int lineWidth) {
        this.myColor = color;
        this.a = Math.max(lineWidth, 1);
        this.b = this.a > 1 ? new BasicStroke(this.a) : null;
    }

    @Override
    public InputTool findTargetTool(DecorationLayer layer, RadComponent component, int x2, int y2) {
        Rectangle rectangle = this.getBounds(layer, component);
        int n2 = Math.max(this.a, 2);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, n2);
        Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y + rectangle.height - n2, rectangle.width, n2);
        Rectangle rectangle4 = new Rectangle(rectangle.x, rectangle.y, n2, rectangle.height);
        Rectangle rectangle5 = new Rectangle(rectangle.x + rectangle.width - n2, rectangle.y, n2, rectangle.height);
        if (rectangle2.contains(x2, y2) || rectangle3.contains(x2, y2) || rectangle4.contains(x2, y2) || rectangle5.contains(x2, y2)) {
            return new DragTracker(component);
        }
        return null;
    }

    @Override
    protected void paint(DecorationLayer layer, Graphics2D g10, RadComponent component) {
        g10.setColor(this.myColor);
        if (this.b != null) {
            g10.setStroke(this.b);
        }
        Rectangle rectangle = this.getBounds(layer, component);
        g10.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected Rectangle getBounds(DecorationLayer layer, RadComponent component) {
        return component.getBounds(layer);
    }
}

