/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.model;

import b.a.lb;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.ModelLoader;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.VariationPaletteItem;
import com.intellij.designer.palette.DefaultPaletteItem;
import com.intellij.designer.palette.PaletteGroup;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MetaManager
extends ModelLoader {
    private static final String k = "meta";
    private static final String d = "palette";
    private static final String g = "group";
    private static final String h = "name";
    private static final String e = "item";
    private static final String i = "tag";
    private static final String c = "wrap-in";
    private final Map<String, MetaModel> l = new HashMap<String, MetaModel>();
    private final Map<String, MetaModel> a = new HashMap<String, MetaModel>();
    private final List<PaletteGroup> b = new ArrayList<PaletteGroup>();
    private final List<MetaModel> j = new ArrayList<MetaModel>();
    private final Map<Object, Object> f = new HashMap<Object, Object>();
    private static final long m = lb.a(-8845519556561166135L, -2597502448504993904L, MethodHandles.lookup().lookupClass()).a(93839182807545L);

    protected MetaManager(Project project2, String name2) {
        super(project2);
        this.load(name2);
    }

    @Override
    protected void loadDocument(Element rootElement) throws Exception {
        long l2 = m ^ 0x2A0AA5E89C00L;
        ClassLoader classLoader = this.getClass().getClassLoader();
        HashMap<MetaModel, List<String>> hashMap = new HashMap<MetaModel, List<String>>();
        for (Object object : rootElement.getChildren(k)) {
            this.loadModel(classLoader, (Element)object, hashMap);
        }
        for (Object object : rootElement.getChild(d).getChildren(g)) {
            this.loadGroup((Element)object);
        }
        Element element = rootElement.getChild(c);
        if (element != null) {
            for (Element entry : element.getChildren(e)) {
                this.j.add(this.l.get(entry.getAttributeValue(i)));
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            MetaModel metaModel = (MetaModel)entry.getKey();
            ArrayList<MetaModel> arrayList = new ArrayList<MetaModel>();
            for (String string : (List)entry.getValue()) {
                MetaModel metaModel2 = this.l.get(string);
                if (metaModel2 == null) continue;
                arrayList.add(metaModel2);
            }
            if (arrayList.isEmpty()) continue;
            metaModel.setMorphingModels(arrayList);
        }
    }

    @NotNull
    protected MetaModel loadModel(ClassLoader classLoader, Element element, Map<MetaModel, List<String>> modelToMorphing) throws Exception {
        Element element2;
        Element element3;
        Element element4;
        Element element5;
        Element element6;
        String string;
        long l2 = m ^ 0x74D0C66AE0DDL;
        String string2 = element.getAttributeValue("model");
        Class<RadComponent> clazz = string2 == null ? null : classLoader.loadClass(string2);
        String string3 = element.getAttributeValue("class");
        String string4 = element.getAttributeValue(i);
        MetaModel metaModel = this.createModel(clazz, string3, string4);
        String string5 = element.getAttributeValue("layout");
        if (string5 != null) {
            metaModel.setLayout(classLoader.loadClass(string5));
        }
        if ((string = element.getAttributeValue("delete")) != null) {
            metaModel.setDelete(Boolean.parseBoolean(string));
        }
        if ((element6 = element.getChild("presentation")) != null) {
            metaModel.setPresentation(element6.getAttributeValue("title"), element6.getAttributeValue("icon"));
        }
        if ((element5 = element.getChild(d)) != null) {
            metaModel.setPaletteItem(this.createPaletteItem(element5));
        }
        if ((element4 = element.getChild("creation")) != null) {
            metaModel.setCreation(element4.getTextTrim());
        }
        if ((element3 = element.getChild("properties")) != null) {
            this.loadProperties(metaModel, element3);
        }
        if ((element2 = element.getChild("morphing")) != null) {
            modelToMorphing.put(metaModel, StringUtil.split((String)element2.getAttribute("to").getValue(), (String)" "));
        }
        this.loadOther(metaModel, element);
        if (string4 != null) {
            this.l.put(string4, metaModel);
        }
        if (string3 != null) {
            this.a.put(string3, metaModel);
        }
        MetaModel metaModel2 = metaModel;
        if (metaModel2 == null) {
            MetaManager.a(0);
        }
        return metaModel2;
    }

    @NotNull
    protected MetaModel createModel(Class<RadComponent> model, String target, String tag) throws Exception {
        MetaModel metaModel = new MetaModel(model, target, tag);
        if (metaModel == null) {
            MetaManager.a(1);
        }
        return metaModel;
    }

    @NotNull
    protected DefaultPaletteItem createPaletteItem(Element palette) {
        DefaultPaletteItem defaultPaletteItem = new DefaultPaletteItem(palette);
        if (defaultPaletteItem == null) {
            MetaManager.a(2);
        }
        return defaultPaletteItem;
    }

    @NotNull
    protected VariationPaletteItem createVariationPaletteItem(PaletteItem paletteItem, MetaModel model, Element itemElement) {
        VariationPaletteItem variationPaletteItem = new VariationPaletteItem(paletteItem, model, itemElement);
        if (variationPaletteItem == null) {
            MetaManager.a(3);
        }
        return variationPaletteItem;
    }

    @NotNull
    protected PaletteGroup createPaletteGroup(String name2) {
        PaletteGroup paletteGroup = new PaletteGroup(name2);
        if (paletteGroup == null) {
            MetaManager.a(4);
        }
        return paletteGroup;
    }

    protected void loadProperties(MetaModel meta, Element properties) throws Exception {
        Attribute attribute;
        Attribute attribute2;
        Attribute attribute3;
        Attribute attribute4;
        Attribute attribute5;
        long l2 = m ^ 0x5E25EDF422F0L;
        Attribute attribute6 = properties.getAttribute("inplace");
        if (attribute6 != null) {
            meta.setInplaceProperties(StringUtil.split((String)attribute6.getValue(), (String)" "));
        }
        if ((attribute5 = properties.getAttribute("top")) != null) {
            meta.setTopProperties(StringUtil.split((String)attribute5.getValue(), (String)" "));
        }
        if ((attribute4 = properties.getAttribute("normal")) != null) {
            meta.setNormalProperties(StringUtil.split((String)attribute4.getValue(), (String)" "));
        }
        if ((attribute3 = properties.getAttribute("important")) != null) {
            meta.setImportantProperties(StringUtil.split((String)attribute3.getValue(), (String)" "));
        }
        if ((attribute2 = properties.getAttribute("expert")) != null) {
            meta.setExpertProperties(StringUtil.split((String)attribute2.getValue(), (String)" "));
        }
        if ((attribute = properties.getAttribute("deprecated")) != null) {
            meta.setDeprecatedProperties(StringUtil.split((String)attribute.getValue(), (String)" "));
        }
    }

    protected void loadOther(MetaModel meta, Element element) throws Exception {
    }

    @NotNull
    protected PaletteGroup loadGroup(Element element) throws Exception {
        long l2 = m ^ 0x6828BCFBFB39L;
        PaletteGroup paletteGroup = this.createPaletteGroup(element.getAttributeValue(h));
        for (Element element2 : element.getChildren(e)) {
            MetaModel metaModel = this.getModelByTag(element2.getAttributeValue(i));
            PaletteItem paletteItem = metaModel.getPaletteItem();
            if (!element2.getChildren().isEmpty()) {
                if (element2.getAttribute("title") != null) {
                    paletteItem = this.createVariationPaletteItem(paletteItem, metaModel, element2);
                }
                paletteGroup.addItem(paletteItem);
                for (Element element3 : element2.getChildren(e)) {
                    paletteGroup.addItem(this.createVariationPaletteItem(paletteItem, metaModel, element3));
                }
                continue;
            }
            paletteGroup.addItem(paletteItem);
        }
        this.b.add(paletteGroup);
        PaletteGroup paletteGroup2 = paletteGroup;
        if (paletteGroup2 == null) {
            MetaManager.a(5);
        }
        return paletteGroup2;
    }

    public <K, V> Map<K, V> getCache(Object key) {
        return (Map)this.f.get(key);
    }

    public void setCache(Object key, Object value) {
        this.f.put(key, value);
    }

    @Nullable
    public MetaModel getModelByTag(String tag) {
        return this.l.get(tag);
    }

    @Nullable
    public MetaModel getModelByTarget(String target) {
        return this.a.get(target);
    }

    public List<MetaModel> getWrapInModels() {
        return this.j;
    }

    public List<PaletteGroup> getPaletteGroups() {
        return this.b;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = m ^ 0x6DE0FEA4E68EL;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/designer/model/MetaManager";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPaletteItem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariationPaletteItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPaletteGroup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadGroup";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

