/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.palette;

import b.a.lb;
import com.intellij.designer.PaletteToolWindowContent;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.palette.PaletteContainer;
import com.intellij.designer.palette.PaletteGroup;
import com.intellij.designer.palette.PaletteGroupComponent;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.designer.palette.PaletteItemsComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PalettePanel
extends JPanel
implements DataProvider,
PaletteToolWindowContent {
    private final JPanel e = new PaletteContainer();
    private List<PaletteGroupComponent> a = Collections.emptyList();
    private List<PaletteItemsComponent> c = Collections.emptyList();
    private List<PaletteGroup> g = Collections.emptyList();
    private DesignerEditorPanel f;
    private final FocusListener h = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e10) {
            for (PaletteItemsComponent paletteItemsComponent : PalettePanel.this.c) {
                paletteItemsComponent.clearSelection();
            }
        }
    };
    private final ListSelectionListener d = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent event) {
            PalettePanel.this.a(event);
        }
    };
    private final DragSourceListener b = new DragSourceAdapter(){

        @Override
        public void dragDropEnd(DragSourceDropEvent event) {
            Component component = event.getDragSourceContext().getComponent();
            if (!event.getDropSuccess() && component instanceof PaletteItemsComponent && PalettePanel.this.f != null && PalettePanel.this.f.getRootPane() == ((JComponent)component).getRootPane()) {
                PalettePanel.this.f.getToolProvider().loadDefaultTool();
            }
        }
    };
    private static final long i = lb.a(-6054377269048690255L, 6413329697240225628L, MethodHandles.lookup().lookupClass()).a(97468607413664L);

    public PalettePanel() {
        super(new GridLayout(1, 1));
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)this.e);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
        new AnAction(){
            private static final long a = lb.a(-6679728364124654630L, -7728060880377893818L, MethodHandles.lookup().lookupClass()).a(236929999173542L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    4.a(0);
                }
                PalettePanel.this.clearActiveItem();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x1D2D41BEAF82L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/designer/palette/PalettePanel$4", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, (JComponent)jScrollPane);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DragSource.getDefaultDragSource().addDragSourceListener(this.b);
        }
    }

    public void dispose() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DragSource.getDefaultDragSource().removeDragSourceListener(this.b);
        }
    }

    @Nullable
    public PaletteItem getActiveItem() {
        for (PaletteGroupComponent paletteGroupComponent : this.a) {
            PaletteItem paletteItem;
            if (!paletteGroupComponent.isSelected() || (paletteItem = (PaletteItem)paletteGroupComponent.getItemsComponent().getSelectedValue()) == null) continue;
            return paletteItem;
        }
        return null;
    }

    @Override
    public void clearActiveItem() {
        if (this.getActiveItem() != null) {
            for (PaletteItemsComponent paletteItemsComponent : this.c) {
                paletteItemsComponent.clearSelection();
            }
            this.a(null);
        }
    }

    @Override
    public void refresh() {
        this.repaint();
    }

    public void loadPalette(@Nullable DesignerEditorPanel designer) {
        if (this.f == null && designer == null) {
            return;
        }
        if (this.f != null && designer != null && this.g.equals(designer.getPaletteGroups())) {
            this.f = designer;
            this.a();
            return;
        }
        for (PaletteItemsComponent object : this.c) {
            object.removeListSelectionListener(this.d);
        }
        this.f = designer;
        this.e.removeAll();
        if (designer == null) {
            this.g = Collections.emptyList();
            this.a = Collections.emptyList();
            this.c = Collections.emptyList();
        } else {
            this.g = designer.getPaletteGroups();
            this.a = new ArrayList<PaletteGroupComponent>();
            this.c = new ArrayList<PaletteItemsComponent>();
        }
        for (PaletteGroup paletteGroup : this.g) {
            PaletteGroupComponent paletteGroupComponent = new PaletteGroupComponent(paletteGroup);
            PaletteItemsComponent paletteItemsComponent = new PaletteItemsComponent(paletteGroup, designer);
            paletteGroupComponent.setItemsComponent(paletteItemsComponent);
            paletteGroupComponent.addFocusListener(this.h);
            this.a.add(paletteGroupComponent);
            paletteItemsComponent.addListSelectionListener(this.d);
            this.c.add(paletteItemsComponent);
            this.e.add(paletteGroupComponent);
            this.e.add((Component)((Object)paletteItemsComponent));
        }
        this.e.revalidate();
        if (this.f != null) {
            this.a();
        }
    }

    private void a() {
        PaletteItem paletteItem = this.f.getActivePaletteItem();
        for (PaletteItemsComponent paletteItemsComponent : this.c) {
            paletteItemsComponent.restoreSelection(paletteItem);
        }
    }

    private void a(@Nullable ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent != null) {
            PaletteItemsComponent paletteItemsComponent = (PaletteItemsComponent)((Object)listSelectionEvent.getSource());
            for (int i10 = listSelectionEvent.getFirstIndex(); i10 <= listSelectionEvent.getLastIndex(); ++i10) {
                if (!paletteItemsComponent.isSelectedIndex(i10)) continue;
                for (PaletteItemsComponent paletteItemsComponent2 : this.c) {
                    if (paletteItemsComponent2 == paletteItemsComponent) continue;
                    paletteItemsComponent2.clearSelection();
                }
                PaletteItem paletteItem = (PaletteItem)paletteItemsComponent.getSelectedValue();
                if (paletteItem == null || paletteItem.isEnabled()) break;
                paletteItemsComponent.clearSelection();
                break;
            }
        }
        if (this.f != null) {
            this.f.activatePaletteItem(this.getActiveItem());
        }
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            PalettePanel.a(0);
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId) && this.f != null) {
            return this.f.getEditor();
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = i ^ 0x529FD50BA9E4L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/designer/palette/PalettePanel", "getData"));
    }
}

