/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.editor;

import b.a.lb;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.ArrayUtil;
import gnu.trove.TIntArrayList;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class TodoItemsTestCase
extends LightPlatformCodeInsightTestCase {
    private static final long a = lb.a(-2525363168110696492L, -4044711812165662392L, MethodHandles.lookup().lookupClass()).a(5101795316738L);

    protected abstract String getFileExtension();

    @NotNull
    protected List<HighlightInfo> doHighlighting() {
        PsiDocumentManager.getInstance((Project)TodoItemsTestCase.getProject()).commitAllDocuments();
        TIntArrayList tIntArrayList = new TIntArrayList();
        tIntArrayList.add(1);
        tIntArrayList.add(7);
        tIntArrayList.add(12);
        int[] nArray = tIntArrayList.isEmpty() ? ArrayUtil.EMPTY_INT_ARRAY : tIntArrayList.toNativeArray();
        Editor editor = TodoItemsTestCase.getEditor();
        PsiFile psiFile = TodoItemsTestCase.getFile();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            psiFile = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).getTopLevelFile((PsiElement)psiFile);
        }
        List<HighlightInfo> list2 = CodeInsightTestFixtureImpl.instantiateAndRun(psiFile, editor, nArray, false);
        if (list2 == null) {
            TodoItemsTestCase.a(0);
        }
        return list2;
    }

    protected void testTodos(String text2) {
        long l2 = a ^ 0x729E08B3CE30L;
        TodoItemsTestCase.configureFromFileText("Foo." + this.getFileExtension(), text2);
        EditorTestUtil.setEditorVisibleSize(myEditor, 1000, 1000);
        List<TextRange> list2 = TodoItemsTestCase.a(myEditor.getDocument());
        List<HighlightInfo> list3 = this.doHighlighting();
        List<TextRange> list4 = TodoItemsTestCase.a(list3);
        TodoItemsTestCase.a(list2, list4);
    }

    protected void checkTodos(String text2) {
        DocumentImpl documentImpl = new DocumentImpl(text2);
        List<TextRange> list2 = TodoItemsTestCase.a((Document)documentImpl);
        List<HighlightInfo> list3 = this.doHighlighting();
        this.checkResultByText(documentImpl.getText());
        List<TextRange> list4 = TodoItemsTestCase.a(list3);
        TodoItemsTestCase.a(list2, list4);
    }

    private static List<TextRange> a(Document document) {
        int n2;
        ArrayList<TextRange> arrayList = new ArrayList<TextRange>();
        int n3 = 0;
        while ((n2 = document.getText().indexOf(91, n3)) != -1) {
            int n4 = n2;
            WriteCommandAction.runWriteCommandAction((Project)ourProject, () -> document.deleteString(n4, n4 + 1));
            int n5 = document.getText().indexOf(93, n2);
            if (n5 == -1) break;
            WriteCommandAction.runWriteCommandAction((Project)ourProject, () -> document.deleteString(n5, n5 + 1));
            arrayList.add(new TextRange(n2, n5));
        }
        return arrayList;
    }

    private static List<TextRange> a(List<HighlightInfo> list2) {
        return list2.stream().filter(highlightInfo -> highlightInfo.type == HighlightInfoType.TODO).map(highlightInfo -> TextRange.create((Segment)highlightInfo.getHighlighter())).sorted(Segment.BY_START_OFFSET_THEN_END_OFFSET).collect(Collectors.toList());
    }

    private static void a(List<TextRange> list2, List<TextRange> list3) {
        long l2 = a ^ 0xEECA85BB5L;
        TodoItemsTestCase.assertEquals((String)"Unexpected todos highlighting", (String)TodoItemsTestCase.b(list2), (String)TodoItemsTestCase.b(list3));
    }

    private static String b(List<TextRange> list2) {
        StringBuilder stringBuilder = new StringBuilder(myEditor.getDocument().getText());
        int n2 = Integer.MAX_VALUE;
        for (int i10 = list2.size() - 1; i10 >= 0; --i10) {
            TextRange textRange = list2.get(i10);
            TodoItemsTestCase.assertTrue((textRange.getEndOffset() <= n2 ? 1 : 0) != 0);
            stringBuilder.insert(textRange.getEndOffset(), ']');
            n2 = textRange.getStartOffset();
            stringBuilder.insert(n2, '[');
        }
        return stringBuilder.toString();
    }

    protected abstract boolean supportsCStyleSingleLineComments();

    protected abstract boolean supportsCStyleMultiLineComments();

    public void testSuccessiveLineComments() {
        long l2 = a ^ 0x54F82D51B757L;
        if (!this.supportsCStyleSingleLineComments()) {
            return;
        }
        this.testTodos("// [TODO first line]\n//      [second line]");
    }

    public void testSuccessiveLineCommentsAfterEditing() {
        long l2 = a ^ 0x3C29047F6922L;
        if (!this.supportsCStyleSingleLineComments()) {
            return;
        }
        this.testTodos("// [TODO first line]\n// <caret>second line");
        this.type("     ");
        this.checkTodos("// [TODO first line]\n//      [second line]");
    }

    public void testAllLinesLoseHighlightingWithFirstLine() {
        long l2 = a ^ 0x3ACD04BD4A90L;
        if (!this.supportsCStyleSingleLineComments()) {
            return;
        }
        this.testTodos("// [TO<caret>DO first line]\n//      [second line]");
        this.delete();
        this.checkTodos("// TOO first line\n//      second line");
    }

    public void testContinuationIsNotOverlappedWithFollowingTodo() {
        long l2 = a ^ 0x39D536E9CF3EL;
        if (!this.supportsCStyleSingleLineComments()) {
            return;
        }
        this.testTodos("// [TODO first line]\n//  [TODO second line]");
    }

    public void testContinuationInBlockCommentWithStars() {
        long l2 = a ^ 0x658DEAA6C7DCL;
        if (!this.supportsCStyleMultiLineComments()) {
            return;
        }
        this.testTodos("/*\n * [TODO first line]\n *  [second line]\n */");
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = a ^ 0x7FB306755653L;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/editor/TodoItemsTestCase", "doHighlighting"));
    }
}

