/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell;

import b.a.lb;
import com.intellij.execution.jshell.JShellDiagnostic;
import com.intellij.execution.jshell.JShellHandler;
import com.intellij.execution.jshell.SnippetEditorDecorator;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJShellFile;
import com.intellij.psi.PsiJShellHolderMethod;
import com.intellij.psi.PsiJShellSyntheticElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.DocumentUtil;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExecuteJShellAction
extends AnAction {
    private static final AnAction a;
    private final boolean b = false;
    private static final long c;

    private ExecuteJShellAction() {
        super(AllIcons.Toolwindows.ToolWindowRun);
    }

    public void actionPerformed(@NotNull AnActionEvent e10) {
        Project project2;
        long l2 = c ^ 0x26C308CFBC6L;
        if (e10 == null) {
            ExecuteJShellAction.a(0);
        }
        if ((project2 = e10.getProject()) == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e10.getDataContext());
        if (editor == null) {
            return;
        }
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e10.getDataContext());
        if (virtualFile == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        try {
            Sdk sdk;
            Module module2;
            JShellHandler jShellHandler = JShellHandler.getAssociatedHandler(virtualFile);
            if (jShellHandler == null) {
                SnippetEditorDecorator.ConfigurationPane configurationPane = SnippetEditorDecorator.getJShellConfiguration(e10.getDataContext());
                module2 = configurationPane != null ? configurationPane.getContextModule() : null;
                sdk = configurationPane != null ? configurationPane.getRuntimeSdk() : null;
                jShellHandler = JShellHandler.create(project2, virtualFile, module2, sdk);
            }
            if (jShellHandler != null) {
                jShellHandler.toFront();
                boolean bl2 = false;
                module2 = editor.getDocument();
                sdk = EditorUtil.getSelectionInAnyMode((Editor)editor);
                if (sdk.isEmpty()) {
                    PsiElement psiElement = this.a(project2, e10);
                    if (psiElement instanceof PsiJShellFile) {
                        for (PsiElement psiElement2 : ((PsiJShellFile)psiElement).getExecutableSnippets()) {
                            bl2 |= ExecuteJShellAction.a(jShellHandler, psiElement2.getText());
                        }
                    } else if (psiElement != null) {
                        bl2 = ExecuteJShellAction.a(jShellHandler, psiElement.getText());
                    }
                } else {
                    bl2 = ExecuteJShellAction.a(jShellHandler, module2.getText((TextRange)sdk));
                }
                if (!bl2) {
                    JShellDiagnostic.notifyInfo("Nothing to execute", project2);
                }
            }
        }
        catch (Exception exception) {
            Logger.getInstance(ExecuteJShellAction.class).warn((Throwable)exception);
            JShellDiagnostic.notifyError(exception, project2);
        }
    }

    private static boolean a(@NotNull JShellHandler jShellHandler, String string) {
        if (jShellHandler == null) {
            ExecuteJShellAction.a(1);
        }
        if (!StringUtil.isEmptyOrSpaces((String)string)) {
            jShellHandler.evaluate(string.trim());
            return true;
        }
        return false;
    }

    @Nullable
    private PsiElement a(Project project2, AnActionEvent anActionEvent) {
        PsiFile psiFile;
        Editor editor = (Editor)anActionEvent.getData(CommonDataKeys.EDITOR);
        if (editor != null && (psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument())) instanceof PsiJShellFile) {
            PsiFile psiFile2 = null;
            while (psiFile2 != null) {
                PsiElement psiElement = psiFile2.getParent();
                if (psiElement instanceof PsiJShellHolderMethod && psiFile2 instanceof PsiEmptyStatement) {
                    psiFile2 = psiElement.getPrevSibling();
                    if (!(psiFile2 instanceof PsiJShellSyntheticElement)) continue;
                    psiFile2 = psiFile2.getFirstChild();
                    break;
                }
                if (psiElement instanceof PsiJShellSyntheticElement || psiElement instanceof PsiJShellFile) break;
                psiFile2 = psiElement;
            }
            return psiFile2 != null ? psiFile2 : psiFile;
        }
        return null;
    }

    private static PsiElement a(PsiFile psiFile, Document document, int n2) {
        int n3 = DocumentUtil.getLineStartOffset((int)n2, (Document)document);
        PsiElement psiElement = null;
        for (int i10 = n2; i10 >= n3 && ((psiElement = psiFile.findElementAt(i10)) == null || psiElement instanceof PsiWhiteSpace); --i10) {
        }
        return psiElement;
    }

    public static AnAction getSharedInstance() {
        return a;
    }

    static {
        c = lb.a(7883088735607918355L, -6147480941777311608L, MethodHandles.lookup().lookupClass()).a(135971723247858L);
        a = new ExecuteJShellAction();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = c ^ 0x7B760254440EL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/jshell/ExecuteJShellAction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleEval";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

