/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell;

import b.a.lb;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ConsoleState;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewRunningState;
import com.intellij.execution.jshell.JShellDiagnostic;
import com.intellij.execution.jshell.protocol.CodeSnippet;
import com.intellij.execution.jshell.protocol.Endpoint;
import com.intellij.execution.jshell.protocol.Event;
import com.intellij.execution.jshell.protocol.Message;
import com.intellij.execution.jshell.protocol.MessageReader;
import com.intellij.execution.jshell.protocol.MessageWriter;
import com.intellij.execution.jshell.protocol.Request;
import com.intellij.execution.jshell.protocol.Response;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JShellHandler {
    private static final Logger l;
    private static final int k = -1;
    public static final Key<JShellHandler> MARKER_KEY;
    private static final Charset f;
    private static final Executor i;
    private static final String j = "jshell-frontend.jar";
    private final Project d;
    private final RunContentDescriptor g;
    private final ConsoleViewImpl h;
    private final OSProcessHandler e;
    private final MessageReader<Response> b;
    private final MessageWriter<Request> m;
    private final ExecutorService a;
    private final AtomicReference<Collection<String>> c;
    private static final long n;

    private JShellHandler(@NotNull Project project2, RunContentDescriptor descriptor2, ConsoleViewImpl view2, final VirtualFile contentFile, OSProcessHandler handler) throws Exception {
        long l2 = n ^ 0x19BF33BCF71EL;
        if (project2 == null) {
            JShellHandler.a(0);
        }
        this.a = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"JShell Command Queue");
        this.c = new AtomicReference<Object>(null);
        this.d = project2;
        this.g = descriptor2;
        this.h = view2;
        this.e = handler;
        PipedInputStream pipedInputStream = new PipedInputStream();
        final OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new PipedOutputStream(pipedInputStream));
        this.b = new MessageReader((InputStream)pipedInputStream, Response.class);
        this.m = new MessageWriter(handler.getProcessInput());
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private static final long a = lb.a(267727426128779231L, -1168383577953167014L, MethodHandles.lookup().lookupClass()).a(120084533071083L);

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.a(0);
                }
                if (outputType == null) {
                    1.a(1);
                }
                if (outputType == ProcessOutputTypes.STDOUT) {
                    try {
                        outputStreamWriter.write(event.getText());
                        outputStreamWriter.flush();
                    }
                    catch (IOException iOException) {
                        l.info((Throwable)iOException);
                    }
                } else {
                    JShellHandler.this.h.print(event.getText(), outputType == ProcessOutputTypes.STDERR ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.SYSTEM_OUTPUT);
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.a(2);
                }
                if (JShellHandler.getAssociatedHandler(contentFile) == JShellHandler.this) {
                    contentFile.putUserData(MARKER_KEY, null);
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                long l2 = a ^ 0x6C416218B16FL;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/jshell/JShellHandler$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        project2.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){
            private static final long a = lb.a(-4173788341655485677L, -3646470604410317832L, MethodHandles.lookup().lookupClass()).a(270921237500570L);

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    2.a(0);
                }
                if (file == null) {
                    2.a(1);
                }
                if (file.equals(contentFile)) {
                    JShellHandler.this.stop();
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x3BEDA8C7215AL;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/jshell/JShellHandler$2";
                objectArray[2] = "fileClosed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        contentFile.putUserData(MARKER_KEY, (Object)this);
        view2.attachToProcess((ProcessHandler)handler);
    }

    @Nullable
    public static JShellHandler getAssociatedHandler(VirtualFile contentFile) {
        return contentFile != null ? (JShellHandler)contentFile.getUserData(MARKER_KEY) : null;
    }

    public static JShellHandler create(@NotNull Project project2, @NotNull VirtualFile contentFile, @Nullable Module module2, @Nullable Sdk alternateSdk) throws Exception {
        long l2 = n ^ 0x595566C5EF7FL;
        if (project2 == null) {
            JShellHandler.a(1);
        }
        if (contentFile == null) {
            JShellHandler.a(2);
        }
        final OSProcessHandler oSProcessHandler = JShellHandler.a(project2, module2, alternateSdk);
        String string = "JShell " + contentFile.getNameWithoutExtension();
        MyConsoleView myConsoleView = new MyConsoleView(project2);
        RunContentDescriptor runContentDescriptor = new RunContentDescriptor((ExecutionConsole)myConsoleView, (ProcessHandler)oSProcessHandler, (JComponent)new JPanel(new BorderLayout()), string);
        final JShellHandler jShellHandler = new JShellHandler(project2, runContentDescriptor, myConsoleView, contentFile, oSProcessHandler);
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Computable computable = module2 != null ? () -> ModuleRootManager.getInstance((Module)module2).orderEntries() : () -> {
            if (project2 == null) {
                JShellHandler.a(6);
            }
            return ProjectRootManager.getInstance((Project)project2).orderEntries();
        };
        ApplicationManager.getApplication().runReadAction(() -> linkedHashSet.addAll(((OrderEnumerator)computable.compute()).librariesOnly().recursively().withoutSdk().getPathsList().getPathList()));
        if (!linkedHashSet.isEmpty()) {
            jShellHandler.c.set(linkedHashSet);
        }
        JComponent jComponent = myConsoleView.getComponent();
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.addAll(myConsoleView.createConsoleActions());
        defaultActionGroup.add((AnAction)new CloseAction(i, runContentDescriptor, project2){
            private static final long a = lb.a(7808606908155716175L, -1225925604259790538L, MethodHandles.lookup().lookupClass()).a(63609588024760L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    3.a(0);
                }
                jShellHandler.stop();
                if (!oSProcessHandler.waitFor(10000L)) {
                    oSProcessHandler.destroyProcess();
                }
                super.actionPerformed(e10);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x69C769C8B7DCL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/jshell/JShellHandler$3", "actionPerformed"));
            }
        });
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)defaultActionGroup, false);
        actionToolbar.setTargetComponent(jComponent);
        JComponent jComponent2 = runContentDescriptor.getComponent();
        jComponent2.add((Component)jComponent, "Center");
        jComponent2.add((Component)actionToolbar.getComponent(), "West");
        oSProcessHandler.startNotify();
        ExecutionManager.getInstance((Project)project2).getContentManager().showRunContent(i, runContentDescriptor);
        return jShellHandler;
    }

    private static OSProcessHandler a(@NotNull Project project2, @Nullable Module module2, @Nullable Sdk sdk) throws Exception {
        Sdk sdk2;
        long l2 = n ^ 0xAB2782FE405L;
        if (project2 == null) {
            JShellHandler.a(3);
        }
        Sdk sdk3 = sdk != null ? sdk : (sdk2 = module2 != null ? ModuleRootManager.getInstance((Module)module2).getSdk() : ProjectRootManager.getInstance((Project)project2).getProjectSdk());
        if (sdk2 == null || !(sdk2.getSdkType() instanceof JavaSdkType)) {
            throw new ExecException((sdk2 != null ? "Expected Java SDK" : " SDK is not configured") + (module2 != null ? " for module " + module2.getName() : " for project " + project2.getName()));
        }
        JavaSdkVersion javaSdkVersion = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)sdk2);
        if (javaSdkVersion == null) {
            throw new ExecException("Cannot determine version for JDK " + sdk2.getName() + ". Please re-configure the JDK.");
        }
        if (!javaSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_9)) {
            throw new ExecException("JDK version is " + javaSdkVersion.getDescription() + ". JDK 9 or higher is needed to run JShell.");
        }
        JavaSdkType javaSdkType = (JavaSdkType)sdk2.getSdkType();
        String string = javaSdkType.getVMExecutablePath(sdk2);
        if (string == null) {
            throw new ExecException("Cannot determine path to VM executable for JDK " + sdk2.getName() + ". Please re-configure the JDK.");
        }
        File file = new File(string);
        String string2 = JShellHandler.b();
        if (string2 == null) {
            throw new ExecException("Library jshell-frontend.jar not found in IDE classpath");
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        generalCommandLine.setExePath(file.getAbsolutePath());
        generalCommandLine.setWorkDirectory(file.getParent());
        generalCommandLine.setCharset(f);
        StringBuilder stringBuilder = new StringBuilder().append(string2);
        String string3 = JShellHandler.a(Endpoint.class);
        if (string3 != null) {
            stringBuilder.append(File.pathSeparator).append(string3);
        }
        if (stringBuilder.length() > 0) {
            generalCommandLine.addParameter("-classpath");
            generalCommandLine.addParameter(stringBuilder.toString());
        }
        generalCommandLine.addParameter("com.intellij.execution.jshell.frontend.Main");
        OSProcessHandler oSProcessHandler = new OSProcessHandler(generalCommandLine);
        return oSProcessHandler;
    }

    private static String b() {
        long l2 = n ^ 0x57EA3F4AF9D0L;
        String string = PathManager.getResourceRoot((ClassLoader)JShellHandler.class.getClassLoader(), (String)"/com/intellij/execution/jshell/frontend/Marker.class");
        return string != null ? string : j;
    }

    private static String a(Class<?> clazz) {
        long l2 = n ^ 0x608483BBBABBL;
        return PathManager.getResourceRoot(clazz, (String)("/" + clazz.getName().replace('.', '/') + ".class"));
    }

    public void stop() {
        this.e.destroyProcess();
        ExecutionManager.getInstance((Project)this.d).getContentManager().removeRunContent(i, this.g);
    }

    public void toFront() {
        ExecutionManager.getInstance((Project)this.d).getContentManager().toFrontRunContent(i, this.g);
    }

    @Nullable
    public Future<Response> evaluate(@NotNull String code) {
        if (code == null) {
            JShellHandler.a(4);
        }
        return StringUtil.isEmptyOrSpaces((String)code) ? null : this.a.submit(() -> {
            if (code == null) {
                JShellHandler.a(5);
            }
            return this.b(new Request(JShellHandler.a(), Request.Command.EVAL, code));
        });
    }

    public void dropState() {
        this.a.submit(() -> this.b(new Request(JShellHandler.a(), Request.Command.DROP_STATE, null)));
    }

    private static String a() {
        return UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Response b(Request request) {
        Object object;
        Response response;
        Object object2;
        boolean bl2;
        boolean bl3 = bl2 = !this.e.isProcessTerminating() && !this.e.isProcessTerminated();
        if (bl2) {
            object2 = this.c.getAndSet(null);
            if (object2 != null) {
                response = object2.iterator();
                while (response.hasNext()) {
                    object = (String)response.next();
                    request.addClasspathItem((String)object);
                }
            }
            this.h.performWhenNoDeferredOutput(() -> {
                try {
                    this.m.send((Message)request);
                }
                catch (IOException iOException) {
                    l.info((Throwable)iOException);
                }
            });
        }
        object2 = new StringBuilder();
        response = null;
        try {
            object = response = (Response)this.b.receive(arg_0 -> JShellHandler.a((StringBuilder)object2, arg_0));
            return object;
        }
        catch (IOException iOException) {
            l.info((Throwable)iOException);
        }
        finally {
            this.a(request, response, ((StringBuilder)object2).toString());
        }
        return response;
    }

    private void a(Request request, @Nullable Response response, String string) {
        List list2;
        long l2 = n ^ 0x4339E493F950L;
        if (response != null && (list2 = response.getEvents()) != null) {
            if (request.getCommand() == Request.Command.DROP_STATE) {
                int n2 = 0;
                for (Event event : list2) {
                    CodeSnippet.Status status = event.getPreviousStatus();
                    CodeSnippet.Status status2 = event.getStatus();
                    if (event.getSnippet() == null || status == status2 || status2 != CodeSnippet.Status.DROPPED) continue;
                    ++n2;
                }
                JShellDiagnostic.notifyInfo("Dropped " + n2 + " code snippets", this.d);
            } else {
                for (Event event : list2) {
                    CodeSnippet codeSnippet;
                    String string2;
                    String string3;
                    String string4;
                    if (event.getCauseSnippet() != null) continue;
                    String string5 = event.getExceptionText();
                    if (!StringUtil.isEmptyOrSpaces((String)string5)) {
                        this.h.print("\n" + string5, ConsoleViewContentType.SYSTEM_OUTPUT);
                    }
                    if (!StringUtil.isEmptyOrSpaces((String)(string4 = event.getDiagnostic()))) {
                        this.h.print("\n" + string4, ConsoleViewContentType.SYSTEM_OUTPUT);
                    }
                    if (!StringUtil.isEmptyOrSpaces((String)(string3 = JShellHandler.a(event)))) {
                        this.h.print("\n" + string3, ConsoleViewContentType.SYSTEM_OUTPUT);
                    }
                    if ((string2 = (codeSnippet = event.getSnippet()) != null && !codeSnippet.getSubKind().hasValue() ? null : event.getValue()) == null) continue;
                    this.h.print(" = " + (string2.isEmpty() ? "\"\"" : string2), ConsoleViewContentType.NORMAL_OUTPUT);
                }
            }
        }
        if (!StringUtil.isEmpty((String)string)) {
            this.h.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
            if (!"\n".equals(string)) {
                this.h.print(string, ConsoleViewContentType.NORMAL_OUTPUT);
            }
        }
    }

    private static String a(Event event) {
        long l2 = n ^ 0x2F5A5D03A42CL;
        CodeSnippet codeSnippet = event.getSnippet();
        if (event.getCauseSnippet() != null || codeSnippet == null) {
            return "";
        }
        CodeSnippet.Status status = event.getStatus();
        CodeSnippet.Kind kind = codeSnippet.getKind();
        CodeSnippet.SubKind subKind = codeSnippet.getSubKind();
        String string = codeSnippet.getPresentation();
        if (string == null || subKind == CodeSnippet.SubKind.TEMP_VAR_EXPRESSION_SUBKIND) {
            string = StringUtil.trim((String)codeSnippet.getCodeText());
        }
        String string2 = event.getPreviousStatus() == CodeSnippet.Status.NONEXISTENT && status.isDefined() ? (subKind == CodeSnippet.SubKind.VAR_DECLARATION_WITH_INITIALIZER_SUBKIND || !subKind.isExecutable() ? "Defined" : "") : (status == CodeSnippet.Status.REJECTED ? "Rejected" : (status == CodeSnippet.Status.DROPPED ? "Dropped" : (status == CodeSnippet.Status.OVERWRITTEN ? "Overwritten" : "")));
        String string3 = kind == CodeSnippet.Kind.TYPE_DECL ? (subKind == CodeSnippet.SubKind.INTERFACE_SUBKIND ? "interface" : (subKind == CodeSnippet.SubKind.ENUM_SUBKIND ? "enum" : (subKind == CodeSnippet.SubKind.ANNOTATION_TYPE_SUBKIND ? "annotation" : "class"))) : (kind == CodeSnippet.Kind.VAR ? (subKind == CodeSnippet.SubKind.TEMP_VAR_EXPRESSION_SUBKIND ? "" : "field") : (kind == CodeSnippet.Kind.METHOD ? "method" : (kind == CodeSnippet.Kind.IMPORT ? (subKind == CodeSnippet.SubKind.STATIC_IMPORT_ON_DEMAND_SUBKIND || subKind == CodeSnippet.SubKind.SINGLE_STATIC_IMPORT_SUBKIND ? "static import" : "import") : "")));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        if (!string2.isEmpty()) {
            stringBuilder.append(" ");
        }
        if (!string3.isEmpty()) {
            stringBuilder.append(string3).append(" ");
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static /* synthetic */ void a(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string);
    }

    static {
        n = lb.a(-3266359692711490428L, -7227837833213961981L, MethodHandles.lookup().lookupClass()).a(267907292347202L);
        long l2 = n ^ 0x213446665E08L;
        l = Logger.getInstance((String)"#com.intellij.execution.jshell.JShellHandler");
        MARKER_KEY = Key.create((String)"JShell console key");
        f = StandardCharsets.UTF_8;
        i = DefaultRunExecutor.getRunExecutorInstance();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = n ^ 0x7C658189DE85L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/jshell/JShellHandler";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "launchProcess";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluate";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$evaluate$3";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$create$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ExecException
    extends Exception {
        ExecException(String message) {
            super(message);
        }

        ExecException(String message, Throwable cause) {
            super(message, cause);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class MyConsoleView
    extends ConsoleViewImpl {
        MyConsoleView(Project project2) {
            super(project2, GlobalSearchScope.allScope((Project)project2), true, (ConsoleState)new ConsoleState.NotStartedStated(){
                private static final long a = lb.a(4490287471992254523L, 4685086425012153337L, MethodHandles.lookup().lookupClass()).a(242179828724320L);

                @NotNull
                public ConsoleState attachTo(@NotNull ConsoleViewImpl console, ProcessHandler processHandler) {
                    if (console == null) {
                        1.a(0);
                    }
                    ConsoleViewRunningState consoleViewRunningState = new ConsoleViewRunningState(console, processHandler, (ConsoleState)this, false, false);
                    if (consoleViewRunningState == null) {
                        1.a(1);
                    }
                    return consoleViewRunningState;
                }

                private static /* synthetic */ void a(int n2) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n3;
                    String string;
                    long l2 = a ^ 0x113A5D83A635L;
                    switch (n2) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            n3 = 3;
                            break;
                        }
                        case 1: {
                            n3 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "console";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/execution/jshell/JShellHandler$MyConsoleView$1";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/execution/jshell/JShellHandler$MyConsoleView$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "attachTo";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "attachTo";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n2) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }, true);
        }
    }
}

