/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import b.a.lb;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.hash.HashSet;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaRuntimeConfigurationProducerBase
extends RuntimeConfigurationProducer {
    private static final long b = lb.a(-7306105809153679723L, 7163676398102231997L, MethodHandles.lookup().lookupClass()).a(56729441652627L);

    protected JavaRuntimeConfigurationProducerBase(@NotNull ConfigurationType configurationType) {
        if (configurationType == null) {
            JavaRuntimeConfigurationProducerBase.a(0);
        }
        super(configurationType);
    }

    @Nullable
    public static PsiPackage checkPackage(PsiElement element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        Project project2 = element.getProject();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        if (element instanceof PsiPackage) {
            PsiDirectory[] psiDirectoryArray;
            PsiPackage psiPackage = (PsiPackage)element;
            for (PsiDirectory psiDirectory : psiDirectoryArray = psiPackage.getDirectories(GlobalSearchScope.projectScope((Project)project2))) {
                if (!JavaRuntimeConfigurationProducerBase.a(psiDirectory, projectFileIndex)) continue;
                return psiPackage;
            }
            return null;
        }
        if (element instanceof PsiDirectory) {
            Module module2;
            PsiDirectory psiDirectory = (PsiDirectory)element;
            if (JavaRuntimeConfigurationProducerBase.a(psiDirectory, projectFileIndex)) {
                return JavaDirectoryService.getInstance().getPackage(psiDirectory);
            }
            VirtualFile virtualFile = psiDirectory.getVirtualFile();
            if (virtualFile.equals(projectFileIndex.getContentRootForFile(virtualFile)) && (module2 = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project2)) != null) {
                for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module2).getContentEntries()) {
                    if (!virtualFile.equals(contentEntry.getFile())) continue;
                    SourceFolder[] sourceFolderArray = contentEntry.getSourceFolders();
                    HashSet hashSet = new HashSet();
                    for (SourceFolder sourceFolder : sourceFolderArray) {
                        hashSet.add(sourceFolder.getPackagePrefix());
                    }
                    if (hashSet.size() > 1) {
                        return null;
                    }
                    return JavaPsiFacade.getInstance((Project)project2).findPackage(hashSet.isEmpty() ? "" : (String)hashSet.iterator().next());
                }
            }
            return null;
        }
        return null;
    }

    private static boolean a(PsiDirectory psiDirectory, ProjectFileIndex projectFileIndex) {
        VirtualFile virtualFile = psiDirectory.getVirtualFile();
        return projectFileIndex.getSourceRootForFile(virtualFile) != null;
    }

    protected boolean setupConfigurationModule(@Nullable ConfigurationContext context, ModuleBasedConfiguration configuration) {
        if (context != null) {
            RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettingsImpl = ((RunManagerImpl)context.getRunManager()).getConfigurationTemplate(this.getConfigurationFactory());
            Module module2 = context.getModule();
            Module module3 = ((ModuleBasedConfiguration)runnerAndConfigurationSettingsImpl.getConfiguration()).getConfigurationModule().getModule();
            if (module3 != null) {
                configuration.setModule(module3);
                return true;
            }
            Module module4 = this.findModule(configuration, module2);
            if (module4 != null) {
                configuration.setModule(module4);
                return true;
            }
        }
        return false;
    }

    protected Module findModule(ModuleBasedConfiguration configuration, Module contextModule) {
        if (configuration.getConfigurationModule().getModule() == null && contextModule != null) {
            return contextModule;
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = b ^ 0x723C6760DB54L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationType", "com/intellij/execution/junit/JavaRuntimeConfigurationProducerBase", "<init>"));
    }
}

