/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.scratch;

import b.a.lb;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.scratch.JavaScratchCompilationSupport;
import com.intellij.execution.scratch.JavaScratchConfigurable;
import com.intellij.execution.scratch.JavaScratchConfigurationOptions;
import com.intellij.execution.scratch.JavaScratchPositionManager;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScratchConfiguration
extends ApplicationConfiguration {
    private static final long b = lb.a(2837792813234610977L, 6202660713541320444L, MethodHandles.lookup().lookupClass()).a(278886134720700L);

    protected JavaScratchConfiguration(String name2, @NotNull Project project2, @NotNull ConfigurationFactory factory2) {
        if (project2 == null) {
            JavaScratchConfiguration.b(0);
        }
        if (factory2 == null) {
            JavaScratchConfiguration.b(1);
        }
        super(name2, project2, factory2);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        long l2 = b ^ 0x5C4181FE51D9L;
        JavaParametersUtil.checkAlternativeJRE(this);
        String string = this.getMainClassName();
        if (string == null || string.length() == 0) {
            throw new RuntimeConfigurationError(ExecutionBundle.message((String)"no.main.class.specified.error.text", (Object[])new Object[0]));
        }
        if (this.getScratchFileUrl() == null) {
            throw new RuntimeConfigurationError("No scratch file associated with configuration");
        }
        if (this.getScratchVirtualFile() == null) {
            throw new RuntimeConfigurationError("Associated scratch file not found");
        }
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this, (Project)this.getProject(), (Module)((JavaRunConfigurationModule)this.getConfigurationModule()).getModule());
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid(this);
    }

    @Override
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            JavaScratchConfiguration.b(2);
        }
        if (env == null) {
            JavaScratchConfiguration.b(3);
        }
        ApplicationConfiguration.JavaApplicationCommandLineState<JavaScratchConfiguration> javaApplicationCommandLineState = new ApplicationConfiguration.JavaApplicationCommandLineState<JavaScratchConfiguration>(this, env){
            private static final long d = lb.a(-1653216639580008978L, 1825732959850632009L, MethodHandles.lookup().lookupClass()).a(207493715136609L);

            @Override
            protected JavaParameters createJavaParameters() throws ExecutionException {
                ParametersList parametersList;
                JavaSdkVersion javaSdkVersion;
                long l2 = d ^ 0x97790C17C1CL;
                JavaParameters javaParameters = super.createJavaParameters();
                Sdk sdk = javaParameters.getJdk();
                if (sdk != null && (javaSdkVersion = JavaSdk.getInstance().getVersion(sdk)) != null && javaSdkVersion.getMaxLanguageLevel().isPreview() && !(parametersList = javaParameters.getVMParametersList()).hasParameter("--enable-preview")) {
                    parametersList.add("--enable-preview");
                }
                return javaParameters;
            }

            @Override
            protected void setupJavaParameters(JavaParameters params) throws ExecutionException {
                super.setupJavaParameters(params);
                File file = JavaScratchCompilationSupport.getScratchOutputDirectory(JavaScratchConfiguration.this.getProject());
                if (file != null) {
                    params.getClassPath().addFirst(FileUtil.toCanonicalPath((String)file.getAbsolutePath()).replace('/', File.separatorChar));
                }
            }

            @Override
            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                VirtualFile virtualFile;
                OSProcessHandler oSProcessHandler = super.startProcess();
                if (this.getRunnerSettings() instanceof DebuggingRunnerData && (virtualFile = ((JavaScratchConfiguration)this.getConfiguration()).getScratchVirtualFile()) != null) {
                    DebuggerManager.getInstance((Project)JavaScratchConfiguration.this.getProject()).addDebugProcessListener((ProcessHandler)oSProcessHandler, new DebugProcessListener(){
                        private static final long a = lb.a(-8110664555564457755L, 4951512405882998909L, MethodHandles.lookup().lookupClass()).a(169222694034751L);

                        public void processAttached(@NotNull DebugProcess process2) {
                            if (process2 == null) {
                                1.a(0);
                            }
                            if (virtualFile.isValid()) {
                                process2.appendPositionManager((PositionManager)new JavaScratchPositionManager((DebugProcessImpl)process2, virtualFile));
                            }
                            process2.removeDebugProcessListener((DebugProcessListener)this);
                        }

                        private static /* synthetic */ void a(int n2) {
                            long l2 = a ^ 0x2FA10EC5D11CL;
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/scratch/JavaScratchConfiguration$1$1", "processAttached"));
                        }
                    });
                }
                OSProcessHandler oSProcessHandler2 = oSProcessHandler;
                if (oSProcessHandler2 == null) {
                    1.d(0);
                }
                return oSProcessHandler2;
            }

            private static /* synthetic */ void d(int n2) {
                long l2 = d ^ 0x5E938E22F2C1L;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/scratch/JavaScratchConfiguration$1", "startProcess"));
            }
        };
        javaApplicationCommandLineState.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject(), ((JavaRunConfigurationModule)this.getConfigurationModule()).getSearchScope()));
        return javaApplicationCommandLineState;
    }

    @Override
    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        JavaScratchConfigurable javaScratchConfigurable = new JavaScratchConfigurable(this.getProject());
        if (javaScratchConfigurable == null) {
            JavaScratchConfiguration.b(4);
        }
        return javaScratchConfigurable;
    }

    public void setScratchFileUrl(String url) {
        this.getOptions().setScratchFileUrl(url);
    }

    @Nullable
    public String getScratchFileUrl() {
        return this.getOptions().getScratchFileUrl();
    }

    @Nullable
    public VirtualFile getScratchVirtualFile() {
        String string = this.getScratchFileUrl();
        return string == null ? null : VirtualFileManager.getInstance().findFileByUrl(string);
    }

    @Override
    @NotNull
    protected JavaScratchConfigurationOptions getOptions() {
        JavaScratchConfigurationOptions javaScratchConfigurationOptions = (JavaScratchConfigurationOptions)super.getOptions();
        if (javaScratchConfigurationOptions == null) {
            JavaScratchConfiguration.b(5);
        }
        return javaScratchConfigurationOptions;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x2E215DE9CF1FL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/scratch/JavaScratchConfiguration";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/scratch/JavaScratchConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

