/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import b.a.lb;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.stacktrace.StackTraceLine;
import com.intellij.execution.testframework.ResetConfigurationModuleAdapter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaAwareTestConsoleProperties<T extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element>>
extends SMTRunnerConsoleProperties {
    private static final long a = lb.a(4695988513343511680L, -1524369647301549495L, MethodHandles.lookup().lookupClass()).a(220655152130108L);

    public JavaAwareTestConsoleProperties(String testFrameworkName, RunConfiguration configuration, Executor executor) {
        super(configuration, testFrameworkName, executor);
        this.setPrintTestingStartedTime(false);
    }

    public boolean isPaused() {
        DebuggerSession debuggerSession = this.getDebugSession();
        return debuggerSession != null && debuggerSession.isPaused();
    }

    public T getConfiguration() {
        return (T)((ModuleBasedConfiguration)super.getConfiguration());
    }

    public int getSelectionMode() {
        return 4;
    }

    public boolean fixEmptySuite() {
        return ResetConfigurationModuleAdapter.tryWithAnotherModule(this.getConfiguration(), this.isDebug());
    }

    @Nullable
    public Navigatable getErrorNavigatable(@NotNull Location<?> location, @NotNull String stacktrace) {
        if (location == null) {
            JavaAwareTestConsoleProperties.a(0);
        }
        if (stacktrace == null) {
            JavaAwareTestConsoleProperties.a(1);
        }
        return JavaAwareTestConsoleProperties.getStackTraceErrorNavigatable(location, stacktrace);
    }

    @Nullable
    public static Navigatable getStackTraceErrorNavigatable(@NotNull Location<?> location, @NotNull String stacktrace) {
        String[] stringArray;
        Object object;
        PsiLocation psiLocation;
        PsiClass psiClass;
        if (location == null) {
            JavaAwareTestConsoleProperties.a(2);
        }
        if (stacktrace == null) {
            JavaAwareTestConsoleProperties.a(3);
        }
        if ((psiClass = (PsiClass)(psiLocation = location.toPsiLocation()).getParentElement(PsiClass.class)) == null) {
            return null;
        }
        String string = psiClass.getQualifiedName();
        if (string == null) {
            return null;
        }
        PsiMethod psiMethod = null;
        Object object2 = psiLocation.getAncestors(PsiMethod.class, false);
        while (object2.hasNext()) {
            object = (PsiMethod)((Location)object2.next()).getPsiElement();
            if (!psiClass.equals(object.getContainingClass())) continue;
            psiMethod = object;
        }
        if (psiMethod == null) {
            return null;
        }
        object2 = psiMethod.getName();
        object = null;
        for (String string2 : stringArray = new LineTokenizer(stacktrace).execute()) {
            StackTraceLine stackTraceLine = new StackTraceLine(psiClass.getProject(), string2);
            if (!((String)object2).equals(stackTraceLine.getMethodName()) || !string.equals(stackTraceLine.getClassName())) continue;
            object = stackTraceLine;
            break;
        }
        if (object != null) {
            try {
                String string2;
                int n2 = object.getLineNumber();
                PsiFile psiFile = psiClass.getContainingFile();
                Document document = PsiDocumentManager.getInstance((Project)psiClass.getProject()).getDocument(psiFile);
                string2 = psiMethod.getTextRange();
                if (string2 == null || document == null || n2 < 0 || n2 >= document.getLineCount() || string2.contains(document.getLineStartOffset(n2))) {
                    return new OpenFileDescriptor(psiClass.getProject(), psiFile.getVirtualFile(), n2, 0);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public DebuggerSession getDebugSession() {
        DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx(this.getProject());
        if (debuggerManagerEx == null) {
            return null;
        }
        Collection<DebuggerSession> collection = debuggerManagerEx.getSessions();
        for (DebuggerSession debuggerSession : collection) {
            if (this.getConsole() != debuggerSession.getProcess().getExecutionResult().getExecutionConsole()) continue;
            return debuggerSession;
        }
        return null;
    }

    public boolean isEditable() {
        long l2 = a ^ 0x5CA5121FCED5L;
        return Registry.is((String)"editable.java.test.console");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x7F6ED9AF9596L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacktrace";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/JavaAwareTestConsoleProperties";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getErrorNavigatable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getStackTraceErrorNavigatable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

