/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import b.a.lb;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchForTestsTask
extends Task.Backgroundable {
    private static final Logger c;
    protected Socket mySocket;
    private final ServerSocket a;
    private ProgressIndicator b;
    private static final long d;

    public SearchForTestsTask(@Nullable Project project2, ServerSocket socket) {
        long l2 = d ^ 0x757991CC881BL;
        super(project2, ExecutionBundle.message((String)"searching.test.progress.title", (Object[])new Object[0]), true);
        this.a = socket;
    }

    protected abstract void search() throws ExecutionException;

    protected abstract void onFound() throws ExecutionException;

    public void ensureFinished() {
        if (this.b != null && !this.b.isCanceled()) {
            this.finish();
        }
    }

    public void startSearch() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                this.search();
            }
            catch (Throwable throwable) {
                c.error(throwable);
            }
            try {
                this.onFound();
            }
            catch (ExecutionException executionException) {
                c.error((Throwable)executionException);
            }
        } else {
            this.b = new BackgroundableProcessIndicator((Task.Backgroundable)this);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)this, this.b);
        }
    }

    public void attachTaskToProcess(final OSProcessHandler handler) {
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private static final long a = lb.a(6833068030989982104L, -7849596393551983031L, MethodHandles.lookup().lookupClass()).a(16838596430558L);

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.a(0);
                }
                handler.removeProcessListener((ProcessListener)this);
                SearchForTestsTask.this.ensureFinished();
            }

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.a(1);
                }
                SearchForTestsTask.this.startSearch();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x1A495130AE71L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/execution/testframework/SearchForTestsTask$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SearchForTestsTask.a(0);
        }
        try {
            this.mySocket = this.a.accept();
            ExecutionException[] executionExceptionArray = new ExecutionException[1];
            Runnable runnable = () -> {
                try {
                    this.search();
                }
                catch (ExecutionException executionException) {
                    executionExceptionArray[0] = executionException;
                }
            };
            while (!this.a(runnable, (ProgressIndicator)new SensitiveProgressWrapper(indicator))) {
            }
            if (executionExceptionArray[0] != null) {
                this.logCantRunException(executionExceptionArray[0]);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw processCanceledException;
        }
        catch (IOException iOException) {
            c.info((Throwable)iOException);
        }
        catch (Throwable throwable) {
            c.error(throwable);
        }
    }

    private boolean a(@NotNull Runnable runnable, ProgressIndicator progressIndicator) {
        if (runnable == null) {
            SearchForTestsTask.a(1);
        }
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        progressIndicator.checkCanceled();
        dumbService.waitForSmartMode();
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        boolean bl2 = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
            if (runnable == null) {
                SearchForTestsTask.a(2);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            if (dumbService.isDumb()) {
                atomicBoolean.set(true);
                return;
            }
            runnable.run();
        }, (ProgressIndicator)progressIndicator);
        if (atomicBoolean.get()) {
            return false;
        }
        if (!bl2) {
            ProgressIndicatorUtils.yieldToPendingWriteActions();
        }
        return bl2;
    }

    protected void logCantRunException(ExecutionException e10) throws ExecutionException {
        throw e10;
    }

    public void onCancel() {
        this.finish();
    }

    public void onSuccess() {
        Runnable runnable = () -> {
            try {
                this.onFound();
            }
            catch (ExecutionException executionException) {
                c.error((Throwable)executionException);
            }
            this.finish();
        };
        DumbService.getInstance((Project)this.getProject()).runWhenSmart(runnable);
    }

    public void finish() {
        FilterOutputStream filterOutputStream = null;
        try {
            if (this.mySocket == null || this.mySocket.isClosed()) {
                return;
            }
            filterOutputStream = new DataOutputStream(this.mySocket.getOutputStream());
            ((DataOutputStream)filterOutputStream).writeBoolean(true);
        }
        catch (Throwable throwable) {
            c.info(throwable);
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (Throwable throwable) {
                c.info(throwable);
            }
            try {
                if (!this.a.isClosed()) {
                    this.a.close();
                }
            }
            catch (Throwable throwable) {
                c.info(throwable);
            }
        }
    }

    static {
        d = lb.a(-7817065361724495423L, 9050356117654344938L, MethodHandles.lookup().lookupClass()).a(132993021569232L);
        c = Logger.getInstance(SearchForTestsTask.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = d ^ 0x3CB41208B214L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/SearchForTestsTask";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runSmartModeReadActionWithWritePriority";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runSmartModeReadActionWithWritePriority$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

