/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import b.a.lb;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiMethodUtil;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.Nullable;

public abstract class ClassBrowser
extends BrowseModuleValueActionListener {
    private final String a;
    private static final long c = lb.a(5394357296502813118L, 1002536806584790845L, MethodHandles.lookup().lookupClass()).a(54571312191363L);

    public ClassBrowser(Project project2, String title) {
        super(project2);
        this.a = title;
    }

    @Nullable
    protected String showDialog() {
        ClassFilter.ClassFilterWithScope classFilterWithScope;
        try {
            classFilterWithScope = this.getFilter();
        }
        catch (NoFilterException noFilterException) {
            MessagesEx.MessageInfo messageInfo = noFilterException.getMessageInfo();
            messageInfo.showNow();
            return null;
        }
        TreeClassChooser treeClassChooser = this.createClassChooser(classFilterWithScope);
        this.a(treeClassChooser);
        treeClassChooser.showDialog();
        PsiClass psiClass = treeClassChooser.getSelected();
        if (psiClass == null) {
            return null;
        }
        this.onClassChoosen(psiClass);
        return psiClass.getQualifiedName();
    }

    protected TreeClassChooser createClassChooser(ClassFilter.ClassFilterWithScope classFilter) {
        return TreeClassChooserFactory.getInstance((Project)this.getProject()).createWithInnerClassesScopeChooser(this.a, classFilter.getScope(), (ClassFilter)classFilter, null);
    }

    protected abstract ClassFilter.ClassFilterWithScope getFilter() throws NoFilterException;

    protected void onClassChoosen(PsiClass psiClass) {
    }

    private void a(TreeClassChooser treeClassChooser) {
        String string = this.getText();
        PsiClass psiClass = this.findClass(string);
        if (psiClass == null) {
            return;
        }
        PsiDirectory psiDirectory = psiClass.getContainingFile().getContainingDirectory();
        if (psiDirectory != null) {
            treeClassChooser.selectDirectory(psiDirectory);
        }
        treeClassChooser.select(psiClass);
    }

    protected abstract PsiClass findClass(String var1);

    public static ClassBrowser createApplicationClassBrowser(Project project2, ConfigurationModuleSelector moduleSelector) {
        long l2 = c ^ 0x73C8896F67AEL;
        final ClassFilter classFilter = new ClassFilter(){

            public boolean isAccepted(PsiClass aClass) {
                return ConfigurationUtil.MAIN_CLASS.value((Object)aClass) && this.b(aClass) != null;
            }

            @Nullable
            private PsiMethod b(PsiClass psiClass) {
                return (PsiMethod)ReadAction.compute(() -> PsiMethodUtil.findMainMethod((PsiClass)psiClass));
            }
        };
        return new MainClassBrowser(project2, moduleSelector, ExecutionBundle.message((String)"choose.main.class.dialog.title", (Object[])new Object[0])){

            @Override
            protected ClassFilter createFilter(Module module2) {
                return classFilter;
            }
        };
    }

    public static ClassBrowser createAppletClassBrowser(final Project project2, final ConfigurationModuleSelector moduleSelector) {
        long l2 = c ^ 0x58FE8916CD4CL;
        final String string = ExecutionBundle.message((String)"choose.applet.class.dialog.title", (Object[])new Object[0]);
        return new MainClassBrowser(project2, moduleSelector, string){
            private static final long d = lb.a(4165295216734886492L, 499304678557360129L, MethodHandles.lookup().lookupClass()).a(224558739783810L);

            @Override
            protected TreeClassChooser createClassChooser(ClassFilter.ClassFilterWithScope classFilter) {
                long l2 = d ^ 0x1760E7A48EC0L;
                Module module2 = moduleSelector.getModule();
                GlobalSearchScope globalSearchScope = module2 == null ? GlobalSearchScope.allScope((Project)this.myProject) : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2);
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)project2).findClass("java.applet.Applet", globalSearchScope);
                return TreeClassChooserFactory.getInstance((Project)this.getProject()).createInheritanceClassChooser(string, classFilter.getScope(), psiClass, false, false, ConfigurationUtil.PUBLIC_INSTANTIATABLE_CLASS);
            }
        };
    }

    public static class NoFilterException
    extends Exception {
        private final MessagesEx.MessageInfo a;
        private static final long b = lb.a(4378112618587533794L, -110519090653319456L, MethodHandles.lookup().lookupClass()).a(157447072728163L);

        public NoFilterException(MessagesEx.MessageInfo messageInfo) {
            super(messageInfo.getMessage());
            this.a = messageInfo;
        }

        public MessagesEx.MessageInfo getMessageInfo() {
            return this.a;
        }

        public static NoFilterException noJUnitInModule(Module module2) {
            long l2 = b ^ 0x56BAD5ABA95FL;
            return new NoFilterException(new MessagesEx.MessageInfo(module2.getProject(), ExecutionBundle.message((String)"junit.not.found.in.module.error.message", (Object[])new Object[]{module2.getName()}), ExecutionBundle.message((String)"cannot.browse.test.inheritors.dialog.title", (Object[])new Object[0])));
        }

        public static NoFilterException moduleDoesntExist(ConfigurationModuleSelector moduleSelector) {
            long l2 = b ^ 0x79BC46F4D9CEL;
            Project project2 = moduleSelector.getProject();
            String string = moduleSelector.getModuleName();
            return new NoFilterException(new MessagesEx.MessageInfo(project2, string.isEmpty() ? "No module selected" : ExecutionBundle.message((String)"module.does.not.exists", (Object[])new Object[]{string, project2.getName()}), ExecutionBundle.message((String)"cannot.browse.test.inheritors.dialog.title", (Object[])new Object[0])));
        }
    }

    public static abstract class MainClassBrowser
    extends ClassBrowser {
        protected final Project myProject;
        private final ConfigurationModuleSelector b;

        public MainClassBrowser(Project project2, ConfigurationModuleSelector moduleSelector, String title) {
            super(project2, title);
            this.myProject = project2;
            this.b = moduleSelector;
        }

        @Override
        protected PsiClass findClass(String className) {
            return this.b.findClass(className);
        }

        @Override
        protected ClassFilter.ClassFilterWithScope getFilter() throws NoFilterException {
            Module module2 = this.b.getModule();
            final GlobalSearchScope globalSearchScope = module2 == null ? GlobalSearchScope.allScope((Project)this.myProject) : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2);
            final ClassFilter classFilter = this.createFilter(module2);
            return new ClassFilter.ClassFilterWithScope(){

                public GlobalSearchScope getScope() {
                    return globalSearchScope;
                }

                public boolean isAccepted(PsiClass aClass) {
                    return classFilter == null || classFilter.isAccepted(aClass);
                }
            };
        }

        protected ClassFilter createFilter(Module module2) {
            return null;
        }
    }
}

