/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import b.a.lb;
import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.PathUtilEx;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaParametersUtil {
    private static final long a = lb.a(-331433903073119775L, -2142377664428531277L, MethodHandles.lookup().lookupClass()).a(52261452157659L);

    private JavaParametersUtil() {
    }

    public static void configureConfiguration(SimpleJavaParameters parameters, CommonJavaRunConfigurationParameters configuration) {
        String string;
        ProgramParametersUtil.configureConfiguration((SimpleProgramParameters)parameters, (CommonProgramRunConfigurationParameters)configuration);
        Project project2 = configuration.getProject();
        Module module2 = ProgramParametersUtil.getModule((CommonProgramRunConfigurationParameters)configuration);
        String string2 = configuration.getAlternativeJrePath();
        if (string2 != null) {
            configuration.setAlternativeJrePath(ProgramParametersUtil.expandPath((String)string2, null, (Project)project2));
        }
        if ((string = configuration.getVMParameters()) != null) {
            string = ProgramParametersUtil.expandPath((String)string, (Module)module2, (Project)project2);
            for (Map.Entry entry : parameters.getEnv().entrySet()) {
                string = StringUtil.replace((String)string, (String)("$" + (String)entry.getKey() + "$"), (String)((String)entry.getValue()), (boolean)false);
            }
        }
        parameters.getVMParametersList().addParametersString(string);
    }

    public static int getClasspathType(RunConfigurationModule configurationModule, String mainClassName, boolean classMustHaveSource) throws CantRunException {
        return JavaParametersUtil.getClasspathType(configurationModule, mainClassName, classMustHaveSource, false);
    }

    public static int getClasspathType(RunConfigurationModule configurationModule, String mainClassName, boolean classMustHaveSource, boolean includeProvidedDependencies) throws CantRunException {
        Module module2 = configurationModule.getModule();
        if (module2 == null) {
            throw CantRunException.noModuleConfigured((String)configurationModule.getModuleName());
        }
        Boolean bl2 = JavaParametersUtil.isClassInProductionSources(mainClassName, module2);
        if (bl2 == null) {
            if (!classMustHaveSource) {
                return 7;
            }
            throw CantRunException.classNotFound((String)mainClassName, (Module)module2);
        }
        return bl2.booleanValue() ? (includeProvidedDependencies ? 11 : 3) : 7;
    }

    @Nullable(value="null if class not found")
    public static Boolean isClassInProductionSources(@NotNull String mainClassName, @NotNull Module module2) {
        ModuleFileIndex moduleFileIndex;
        Module module3;
        PsiClass psiClass;
        if (mainClassName == null) {
            JavaParametersUtil.a(0);
        }
        if (module2 == null) {
            JavaParametersUtil.a(1);
        }
        if ((psiClass = JavaExecutionUtil.findMainClass((Module)module2, (String)mainClassName)) == null) {
            return null;
        }
        PsiFile psiFile = psiClass.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Module module4 = module3 = psiClass.isValid() ? ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass) : null;
        if (module3 == null) {
            module3 = module2;
        }
        if ((moduleFileIndex = ModuleRootManager.getInstance((Module)module3).getFileIndex()).isInSourceContent(virtualFile)) {
            return !moduleFileIndex.isInTestSourceContent(virtualFile);
        }
        List list2 = moduleFileIndex.getOrderEntriesForFile(virtualFile);
        for (OrderEntry orderEntry : list2) {
            if (!(orderEntry instanceof ExportableOrderEntry) || ((ExportableOrderEntry)orderEntry).getScope() != DependencyScope.TEST) continue;
            return false;
        }
        return true;
    }

    public static void configureModule(RunConfigurationModule runConfigurationModule, JavaParameters parameters, int classPathType, @Nullable String jreHome) throws CantRunException {
        Module module2 = runConfigurationModule.getModule();
        if (module2 == null) {
            throw CantRunException.noModuleConfigured((String)runConfigurationModule.getModuleName());
        }
        JavaParametersUtil.configureModule(module2, parameters, classPathType, jreHome);
    }

    public static void configureModule(Module module2, JavaParameters parameters, int classPathType, @Nullable String jreHome) throws CantRunException {
        parameters.configureByModule(module2, classPathType, JavaParametersUtil.createModuleJdk(module2, (classPathType & 4) == 0, jreHome));
    }

    public static void configureProject(Project project2, JavaParameters parameters, int classPathType, @Nullable String jreHome) throws CantRunException {
        parameters.configureByProject(project2, classPathType, JavaParametersUtil.createProjectJdk(project2, jreHome));
    }

    public static Sdk createModuleJdk(Module module2, boolean productionOnly, @Nullable String jreHome) throws CantRunException {
        return jreHome == null ? JavaParameters.getValidJdkToRunModule((Module)module2, (boolean)productionOnly) : JavaParametersUtil.a(jreHome);
    }

    public static Sdk createProjectJdk(Project project2, @Nullable String jreHome) throws CantRunException {
        return jreHome == null ? JavaParametersUtil.a(project2) : JavaParametersUtil.a(jreHome);
    }

    private static Sdk a(Project project2) throws CantRunException {
        Sdk sdk = PathUtilEx.getAnyJdk((Project)project2);
        if (sdk == null) {
            throw CantRunException.noJdkConfigured();
        }
        return sdk;
    }

    private static Sdk a(@NotNull String string) throws CantRunException {
        Sdk sdk;
        long l2 = a ^ 0x14B9B8D8562AL;
        if (string == null) {
            JavaParametersUtil.a(2);
        }
        if ((sdk = ProjectJdkTable.getInstance().findJdk(string)) != null) {
            return sdk;
        }
        if (!JdkUtil.checkForJre((String)string)) {
            throw new CantRunException(ExecutionBundle.message((String)"jre.path.is.not.valid.jre.home.error.message", (Object[])new Object[]{string}));
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        return javaSdk.createJdk((String)ObjectUtils.notNull((Object)javaSdk.getVersionString(string), (Object)""), string);
    }

    public static void checkAlternativeJRE(@NotNull CommonJavaRunConfigurationParameters configuration) throws RuntimeConfigurationWarning {
        if (configuration == null) {
            JavaParametersUtil.a(3);
        }
        if (configuration.isAlternativeJrePathEnabled()) {
            JavaParametersUtil.checkAlternativeJRE(configuration.getAlternativeJrePath());
        }
    }

    public static void checkAlternativeJRE(@Nullable String jrePath) throws RuntimeConfigurationWarning {
        long l2 = a ^ 0x1C82A52A5DDEL;
        if (StringUtil.isEmptyOrSpaces((String)jrePath) || ProjectJdkTable.getInstance().findJdk(jrePath) == null && !JdkUtil.checkForJre((String)jrePath)) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"jre.path.is.not.valid.jre.home.error.message", (Object[])new Object[]{jrePath}));
        }
    }

    @NotNull
    public static DefaultJDOMExternalizer.JDOMFilter getFilter(final @NotNull CommonJavaRunConfigurationParameters parameters) {
        if (parameters == null) {
            JavaParametersUtil.a(4);
        }
        DefaultJDOMExternalizer.JDOMFilter jDOMFilter = new DefaultJDOMExternalizer.JDOMFilter(){
            private static final long a = lb.a(-590624998360483518L, 6722671144589073202L, MethodHandles.lookup().lookupClass()).a(261983879670452L);

            public boolean isAccept(@NotNull Field field) {
                String string;
                long l2 = a ^ 0x76F6C286F574L;
                if (field == null) {
                    1.a(0);
                }
                return (!(string = field.getName()).equals("ALTERNATIVE_JRE_PATH_ENABLED") || parameters.isAlternativeJrePathEnabled()) && (!string.equals("ALTERNATIVE_JRE_PATH") || !StringUtil.isEmpty((String)parameters.getAlternativeJrePath()));
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x59AE9837CC7DL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/execution/util/JavaParametersUtil$1", "isAccept"));
            }
        };
        if (jDOMFilter == null) {
            JavaParametersUtil.a(5);
        }
        return jDOMFilter;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x49EC5F73CDBL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainClassName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jreHome";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/util/JavaParametersUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/util/JavaParametersUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isClassInProductionSources";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAlternativeJdk";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkAlternativeJRE";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFilter";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

