/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import b.a.lb;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class FormatterTestUtils {
    public static final Map<Action, TestFormatAction> ACTIONS;
    private static final long a;

    public static void testFormatting(@NotNull Project project2, @NotNull String ext, @NotNull String before, @NotNull String after2, @NotNull Action action) {
        long l2 = a ^ 0xB3DFD2B152EL;
        if (project2 == null) {
            FormatterTestUtils.a(0);
        }
        if (ext == null) {
            FormatterTestUtils.a(1);
        }
        if (before == null) {
            FormatterTestUtils.a(2);
        }
        if (after2 == null) {
            FormatterTestUtils.a(3);
        }
        if (action == null) {
            FormatterTestUtils.a(4);
        }
        String string = "FTU." + ext;
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(string);
        FormatData formatData = FormatterTestUtils.a(before);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project2).createFileFromText(string, fileType, (CharSequence)formatData.text, System.currentTimeMillis(), true);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        Document document = psiDocumentManager.getDocument(psiFile);
        if (document == null) {
            throw new IllegalStateException("Document is null");
        }
        TestFormatAction testFormatAction = ACTIONS.get((Object)action);
        if (testFormatAction == null) {
            throw new IllegalStateException("Format action is null");
        }
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> testFormatAction.run(psiFile, formatData.startOffset, formatData.endOffset));
        Assert.assertEquals((Object)after2, (Object)document.getText());
    }

    private static FormatData a(@NotNull String string) {
        long l2 = a ^ 0x6DB0D6DBDB12L;
        if (string == null) {
            FormatterTestUtils.a(5);
        }
        String string2 = "<selection>";
        String string3 = "<selection/>";
        int n2 = string.indexOf("<selection>");
        if (n2 > 0) {
            int n3 = string.indexOf("<selection/>") - "<selection>".length();
            String string4 = string.replace("<selection>", "").replace("<selection/>", "");
            return new FormatData(string4, n2, n3);
        }
        return new FormatData(string, 0, string.length());
    }

    static {
        a = lb.a(7345518880252305590L, 8012998881497787579L, MethodHandles.lookup().lookupClass()).a(264096555940609L);
        ACTIONS = new EnumMap<Action, TestFormatAction>(Action.class);
        ACTIONS.put(Action.REFORMAT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int startOffset, int endOffset) {
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).reformatText(psiFile, startOffset, endOffset);
            }
        });
        ACTIONS.put(Action.INDENT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int startOffset, int endOffset) {
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).adjustLineIndent(psiFile, startOffset);
            }
        });
        ACTIONS.put(Action.REFORMAT_WITH_CONTEXT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int startOffset, int endOffset) {
                ArrayList arrayList = ContainerUtil.newArrayList((Object[])new TextRange[]{new TextRange(startOffset, endOffset)});
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).reformatTextWithContext(psiFile, (Collection)arrayList);
            }
        });
        ACTIONS.put(Action.REFORMAT_WITH_INSERTED_LINE_CONTEXT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int startOffset, int endOffset) {
                ArrayList arrayList = ContainerUtil.newArrayList((Object[])new TextRange[]{new TextRange(startOffset, endOffset)});
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).reformatTextWithContext(psiFile, new ChangedRangesInfo((List)arrayList, (List)arrayList));
            }
        });
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x751F276E730DL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/FormatterTestUtils";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "testFormatting";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "extractFormatData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FormatData {
        public int startOffset;
        public int endOffset;
        public String text;

        public FormatData(String text2, int startOffset, int endOffset) {
            this.text = text2;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }
    }

    public static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action REFORMAT;
        public static final /* enum */ Action INDENT;
        public static final /* enum */ Action REFORMAT_WITH_CONTEXT;
        public static final /* enum */ Action REFORMAT_WITH_INSERTED_LINE_CONTEXT;
        private static final /* synthetic */ Action[] a;

        public static Action[] values() {
            return (Action[])a.clone();
        }

        public static Action valueOf(String name2) {
            return Enum.valueOf(Action.class, name2);
        }

        static {
            long l2 = lb.a(8271262993977283291L, -4154636943071339589L, MethodHandles.lookup().lookupClass()).a(204867620238126L) ^ 0x79582340FE07L;
            REFORMAT = new Action();
            INDENT = new Action();
            REFORMAT_WITH_CONTEXT = new Action();
            REFORMAT_WITH_INSERTED_LINE_CONTEXT = new Action();
            a = new Action[]{REFORMAT, INDENT, REFORMAT_WITH_CONTEXT, REFORMAT_WITH_INSERTED_LINE_CONTEXT};
        }
    }

    public static interface TestFormatAction {
        public void run(PsiFile var1, int var2, int var3);
    }
}

