/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import b.a.lb;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryTypeServiceImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryNameAndLevelPanel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.FormBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateLibraryFromFilesDialog
extends DialogWrapper {
    private final LibraryNameAndLevelPanel c;
    private final ModulesComboBox e;
    private final Project d;
    private final List<OrderRoot> b;
    private final JPanel a;
    private final String f;
    private static final long g = lb.a(-1872052995002397008L, -5644501579006371309L, MethodHandles.lookup().lookupClass()).a(1695538132510L);

    public CreateLibraryFromFilesDialog(@NotNull Project project2, @NotNull List<OrderRoot> roots) {
        long l2 = g ^ 0x3F7A8AD711E3L;
        if (project2 == null) {
            CreateLibraryFromFilesDialog.a(0);
        }
        if (roots == null) {
            CreateLibraryFromFilesDialog.a(1);
        }
        super(project2, true);
        this.setTitle("Create Library");
        this.d = project2;
        this.b = roots;
        FormBuilder formBuilder = LibraryNameAndLevelPanel.createFormBuilder();
        this.f = LibrariesContainerFactory.createContainer(project2).suggestUniqueLibraryName(LibraryTypeServiceImpl.suggestLibraryName(roots));
        this.c = new LibraryNameAndLevelPanel(formBuilder, this.f, Arrays.asList(LibrariesContainer.LibraryLevel.values()), LibrariesContainer.LibraryLevel.PROJECT);
        this.c.setDefaultName(this.f);
        this.e = new ModulesComboBox();
        this.e.fillModules(this.d);
        this.e.setSelectedModule(this.a(roots));
        formBuilder.addLabeledComponent("&Add to module:", (JComponent)this.e);
        this.a = formBuilder.getPanel();
        this.c.getLibraryNameField().selectAll();
        this.c.getLevelComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                CreateLibraryFromFilesDialog.this.c();
            }
        });
        this.c.getLibraryNameField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){
            private static final long a = lb.a(-9165103132234889185L, -3240167337192485304L, MethodHandles.lookup().lookupClass()).a(245215630441635L);

            protected void textChanged(@NotNull DocumentEvent e10) {
                if (e10 == null) {
                    2.a(0);
                }
                CreateLibraryFromFilesDialog.this.a();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x59FCA84F4127L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/projectView/actions/CreateLibraryFromFilesDialog$2", "textChanged"));
            }
        });
        this.init();
    }

    private void a() {
        this.setOKActionEnabled(!this.c.getLibraryName().isEmpty() || this.c.getLibraryLevel() == LibrariesContainer.LibraryLevel.MODULE && this.b.size() == 1);
    }

    private void c() {
        if (this.c.getLibraryLevel() == LibrariesContainer.LibraryLevel.MODULE) {
            this.c.setDefaultName(this.b.size() == 1 ? "" : this.f);
        } else {
            this.c.setDefaultName(this.f);
            if (this.c.getLibraryName().isEmpty()) {
                this.c.getLibraryNameField().setText(this.f);
            }
        }
        this.a();
    }

    @Nullable
    private Module a(List<OrderRoot> list2) {
        for (OrderRoot orderRoot : list2) {
            Module module2 = null;
            VirtualFile virtualFile = JarFileSystem.getInstance().getVirtualFileForJar(orderRoot.getFile());
            if (virtualFile != null) {
                module2 = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)this.d);
            }
            if (module2 == null) {
                module2 = ModuleUtil.findModuleForFile((VirtualFile)orderRoot.getFile(), (Project)this.d);
            }
            if (module2 == null) continue;
            return module2;
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.c.getLibraryNameField();
    }

    protected void doOKAction() {
        this.b();
        super.doOKAction();
    }

    private void b() {
        LibrariesContainer.LibraryLevel libraryLevel = this.c.getLibraryLevel();
        WriteAction.run(() -> {
            Module module2 = this.e.getSelectedModule();
            String string = this.c.getLibraryName();
            if (libraryLevel == LibrariesContainer.LibraryLevel.MODULE) {
                ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
                LibrariesContainerFactory.createContainer(modifiableRootModel).createLibrary(string, libraryLevel, this.b);
                modifiableRootModel.commit();
            } else {
                Library library = LibrariesContainerFactory.createContainer(this.d).createLibrary(string, libraryLevel, this.b);
                if (module2 != null) {
                    ModuleRootModificationUtil.addDependency((Module)module2, (Library)library);
                }
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.a;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = g ^ 0x64F0B184533FL;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "roots";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/projectView/actions/CreateLibraryFromFilesDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

