/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import b.a.lb;
import com.intellij.ide.util.importProject.DetectedRootData;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;

public class DetectedRootsChooser {
    private static final int h = new JCheckBox().getPreferredSize().width + 4;
    private final ColumnInfo<DetectedRootData, Boolean> c = new ColumnInfo<DetectedRootData, Boolean>(""){

        public Class getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(DetectedRootData detectedRootData) {
            return detectedRootData.isIncluded();
        }

        public boolean isCellEditable(DetectedRootData detectedRootData) {
            return true;
        }

        public int getWidth(JTable table) {
            return h;
        }

        public void setValue(DetectedRootData detectedRootData, Boolean value) {
            if (value.booleanValue() != detectedRootData.isIncluded()) {
                detectedRootData.setIncluded(value);
                ((RootSelectionListener)DetectedRootsChooser.this.f.getMulticaster()).selectionChanged();
            }
        }
    };
    private static final ColumnInfo<DetectedRootData, String> b = new ColumnInfo<DetectedRootData, String>(""){

        public String valueOf(DetectedRootData detectedRootData) {
            return detectedRootData.getDirectory().getAbsolutePath();
        }
    };
    private static final ColumnInfo<DetectedRootData, DetectedProjectRoot> d = new ColumnInfo<DetectedRootData, DetectedProjectRoot>(""){

        public DetectedProjectRoot valueOf(DetectedRootData detectedRootData) {
            return detectedRootData.getSelectedRoot();
        }

        public TableCellRenderer getRenderer(DetectedRootData detectedRootData) {
            if (this.isCellEditable(detectedRootData)) {
                return new ComboBoxTableRenderer<DetectedProjectRoot>(detectedRootData.getAllRoots()){
                    private static final long a = lb.a(-7951972968851236366L, -4930198856271315406L, MethodHandles.lookup().lookupClass()).a(273075101862271L);

                    protected String getTextFor(@NotNull DetectedProjectRoot value) {
                        if (value == null) {
                            1.a(0);
                        }
                        return value.getRootTypeName();
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x38E1339BB788L;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/util/importProject/DetectedRootsChooser$3$1", "getTextFor"));
                    }
                };
            }
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (value instanceof DetectedProjectRoot) {
                        this.setText(((DetectedProjectRoot)value).getRootTypeName());
                    }
                    return component;
                }
            };
        }

        public TableCellEditor getEditor(DetectedRootData o2) {
            ComboBox comboBox = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(Arrays.asList(o2.getAllRoots()), (Object)o2.getSelectedRoot()));
            comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<DetectedProjectRoot>(){

                public void customize(JList list2, DetectedProjectRoot value, int index, boolean selected, boolean hasFocus) {
                    this.setText(value.getRootTypeName());
                }
            });
            return new DefaultCellEditor((JComboBox<?>)comboBox);
        }

        public boolean isCellEditable(DetectedRootData detectedRootData) {
            return detectedRootData.getAllRoots().length > 1;
        }

        public void setValue(DetectedRootData detectedRootData, DetectedProjectRoot value) {
            detectedRootData.setSelectedRoot(value);
        }
    };
    private final TableView<DetectedRootData> a;
    private final JComponent e;
    private final ListTableModel<DetectedRootData> g;
    private final EventDispatcher<RootSelectionListener> f = EventDispatcher.create(RootSelectionListener.class);

    public DetectedRootsChooser() {
        this.g = new ListTableModel(new ColumnInfo[0]);
        this.a = new TableView(this.g);
        this.a.setTableHeader(null);
        this.a.setShowGrid(false);
        this.e = ScrollPaneFactory.createScrollPane(this.a);
        this.a.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                DetectedRootsChooser.this.a();
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
    }

    private void a() {
        int[] nArray = this.a.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        boolean bl2 = false;
        for (int n2 : nArray) {
            bl2 |= ((DetectedRootData)this.g.getItems().get(n2)).isIncluded();
        }
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        for (int n5 : nArray) {
            n3 = Math.min(n3, n5);
            n4 = Math.max(n4, n5);
            ((DetectedRootData)this.g.getItems().get(n5)).setIncluded(!bl2);
        }
        this.g.fireTableRowsUpdated(n3, n4 + 1);
        ((RootSelectionListener)this.f.getMulticaster()).selectionChanged();
    }

    public JComponent getComponent() {
        return this.e;
    }

    public void addSelectionListener(RootSelectionListener listener) {
        this.f.addListener((EventListener)listener);
    }

    public void setAllElementsMarked(boolean mark) {
        for (DetectedRootData detectedRootData : this.g.getItems()) {
            detectedRootData.setIncluded(mark);
        }
        this.g.fireTableRowsUpdated(0, this.g.getRowCount() - 1);
        ((RootSelectionListener)this.f.getMulticaster()).selectionChanged();
    }

    public List<DetectedRootData> getMarkedElements() {
        ArrayList<DetectedRootData> arrayList = new ArrayList<DetectedRootData>();
        for (DetectedRootData detectedRootData : this.g.getItems()) {
            if (!detectedRootData.isIncluded()) continue;
            arrayList.add(detectedRootData);
        }
        return arrayList;
    }

    public void setElements(List<? extends DetectedRootData> roots) {
        HashSet<String> hashSet = new HashSet<String>();
        for (DetectedRootData object2 : roots) {
            for (DetectedProjectRoot detectedProjectRoot : object2.getAllRoots()) {
                hashSet.add(detectedProjectRoot.getRootTypeName());
            }
        }
        this.g.setColumnInfos(new ColumnInfo[]{this.c, b, d});
        int n2 = 0;
        for (String string : hashSet) {
            n2 = Math.max(n2, this.a.getFontMetrics(this.a.getFont()).stringWidth(string));
        }
        TableColumn tableColumn = this.a.getColumnModel().getColumn(2);
        int n3 = n2 + 20;
        tableColumn.setPreferredWidth(n3);
        tableColumn.setMaxWidth(n3);
        this.a.updateColumnSizes();
        ArrayList<? extends DetectedRootData> arrayList = new ArrayList<DetectedRootData>(roots);
        Collections.sort(arrayList, Comparator.comparing(DetectedRootData::getDirectory));
        this.g.setItems(arrayList);
    }

    static interface RootSelectionListener
    extends EventListener {
        public void selectionChanged();
    }
}

