/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import b.a.lb;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ModulesLayoutPanel;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class ModulesDetectionStep
extends AbstractStepWithProgress<List<ModuleDescriptor>> {
    private final ProjectStructureDetector j;
    private final ProjectFromSourcesBuilder k;
    private final ProjectDescriptor n;
    private final ModuleInsight p;
    private final Icon m;
    private final String i;
    private ModulesLayoutPanel l;
    private int o;
    private static final long q = lb.a(4783127641837712148L, -3161915867189632690L, MethodHandles.lookup().lookupClass()).a(199562769792043L);

    public ModulesDetectionStep(ProjectStructureDetector detector, ProjectFromSourcesBuilder builder, ProjectDescriptor projectDescriptor, ModuleInsight insight, Icon icon, @NonNls String helpId) {
        long l2 = q ^ 0x680C33C7C22L;
        super("Stop module analysis?");
        this.o = -1;
        this.j = detector;
        this.k = builder;
        this.n = projectDescriptor;
        this.p = insight;
        this.m = icon;
        this.i = helpId;
    }

    public void updateDataModel() {
        this.n.setModules(this.l.getChosenEntries());
    }

    @Override
    protected JComponent createResultsPanel() {
        this.l = new ModulesLayoutPanel(this.p, libraryDescriptor -> this.n.isLibraryChosen(libraryDescriptor));
        return this.l;
    }

    @Override
    protected String getProgressText() {
        long l2 = q ^ 0x6D6327FB8F15L;
        return "Searching for modules. Please wait.";
    }

    @Override
    protected boolean shouldRunProgress() {
        int n2 = this.a();
        try {
            boolean bl2 = n2 != this.o;
            return bl2;
        }
        finally {
            this.o = n2;
        }
    }

    private int a() {
        String string = this.k.getBaseProjectPath();
        int n2 = string != null ? string.hashCode() : 1;
        for (DetectedProjectRoot object2 : this.k.getProjectRoots(this.j)) {
            n2 = 31 * n2 + object2.getDirectory().hashCode();
        }
        List<LibraryDescriptor> list2 = this.n.getLibraries();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            LibraryDescriptor libraryDescriptor = (LibraryDescriptor)iterator.next();
            Collection<File> collection = libraryDescriptor.getJars();
            for (File file : collection) {
                n2 = 31 * n2 + file.hashCode();
            }
        }
        return n2;
    }

    @Override
    protected List<ModuleDescriptor> calculate() {
        this.p.scanModules();
        List<ModuleDescriptor> list2 = this.p.getSuggestedModules();
        return list2 != null ? list2 : Collections.emptyList();
    }

    @Override
    public boolean validate() throws ConfigurationException {
        long l2 = q ^ 0x6B68E80F4B0EL;
        boolean bl2 = super.validate();
        if (!bl2) {
            return false;
        }
        List list2 = this.l.getChosenEntries();
        LinkedHashMap<String, ModuleDescriptor> linkedHashMap = new LinkedHashMap<String, ModuleDescriptor>();
        for (Object object : list2) {
            try {
                Object object2 = ((ModuleDescriptor)object).computeModuleFilePath();
                if (!new File((String)object2).exists()) continue;
                linkedHashMap.put(IdeBundle.message((String)"warning.message.the.module.file.0.already.exist.and.will.be.overwritten", (Object[])new Object[]{object2}), (ModuleDescriptor)object);
            }
            catch (InvalidDataException invalidDataException) {
                linkedHashMap.put(invalidDataException.getMessage(), (ModuleDescriptor)object);
            }
        }
        if (!linkedHashMap.isEmpty()) {
            int n2 = Messages.showYesNoCancelDialog((Component)this.getComponent(), (String)IdeBundle.message((String)"warning.text.0.do.you.want.to.overwrite.these.files", (Object[])new Object[]{StringUtil.join(linkedHashMap.keySet(), (String)"\n"), linkedHashMap.size()}), (String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (String)"Overwrite", (String)"Reuse", (String)"Cancel", (Icon)Messages.getQuestionIcon());
            if (n2 == 2) {
                return false;
            }
            if (n2 != 0) {
                for (Object object2 : linkedHashMap.values()) {
                    ((ModuleDescriptor)object2).reuseExisting(true);
                }
            }
        }
        return true;
    }

    @Override
    protected void onFinished(List<ModuleDescriptor> moduleDescriptors, boolean canceled) {
        this.l.rebuild();
    }

    @NonNls
    public String getHelpId() {
        return this.i;
    }

    public Icon getIcon() {
        return this.m;
    }
}

