/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import b.a.lb;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;

public class ProjectNameStep
extends ModuleWizardStep {
    private final NamePathComponent a;
    private final JPanel c;
    private final WizardContext b;
    private static final long d = lb.a(3518907354349452320L, 3714388248173454224L, MethodHandles.lookup().lookupClass()).a(266921207323237L);

    public ProjectNameStep(WizardContext wizardContext) {
        long l2 = d ^ 0x7FEABD1906C6L;
        this.b = wizardContext;
        this.a = new NamePathComponent(IdeBundle.message((String)"label.project.name", (Object[])new Object[0]), IdeBundle.message((String)"label.component.file.location", (Object[])new Object[]{StringUtil.capitalize((String)this.b.getPresentationName())}), IdeBundle.message((String)"title.select.project.file.directory", (Object[])new Object[]{this.b.getPresentationName()}), IdeBundle.message((String)"description.select.project.file.directory", (Object[])new Object[]{this.b.getPresentationName()}));
        this.c = new JPanel(new GridBagLayout());
        this.c.setBorder(BorderFactory.createEtchedBorder());
        String string = ApplicationNamesInfo.getInstance().getFullProductName();
        this.c.add((Component)new JLabel(IdeBundle.message((String)"label.please.enter.project.name", (Object[])new Object[]{string, wizardContext.getPresentationName()})), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
        this.c.add((Component)this.a, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.insets((int)8, (int)10), 0, 0));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.a.getNameComponent();
    }

    public String getHelpId() {
        long l2 = d ^ 0x7276BF335922L;
        return "reference.dialogs.new.project.import.name";
    }

    public JComponent getComponent() {
        return this.c;
    }

    public void updateStep() {
        List list2;
        super.updateStep();
        this.a.setPath(FileUtil.toSystemDependentName((String)this.b.getProjectFileDirectory()));
        String string = this.b.getProjectName();
        if (string == null && !(list2 = StringUtil.split((String)FileUtil.toSystemIndependentName((String)this.b.getProjectFileDirectory()), (String)"/")).isEmpty()) {
            string = (String)list2.get(list2.size() - 1);
        }
        this.a.setNameValue(string);
        if (string != null) {
            this.a.getNameComponent().setSelectionStart(0);
            this.a.getNameComponent().setSelectionEnd(string.length());
        }
    }

    public void updateDataModel() {
        this.b.setProjectName(this.getProjectName());
        this.b.setProjectFileDirectory(this.getProjectFileDirectory());
    }

    public Icon getIcon() {
        return this.b.getStepIcon();
    }

    public boolean validate() throws ConfigurationException {
        long l2 = d ^ 0x654005DA3F72L;
        String string = this.a.getNameValue();
        if (string.length() == 0) {
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            throw new ConfigurationException(IdeBundle.message((String)"prompt.new.project.file.name", (Object[])new Object[]{applicationNamesInfo.getFullProductName(), this.b.getPresentationName()}));
        }
        String string2 = this.getProjectFileDirectory();
        if (string2.length() == 0) {
            throw new ConfigurationException(IdeBundle.message((String)"prompt.enter.project.file.location", (Object[])new Object[]{this.b.getPresentationName()}));
        }
        boolean bl2 = this.a.isPathChangedByUser();
        String string3 = IdeBundle.message((String)"directory.project.file.directory", (Object[])new Object[]{this.b.getPresentationName()});
        if (!ProjectWizardUtil.createDirectoryIfNotExists(string3, string2, bl2)) {
            return false;
        }
        boolean bl3 = true;
        String string4 = this.b.isCreatingNewProject() && this.b.getProjectStorageFormat() == StorageScheme.DIRECTORY_BASED ? this.getProjectFileDirectory() + "/" + ".idea" : this.getProjectFilePath();
        File file = new File(string4);
        if (file.exists()) {
            String string5 = this.b.isCreatingNewProject() ? IdeBundle.message((String)"title.new.project", (Object[])new Object[0]) : IdeBundle.message((String)"title.add.module", (Object[])new Object[0]);
            String string6 = this.b.isCreatingNewProject() && this.b.getProjectStorageFormat() == StorageScheme.DIRECTORY_BASED ? IdeBundle.message((String)"prompt.overwrite.project.folder", (Object[])new Object[]{".idea", file.getParentFile().getAbsolutePath()}) : IdeBundle.message((String)"prompt.overwrite.project.file", (Object[])new Object[]{file.getAbsolutePath(), this.b.getPresentationName()});
            int n2 = Messages.showYesNoDialog((String)string6, (String)string5, (Icon)Messages.getQuestionIcon());
            bl3 = n2 == 0;
        }
        return bl3;
    }

    @NonNls
    public String getProjectFilePath() {
        long l2 = d ^ 0x49ABE0145338L;
        return this.getProjectFileDirectory() + "/" + this.a.getNameValue() + (this.b.getProject() == null ? ".ipr" : ".iml");
    }

    public String getProjectFileDirectory() {
        return FileUtil.toSystemIndependentName((String)this.a.getPath());
    }

    public String getProjectName() {
        return this.a.getNameValue();
    }

    public String getName() {
        long l2 = d ^ 0x41C6BDC6DB75L;
        return "Name";
    }

    public boolean isStepVisible() {
        ProjectBuilder projectBuilder = this.b.getProjectBuilder();
        if (projectBuilder != null && projectBuilder.isUpdate()) {
            return false;
        }
        return super.isStepVisible();
    }
}

