/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources.util;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NullableFunction;
import com.intellij.util.text.StringFactory;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public abstract class CommonSourceRootDetectionUtil<F> {
    public static final CommonSourceRootDetectionUtil<File> IO_FILE = new CommonSourceRootDetectionUtil<File>(){

        @Override
        protected String getName(File file) {
            return file.getName();
        }

        @Override
        protected File getParentFile(File file) {
            return file.getParentFile();
        }

        @Override
        protected CharSequence loadText(File file) throws IOException {
            return StringFactory.createShared((char[])CommonSourceRootDetectionUtil.a(file));
        }

        @Override
        protected boolean isFile(File file) {
            return file.isFile();
        }
    };
    public static final CommonSourceRootDetectionUtil<VirtualFile> VIRTUAL_FILE = new CommonSourceRootDetectionUtil<VirtualFile>(){

        @Override
        protected String getName(VirtualFile file) {
            return file.getName();
        }

        @Override
        protected VirtualFile getParentFile(VirtualFile file) {
            return file.getParent();
        }

        @Override
        protected CharSequence loadText(VirtualFile file) throws IOException {
            return VfsUtilCore.loadText((VirtualFile)file);
        }

        @Override
        protected boolean isFile(VirtualFile file) {
            return !file.isDirectory();
        }
    };

    protected CommonSourceRootDetectionUtil() {
    }

    @Nullable
    public Pair<F, String> suggestRootForFileWithPackageStatement(F file, F topmostPossibleRoot, NullableFunction<CharSequence, String> packageNameFetcher, boolean packagePrefixSupported) {
        CharSequence charSequence;
        if (!this.isFile(file)) {
            return null;
        }
        try {
            charSequence = this.loadText(file);
        }
        catch (IOException iOException) {
            return null;
        }
        String string = (String)packageNameFetcher.fun((Object)charSequence);
        if (string != null) {
            F f10 = this.getParentFile(file);
            int n2 = string.length();
            while (n2 > 0) {
                boolean bl2;
                int n3 = string.lastIndexOf(46, n2 - 1);
                String string2 = string.substring(n3 + 1, n2);
                String string3 = this.getName(f10);
                boolean bl3 = bl2 = SystemInfo.isFileSystemCaseSensitive ? string3.equals(string2) : string3.equalsIgnoreCase(string2);
                if (!bl2 || f10.equals(topmostPossibleRoot)) {
                    String string4 = string.substring(0, n2);
                    if (!packagePrefixSupported && string4.length() > 0) {
                        return null;
                    }
                    return Pair.create(f10, (Object)string4);
                }
                if ((f10 = this.getParentFile(f10)) == null) {
                    return null;
                }
                n2 = n3;
            }
            return Pair.create(f10, (Object)"");
        }
        return null;
    }

    protected abstract String getName(F var1);

    @Nullable
    protected abstract F getParentFile(F var1);

    protected abstract CharSequence loadText(F var1) throws IOException;

    protected abstract boolean isFile(F var1);

    /*
     * Exception decompiling
     */
    private static char[] a(File var0) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

