/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.model.common;

import b.a.lb;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamMessages;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelManager;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.view.DeleteHandler;
import com.intellij.jam.view.JamDeleteHandler;
import com.intellij.jam.view.JamUserResponse;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.ModelMergerUtil;
import gnu.trove.THashSet;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class CommonModelManagerImpl
extends CommonModelManager {
    private final List<JamDeleteHandler> a = new ArrayList<JamDeleteHandler>();
    private final Map<Class<? extends CommonModelElement>, JamDeleteHandler> b = FactoryMap.create(clazz -> {
        DeleteHandler deleteHandler = (DeleteHandler)DomReflectionUtil.findAnnotationDFS((Class)clazz, DeleteHandler.class);
        if (deleteHandler == null) {
            return null;
        }
        try {
            Class<?> clazz2 = deleteHandler.handlerClass();
            if (clazz2 == JamDeleteHandler.class) {
                clazz2 = Class.forName(deleteHandler.value(), true, clazz.getClassLoader());
            }
            return (JamDeleteHandler)clazz2.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    });
    private static final long c = lb.a(3615088555916928779L, 7045461469334773683L, MethodHandles.lookup().lookupClass()).a(136684145935419L);

    public CommonModelManagerImpl() {
        this.registerDeleteHandler(new JamDeleteHandler(){

            public void addPsiElements(CommonModelElement element, Collection<? super PsiElement> result) {
                DomElement domElement = (DomElement)ModelMergerUtil.getImplementation((Object)element, DomElement.class);
                JamElement jamElement = (JamElement)ModelMergerUtil.getImplementation((Object)element, JamElement.class);
                if (domElement != null) {
                    XmlTag xmlTag = domElement.getXmlTag();
                    if (xmlTag != null) {
                        result.add((PsiElement)xmlTag);
                    }
                } else if (jamElement instanceof CommonModelElement) {
                    ContainerUtil.addIfNotNull(result, (Object)((CommonModelElement)jamElement).getIdentifyingPsiElement());
                }
            }
        });
    }

    public final void registerDeleteHandler(JamDeleteHandler handler) {
        this.a.add(handler);
    }

    @Nullable
    public <T extends DomElement> T getDomElement(CommonModelElement element) {
        return (T)((DomElement)ModelMergerUtil.getImplementation((Object)element, DomElement.class));
    }

    public final void deleteModelElement(CommonModelElement element, JamUserResponse response) {
        this.deleteModelElements(Arrays.asList(element), response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteModelElements(Collection<? extends CommonModelElement> elements, JamUserResponse response) {
        Object object;
        String string;
        long l2 = c ^ 0x58BE4C2CD194L;
        THashSet tHashSet = new THashSet();
        for (CommonModelElement object22 : elements) {
            if (object22 == null || !object22.isValid()) continue;
            tHashSet.add((Object)object22);
        }
        if (tHashSet.isEmpty()) {
            return;
        }
        CommonModelElement commonModelElement = elements.iterator().next();
        String string2 = string = elements.size() == 1 ? JamCommonUtil.getDisplayName((Object)commonModelElement) : JamMessages.message((String)"model.delete.items", (Object[])new Object[0]);
        if (!CommonModelManagerImpl.a(string, response)) {
            return;
        }
        this.a(tHashSet);
        ArrayList<? extends PsiElement> arrayList = new ArrayList<PsiElement>(this.b((Collection<? extends CommonModelElement>)tHashSet));
        if (arrayList.size() > tHashSet.size()) {
            object = new ArrayList(response.askUserToDeletePsiElements(arrayList, string));
            if (object.isEmpty()) {
                return;
            }
            arrayList.clear();
            arrayList.addAll((Collection<? extends PsiElement>)object);
        }
        object = commonModelElement.getPsiManager().getProject();
        String string3 = JamMessages.message((String)"local.vcs.action.name.deleting.element", (Object[])new Object[]{string});
        LocalHistoryAction localHistoryAction = LocalHistory.getInstance().startAction(string3);
        try {
            if (arrayList.isEmpty() || CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)object, arrayList)) {
                PsiDocumentManager.getInstance((Project)object).commitAllDocuments();
                WriteCommandAction.writeCommandAction((Project)object).withName(JamMessages.message((String)"command.name.deleting.element", (Object[])new Object[]{string})).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).withGlobalUndo().run(() -> this.a(arrayList, response, string, (Project)object));
            }
        }
        finally {
            localHistoryAction.finish();
        }
        response.onDeletingHasBeenFinished();
    }

    private void a(Set<CommonModelElement> set) {
        THashSet tHashSet = new THashSet(CommonModelManagerImpl.a(set));
        while (!tHashSet.isEmpty()) {
            THashSet tHashSet2 = new THashSet();
            for (CommonModelElement commonModelElement : tHashSet) {
                for (JamDeleteHandler jamDeleteHandler : this.a(commonModelElement)) {
                    jamDeleteHandler.addModelElements(commonModelElement, (Collection)tHashSet2);
                }
            }
            tHashSet2.removeAll(set);
            set.addAll((Collection<CommonModelElement>)CommonModelManagerImpl.a(tHashSet2));
            tHashSet = tHashSet2;
        }
    }

    private List<JamDeleteHandler> a(Object object) {
        JamDeleteHandler jamDeleteHandler;
        Class<?> clazz = object.getClass();
        if (CommonModelElement.class.isAssignableFrom(clazz) && (jamDeleteHandler = this.b.get(clazz)) != null) {
            ArrayList<JamDeleteHandler> arrayList = new ArrayList<JamDeleteHandler>(this.a);
            arrayList.add(jamDeleteHandler);
            return arrayList;
        }
        return this.a;
    }

    private static <T extends Collection<CommonModelElement>> T a(T t2) {
        Iterator<CommonModelElement> iterator = t2.iterator();
        while (iterator.hasNext()) {
            CommonModelElement commonModelElement = iterator.next();
            if (commonModelElement != null && commonModelElement.isValid()) continue;
            iterator.remove();
        }
        return t2;
    }

    private Collection<? extends PsiElement> b(Collection<? extends CommonModelElement> collection) {
        THashSet tHashSet = new THashSet();
        for (CommonModelElement commonModelElement : collection) {
            for (JamDeleteHandler jamDeleteHandler : this.a(commonModelElement)) {
                jamDeleteHandler.addPsiElements(commonModelElement, (Collection)tHashSet);
            }
        }
        Iterator iterator = tHashSet.iterator();
        while (iterator.hasNext()) {
            PsiElement psiElement = (PsiElement)iterator.next();
            if (psiElement != null && !(psiElement instanceof PsiCompiledElement) && !(psiElement instanceof FakePsiElement) && psiElement.isValid() && psiElement.getManager().isInProject(psiElement)) continue;
            iterator.remove();
        }
        return tHashSet;
    }

    private static void a(List<? extends PsiElement> list2, JamUserResponse jamUserResponse, String string) {
        for (PsiElement psiElement : list2) {
            if (!psiElement.isValid()) continue;
            try {
                psiElement.delete();
            }
            catch (IncorrectOperationException incorrectOperationException) {
                jamUserResponse.logErrorWhileDeletingPsiElement(incorrectOperationException, string, psiElement);
            }
        }
    }

    private static boolean a(String string, JamUserResponse jamUserResponse) {
        long l2 = c ^ 0x7F6E82576470L;
        return jamUserResponse.showYesNoDialog(JamMessages.message((String)"confirmation.text.delete.element", (Object[])new Object[]{string}), JamMessages.message((String)"message.title.deleting.element", (Object[])new Object[]{string}), Messages.getQuestionIcon()) == 0;
    }

    private /* synthetic */ void a(List list2, JamUserResponse jamUserResponse, String string, Project project2) throws RuntimeException {
        THashSet tHashSet = new THashSet();
        for (Object object : list2) {
            ContainerUtil.addIfNotNull((Collection)tHashSet, (Object)object.getParent());
        }
        CommonModelManagerImpl.a(list2, jamUserResponse, string);
        DomManager domManager = DomManager.getDomManager((Project)project2);
        block1: for (PsiElement psiElement : tHashSet) {
            if (!psiElement.isValid()) continue;
            DomElement domElement = psiElement instanceof XmlTag ? domManager.getDomElement((XmlTag)psiElement) : null;
            for (JamDeleteHandler jamDeleteHandler : this.a(domElement == null ? psiElement : domElement)) {
                if ((domElement == null || !jamDeleteHandler.onChildrenDelete(domElement)) && (domElement != null || !jamDeleteHandler.onChildrenDelete(psiElement))) continue;
                continue block1;
            }
        }
    }
}

