/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.util;

import com.intellij.compiler.CompilerIOUtil;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PsiElementsValidityState
implements ValidityState {
    private final Map<String, Long> a = new HashMap<String, Long>();

    public void addDependency(String key, Long value) {
        this.a.put(key, value);
    }

    public boolean equalsTo(ValidityState otherState) {
        return otherState instanceof PsiElementsValidityState && this.a.equals(((PsiElementsValidityState)otherState).a);
    }

    public void save(DataOutput out) throws IOException {
        Set<Map.Entry<String, Long>> set = this.a.entrySet();
        out.writeInt(set.size());
        for (Map.Entry<String, Long> entry : set) {
            IOUtil.writeString((String)entry.getKey(), (DataOutput)out);
            out.writeLong(entry.getValue());
        }
    }

    public static PsiElementsValidityState load(DataInput input) throws IOException {
        int n2 = input.readInt();
        PsiElementsValidityState psiElementsValidityState = new PsiElementsValidityState();
        while (n2-- > 0) {
            String string = CompilerIOUtil.readString(input);
            long l2 = input.readLong();
            psiElementsValidityState.addDependency(string, l2);
        }
        return psiElementsValidityState;
    }

    public void addDependency(PsiElement element) {
        VirtualFile virtualFile;
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null && (virtualFile = psiFile.getVirtualFile()) != null) {
            this.addDependency(virtualFile.getUrl(), virtualFile.getTimeStamp());
        }
    }
}

