/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import b.a.lb;
import com.intellij.ProjectTopics;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.autoimport.ConfigurationFileCrcFactory;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcher;
import com.intellij.openapi.externalSystem.service.project.autoimport.FileChangeListenerBase;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashMap;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemProjectsWatcherImpl
extends ExternalSystemTaskNotificationListenerAdapter
implements ExternalSystemProjectsWatcher {
    private static final Logger o;
    private static final ExtensionPointName<Contributor> k;
    private static final Key<Long> l;
    private static final Key<Long> g;
    private static final int d = 1000;
    private static final int h = 2000;
    private final Project b;
    private final MergingUpdateQueue e;
    private final List<ExternalSystemAutoImportAware> m;
    private final MergingUpdateQueue n;
    private final Map<ProjectSystemId, MyNotification> i;
    private final MultiMap<String, String> a;
    private final MultiMap<VirtualFilePointer, String> j;
    private final List<LocalFileSystem.WatchRequest> c;
    private final MergingUpdateQueue f;
    private static final long p;

    public ExternalSystemProjectsWatcherImpl(Project project2) {
        long l2 = p ^ 0x5E348A3B1338L;
        this.a = MultiMap.createConcurrentSet();
        this.j = MultiMap.createConcurrentSet();
        this.c = new ArrayList<LocalFileSystem.WatchRequest>();
        this.b = project2;
        this.e = new MergingUpdateQueue("ExternalSystemProjectsWatcher: Document changes queue", 1000, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.b);
        this.f = new MergingUpdateQueue("ExternalSystemProjectsWatcher: Refresh requests queue", 2000, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.b, null, false);
        this.m = ContainerUtil.newArrayList();
        for (ExternalSystemManager externalSystemManager : ExternalSystemApiUtil.getAllManagers()) {
            if (!(externalSystemManager instanceof ExternalSystemAutoImportAware)) continue;
            this.m.add((ExternalSystemAutoImportAware)externalSystemManager);
            NotificationsConfiguration.getNotificationsConfiguration().register(externalSystemManager.getSystemId().getReadableName() + " Import", NotificationDisplayType.STICKY_BALLOON, false);
        }
        this.n = new MergingUpdateQueue("ExternalSystemProjectsWatcher: Notifier queue", 500, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.b);
        this.i = ContainerUtil.newConcurrentMap();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.b).subscribe(BatchFileChangeListener.TOPIC, (Object)new BatchFileChangeListener(){
            private static final long a = lb.a(4757064855272601586L, -7443451616944936635L, MethodHandles.lookup().lookupClass()).a(138732984913774L);

            public void batchChangeStarted(@NotNull Project project2, @Nullable String activityName) {
                if (project2 == null) {
                    1.a(0);
                }
                ExternalSystemProjectsWatcherImpl.this.f.suspend();
            }

            public void batchChangeCompleted(@NotNull Project project2) {
                if (project2 == null) {
                    1.a(1);
                }
                ExternalSystemProjectsWatcherImpl.this.f.resume();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x3729704C9578L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "batchChangeStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "batchChangeCompleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void markDirtyAllExternalProjects() {
        this.b().forEach(this::a);
        for (Contributor contributor : (Contributor[])k.getExtensions()) {
            contributor.markDirtyAllExternalProjects(this.b);
        }
    }

    public void markDirty(Module module2) {
        this.b(ExternalSystemApiUtil.getExternalProjectPath((Module)module2));
        for (Contributor contributor : (Contributor[])k.getExtensions()) {
            contributor.markDirty(module2);
        }
    }

    public void markDirty(String projectPath) {
        this.b(projectPath);
    }

    public synchronized void start() {
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            return;
        }
        this.n.activate();
        MessageBusConnection messageBusConnection = this.b.getMessageBus().connect((Disposable)this.e);
        messageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyFileChangeListener(this));
        ExternalSystemProjectsWatcherImpl.a(this.e, this.b);
        this.e.activate();
        this.f.activate();
        DocumentListener documentListener = new DocumentListener(){
            private final Map<Document, Pair<String, VirtualFile>> a = new THashMap();
            private static final long b = lb.a(8859231420484984691L, 5804070627324575631L, MethodHandles.lookup().lookupClass()).a(34482951180791L);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.a(0);
                }
                Document document = event.getDocument();
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
                if (virtualFile == null) {
                    return;
                }
                String string = ExternalSystemProjectsWatcherImpl.this.a(virtualFile);
                if (string == null) {
                    return;
                }
                Map<Document, Pair<String, VirtualFile>> map2 = this.a;
                synchronized (map2) {
                    this.a.put(document, (Pair<String, VirtualFile>)Pair.create((Object)string, (Object)virtualFile));
                }
                ExternalSystemProjectsWatcherImpl.this.e.queue(new Update((Object)ExternalSystemProjectsWatcherImpl.this){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        THashMap tHashMap;
                        Map map2 = a;
                        synchronized (map2) {
                            tHashMap = new THashMap(a);
                            a.clear();
                        }
                        ExternalSystemUtil.invokeLater(ExternalSystemProjectsWatcherImpl.this.b, () -> this.b((Map)tHashMap));
                    }

                    private /* synthetic */ void b(Map map2) {
                        WriteAction.run(() -> map2.forEach((document, pair2) -> {
                            if (!((VirtualFile)pair2.second).isValid()) {
                                return;
                            }
                            PsiDocumentManager.getInstance((Project)ExternalSystemProjectsWatcherImpl.this.b).commitDocument(document);
                            FileDocumentManagerImpl fileDocumentManagerImpl = (FileDocumentManagerImpl)FileDocumentManager.getInstance();
                            fileDocumentManagerImpl.saveDocumentAsIs(document);
                            Long l2 = (Long)((VirtualFile)pair2.second).getUserData(g);
                            Long l3 = (Long)((VirtualFile)pair2.second).getUserData(l);
                            if (l3 != null && l3.equals(l2)) {
                                Long l5 = ExternalSystemProjectsWatcherImpl.this.b((VirtualFile)pair2.second);
                                ((VirtualFile)pair2.second).putUserData(l, (Object)l5);
                                if (!l3.equals(l5)) {
                                    ExternalSystemProjectsWatcherImpl.this.a((String)pair2.first, false);
                                }
                            }
                        }));
                    }
                });
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = b ^ 0x4AD465D6F89AL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$2", "documentChanged"));
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(documentListener, (Disposable)messageBusConnection);
        ((ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class)).addNotificationListener((ExternalSystemTaskNotificationListener)this);
        this.a(true);
        Disposer.register((Disposable)this.e, () -> this.j.clear());
    }

    public synchronized void stop() {
        Disposer.dispose((Disposable)this.e);
        Disposer.dispose((Disposable)this.n);
        Disposer.dispose((Disposable)this.f);
        this.i.clear();
        ((ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class)).removeNotificationListener((ExternalSystemTaskNotificationListener)this);
    }

    public void onStart(@NotNull ExternalSystemTaskId id2, final String workingDir) {
        if (id2 == null) {
            ExternalSystemProjectsWatcherImpl.a(0);
        }
        if (id2.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
            final ProjectSystemId projectSystemId = id2.getProjectSystemId();
            for (String string : ContainerUtil.newArrayList((Iterable)this.a.get((Object)workingDir))) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File(string), (boolean)false);
                if (virtualFile == null || virtualFile.isDirectory()) continue;
                virtualFile.putUserData(g, virtualFile.getUserData(l));
            }
            this.n.queue(new Update(Pair.create((Object)projectSystemId, (Object)workingDir)){

                public void run() {
                    ExternalSystemProjectsWatcherImpl.this.a(true, projectSystemId, workingDir);
                }
            });
        }
    }

    public void onSuccess(@NotNull ExternalSystemTaskId id2) {
        if (id2 == null) {
            ExternalSystemProjectsWatcherImpl.a(1);
        }
        if (id2.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
            this.a(false);
        }
    }

    private void b(@Nullable String string) {
        this.a(string, true);
    }

    private void a(@Nullable String string, boolean bl2) {
        if (string == null || ExternalSystemUtil.isNoBackgroundMode()) {
            return;
        }
        Pair<ExternalSystemManager, ExternalProjectSettings> pair2 = this.a(string);
        if (pair2 == null) {
            return;
        }
        this.a(pair2, bl2);
    }

    private void a(@NotNull Pair<ExternalSystemManager, ExternalProjectSettings> pair2) {
        if (pair2 == null) {
            ExternalSystemProjectsWatcherImpl.a(2);
        }
        this.a(pair2, true);
    }

    private void a(@NotNull Pair<ExternalSystemManager, ExternalProjectSettings> pair2, boolean bl2) {
        long l2 = p ^ 0x7EBB9F96B99CL;
        if (pair2 == null) {
            ExternalSystemProjectsWatcherImpl.a(3);
        }
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            return;
        }
        ExternalSystemManager externalSystemManager = (ExternalSystemManager)pair2.first;
        final String string = ((ExternalProjectSettings)pair2.second).getExternalProjectPath();
        final ProjectSystemId projectSystemId = externalSystemManager.getSystemId();
        boolean bl3 = ((ExternalProjectSettings)pair2.second).isUseAutoImport();
        if (bl3) {
            ExternalSystemTaskState externalSystemTaskState;
            ExternalSystemTask externalSystemTask = ((ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class)).findTask(ExternalSystemTaskType.RESOLVE_PROJECT, projectSystemId, string);
            ExternalSystemTaskState externalSystemTaskState2 = externalSystemTaskState = externalSystemTask == null ? null : externalSystemTask.getState();
            if (externalSystemTaskState == null || externalSystemTaskState.isStopped()) {
                this.a(string, projectSystemId, bl2);
            } else if (externalSystemTaskState != ExternalSystemTaskState.NOT_STARTED) {
                Object object;
                Object object2;
                if (externalSystemManager instanceof ExternalSystemAutoImportAware && (object2 = (Long)((AbstractExternalSystemLocalSettings)externalSystemManager.getLocalSettingsProvider().fun((Object)this.b)).getExternalConfigModificationStamps().get(string)) != null) {
                    object = ((ExternalSystemAutoImportAware)externalSystemManager).getAffectedExternalProjectFiles(string, this.b);
                    long l3 = object.stream().mapToLong(File::lastModified).sum();
                    if ((Long)object2 != l3) {
                        return;
                    }
                }
                object2 = (ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
                object = new ExternalSystemTaskNotificationListenerAdapter((ExternalSystemProgressNotificationManager)object2, string, projectSystemId, bl2){
                    final /* synthetic */ ExternalSystemProgressNotificationManager val$progressManager;
                    final /* synthetic */ String val$projectPath;
                    final /* synthetic */ ProjectSystemId val$systemId;
                    final /* synthetic */ boolean val$reportRefreshError;
                    private static final long a = lb.a(-9208385121054237135L, 1353924322714172661L, MethodHandles.lookup().lookupClass()).a(223158963581004L);
                    {
                        this.val$progressManager = externalSystemProgressNotificationManager;
                        this.val$projectPath = string;
                        this.val$systemId = projectSystemId;
                        this.val$reportRefreshError = bl2;
                    }

                    public void onEnd(@NotNull ExternalSystemTaskId id2) {
                        if (id2 == null) {
                            4.a(0);
                        }
                        this.val$progressManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this);
                        ExternalSystemProjectsWatcherImpl.this.a(this.val$projectPath, this.val$systemId, this.val$reportRefreshError);
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x39BA765CDF35L;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$4", "onEnd"));
                    }
                };
                object2.addNotificationListener(externalSystemTask.getId(), (ExternalSystemTaskNotificationListener)object);
            }
        } else {
            o.debug("Scheduling new external project update notification", new Throwable("Schedule update call trace"));
            this.n.queue(new Update(Pair.create((Object)projectSystemId, (Object)string)){

                public void run() {
                    ExternalSystemProjectsWatcherImpl.this.a(false, projectSystemId, string);
                }
            });
        }
    }

    private void a(final String string, final ProjectSystemId projectSystemId, final boolean bl2) {
        this.f.queue(new Update(Pair.create((Object)projectSystemId, (Object)string)){

            public void run() {
                ExternalSystemProjectsWatcherImpl.a(ExternalSystemProjectsWatcherImpl.this.b, string, projectSystemId, bl2);
            }
        });
    }

    private void a(boolean bl2) {
        SmartList smartList = new SmartList();
        this.j.clear();
        LocalFileSystem.getInstance().removeWatchedRoots(this.c);
        HashMap hashMap = ContainerUtil.newHashMap();
        for (ExternalSystemManager externalSystemManager : ExternalSystemApiUtil.getAllManagers()) {
            if (!(externalSystemManager instanceof ExternalSystemAutoImportAware)) continue;
            ExternalSystemAutoImportAware externalSystemAutoImportAware = (ExternalSystemAutoImportAware)externalSystemManager;
            for (ExternalProjectSettings externalProjectSettings : ((AbstractExternalSystemSettings)externalSystemManager.getSettingsProvider().fun((Object)this.b)).getLinkedProjectsSettings()) {
                Object object2;
                List list2 = externalSystemAutoImportAware.getAffectedExternalProjectFiles(externalProjectSettings.getExternalProjectPath(), this.b);
                long l2 = 0L;
                for (Object object2 : list2) {
                    l2 += ((File)object2).lastModified();
                }
                Map map2 = ((AbstractExternalSystemLocalSettings)externalSystemManager.getLocalSettingsProvider().fun((Object)this.b)).getExternalConfigModificationStamps();
                if (bl2 && this.b.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) != Boolean.TRUE && this.b.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) != Boolean.TRUE && l2 != (Long)(object2 = Long.valueOf((object2 = (Long)map2.get(externalProjectSettings.getExternalProjectPath())) == null ? -1L : (Long)object2))) {
                    this.b(externalProjectSettings.getExternalProjectPath());
                }
                map2.put(externalProjectSettings.getExternalProjectPath(), l2);
                object2 = list2.iterator();
                while (object2.hasNext()) {
                    String string;
                    File file = (File)object2.next();
                    if (file == null || (string = ExternalSystemProjectsWatcherImpl.a(file)) == null) continue;
                    smartList.add(string);
                    String string2 = VfsUtilCore.pathToUrl((String)string);
                    VirtualFilePointer virtualFilePointer = (VirtualFilePointer)hashMap.get(string2);
                    if (virtualFilePointer == null) {
                        virtualFilePointer = VirtualFilePointerManager.getInstance().create(string2, (Disposable)this.e, null);
                        hashMap.put(string2, virtualFilePointer);
                        VirtualFile virtualFile = virtualFilePointer.getFile();
                        if (virtualFile != null) {
                            Long l3 = (Long)virtualFile.getUserData(g);
                            if (l3 != null) {
                                map2.put(string, l3);
                            } else {
                                UIUtil.invokeLaterIfNeeded(() -> {
                                    Long l2 = this.b(virtualFile);
                                    virtualFile.putUserData(l, (Object)l2);
                                    virtualFile.putUserData(g, (Object)l2);
                                    map2.put(string, l2);
                                });
                            }
                        }
                    }
                    this.j.putValue((Object)virtualFilePointer, (Object)externalProjectSettings.getExternalProjectPath());
                }
            }
        }
        this.c.addAll(LocalFileSystem.getInstance().addRootsToWatch((Collection)smartList, false));
    }

    @Nullable
    private String a(VirtualFile virtualFile) {
        String string = virtualFile.getPath();
        return this.c(string);
    }

    @Nullable
    private String c(String string) {
        ExternalSystemAutoImportAware externalSystemAutoImportAware;
        String string2 = null;
        Iterator<ExternalSystemAutoImportAware> iterator = this.m.iterator();
        while (iterator.hasNext() && (string2 = (externalSystemAutoImportAware = iterator.next()).getAffectedExternalProjectPath(string, this.b)) == null) {
        }
        if (string2 != null) {
            this.a.putValue(string2, (Object)string);
        }
        return string2;
    }

    private void a(boolean bl2, @NotNull ProjectSystemId projectSystemId, @NotNull String string) {
        if (projectSystemId == null) {
            ExternalSystemProjectsWatcherImpl.a(4);
        }
        if (string == null) {
            ExternalSystemProjectsWatcherImpl.a(5);
        }
        MyNotification myNotification = this.i.get(projectSystemId);
        if (bl2) {
            if (myNotification == null) {
                return;
            }
            myNotification.b.remove(string);
            if (myNotification.b.isEmpty()) {
                myNotification.expire();
            }
        } else {
            if (myNotification != null && !myNotification.isExpired()) {
                myNotification.b.add(string);
                return;
            }
            myNotification = new MyNotification(this.b, this.i, projectSystemId, string);
            this.i.put(projectSystemId, myNotification);
            Notifications.Bus.notify((Notification)myNotification, (Project)this.b);
        }
    }

    private static void a(final @NotNull Project project2, String string, ProjectSystemId projectSystemId, boolean bl2) {
        if (project2 == null) {
            ExternalSystemProjectsWatcherImpl.a(6);
        }
        ExternalSystemUtil.refreshProject(project2, projectSystemId, string, new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject != null) {
                    ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProject, project2, true);
                }
            }
        }, false, ProgressExecutionMode.IN_BACKGROUND_ASYNC, bl2);
    }

    private static void a(final MergingUpdateQueue mergingUpdateQueue, Project project2) {
        ApplicationManager.getApplication().runReadAction(() -> {
            EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
            editorEventMulticaster.addCaretListener(new CaretListener(){
                private static final long a = lb.a(-5084779575255607058L, 7468167993008039686L, MethodHandles.lookup().lookupClass()).a(247821459902612L);

                public void caretPositionChanged(@NotNull CaretEvent e10) {
                    if (e10 == null) {
                        8.a(0);
                    }
                    mergingUpdateQueue.restartTimer();
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x7F411DF82347L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$8", "caretPositionChanged"));
                }
            }, (Disposable)mergingUpdateQueue);
            editorEventMulticaster.addDocumentListener(new DocumentListener(){
                private static final long a = lb.a(-725785960371383975L, 2572324931609202048L, MethodHandles.lookup().lookupClass()).a(180725582022903L);

                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        9.a(0);
                    }
                    mergingUpdateQueue.restartTimer();
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x157C4A71FAE7L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$9", "documentChanged"));
                }
            }, (Disposable)mergingUpdateQueue);
            project2.getMessageBus().connect((Disposable)mergingUpdateQueue).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
                int beforeCalled;
                private static final long a = lb.a(259218039133720278L, 4629849072162060611L, MethodHandles.lookup().lookupClass()).a(112015653161579L);

                public void beforeRootsChange(@NotNull ModuleRootEvent event) {
                    if (event == null) {
                        10.a(0);
                    }
                    if (this.beforeCalled++ == 0) {
                        mergingUpdateQueue.suspend();
                    }
                }

                public void rootsChanged(@NotNull ModuleRootEvent event) {
                    if (event == null) {
                        10.a(1);
                    }
                    if (this.beforeCalled == 0) {
                        return;
                    }
                    if (--this.beforeCalled == 0) {
                        mergingUpdateQueue.resume();
                        mergingUpdateQueue.restartTimer();
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    long l2 = a ^ 0x40092F6823A4L;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$10";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforeRootsChange";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "rootsChanged";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        });
    }

    @Nullable
    private Pair<ExternalSystemManager, ExternalProjectSettings> a(String string) {
        ExternalProjectSettings[] externalProjectSettingsArray = new ExternalProjectSettings[1];
        Optional<ExternalSystemManager> optional = ExternalSystemApiUtil.getAllManagers().stream().filter(externalSystemManager -> {
            externalProjectSettingsArray[0] = ((AbstractExternalSystemSettings)externalSystemManager.getSettingsProvider().fun((Object)this.b)).getLinkedProjectSettings(string);
            return externalProjectSettingsArray[0] != null;
        }).findAny();
        if (!optional.isPresent()) {
            return null;
        }
        ExternalSystemManager externalSystemManager2 = optional.get();
        return Pair.create((Object)externalSystemManager2, (Object)externalProjectSettingsArray[0]);
    }

    @NotNull
    private List<Pair<ExternalSystemManager, ExternalProjectSettings>> b() {
        List<Pair<ExternalSystemManager, ExternalProjectSettings>> list2 = ExternalSystemApiUtil.getAllManagers().stream().flatMap(externalSystemManager -> ((AbstractExternalSystemSettings)externalSystemManager.getSettingsProvider().fun((Object)this.b)).getLinkedProjectsSettings().stream().map(externalProjectSettings -> Pair.create((Object)externalSystemManager, (Object)externalProjectSettings))).collect(Collectors.toList());
        if (list2 == null) {
            ExternalSystemProjectsWatcherImpl.a(7);
        }
        return list2;
    }

    @Nullable
    private static String a(@NotNull File file) {
        String string;
        if (file == null) {
            ExternalSystemProjectsWatcherImpl.a(8);
        }
        return (string = PathUtil.getCanonicalPath((String)file.getAbsolutePath())) == null ? null : FileUtil.toSystemIndependentName((String)string);
    }

    @NotNull
    private Long b(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ExternalSystemProjectsWatcherImpl.a(9);
        }
        Long l2 = new ConfigurationFileCrcFactory(this.b, virtualFile).create();
        if (l2 == null) {
            ExternalSystemProjectsWatcherImpl.a(10);
        }
        return l2;
    }

    static {
        p = lb.a(8019048622786030362L, 4374968750299626451L, MethodHandles.lookup().lookupClass()).a(1043407533110L);
        long l2 = p ^ 0x19147527731EL;
        o = Logger.getInstance(ExternalSystemProjectsWatcherImpl.class);
        k = ExtensionPointName.create((String)"com.intellij.externalProjectWatcherContributor");
        l = Key.create((String)"ExternalSystemProjectsWatcher.CRC_WITHOUT_SPACES_CURRENT");
        g = Key.create((String)"ExternalSystemProjectsWatcher.CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = p ^ 0x2869B6F36B81L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProject";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findLinkedProjectsSettings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateCrc";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onStart";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onSuccess";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUpdate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateNotifications";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRefresh";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calculateCrc";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Experimental
    public static interface Contributor {
        public void markDirtyAllExternalProjects(@NotNull Project var1);

        public void markDirty(@NotNull Module var1);
    }

    private class MyFileChangeListener
    extends FileChangeListenerBase {
        private final ExternalSystemProjectsWatcherImpl b;
        private final MultiMap<String, String> a = MultiMap.createSet();
        private List<VirtualFile> d;
        private List<VirtualFile> c;
        private static final long e = lb.a(8632817568265833413L, -3381234029249490346L, MethodHandles.lookup().lookupClass()).a(219391164981455L);

        MyFileChangeListener(ExternalSystemProjectsWatcherImpl watcher) {
            this.b = watcher;
        }

        @Override
        protected boolean isRelevant(String path) {
            long l2 = e ^ 0x18AA431B024L;
            if (!this.a.get((Object)path).isEmpty()) {
                return true;
            }
            for (VirtualFilePointer virtualFilePointer : ExternalSystemProjectsWatcherImpl.this.j.keySet()) {
                String string = VfsUtilCore.urlToPath((String)virtualFilePointer.getUrl());
                if (StringUtil.isNotEmpty((String)string) && FileUtil.namesEqual((String)path, (String)string)) {
                    for (String string2 : ExternalSystemProjectsWatcherImpl.this.j.get((Object)virtualFilePointer)) {
                        this.a.putValue((Object)path, (Object)string2);
                        ExternalSystemProjectsWatcherImpl.this.a.putValue((Object)string2, (Object)path);
                    }
                    return true;
                }
                if (!o.isDebugEnabled() || !StringUtil.isNotEmpty((String)string) || !FileUtil.namesEqual((String)FileUtil.toCanonicalPath((String)path), (String)FileUtil.toCanonicalPath((String)string))) continue;
                o.debug("Changes were ignored: " + path + ". Related FW: " + string);
            }
            String string = ExternalSystemProjectsWatcherImpl.this.c(path);
            if (string != null) {
                this.a.putValue((Object)path, (Object)string);
            }
            return string != null;
        }

        @Override
        protected void updateFile(VirtualFile file, VFileEvent event) {
            this.a(file, event, false);
        }

        @Override
        protected void deleteFile(VirtualFile file, VFileEvent event) {
            this.a(file, event, true);
        }

        private void a(VirtualFile virtualFile, VFileEvent vFileEvent, boolean bl2) {
            this.a();
            if (bl2) {
                this.c.add(virtualFile);
            } else if (this.a(virtualFile, vFileEvent)) {
                this.d.add(virtualFile);
            } else {
                for (String string : this.a.get((Object)virtualFile.getPath())) {
                    this.a(string);
                }
            }
        }

        private void a(String string) {
            for (Object object : ContainerUtil.newArrayList((Iterable)ExternalSystemProjectsWatcherImpl.this.a.get((Object)string))) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File((String)object), (boolean)false);
                if (virtualFile != null && Objects.equals(virtualFile.getUserData(g), virtualFile.getUserData(l))) continue;
                return;
            }
            ProjectSystemId projectSystemId = null;
            for (VirtualFile virtualFile : ExternalSystemApiUtil.getAllManagers()) {
                if (((AbstractExternalSystemSettings)virtualFile.getSettingsProvider().fun((Object)ExternalSystemProjectsWatcherImpl.this.b)).getLinkedProjectSettings(string) == null) continue;
                projectSystemId = virtualFile.getSystemId();
            }
            if (projectSystemId != null) {
                Object object;
                object = projectSystemId;
                ExternalSystemProjectsWatcherImpl.this.n.queue(new Update(Pair.create(object, (Object)string), (ProjectSystemId)object, string){
                    final /* synthetic */ ProjectSystemId val$finalSystemId;
                    final /* synthetic */ String val$externalProjectPath;
                    {
                        this.val$finalSystemId = projectSystemId;
                        this.val$externalProjectPath = string;
                        super(arg0);
                    }

                    public void run() {
                        ExternalSystemProjectsWatcherImpl.this.a(true, this.val$finalSystemId, this.val$externalProjectPath);
                    }
                });
            }
        }

        private boolean a(VirtualFile virtualFile, VFileEvent vFileEvent) {
            if (!virtualFile.isValid()) {
                return true;
            }
            if (!(vFileEvent instanceof VFileContentChangeEvent)) {
                return false;
            }
            Long l2 = ExternalSystemProjectsWatcherImpl.this.b(virtualFile);
            virtualFile.putUserData(l, (Object)l2);
            Long l3 = (Long)virtualFile.getUserData(g);
            if (l3 == null) {
                virtualFile.putUserData(g, (Object)l2);
                return true;
            }
            return !l2.equals(l3);
        }

        @Override
        protected void apply() {
            if (this.b()) {
                this.d.removeAll(this.c);
                this.a(ContainerUtil.concat(this.d, this.c));
            }
            this.c();
        }

        private boolean b() {
            return this.d != null;
        }

        private void a(List<VirtualFile> list2) {
            list2.stream().flatMap(virtualFile -> this.a.get((Object)virtualFile.getPath()).stream()).distinct().forEach(string -> this.b.a(string, false));
        }

        private void a() {
            if (this.b()) {
                return;
            }
            this.d = new ArrayList<VirtualFile>();
            this.c = new ArrayList<VirtualFile>();
        }

        private void c() {
            this.d = null;
            this.c = null;
            this.a.clear();
        }
    }

    private static class MyNotification
    extends Notification {
        private final ProjectSystemId a;
        private final Map<ProjectSystemId, MyNotification> c;
        private final Set<String> b;
        private static final long d = lb.a(4008298279920938501L, 4754274239112001726L, MethodHandles.lookup().lookupClass()).a(53561959038422L);

        MyNotification(final Project project2, Map<ProjectSystemId, MyNotification> notificationMap, final ProjectSystemId systemId, String projectPath) {
            long l2 = d ^ 0x5143F033FD11L;
            super(systemId.getReadableName() + " Import", ExternalSystemBundle.message((String)"import.needed", (Object[])new Object[]{systemId.getReadableName()}), "", NotificationType.INFORMATION, null);
            this.a = systemId;
            this.c = notificationMap;
            this.b = ContainerUtil.newHashSet((Object[])new String[]{projectPath});
            this.addAction((AnAction)new NotificationAction(ExternalSystemBundle.message((String)"import.importChanged", (Object[])new Object[0])){
                private static final long a = lb.a(-7011959475573153066L, 7792242984278109508L, MethodHandles.lookup().lookupClass()).a(126428169456537L);

                public void actionPerformed(@NotNull AnActionEvent e10, @NotNull Notification notification) {
                    if (e10 == null) {
                        1.a(0);
                    }
                    if (notification == null) {
                        1.a(1);
                    }
                    this.a(notification, project2, systemId, false);
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    long l2 = a ^ 0x40E08FB0E07FL;
                    Object[] objectArray2 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$MyNotification$1";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.addAction((AnAction)new NotificationAction(ExternalSystemBundle.message((String)"import.enableAutoImport", (Object[])new Object[0])){
                private static final long a = lb.a(6387520445784765311L, 8340177005906602832L, MethodHandles.lookup().lookupClass()).a(72671746496413L);

                public void actionPerformed(@NotNull AnActionEvent e10, @NotNull Notification notification) {
                    if (e10 == null) {
                        2.a(0);
                    }
                    if (notification == null) {
                        2.a(1);
                    }
                    this.a(notification, project2, systemId, true);
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    long l2 = a ^ 0x7AB1E4E4B95AL;
                    Object[] objectArray2 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$MyNotification$2";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        public void expire() {
            super.expire();
            this.b.clear();
            this.c.remove(this.a);
        }

        private void a(@NotNull Notification notification, Project project2, ProjectSystemId projectSystemId, boolean bl2) {
            if (notification == null) {
                MyNotification.a(0);
            }
            this.b.stream().map(string -> ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)projectSystemId).getLinkedProjectSettings(string)).distinct().filter(Objects::nonNull).forEach(externalProjectSettings -> {
                if (bl2) {
                    externalProjectSettings.setUseAutoImport(true);
                }
                ExternalSystemProjectsWatcherImpl.a(project2, externalProjectSettings.getExternalProjectPath(), projectSystemId, !bl2);
            });
            notification.expire();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = d ^ 0x52F64FA21E75L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$MyNotification", "doAction"));
        }
    }
}

