/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import b.a.lb;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.TaskActivationState;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskActivator {
    private static final Logger b;
    public static final String RUN_CONFIGURATION_TASK_PREFIX = "run: ";
    @NotNull
    private final Project a;
    private final List<Listener> c;
    private static final long d;

    public ExternalSystemTaskActivator(@NotNull Project project2) {
        if (project2 == null) {
            ExternalSystemTaskActivator.a(0);
        }
        this.c = ContainerUtil.createLockFreeCopyOnWriteList();
        this.a = project2;
    }

    @NotNull
    public static String getRunConfigurationActivationTaskName(@NotNull RunnerAndConfigurationSettings settings) {
        long l2 = d ^ 0x246DAD52A3C5L;
        if (settings == null) {
            ExternalSystemTaskActivator.a(1);
        }
        String string = RUN_CONFIGURATION_TASK_PREFIX + settings.getName();
        if (string == null) {
            ExternalSystemTaskActivator.a(2);
        }
        return string;
    }

    public void init() {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.a);
        if (compilerManager == null) {
            return;
        }
        class MyCompileTask
        implements CompileTask {
            private final boolean a;

            MyCompileTask(boolean before) {
                this.a = before;
            }

            public boolean execute(CompileContext context) {
                return ExternalSystemTaskActivator.this.a(this.a, context);
            }
        }
        compilerManager.addBeforeTask((CompileTask)new MyCompileTask(true));
        compilerManager.addAfterTask((CompileTask)new MyCompileTask(false));
        this.fireTasksChanged();
    }

    public String getDescription(ProjectSystemId systemId, String projectPath, String taskName) {
        long l2 = d ^ 0x4D4A7086DDD3L;
        ArrayList<String> arrayList = new ArrayList<String>();
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider externalProjectsStateProvider = ExternalProjectsManagerImpl.getInstance(this.a).getStateProvider();
        TaskActivationState taskActivationState = externalProjectsStateProvider.getTasksActivation(systemId, projectPath);
        if (taskActivationState == null) {
            return null;
        }
        for (Phase phase : Phase.values()) {
            if (!taskActivationState.getTasks(phase).contains(taskName)) continue;
            arrayList.add(phase.toString());
        }
        return StringUtil.join(arrayList, (String)", ");
    }

    private boolean a(boolean bl2, @NotNull CompileContext compileContext) {
        if (compileContext == null) {
            ExternalSystemTaskActivator.a(3);
        }
        List list2 = (List)ReadAction.compute(() -> {
            if (compileContext == null) {
                ExternalSystemTaskActivator.a(28);
            }
            return ContainerUtil.mapNotNull((Object[])compileContext.getCompileScope().getAffectedModules(), module2 -> ExternalSystemApiUtil.getExternalProjectPath((Module)module2));
        });
        ArrayList arrayList = ContainerUtil.newArrayList();
        if (bl2) {
            if (compileContext.isRebuild()) {
                arrayList.add(Phase.BEFORE_REBUILD);
            }
            arrayList.add(Phase.BEFORE_COMPILE);
        } else {
            arrayList.add(Phase.AFTER_COMPILE);
            if (compileContext.isRebuild()) {
                arrayList.add(Phase.AFTER_REBUILD);
            }
        }
        return this.runTasks(list2, (Phase[])ArrayUtil.toObjectArray((Collection)arrayList, Phase.class));
    }

    public boolean runTasks(@NotNull String modulePath, Phase ... phases) {
        if (modulePath == null) {
            ExternalSystemTaskActivator.a(4);
        }
        if (phases == null) {
            ExternalSystemTaskActivator.a(5);
        }
        return this.runTasks(Collections.singleton(modulePath), phases);
    }

    public boolean runTasks(@NotNull Collection<String> modules, Phase ... phases) {
        long l2 = d ^ 0x25199D5CB94L;
        if (modules == null) {
            ExternalSystemTaskActivator.a(6);
        }
        if (phases == null) {
            ExternalSystemTaskActivator.a(7);
        }
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider externalProjectsStateProvider = ExternalProjectsManagerImpl.getInstance(this.a).getStateProvider();
        LinkedList<Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>> linkedList = new LinkedList<Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>>();
        Map map2 = FactoryMap.create(projectSystemId -> {
            AbstractExternalSystemTaskConfigurationType abstractExternalSystemTaskConfigurationType = ExternalSystemUtil.findConfigurationType(projectSystemId);
            if (abstractExternalSystemTaskConfigurationType == null) {
                return null;
            }
            return ContainerUtil.map2Map((Collection)RunManager.getInstance((Project)this.a).getConfigurationSettingsList((ConfigurationType)abstractExternalSystemTaskConfigurationType), runnerAndConfigurationSettings -> Pair.create((Object)runnerAndConfigurationSettings.getName(), (Object)runnerAndConfigurationSettings));
        });
        for (ExternalProjectsManagerImpl.ExternalProjectsStateProvider.TasksActivation tasksActivation : externalProjectsStateProvider.getAllTasksActivation()) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings;
            boolean bl2 = modules.contains(tasksActivation.projectPath);
            LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet();
            for (Phase phase : phases) {
                runnerAndConfigurationSettings = tasksActivation.state.getTasks(phase);
                if (!bl2 && (!phase.isSyncPhase() || runnerAndConfigurationSettings.isEmpty() || !this.a(modules, tasksActivation))) continue;
                ContainerUtil.addAll((Collection)linkedHashSet, runnerAndConfigurationSettings);
            }
            if (linkedHashSet.isEmpty()) continue;
            Object object = linkedHashSet.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (string.length() <= RUN_CONFIGURATION_TASK_PREFIX.length() || !string.startsWith(RUN_CONFIGURATION_TASK_PREFIX)) continue;
                object.remove();
                String string2 = string.substring(RUN_CONFIGURATION_TASK_PREFIX.length());
                Map map3 = (Map)map2.get(tasksActivation.systemId);
                if (map3 == null || (runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)map3.get(string2)) == null) continue;
                RunConfiguration runConfiguration = runnerAndConfigurationSettings.getConfiguration();
                if (!string2.equals(runnerAndConfigurationSettings.getName()) || !(runConfiguration instanceof ExternalSystemRunConfiguration)) continue;
                linkedList.add((Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>)Pair.create((Object)tasksActivation.systemId, (Object)((ExternalSystemRunConfiguration)runConfiguration).getSettings()));
            }
            if (linkedHashSet.isEmpty() || ExternalProjectsManager.getInstance((Project)this.a).isIgnored(tasksActivation.systemId, tasksActivation.projectPath)) continue;
            object = new ExternalSystemTaskExecutionSettings();
            object.setExternalSystemIdString(tasksActivation.systemId.toString());
            object.setExternalProjectPath(tasksActivation.projectPath);
            object.getTaskNames().addAll(linkedHashSet);
            linkedList.add((Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>)Pair.create((Object)tasksActivation.systemId, (Object)object));
        }
        return this.a(linkedList);
    }

    private boolean a(@NotNull Collection<String> collection, @NotNull ExternalProjectsManagerImpl.ExternalProjectsStateProvider.TasksActivation tasksActivation) {
        if (collection == null) {
            ExternalSystemTaskActivator.a(8);
        }
        if (tasksActivation == null) {
            ExternalSystemTaskActivator.a(9);
        }
        AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)this.a, (ProjectSystemId)tasksActivation.systemId);
        String string2 = ExternalSystemTaskActivator.a(abstractExternalSystemSettings, tasksActivation.projectPath);
        List list2 = ContainerUtil.mapNotNull(collection, string -> ExternalSystemTaskActivator.a(abstractExternalSystemSettings, string));
        return list2.contains(string2);
    }

    @Nullable
    private static String a(@NotNull AbstractExternalSystemSettings abstractExternalSystemSettings, @NotNull String string) {
        ExternalProjectSettings externalProjectSettings;
        if (abstractExternalSystemSettings == null) {
            ExternalSystemTaskActivator.a(10);
        }
        if (string == null) {
            ExternalSystemTaskActivator.a(11);
        }
        return (externalProjectSettings = abstractExternalSystemSettings.getLinkedProjectSettings(string)) != null ? externalProjectSettings.getExternalProjectPath() : null;
    }

    private boolean a(final Queue<Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>> queue) {
        Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings> pair2 = queue.poll();
        if (pair2 == null) {
            return true;
        }
        ProjectSystemId projectSystemId = (ProjectSystemId)pair2.first;
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = (ExternalSystemTaskExecutionSettings)pair2.getSecond();
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref ref = new Ref((Object)false);
        ExternalSystemUtil.runTask(externalSystemTaskExecutionSettings, DefaultRunExecutor.EXECUTOR_ID, this.a, projectSystemId, new TaskCallback(){

            public void onSuccess() {
                ref.set((Object)ExternalSystemTaskActivator.this.a(queue));
                semaphore.up();
            }

            public void onFailure() {
                semaphore.up();
            }
        }, ProgressExecutionMode.IN_BACKGROUND_ASYNC, false);
        semaphore.waitFor();
        return (Boolean)ref.get();
    }

    public void addListener(@NotNull Listener l2) {
        if (l2 == null) {
            ExternalSystemTaskActivator.a(12);
        }
        this.c.add(l2);
    }

    public boolean isTaskOfPhase(@NotNull TaskData taskData, @NotNull Phase phase) {
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider externalProjectsStateProvider;
        TaskActivationState taskActivationState;
        if (taskData == null) {
            ExternalSystemTaskActivator.a(13);
        }
        if (phase == null) {
            ExternalSystemTaskActivator.a(14);
        }
        if ((taskActivationState = (externalProjectsStateProvider = ExternalProjectsManagerImpl.getInstance(this.a).getStateProvider()).getTasksActivation(taskData.getOwner(), taskData.getLinkedExternalProjectPath())) == null) {
            return false;
        }
        return taskActivationState.getTasks(phase).contains(taskData.getName());
    }

    public void addTasks(@NotNull Collection<TaskData> tasks, @NotNull Phase phase) {
        if (tasks == null) {
            ExternalSystemTaskActivator.a(15);
        }
        if (phase == null) {
            ExternalSystemTaskActivator.a(16);
        }
        if (tasks.isEmpty()) {
            return;
        }
        this.addTasks(ContainerUtil.map(tasks, taskData -> {
            if (phase == null) {
                ExternalSystemTaskActivator.a(27);
            }
            return new TaskActivationEntry(taskData.getOwner(), phase, taskData.getLinkedExternalProjectPath(), taskData.getName());
        }));
        this.fireTasksChanged();
    }

    public void addTasks(@NotNull Collection<TaskActivationEntry> entries) {
        if (entries == null) {
            ExternalSystemTaskActivator.a(17);
        }
        if (entries.isEmpty()) {
            return;
        }
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider externalProjectsStateProvider = ExternalProjectsManagerImpl.getInstance(this.a).getStateProvider();
        for (TaskActivationEntry taskActivationEntry : entries) {
            TaskActivationState taskActivationState = externalProjectsStateProvider.getTasksActivation(taskActivationEntry.b, taskActivationEntry.d);
            taskActivationState.getTasks(taskActivationEntry.a).add(taskActivationEntry.c);
        }
        this.fireTasksChanged();
    }

    public void removeTasks(@NotNull Collection<TaskData> tasks, @NotNull Phase phase) {
        if (tasks == null) {
            ExternalSystemTaskActivator.a(18);
        }
        if (phase == null) {
            ExternalSystemTaskActivator.a(19);
        }
        if (tasks.isEmpty()) {
            return;
        }
        this.removeTasks(ContainerUtil.map(tasks, taskData -> {
            if (phase == null) {
                ExternalSystemTaskActivator.a(26);
            }
            return new TaskActivationEntry(taskData.getOwner(), phase, taskData.getLinkedExternalProjectPath(), taskData.getName());
        }));
    }

    public void removeTasks(@NotNull Collection<TaskActivationEntry> entries) {
        if (entries == null) {
            ExternalSystemTaskActivator.a(20);
        }
        if (entries.isEmpty()) {
            return;
        }
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider externalProjectsStateProvider = ExternalProjectsManagerImpl.getInstance(this.a).getStateProvider();
        for (TaskActivationEntry taskActivationEntry : entries) {
            TaskActivationState taskActivationState = externalProjectsStateProvider.getTasksActivation(taskActivationEntry.b, taskActivationEntry.d);
            taskActivationState.getTasks(taskActivationEntry.a).remove(taskActivationEntry.c);
        }
        this.fireTasksChanged();
    }

    public void addTask(@NotNull TaskActivationEntry entry) {
        if (entry == null) {
            ExternalSystemTaskActivator.a(21);
        }
        this.addTasks(Collections.singleton(entry));
    }

    public void removeTask(@NotNull TaskActivationEntry entry) {
        if (entry == null) {
            ExternalSystemTaskActivator.a(22);
        }
        this.removeTasks(Collections.singleton(entry));
    }

    public void moveTasks(@NotNull Collection<TaskActivationEntry> entries, int increment) {
        if (entries == null) {
            ExternalSystemTaskActivator.a(23);
        }
        b.assertTrue(increment == -1 || increment == 1);
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider externalProjectsStateProvider = ExternalProjectsManagerImpl.getInstance(this.a).getStateProvider();
        for (TaskActivationEntry taskActivationEntry : entries) {
            TaskActivationState taskActivationState = externalProjectsStateProvider.getTasksActivation(taskActivationEntry.b, taskActivationEntry.d);
            List<String> list2 = taskActivationState.getTasks(taskActivationEntry.a);
            int n2 = list2.indexOf(taskActivationEntry.c);
            int n3 = n2 + increment;
            if (n2 == -1 || list2.size() <= n3 || n3 < 0) continue;
            Collections.swap(list2, n2, n3);
        }
    }

    public void moveProjects(@NotNull ProjectSystemId systemId, @NotNull List<String> projectsPathsToMove, @Nullable Collection<String> pathsGroup, int increment) {
        if (systemId == null) {
            ExternalSystemTaskActivator.a(24);
        }
        if (projectsPathsToMove == null) {
            ExternalSystemTaskActivator.a(25);
        }
        b.assertTrue(increment == -1 || increment == 1);
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider externalProjectsStateProvider = ExternalProjectsManagerImpl.getInstance(this.a).getStateProvider();
        Map<String, TaskActivationState> map2 = externalProjectsStateProvider.getProjectsTasksActivationMap(systemId);
        ArrayList arrayList = ContainerUtil.newArrayList(map2.keySet());
        if (pathsGroup != null) {
            arrayList.retainAll(pathsGroup);
        }
        for (String object : projectsPathsToMove) {
            int string = arrayList.indexOf(object);
            int n2 = string + increment;
            if (string == -1 || arrayList.size() <= n2 || n2 < 0) continue;
            Collections.swap(arrayList, string, n2);
        }
        LinkedHashMap linkedHashMap = ContainerUtil.newLinkedHashMap();
        for (String string : arrayList) {
            linkedHashMap.put(string, map2.get(string));
            map2.remove(string);
        }
        map2.putAll(linkedHashMap);
    }

    public void fireTasksChanged() {
        for (Listener listener : this.c) {
            listener.tasksActivationChanged();
        }
    }

    static {
        d = lb.a(-641284141418476972L, 7873943887788781790L, MethodHandles.lookup().lookupClass()).a(179547353594781L);
        b = Logger.getInstance(ExternalSystemTaskActivator.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x7465689CE77L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator";
                break;
            }
            case 3: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phases";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activation";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemSettings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskData";
                break;
            }
            case 14: 
            case 16: 
            case 19: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsPathsToMove";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunConfigurationActivationTaskName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRunConfigurationActivationTaskName";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doExecuteCompileTasks";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runTasks";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isShareSameRootPath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRootProjectPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isTaskOfPhase";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addTasks";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeTasks";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addTask";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeTask";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "moveTasks";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "moveProjects";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeTasks$6";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addTasks$5";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doExecuteCompileTasks$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TaskActivationEntry {
        @NotNull
        private final ProjectSystemId b;
        @NotNull
        private final Phase a;
        @NotNull
        private final String d;
        @NotNull
        private final String c;
        private static final long e = lb.a(3675917326663359304L, -245757776056414563L, MethodHandles.lookup().lookupClass()).a(62789852177793L);

        public TaskActivationEntry(@NotNull ProjectSystemId systemId, @NotNull Phase phase, @NotNull String projectPath, @NotNull String taskName) {
            if (systemId == null) {
                TaskActivationEntry.a(0);
            }
            if (phase == null) {
                TaskActivationEntry.a(1);
            }
            if (projectPath == null) {
                TaskActivationEntry.a(2);
            }
            if (taskName == null) {
                TaskActivationEntry.a(3);
            }
            this.b = systemId;
            this.a = phase;
            this.d = projectPath;
            this.c = taskName;
        }

        @NotNull
        public ProjectSystemId getSystemId() {
            ProjectSystemId projectSystemId = this.b;
            if (projectSystemId == null) {
                TaskActivationEntry.a(4);
            }
            return projectSystemId;
        }

        @NotNull
        public Phase getPhase() {
            Phase phase = this.a;
            if (phase == null) {
                TaskActivationEntry.a(5);
            }
            return phase;
        }

        @NotNull
        public String getProjectPath() {
            String string = this.d;
            if (string == null) {
                TaskActivationEntry.a(6);
            }
            return string;
        }

        @NotNull
        public String getTaskName() {
            String string = this.c;
            if (string == null) {
                TaskActivationEntry.a(7);
            }
            return string;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = e ^ 0x1C012782D5DFL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "systemId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phase";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskName";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator$TaskActivationEntry";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator$TaskActivationEntry";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSystemId";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPhase";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProjectPath";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTaskName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Listener {
        public void tasksActivationChanged();
    }

    public static final class Phase
    extends Enum<Phase> {
        public static final /* enum */ Phase BEFORE_RUN;
        public static final /* enum */ Phase BEFORE_SYNC;
        public static final /* enum */ Phase AFTER_SYNC;
        public static final /* enum */ Phase BEFORE_COMPILE;
        public static final /* enum */ Phase AFTER_COMPILE;
        public static final /* enum */ Phase BEFORE_REBUILD;
        public static final /* enum */ Phase AFTER_REBUILD;
        public final String myMessageKey;
        private static final /* synthetic */ Phase[] a;

        public static Phase[] values() {
            return (Phase[])a.clone();
        }

        public static Phase valueOf(String name2) {
            return Enum.valueOf(Phase.class, name2);
        }

        private Phase(String messageKey) {
            this.myMessageKey = messageKey;
        }

        public boolean isSyncPhase() {
            return this == BEFORE_SYNC || this == AFTER_SYNC;
        }

        public String toString() {
            return ExternalSystemBundle.message((String)this.myMessageKey, (Object[])new Object[0]);
        }

        static {
            long l2 = lb.a(-566145283324962265L, 4511181832059458395L, MethodHandles.lookup().lookupClass()).a(272501678222900L) ^ 0xFE685446593L;
            BEFORE_RUN = new Phase("external.system.task.before.run");
            BEFORE_SYNC = new Phase("external.system.task.before.sync");
            AFTER_SYNC = new Phase("external.system.task.after.sync");
            BEFORE_COMPILE = new Phase("external.system.task.before.compile");
            AFTER_COMPILE = new Phase("external.system.task.after.compile");
            BEFORE_REBUILD = new Phase("external.system.task.before.rebuild");
            AFTER_REBUILD = new Phase("external.system.task.after.rebuild");
            a = new Phase[]{BEFORE_RUN, BEFORE_SYNC, AFTER_SYNC, BEFORE_COMPILE, AFTER_COMPILE, BEFORE_REBUILD, AFTER_REBUILD};
        }
    }
}

