/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import b.a.lb;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.PerformanceTrace;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.DeduplicateVisitorsSupplier;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectDataManagerImpl
implements ProjectDataManager {
    private static final Logger a;
    private static final com.intellij.openapi.util.Key<Boolean> b;
    @NotNull
    private final NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>> c;
    private static final long f;

    public static ProjectDataManagerImpl getInstance() {
        ProjectDataManager projectDataManager = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
        return (ProjectDataManagerImpl)projectDataManager;
    }

    public ProjectDataManagerImpl() {
        this(() -> (ProjectDataService[])ProjectDataService.EP_NAME.getExtensions());
    }

    ProjectDataManagerImpl(ProjectDataService ... dataServices) {
        this(() -> dataServices);
    }

    private ProjectDataManagerImpl(final Supplier<ProjectDataService[]> supplier) {
        this.c = new NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>>(){
            private static final long a = lb.a(-3488251210060620476L, -9196881786353088115L, MethodHandles.lookup().lookupClass()).a(257651041624754L);

            @NotNull
            protected Map<Key<?>, List<ProjectDataService<?, ?>>> compute() {
                HashMap hashMap = ContainerUtilRt.newHashMap();
                for (ProjectDataService projectDataService : (ProjectDataService[])supplier.get()) {
                    List list2 = (List)hashMap.get(projectDataService.getTargetDataKey());
                    if (list2 == null) {
                        list2 = ContainerUtilRt.newArrayList();
                        hashMap.put(projectDataService.getTargetDataKey(), list2);
                    }
                    list2.add(projectDataService);
                }
                for (List list3 : hashMap.values()) {
                    ExternalSystemApiUtil.orderAwareSort((List)list3);
                }
                HashMap hashMap2 = hashMap;
                if (hashMap2 == null) {
                    1.a(0);
                }
                return hashMap2;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x3D8DB3478C96L;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl$1", "compute"));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(@NotNull Collection<DataNode<?>> nodes, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        PerformanceTrace performanceTrace;
        Object object;
        ProjectSystemId projectSystemId;
        ProjectData projectData;
        long l2 = f ^ 0x121957BCE740L;
        if (nodes == null) {
            ProjectDataManagerImpl.a(0);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.a(1);
        }
        if (modelsProvider == null) {
            ProjectDataManagerImpl.a(2);
        }
        if (project2.isDisposed()) {
            return;
        }
        MultiMap multiMap = ExternalSystemApiUtil.recursiveGroup(nodes);
        Collection collection = multiMap.get((Object)ProjectKeys.PROJECT);
        assert (collection.size() == 1 || collection.isEmpty());
        DataNode dataNode = (DataNode)ContainerUtil.getFirstItem((Collection)collection);
        if (dataNode != null) {
            projectData = (ProjectData)dataNode.getData();
            projectSystemId = ((ProjectData)dataNode.getData()).getOwner();
            ExternalProjectsDataStorage.getInstance(project2).saveInclusionSettings((DataNode<ProjectData>)dataNode);
        } else {
            projectData = null;
            object = (DataNode)ContainerUtil.getFirstItem((Collection)multiMap.get((Object)ProjectKeys.MODULE));
            ProjectSystemId projectSystemId2 = projectSystemId = object != null ? ((ModuleData)object.getData()).getOwner() : null;
        }
        if (projectSystemId != null) {
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(project2, projectSystemId);
        }
        object = ContainerUtil.newSmartList();
        List list2 = ContainerUtil.newSmartList();
        Collection collection2 = multiMap.get(PerformanceTrace.TRACE_NODE_KEY);
        if (collection2.size() > 0) {
            performanceTrace = (PerformanceTrace)((DataNode)collection2.iterator().next()).getData();
        } else {
            performanceTrace = new PerformanceTrace();
            multiMap.putValue(PerformanceTrace.TRACE_NODE_KEY, (Object)new DataNode(PerformanceTrace.TRACE_NODE_KEY, (Object)performanceTrace, null));
        }
        long l3 = System.currentTimeMillis();
        try {
            TreeSet treeSet = new TreeSet(multiMap.keySet());
            treeSet.addAll(((Map)this.c.getValue()).keySet());
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.setIndeterminate(false);
            }
            int n2 = treeSet.size();
            int n3 = 0;
            List list3 = ContainerUtil.newSmartList();
            for (Object object2 : treeSet) {
                if (progressIndicator != null) {
                    String string = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{projectSystemId != null ? projectSystemId.getReadableName() : "", "Refresh " + ProjectDataManagerImpl.a((Key)object2)});
                    progressIndicator.setText(string);
                    progressIndicator.setFraction((double)n3++ / (double)n2);
                }
                long l5 = System.currentTimeMillis();
                this.a((Key)object2, multiMap.get(object2), projectData, project2, modelsProvider, list3, (List<Runnable>)object, list2);
                performanceTrace.logPerformance("Data import by " + object2.toString(), System.currentTimeMillis() - l5);
            }
            for (Object object2 : list3) {
                object2.run();
            }
            ProjectDataManagerImpl.a(modelsProvider, project2, synchronous, "Imported data");
            if (progressIndicator != null) {
                progressIndicator.setIndeterminate(true);
            }
            ((ProjectDataImportListener)project2.getMessageBus().syncPublisher(ProjectDataImportListener.TOPIC)).onImportFinished(projectData != null ? projectData.getLinkedExternalProjectPath() : null);
            performanceTrace.logPerformance("Data import total", System.currentTimeMillis() - l3);
        }
        catch (Throwable throwable) {
            try {
                ProjectDataManagerImpl.a(project2, synchronous, list2);
                ProjectDataManagerImpl.a(modelsProvider, project2, synchronous);
            }
            finally {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)throwable);
            }
        }
        ProjectDataManagerImpl.a(project2, synchronous, (List<Runnable>)object);
    }

    private static void a(@NotNull Project project2, boolean bl2, final List<Runnable> list2) {
        if (project2 == null) {
            ProjectDataManagerImpl.a(3);
        }
        DisposeAwareProjectChange disposeAwareProjectChange = new DisposeAwareProjectChange((ComponentManager)project2){

            public void execute() {
                for (Runnable runnable : ContainerUtil.reverse((List)list2)) {
                    runnable.run();
                }
            }
        };
        if (bl2) {
            try {
                disposeAwareProjectChange.run();
            }
            catch (Exception exception) {
                a.warn((Throwable)exception);
            }
        } else {
            ApplicationManager.getApplication().invokeLater((Runnable)disposeAwareProjectChange);
        }
    }

    @NotNull
    private static String a(@NotNull Key key) {
        if (key == null) {
            ProjectDataManagerImpl.a(4);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = key.toString();
        for (int i10 = 0; i10 < string.length(); ++i10) {
            char c10 = string.charAt(i10);
            if (Character.isUpperCase(c10)) {
                if (i10 != 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(StringUtil.toLowerCase((char)c10));
                continue;
            }
            stringBuilder.append(c10);
        }
        String string2 = stringBuilder.toString();
        if (string2 == null) {
            ProjectDataManagerImpl.a(5);
        }
        return string2;
    }

    public <T> void importData(@NotNull Collection<DataNode<T>> nodes, @NotNull Project project2, boolean synchronous) {
        if (nodes == null) {
            ProjectDataManagerImpl.a(6);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.a(7);
        }
        List list2 = ContainerUtil.newSmartList();
        list2.addAll(nodes);
        this.importData(list2, project2, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project2), synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        if (node == null) {
            ProjectDataManagerImpl.a(8);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.a(9);
        }
        if (modelsProvider == null) {
            ProjectDataManagerImpl.a(10);
        }
        List list2 = ContainerUtil.newSmartList();
        list2.add(node);
        this.importData(list2, project2, modelsProvider, synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project2, boolean synchronous) {
        if (node == null) {
            ProjectDataManagerImpl.a(11);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.a(12);
        }
        this.importData(node, project2, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project2), synchronous);
    }

    private <T> void a(@NotNull Key<T> key, @NotNull Collection<DataNode<?>> collection, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @NotNull List<Runnable> list2, @NotNull List<Runnable> list3, @NotNull List<Runnable> list4) {
        long l2 = f ^ 0x2DBB298C2CDBL;
        if (key == null) {
            ProjectDataManagerImpl.a(13);
        }
        if (collection == null) {
            ProjectDataManagerImpl.a(14);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.a(15);
        }
        if (ideModifiableModelsProvider == null) {
            ProjectDataManagerImpl.a(16);
        }
        if (list2 == null) {
            ProjectDataManagerImpl.a(17);
        }
        if (list3 == null) {
            ProjectDataManagerImpl.a(18);
        }
        if (list4 == null) {
            ProjectDataManagerImpl.a(19);
        }
        if (project2.isDisposed()) {
            return;
        }
        if (project2 instanceof ComponentManagerImpl) assert (((ComponentManagerImpl)project2).isComponentsCreated());
        List list5 = ContainerUtil.newSmartList();
        List list6 = ContainerUtil.newSmartList();
        for (DataNode<?> object : collection) {
            if (!key.equals((Object)object.getKey())) continue;
            if (object.isIgnored()) {
                list6.add(object);
                continue;
            }
            list5.add(object);
        }
        this.a(list5);
        List list7 = (List)((Map)this.c.getValue()).get(key);
        if (list7 == null) {
            a.debug(String.format("No data service is registered for %s", key));
        } else {
            Iterator iterator = list7.iterator();
            while (iterator.hasNext()) {
                long l3;
                ProjectDataService projectDataService = (ProjectDataService)iterator.next();
                long l5 = System.currentTimeMillis();
                projectDataService.importData((Collection)list5, projectData, project2, ideModifiableModelsProvider);
                if (a.isDebugEnabled()) {
                    l3 = System.currentTimeMillis() - l5;
                    a.debug(String.format("Service %s imported data in %d ms", projectDataService.getClass().getSimpleName(), l3));
                }
                if (projectData == null) continue;
                this.a(list6);
                l3 = System.currentTimeMillis();
                Computable computable = projectDataService.computeOrphanData((Collection)list5, projectData, project2, ideModifiableModelsProvider);
                projectDataService.removeData(computable, (Collection)list6, projectData, project2, ideModifiableModelsProvider);
                if (!a.isDebugEnabled()) continue;
                long l6 = System.currentTimeMillis() - l3;
                a.debug(String.format("Service %s computed and removed data in %d ms", projectDataService.getClass().getSimpleName(), l6));
            }
        }
        if (list7 != null && projectData != null) {
            list2.add(() -> {
                long l2 = f ^ 0x1CE5CCDA0B78L;
                if (project2 == null) {
                    ProjectDataManagerImpl.a(49);
                }
                if (ideModifiableModelsProvider == null) {
                    ProjectDataManagerImpl.a(50);
                }
                for (ProjectDataService projectDataService : list7) {
                    if (!(projectDataService instanceof AbstractProjectDataService)) continue;
                    long l3 = System.currentTimeMillis();
                    ((AbstractProjectDataService)projectDataService).postProcess((Collection)list5, projectData, project2, ideModifiableModelsProvider);
                    if (!a.isDebugEnabled()) continue;
                    long l5 = System.currentTimeMillis() - l3;
                    a.debug(String.format("Service %s run post import task in %d ms", projectDataService.getClass().getSimpleName(), l5));
                }
            });
            list4.add(() -> {
                long l2 = f ^ 0x22696A89D5E6L;
                if (project2 == null) {
                    ProjectDataManagerImpl.a(48);
                }
                for (ProjectDataService projectDataService : list7) {
                    if (!(projectDataService instanceof AbstractProjectDataService)) continue;
                    long l3 = System.currentTimeMillis();
                    ((AbstractProjectDataService)projectDataService).onFailureImport(project2);
                    if (!a.isDebugEnabled()) continue;
                    long l5 = System.currentTimeMillis() - l3;
                    a.debug(String.format("Service %s run failure import task in %d ms", projectDataService.getClass().getSimpleName(), l5));
                }
            });
            list3.add(() -> {
                long l2 = f ^ 0x41483F4CE030L;
                if (project2 == null) {
                    ProjectDataManagerImpl.a(47);
                }
                IdeModelsProviderImpl ideModelsProviderImpl = new IdeModelsProviderImpl(project2);
                for (ProjectDataService projectDataService : list7) {
                    if (!(projectDataService instanceof AbstractProjectDataService)) continue;
                    long l3 = System.currentTimeMillis();
                    ((AbstractProjectDataService)projectDataService).onSuccessImport((Collection)list5, projectData, project2, (IdeModelsProvider)ideModelsProviderImpl);
                    if (!a.isDebugEnabled()) continue;
                    long l5 = System.currentTimeMillis() - l3;
                    a.debug(String.format("Service %s run success import task in %d ms", projectDataService.getClass().getSimpleName(), l5));
                }
            });
        }
    }

    public void ensureTheDataIsReadyToUse(@Nullable DataNode startNode) {
        if (startNode == null) {
            return;
        }
        if (Boolean.TRUE.equals(startNode.getUserData(b))) {
            return;
        }
        DeduplicateVisitorsSupplier deduplicateVisitorsSupplier = new DeduplicateVisitorsSupplier();
        ExternalSystemApiUtil.visit((DataNode)startNode, dataNode -> {
            if (this.a((DataNode)dataNode)) {
                dataNode.visitData(deduplicateVisitorsSupplier.getVisitor(dataNode.getKey()));
                dataNode.putUserData(b, (Object)Boolean.TRUE);
            }
        });
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> toRemove, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        long l2 = f ^ 0x2EF222ABE16FL;
        if (key == null) {
            ProjectDataManagerImpl.a(20);
        }
        if (toRemove == null) {
            ProjectDataManagerImpl.a(21);
        }
        if (toIgnore == null) {
            ProjectDataManagerImpl.a(22);
        }
        if (projectData == null) {
            ProjectDataManagerImpl.a(23);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.a(24);
        }
        if (modelsProvider == null) {
            ProjectDataManagerImpl.a(25);
        }
        try {
            List list2 = (List)((Map)this.c.getValue()).get(key);
            for (ProjectDataService projectDataService : list2) {
                long l3 = System.currentTimeMillis();
                projectDataService.removeData((Computable)new Computable.PredefinedValueComputable(toRemove), toIgnore, projectData, project2, modelsProvider);
                if (!a.isDebugEnabled()) continue;
                long l5 = System.currentTimeMillis() - l3;
                a.debug(String.format("Service %s removed data in %d ms", projectDataService.getClass().getSimpleName(), l5));
            }
            ProjectDataManagerImpl.a(modelsProvider, project2, synchronous, "Removed data");
        }
        catch (Throwable throwable) {
            ProjectDataManagerImpl.a(modelsProvider, project2, synchronous);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)throwable);
        }
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> toRemove, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project2, boolean synchronous) {
        if (key == null) {
            ProjectDataManagerImpl.a(26);
        }
        if (toRemove == null) {
            ProjectDataManagerImpl.a(27);
        }
        if (toIgnore == null) {
            ProjectDataManagerImpl.a(28);
        }
        if (projectData == null) {
            ProjectDataManagerImpl.a(29);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.a(30);
        }
        this.removeData(key, toRemove, toIgnore, projectData, project2, new IdeModifiableModelsProviderImpl(project2), synchronous);
    }

    public void updateExternalProjectData(@NotNull Project project2, @NotNull ExternalProjectInfo externalProjectInfo) {
        if (project2 == null) {
            ProjectDataManagerImpl.a(31);
        }
        if (externalProjectInfo == null) {
            ProjectDataManagerImpl.a(32);
        }
        if (!project2.isDisposed()) {
            ExternalProjectsManagerImpl.getInstance(project2).updateExternalProjectData(externalProjectInfo);
        }
    }

    @Nullable
    public ExternalProjectInfo getExternalProjectData(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (project2 == null) {
            ProjectDataManagerImpl.a(33);
        }
        if (projectSystemId == null) {
            ProjectDataManagerImpl.a(34);
        }
        if (externalProjectPath == null) {
            ProjectDataManagerImpl.a(35);
        }
        return !project2.isDisposed() ? ExternalProjectsDataStorage.getInstance(project2).get(projectSystemId, externalProjectPath) : null;
    }

    @NotNull
    public Collection<ExternalProjectInfo> getExternalProjectsData(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        if (project2 == null) {
            ProjectDataManagerImpl.a(36);
        }
        if (projectSystemId == null) {
            ProjectDataManagerImpl.a(37);
        }
        if (!project2.isDisposed()) {
            Collection<ExternalProjectInfo> collection = ExternalProjectsDataStorage.getInstance(project2).list(projectSystemId);
            if (collection == null) {
                ProjectDataManagerImpl.a(38);
            }
            return collection;
        }
        List list2 = ContainerUtil.emptyList();
        if (list2 == null) {
            ProjectDataManagerImpl.a(39);
        }
        return list2;
    }

    private void a(@NotNull Collection<DataNode<?>> collection) {
        if (collection == null) {
            ProjectDataManagerImpl.a(40);
        }
        for (DataNode<?> dataNode : collection) {
            this.ensureTheDataIsReadyToUse(dataNode);
        }
    }

    private boolean a(@NotNull DataNode dataNode) {
        Map map2;
        List list2;
        if (dataNode == null) {
            ProjectDataManagerImpl.a(41);
        }
        if ((list2 = (List)(map2 = (Map)this.c.getValue()).get(dataNode.getKey())) != null) {
            try {
                dataNode.prepareData((ClassLoader[])ContainerUtil.map2Array((Collection)list2, ClassLoader.class, projectDataService -> projectDataService.getClass().getClassLoader()));
            }
            catch (Exception exception) {
                a.debug((Throwable)exception);
                dataNode.clear(true);
                return false;
            }
        }
        return true;
    }

    private static void a(final @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @NotNull Project project2, boolean bl2, final @NotNull String string) {
        if (ideModifiableModelsProvider == null) {
            ProjectDataManagerImpl.a(42);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.a(43);
        }
        if (string == null) {
            ProjectDataManagerImpl.a(44);
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)bl2, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project2){
            private static final long a = lb.a(-3385370198942670814L, 4633236503176163207L, MethodHandles.lookup().lookupClass()).a(256758858371187L);

            public void execute() {
                long l2 = a ^ 0x19AF9A765BC0L;
                long l3 = System.currentTimeMillis();
                ideModifiableModelsProvider.commit();
                long l5 = System.currentTimeMillis() - l3;
                a.debug(String.format("%s committed in %d ms", string, l5));
            }
        });
    }

    private static void a(final @NotNull IdeModifiableModelsProvider ideModifiableModelsProvider, @NotNull Project project2, boolean bl2) {
        if (ideModifiableModelsProvider == null) {
            ProjectDataManagerImpl.a(45);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.a(46);
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)bl2, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project2){

            public void execute() {
                ideModifiableModelsProvider.dispose();
            }
        });
    }

    static {
        f = lb.a(4812520979519243897L, -9026663314297932826L, MethodHandles.lookup().lookupClass()).a(148738730650682L);
        long l2 = f ^ 0x3C92AEED115CL;
        a = Logger.getInstance(ProjectDataManagerImpl.class);
        b = com.intellij.openapi.util.Key.create((String)"externalSystem.data.ready");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x2F14B2A92D9L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 38: 
            case 39: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 24: 
            case 30: 
            case 31: 
            case 33: 
            case 36: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 10: 
            case 25: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: 
            case 13: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 16: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModelsProvider";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postImportTasks";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccessImportTasks";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFailureImportTasks";
                break;
            }
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectInfo";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNode";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitDesc";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableText";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectsData";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runFinalTasks";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReadableText";
                break;
            }
            case 5: 
            case 38: 
            case 39: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doImportData";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "updateExternalProjectData";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectData";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectsData";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "ensureTheDataIsReadyToUse";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "prepareDataToUse";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doImportData$4";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doImportData$3";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doImportData$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

