/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import b.a.lb;
import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.BuildContentDescriptor;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.impl.FailureImpl;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.output.BuildOutputInstantReaderImpl;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStartEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStatusEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.model.task.event.Failure;
import com.intellij.openapi.externalSystem.model.task.event.FailureResult;
import com.intellij.openapi.externalSystem.model.task.event.OperationResult;
import com.intellij.openapi.externalSystem.model.task.event.SkippedResult;
import com.intellij.openapi.externalSystem.model.task.event.SuccessResult;
import com.intellij.openapi.externalSystem.service.ImportCanceledException;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.DefaultExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemOutputParserProvider;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ContentRootDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.pom.NonNavigatable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.DisposeAwareRunnable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemUtil {
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019.1")
    @NotNull
    public static final Key<ExternalSystemTaskId> EXTERNAL_SYSTEM_TASK_ID_KEY;
    private static final Logger b;
    @NotNull
    private static final Map<String, String> a;
    public static final TObjectHashingStrategy<Pair<ProjectSystemId, File>> HASHING_STRATEGY;
    private static final long c;

    private ExternalSystemUtil() {
    }

    public static int fileHashCode(@Nullable File file) {
        int n2;
        long l2 = c ^ 0x78F1FC59BDFEL;
        try {
            n2 = FileUtil.pathHashCode((String)(file == null ? null : file.getCanonicalPath()));
        }
        catch (IOException iOException) {
            b.warn("unable to get canonical file path", (Throwable)iOException);
            n2 = FileUtil.fileHashCode((File)file);
        }
        return n2;
    }

    public static boolean filesEqual(@Nullable File file1, @Nullable File file2) {
        long l2 = c ^ 0x4E5464D9F391L;
        try {
            return FileUtil.pathsEqual((String)(file1 == null ? null : file1.getCanonicalPath()), (String)(file2 == null ? null : file2.getCanonicalPath()));
        }
        catch (IOException iOException) {
            b.warn("unable to get canonical file path", (Throwable)iOException);
            return FileUtil.filesEqual((File)file1, (File)file2);
        }
    }

    public static void ensureToolWindowInitialized(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        long l2 = c ^ 0x37F253BF0D39L;
        if (project2 == null) {
            ExternalSystemUtil.a(0);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.a(1);
        }
        try {
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
            if (!(toolWindowManager instanceof ToolWindowManagerEx)) {
                return;
            }
            ToolWindowManagerEx toolWindowManagerEx = (ToolWindowManagerEx)toolWindowManager;
            String string = externalSystemId.getReadableName();
            ToolWindow toolWindow = toolWindowManager.getToolWindow(string);
            if (toolWindow != null) {
                return;
            }
            for (ToolWindowEP toolWindowEP : ToolWindowEP.EP_NAME.getExtensionList()) {
                if (!string.equals(toolWindowEP.id)) continue;
                toolWindowManagerEx.initToolWindow(toolWindowEP);
            }
        }
        catch (Exception exception) {
            b.error(String.format("Unable to initialize %s tool window", externalSystemId.getReadableName()), (Throwable)exception);
        }
    }

    @Nullable
    public static ToolWindow ensureToolWindowContentInitialized(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        ToolWindowManager toolWindowManager;
        if (project2 == null) {
            ExternalSystemUtil.a(2);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.a(3);
        }
        if ((toolWindowManager = ToolWindowManager.getInstance((Project)project2)) == null) {
            return null;
        }
        ToolWindow toolWindow = toolWindowManager.getToolWindow(externalSystemId.getReadableName());
        if (toolWindow == null) {
            return null;
        }
        if (toolWindow instanceof ToolWindowImpl) {
            ((ToolWindowImpl)toolWindow).ensureContentInitialized();
        }
        return toolWindow;
    }

    @Deprecated
    public static void refreshProjects(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, boolean force) {
        if (project2 == null) {
            ExternalSystemUtil.a(4);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.a(5);
        }
        ExternalSystemUtil.refreshProjects(project2, externalSystemId, force, ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }

    @Deprecated
    public static void refreshProjects(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, boolean force, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (project2 == null) {
            ExternalSystemUtil.a(6);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.a(7);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.a(8);
        }
        ExternalSystemUtil.refreshProjects(new ImportSpecBuilder(project2, externalSystemId).forceWhenUptodate(force).use(progressExecutionMode));
    }

    public static void refreshProjects(@NotNull ImportSpecBuilder specBuilder) {
        if (specBuilder == null) {
            ExternalSystemUtil.a(9);
        }
        ExternalSystemUtil.refreshProjects(specBuilder.build());
    }

    public static void refreshProjects(@NotNull ImportSpec spec) {
        ExternalSystemManager externalSystemManager;
        if (spec == null) {
            ExternalSystemUtil.a(10);
        }
        if ((externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)spec.getExternalSystemId())) == null) {
            return;
        }
        AbstractExternalSystemSettings abstractExternalSystemSettings = (AbstractExternalSystemSettings)externalSystemManager.getSettingsProvider().fun((Object)spec.getProject());
        Collection collection = abstractExternalSystemSettings.getLinkedProjectsSettings();
        if (collection.isEmpty()) {
            return;
        }
        ExternalProjectRefreshCallback externalProjectRefreshCallback = spec.getCallback() == null ? new MyMultiExternalProjectRefreshCallback(spec.getProject()) : spec.getCallback();
        HashSet hashSet = ContainerUtilRt.newHashSet();
        for (Object object : collection) {
            if (!object.isUseAutoImport() && spec.whenAutoImportEnabled()) continue;
            hashSet.add(object.getExternalProjectPath());
        }
        if (!hashSet.isEmpty()) {
            ExternalSystemNotificationManager.getInstance(spec.getProject()).clearNotifications(null, NotificationSource.PROJECT_SYNC, spec.getExternalSystemId());
            for (Object object : hashSet) {
                ExternalSystemUtil.refreshProject((String)object, new ImportSpecBuilder(spec).callback(externalProjectRefreshCallback).build());
            }
        }
    }

    @Nullable
    private static String a(@NotNull Throwable throwable) {
        Throwable throwable2;
        if (throwable == null) {
            ExternalSystemUtil.a(11);
        }
        if ((throwable2 = RemoteUtil.unwrap((Throwable)throwable)) instanceof ExternalSystemException) {
            return ((ExternalSystemException)throwable2).getOriginalReason();
        }
        return null;
    }

    public static void refreshProject(final @NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectPath, boolean isPreviewMode, final @NotNull ProgressExecutionMode progressExecutionMode) {
        if (project2 == null) {
            ExternalSystemUtil.a(12);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.a(13);
        }
        if (externalProjectPath == null) {
            ExternalSystemUtil.a(14);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.a(15);
        }
        ExternalSystemUtil.refreshProject(project2, externalSystemId, externalProjectPath, new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject == null) {
                    return;
                }
                boolean bl2 = progressExecutionMode == ProgressExecutionMode.MODAL_SYNC;
                ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProject, project2, bl2);
            }
        }, isPreviewMode, progressExecutionMode, true);
    }

    public static void refreshProject(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectPath, @NotNull ExternalProjectRefreshCallback callback, boolean isPreviewMode, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (project2 == null) {
            ExternalSystemUtil.a(16);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.a(17);
        }
        if (externalProjectPath == null) {
            ExternalSystemUtil.a(18);
        }
        if (callback == null) {
            ExternalSystemUtil.a(19);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.a(20);
        }
        ExternalSystemUtil.refreshProject(project2, externalSystemId, externalProjectPath, callback, isPreviewMode, progressExecutionMode, true);
    }

    public static void refreshProject(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectPath, @NotNull ExternalProjectRefreshCallback callback, boolean isPreviewMode, @NotNull ProgressExecutionMode progressExecutionMode, boolean reportRefreshError) {
        if (project2 == null) {
            ExternalSystemUtil.a(21);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.a(22);
        }
        if (externalProjectPath == null) {
            ExternalSystemUtil.a(23);
        }
        if (callback == null) {
            ExternalSystemUtil.a(24);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.a(25);
        }
        ImportSpecBuilder importSpecBuilder = new ImportSpecBuilder(project2, externalSystemId).callback(callback).use(progressExecutionMode);
        if (isPreviewMode) {
            importSpecBuilder.usePreviewMode();
        }
        if (!reportRefreshError) {
            importSpecBuilder.dontReportRefreshErrors();
        }
        ExternalSystemUtil.refreshProject(externalProjectPath, importSpecBuilder.build());
    }

    public static void refreshProject(final @NotNull String externalProjectPath, final @NotNull ImportSpec importSpec) {
        long l2 = c ^ 0x4F76C7F74531L;
        if (externalProjectPath == null) {
            ExternalSystemUtil.a(26);
        }
        if (importSpec == null) {
            ExternalSystemUtil.a(27);
        }
        final Project project2 = importSpec.getProject();
        final ProjectSystemId projectSystemId = importSpec.getExternalSystemId();
        final ExternalProjectRefreshCallback externalProjectRefreshCallback = importSpec.getCallback();
        final boolean bl2 = importSpec.isPreviewMode();
        ProgressExecutionMode progressExecutionMode = importSpec.getProgressExecutionMode();
        final boolean bl3 = importSpec.isReportRefreshError();
        String string = importSpec.getArguments();
        String string2 = importSpec.getVmOptions();
        final File file = new File(externalProjectPath);
        final String string3 = file.isFile() ? file.getParentFile().getName() : file.getName();
        AbstractExternalSystemLocalSettings abstractExternalSystemLocalSettings = ExternalSystemApiUtil.getLocalSettings((Project)project2, (ProjectSystemId)projectSystemId);
        AbstractExternalSystemLocalSettings.SyncType syncType = bl2 ? AbstractExternalSystemLocalSettings.SyncType.PREVIEW : (abstractExternalSystemLocalSettings.getProjectSyncType().get(externalProjectPath) == AbstractExternalSystemLocalSettings.SyncType.PREVIEW ? AbstractExternalSystemLocalSettings.SyncType.IMPORT : AbstractExternalSystemLocalSettings.SyncType.RE_IMPORT);
        abstractExternalSystemLocalSettings.getProjectSyncType().put(externalProjectPath, syncType);
        final ExternalSystemResolveProjectTask externalSystemResolveProjectTask = new ExternalSystemResolveProjectTask(projectSystemId, project2, externalProjectPath, string2, string, bl2);
        final TaskUnderProgress taskUnderProgress = new TaskUnderProgress(){
            private static final long a = lb.a(9206905511006088144L, 3683814179312742057L, MethodHandles.lookup().lookupClass()).a(255305394066649L);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                Throwable throwable;
                Ref ref;
                block24: {
                    VirtualFile virtualFile;
                    block23: {
                        DataNode dataNode;
                        ExternalSystemProcessingManager externalSystemProcessingManager;
                        long l2 = a ^ 0x29799D0D8AA9L;
                        if (indicator == null) {
                            3.a(0);
                        }
                        if (project2.isDisposed()) {
                            return;
                        }
                        if (indicator instanceof ProgressIndicatorEx) {
                            ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                                public void cancel() {
                                    super.cancel();
                                    this.a();
                                }
                            });
                        }
                        if ((externalSystemProcessingManager = (ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class)).findTask(ExternalSystemTaskType.RESOLVE_PROJECT, projectSystemId, externalProjectPath) != null) {
                            if (externalProjectRefreshCallback == null) return;
                            externalProjectRefreshCallback.onFailure(externalSystemResolveProjectTask.getId(), ExternalSystemBundle.message((String)"error.resolve.already.running", (Object[])new Object[]{externalProjectPath}), null);
                            return;
                        }
                        if (!(externalProjectRefreshCallback instanceof MyMultiExternalProjectRefreshCallback)) {
                            ExternalSystemNotificationManager.getInstance(project2).clearNotifications(null, NotificationSource.PROJECT_SYNC, projectSystemId);
                        }
                        ExternalSystemTaskActivator externalSystemTaskActivator = ExternalProjectsManagerImpl.getInstance(project2).getTaskActivator();
                        if (!bl2 && !externalSystemTaskActivator.runTasks(externalProjectPath, ExternalSystemTaskActivator.Phase.BEFORE_SYNC)) {
                            return;
                        }
                        final ExternalSystemProcessHandler externalSystemProcessHandler = new ExternalSystemProcessHandler(externalSystemResolveProjectTask, string3 + " import"){

                            @Override
                            protected void destroyProcessImpl() {
                                this.a();
                                this.closeInput();
                            }
                        };
                        ExternalSystemExecutionConsoleManager<ExternalSystemRunConfiguration, ExecutionConsole, ProcessHandler> externalSystemExecutionConsoleManager = ExternalSystemUtil.getConsoleManagerFor(externalSystemResolveProjectTask);
                        final ExecutionConsole executionConsole = externalSystemExecutionConsoleManager.attachExecutionConsole(project2, (ExternalSystemTask)externalSystemResolveProjectTask, null, (ProcessHandler)externalSystemProcessHandler);
                        if (executionConsole != null) {
                            Disposer.register((Disposable)project2, (Disposable)executionConsole);
                        } else {
                            Disposer.register((Disposable)project2, (Disposable)externalSystemProcessHandler);
                        }
                        SmartList smartList = new SmartList();
                        for (ExternalSystemOutputParserProvider externalSystemOutputParserProvider : (BuildOutputInstantReaderImpl)ExternalSystemOutputParserProvider.EP_NAME.getExtensions()) {
                            if (!externalSystemResolveProjectTask.getExternalSystemId().equals((Object)externalSystemOutputParserProvider.getExternalSystemId())) continue;
                            smartList.addAll(externalSystemOutputParserProvider.getBuildOutputParsers(externalSystemResolveProjectTask));
                        }
                        final BuildOutputInstantReaderImpl buildOutputInstantReaderImpl = smartList.isEmpty() ? null : new BuildOutputInstantReaderImpl((Object)externalSystemResolveProjectTask.getId(), (BuildProgressListener)ServiceManager.getService((Project)project2, SyncViewManager.class), (List)smartList);
                        ref = Ref.create();
                        ExternalSystemTaskNotificationListenerAdapter externalSystemTaskNotificationListenerAdapter = new ExternalSystemTaskNotificationListenerAdapter(){
                            private static final long a = lb.a(-3000166824804730429L, -6623373876332983596L, MethodHandles.lookup().lookupClass()).a(42504222044041L);

                            public void onStart(@NotNull ExternalSystemTaskId id2, String workingDir) {
                                long l2 = a ^ 0x70CDFE2593F4L;
                                if (id2 == null) {
                                    3.a(0);
                                }
                                long l3 = System.currentTimeMillis();
                                AnAction anAction = new AnAction(){
                                    private static final long a = lb.a(-8126994921335186691L, -3686106421367436730L, MethodHandles.lookup().lookupClass()).a(257399693488667L);

                                    public void update(@NotNull AnActionEvent e10) {
                                        if (e10 == null) {
                                            1.a(0);
                                        }
                                        super.update(e10);
                                        Presentation presentation = e10.getPresentation();
                                        presentation.setEnabled(externalSystemProcessHandler.isProcessTerminated());
                                    }

                                    public void actionPerformed(@NotNull AnActionEvent e10) {
                                        if (e10 == null) {
                                            1.a(1);
                                        }
                                        Presentation presentation = e10.getPresentation();
                                        presentation.setEnabled(false);
                                        ExternalSystemUtil.refreshProject(externalProjectPath, importSpec);
                                    }

                                    private static /* synthetic */ void a(int n2) {
                                        Object[] objectArray;
                                        long l2 = a ^ 0x2A977CA336E2L;
                                        Object[] objectArray2 = new Object[3];
                                        objectArray2[0] = "e";
                                        objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$3$3$1";
                                        switch (n2) {
                                            default: {
                                                objectArray = objectArray2;
                                                objectArray2[2] = "update";
                                                break;
                                            }
                                            case 1: {
                                                objectArray = objectArray2;
                                                objectArray2[2] = "actionPerformed";
                                                break;
                                            }
                                        }
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                                    }
                                };
                                String string = id2.getProjectSystemId().getReadableName();
                                anAction.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.refresh.project.text", (Object[])new Object[]{string}));
                                anAction.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.refresh.project.description", (Object[])new Object[]{string}));
                                anAction.getTemplatePresentation().setIcon(AllIcons.Actions.Refresh);
                                if (bl2) {
                                    return;
                                }
                                String string2 = "syncing...";
                                ((SyncViewManager)ServiceManager.getService((Project)project2, SyncViewManager.class)).onEvent((BuildEvent)new StartBuildEventImpl((BuildDescriptor)new DefaultBuildDescriptor((Object)id2, string3, externalProjectPath, l3), string2).withProcessHandler((BuildProcessHandler)externalSystemProcessHandler, null).withRestartAction(anAction).withContentDescriptorSupplier(() -> {
                                    long l2 = a ^ 0x11B17838D8FEL;
                                    if (executionConsole == null) {
                                        return null;
                                    }
                                    boolean bl3 = ExternalSystemUtil.isNewProject(project2);
                                    BuildContentDescriptor buildContentDescriptor = new BuildContentDescriptor(executionConsole, (ProcessHandler)externalSystemProcessHandler, executionConsole.getComponent(), "Sync");
                                    buildContentDescriptor.setActivateToolWindowWhenAdded(bl3);
                                    buildContentDescriptor.setActivateToolWindowWhenFailed(bl3);
                                    buildContentDescriptor.setAutoFocusContent(bl3);
                                    return buildContentDescriptor;
                                }));
                            }

                            public void onTaskOutput(@NotNull ExternalSystemTaskId id2, @NotNull String text2, boolean stdOut) {
                                if (id2 == null) {
                                    3.a(1);
                                }
                                if (text2 == null) {
                                    3.a(2);
                                }
                                externalSystemProcessHandler.notifyTextAvailable(text2, stdOut ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR);
                                if (buildOutputInstantReaderImpl != null) {
                                    buildOutputInstantReaderImpl.append((CharSequence)text2);
                                }
                            }

                            public void onFailure(@NotNull ExternalSystemTaskId id2, @NotNull Exception e10) {
                                long l2 = a ^ 0x80D70C22639L;
                                if (id2 == null) {
                                    3.a(3);
                                }
                                if (e10 == null) {
                                    3.a(4);
                                }
                                String string = ExternalSystemBundle.message((String)"notification.project.refresh.fail.title", (Object[])new Object[]{projectSystemId.getReadableName(), string3});
                                FailureResultImpl failureResultImpl = ExternalSystemUtil.createFailureResult(string, e10, projectSystemId, project2);
                                String string2 = bl2 ? "project preview creation failed" : "sync failed";
                                ref.set(() -> 3.a(id2, string2, (com.intellij.build.events.FailureResult)failureResultImpl));
                                ExternalSystemUtil.printFailure(e10, (com.intellij.build.events.FailureResult)failureResultImpl, executionConsole, externalSystemProcessHandler);
                                externalSystemProcessHandler.notifyProcessTerminated(1);
                            }

                            public void onSuccess(@NotNull ExternalSystemTaskId id2) {
                                long l2 = a ^ 0x4EDBE053319CL;
                                if (id2 == null) {
                                    3.a(5);
                                }
                                String string = bl2 ? "project preview created" : "sync finished";
                                ref.set(() -> {
                                    if (id2 == null) {
                                        3.a(8);
                                    }
                                    return new FinishBuildEventImpl((Object)id2, null, System.currentTimeMillis(), string, (EventResult)new SuccessResultImpl());
                                });
                                externalSystemProcessHandler.notifyProcessTerminated(0);
                            }

                            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                                if (event == null) {
                                    3.a(6);
                                }
                                if (!bl2 && event instanceof ExternalSystemTaskExecutionEvent) {
                                    BuildEvent buildEvent = ExternalSystemUtil.convert((ExternalSystemTaskExecutionEvent)event);
                                    ((SyncViewManager)ServiceManager.getService((Project)project2, SyncViewManager.class)).onEvent(buildEvent);
                                }
                            }

                            public void onEnd(@NotNull ExternalSystemTaskId id2) {
                                if (id2 == null) {
                                    3.a(7);
                                }
                                if (buildOutputInstantReaderImpl != null) {
                                    buildOutputInstantReaderImpl.close();
                                }
                            }

                            private static /* synthetic */ FinishBuildEvent a(@NotNull ExternalSystemTaskId externalSystemTaskId, String string, com.intellij.build.events.FailureResult failureResult) {
                                if (externalSystemTaskId == null) {
                                    3.a(9);
                                }
                                return new FinishBuildEventImpl((Object)externalSystemTaskId, null, System.currentTimeMillis(), string, (EventResult)failureResult);
                            }

                            private static /* synthetic */ void a(int n2) {
                                Object[] objectArray;
                                Object[] objectArray2;
                                long l2 = a ^ 0x52B638938B6AL;
                                Object[] objectArray3 = new Object[3];
                                switch (n2) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "id";
                                        break;
                                    }
                                    case 2: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "text";
                                        break;
                                    }
                                    case 4: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "e";
                                        break;
                                    }
                                    case 6: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "event";
                                        break;
                                    }
                                }
                                objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$3$3";
                                switch (n2) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "onStart";
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "onTaskOutput";
                                        break;
                                    }
                                    case 3: 
                                    case 4: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "onFailure";
                                        break;
                                    }
                                    case 5: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "onSuccess";
                                        break;
                                    }
                                    case 6: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "onStatusChange";
                                        break;
                                    }
                                    case 7: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "onEnd";
                                        break;
                                    }
                                    case 8: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "lambda$onSuccess$2";
                                        break;
                                    }
                                    case 9: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "lambda$onFailure$1";
                                        break;
                                    }
                                }
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        };
                        long l3 = System.currentTimeMillis();
                        externalSystemResolveProjectTask.execute(indicator, (ExternalSystemTaskNotificationListener[])ArrayUtil.prepend((Object)externalSystemTaskNotificationListenerAdapter, (Object[])ExternalSystemTaskNotificationListener.EP_NAME.getExtensions()));
                        b.info("External project [" + externalProjectPath + "] resolution task executed in " + (System.currentTimeMillis() - l3) + " ms.");
                        if (project2.isDisposed()) {
                            return;
                        }
                        try {
                            ExternalProjectInfo externalProjectInfo;
                            throwable = externalSystemResolveProjectTask.getError();
                            if (throwable != null) break block23;
                            if (externalProjectRefreshCallback != null && (externalProjectInfo = ProjectDataManagerImpl.getInstance().getExternalProjectData(project2, projectSystemId, externalProjectPath)) != null) {
                                dataNode = externalProjectInfo.getExternalProjectStructure();
                                if (dataNode != null && importSpec.shouldCreateDirectoriesForEmptyContentRoots()) {
                                    dataNode.putUserData(ContentRootDataService.CREATE_EMPTY_DIRECTORIES, (Object)Boolean.TRUE);
                                }
                                externalProjectRefreshCallback.onSuccess(externalSystemResolveProjectTask.getId(), dataNode);
                            }
                            if (!bl2) {
                                externalSystemTaskActivator.runTasks(externalProjectPath, ExternalSystemTaskActivator.Phase.AFTER_SYNC);
                            }
                            if (bl2) return;
                        }
                        catch (Throwable throwable2) {
                            VirtualFile virtualFile2;
                            if (bl2) throw throwable2;
                            boolean bl22 = ExternalSystemUtil.isNewProject(project2);
                            if (bl22 && (virtualFile2 = VfsUtil.findFileByIoFile((File)file, (boolean)false)) != null) {
                                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile2});
                            }
                            project2.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, null);
                            project2.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, null);
                            this.a((Ref<? extends Supplier<FinishBuildEvent>>)ref);
                            throw throwable2;
                        }
                        boolean bl32 = ExternalSystemUtil.isNewProject(project2);
                        if (bl32 && (dataNode = VfsUtil.findFileByIoFile((File)file, (boolean)false)) != null) {
                            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{dataNode});
                        }
                        project2.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, null);
                        project2.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, null);
                        this.a((Ref<? extends Supplier<FinishBuildEvent>>)ref);
                        return;
                    }
                    if (!(throwable instanceof ImportCanceledException)) break block24;
                    if (bl2) return;
                    boolean bl4 = ExternalSystemUtil.isNewProject(project2);
                    if (bl4 && (virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)false)) != null) {
                        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
                    }
                    project2.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, null);
                    project2.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, null);
                    this.a((Ref<? extends Supplier<FinishBuildEvent>>)ref);
                    return;
                }
                String string = ExternalSystemApiUtil.buildErrorMessage((Throwable)throwable);
                if (StringUtil.isEmpty((String)string)) {
                    string = String.format("Can't resolve %s project at '%s'. Reason: %s", projectSystemId.getReadableName(), externalProjectPath, string);
                }
                if (externalProjectRefreshCallback != null) {
                    externalProjectRefreshCallback.onFailure(externalSystemResolveProjectTask.getId(), string, ExternalSystemUtil.a(throwable));
                }
                if (bl2) return;
                boolean bl5 = ExternalSystemUtil.isNewProject(project2);
                if (bl5 && (string = VfsUtil.findFileByIoFile((File)file, (boolean)false)) != null) {
                    VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{string});
                }
                project2.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, null);
                project2.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, null);
                this.a((Ref<? extends Supplier<FinishBuildEvent>>)ref);
            }

            private void a(@NotNull Ref<? extends Supplier<FinishBuildEvent>> ref) {
                long l2 = a ^ 0x632E082302E1L;
                if (ref == null) {
                    3.a(1);
                }
                Exception exception = null;
                FinishBuildEvent finishBuildEvent = null;
                Supplier supplier = (Supplier)ref.get();
                if (supplier != null) {
                    try {
                        finishBuildEvent = (FinishBuildEvent)supplier.get();
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                    }
                }
                if (finishBuildEvent != null) {
                    ((SyncViewManager)ServiceManager.getService((Project)project2, SyncViewManager.class)).onEvent((BuildEvent)finishBuildEvent);
                } else {
                    String string = "Sync finish event has not been received";
                    b.warn(string, (Throwable)exception);
                    ((SyncViewManager)ServiceManager.getService((Project)project2, SyncViewManager.class)).onEvent((BuildEvent)new FinishBuildEventImpl((Object)externalSystemResolveProjectTask.getId(), null, System.currentTimeMillis(), "sync failed", (EventResult)new FailureResultImpl((Throwable)new Exception(string, exception))));
                }
            }

            private void a() {
                externalSystemResolveProjectTask.cancel((ExternalSystemTaskNotificationListener[])ExternalSystemTaskNotificationListener.EP_NAME.getExtensions());
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                long l2 = a ^ 0x7DAB037F8C48L;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "finishSyncEventSupplier";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$3";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sendSyncFinishEvent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ApplicationManager.getApplication().invokeAndWait(() -> ((FileDocumentManager)FileDocumentManager.getInstance()).saveAllDocuments());
        switch (progressExecutionMode) {
            case NO_PROGRESS_SYNC: 
            case NO_PROGRESS_ASYNC: {
                throw new ExternalSystemException("Please, use progress for the project import!");
            }
            case MODAL_SYNC: {
                String string4 = ExternalSystemBundle.message((String)"progress.import.text", (Object[])new Object[]{string3, projectSystemId.getReadableName()});
                new Task.Modal(project2, string4, true){
                    private static final long a = lb.a(6489166034794935615L, -7410119375316441855L, MethodHandles.lookup().lookupClass()).a(120288799463280L);

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            4.a(0);
                        }
                        taskUnderProgress.execute(indicator);
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x4E294130F2BDL;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$4", "run"));
                    }
                }.queue();
                break;
            }
            case IN_BACKGROUND_ASYNC: {
                String string5 = ExternalSystemBundle.message((String)"progress.refresh.text", (Object[])new Object[]{string3, projectSystemId.getReadableName()});
                new Task.Backgroundable(project2, string5){
                    private static final long a = lb.a(-2908552731913597827L, -8690760853921363380L, MethodHandles.lookup().lookupClass()).a(247298958886310L);

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            5.a(0);
                        }
                        taskUnderProgress.execute(indicator);
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x284A8D5A549EL;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$5", "run"));
                    }
                }.queue();
                break;
            }
            case START_IN_FOREGROUND_ASYNC: {
                String string6 = ExternalSystemBundle.message((String)"progress.refresh.text", (Object[])new Object[]{string3, projectSystemId.getReadableName()});
                new Task.Backgroundable(project2, string6, true, PerformInBackgroundOption.DEAF){
                    private static final long a = lb.a(3871553438748345973L, -970432676252901292L, MethodHandles.lookup().lookupClass()).a(221001669227444L);

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            6.a(0);
                        }
                        taskUnderProgress.execute(indicator);
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x5534D73A063BL;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$6", "run"));
                    }
                }.queue();
            }
        }
    }

    public static boolean isNewProject(Project project2) {
        return project2.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) == Boolean.TRUE || project2.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE;
    }

    public static void printFailure(@NotNull Exception e10, com.intellij.build.events.FailureResult failureResult, ExecutionConsole consoleView, ExternalSystemProcessHandler processHandler) {
        if (e10 == null) {
            ExternalSystemUtil.a(28);
        }
        if (consoleView instanceof ConsoleView) {
            for (com.intellij.build.events.Failure failure : failureResult.getFailures()) {
                BuildConsoleUtils.printDetails((ConsoleView)((ConsoleView)consoleView), (com.intellij.build.events.Failure)failure);
            }
        } else {
            String string = ExceptionUtil.getMessage((Throwable)e10);
            String string2 = string == null ? e10.toString() : string;
            processHandler.notifyTextAvailable(string2 + '\n', ProcessOutputTypes.STDERR);
        }
    }

    @NotNull
    public static FailureResultImpl createFailureResult(@NotNull String title, @NotNull Exception exception, @NotNull ProjectSystemId externalSystemId, @NotNull Project project2) {
        if (title == null) {
            ExternalSystemUtil.a(29);
        }
        if (exception == null) {
            ExternalSystemUtil.a(30);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.a(31);
        }
        if (project2 == null) {
            ExternalSystemUtil.a(32);
        }
        ExternalSystemNotificationManager externalSystemNotificationManager = ExternalSystemNotificationManager.getInstance(project2);
        NotificationData notificationData = externalSystemNotificationManager.createNotification(title, exception, externalSystemId, project2);
        FailureResultImpl failureResultImpl = ExternalSystemUtil.a(exception, externalSystemId, project2, externalSystemNotificationManager, notificationData);
        if (failureResultImpl == null) {
            ExternalSystemUtil.a(33);
        }
        return failureResultImpl;
    }

    @NotNull
    private static FailureResultImpl a(@NotNull Exception exception, @NotNull ProjectSystemId projectSystemId, @NotNull Project project2, @NotNull ExternalSystemNotificationManager externalSystemNotificationManager, @NotNull NotificationData notificationData) {
        VirtualFile virtualFile;
        Object object;
        long l2 = c ^ 0xE6A547C46C3L;
        if (exception == null) {
            ExternalSystemUtil.a(34);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(35);
        }
        if (project2 == null) {
            ExternalSystemUtil.a(36);
        }
        if (externalSystemNotificationManager == null) {
            ExternalSystemUtil.a(37);
        }
        if (notificationData == null) {
            ExternalSystemUtil.a(38);
        }
        if (notificationData.isBalloonNotification()) {
            externalSystemNotificationManager.showNotification(projectSystemId, notificationData);
            FailureResultImpl failureResultImpl = new FailureResultImpl((Throwable)exception);
            if (failureResultImpl == null) {
                ExternalSystemUtil.a(39);
            }
            return failureResultImpl;
        }
        Object object2 = notificationData.getBalloonGroup() == null ? ((object = ExternalProjectsManagerImpl.getInstance(project2).getExternalProjectsView(projectSystemId)) instanceof ExternalProjectsViewImpl ? ((ExternalProjectsViewImpl)object).getNotificationGroup() : null) : ((object = NotificationGroup.findRegisteredGroup((String)notificationData.getBalloonGroup())) != null ? object : NotificationGroup.balloonGroup((String)notificationData.getBalloonGroup()));
        int n2 = notificationData.getLine() - 1;
        int n3 = notificationData.getColumn() - 1;
        VirtualFile virtualFile2 = virtualFile = notificationData.getFilePath() != null ? ExternalSystemUtil.findLocalFileByPath(notificationData.getFilePath()) : null;
        Object object3 = notificationData.getNavigatable() == null || notificationData.getNavigatable() instanceof NonNavigatable ? (virtualFile != null ? new OpenFileDescriptor(project2, virtualFile, n2, n3) : NonNavigatable.INSTANCE) : notificationData.getNavigatable();
        Notification notification = object2 == null ? new Notification(projectSystemId.getReadableName() + " build", notificationData.getTitle(), notificationData.getMessage(), notificationData.getNotificationCategory().getNotificationType(), notificationData.getListener()) : object2.createNotification(notificationData.getTitle(), notificationData.getMessage(), notificationData.getNotificationCategory().getNotificationType(), notificationData.getListener());
        FailureResultImpl failureResultImpl = new FailureResultImpl(ContainerUtil.list((Object[])new com.intellij.build.events.Failure[]{new FailureImpl(notificationData.getMessage(), (Throwable)exception, notification, object3)}));
        if (failureResultImpl == null) {
            ExternalSystemUtil.a(40);
        }
        return failureResultImpl;
    }

    public static BuildEvent convert(ExternalSystemTaskExecutionEvent taskExecutionEvent) {
        Object object;
        StartEventImpl startEventImpl;
        ExternalSystemProgressEvent externalSystemProgressEvent = taskExecutionEvent.getProgressEvent();
        String string = externalSystemProgressEvent.getDescriptor().getDisplayName();
        long l2 = externalSystemProgressEvent.getDescriptor().getEventTime();
        Object object2 = ObjectUtils.chooseNotNull((Object)externalSystemProgressEvent.getParentEventId(), (Object)taskExecutionEvent.getId());
        if (externalSystemProgressEvent instanceof ExternalSystemStartEvent) {
            startEventImpl = new StartEventImpl((Object)externalSystemProgressEvent.getEventId(), object2, l2, string);
        } else if (externalSystemProgressEvent instanceof ExternalSystemFinishEvent) {
            OperationResult operationResult = ((ExternalSystemFinishEvent)externalSystemProgressEvent).getOperationResult();
            if (operationResult instanceof FailureResult) {
                SmartList smartList = new SmartList();
                for (Failure failure : ((FailureResult)operationResult).getFailures()) {
                    smartList.add(ExternalSystemUtil.a(failure));
                }
                object = new FailureResultImpl((List)smartList);
            } else {
                object = operationResult instanceof SkippedResult ? new SkippedResultImpl() : (operationResult instanceof SuccessResult ? new SuccessResultImpl(((SuccessResult)operationResult).isUpToDate()) : new SuccessResultImpl());
            }
            startEventImpl = new FinishEventImpl((Object)externalSystemProgressEvent.getEventId(), object2, l2, string, (EventResult)object);
        } else if (externalSystemProgressEvent instanceof ExternalSystemStatusEvent) {
            object = (ExternalSystemStatusEvent)externalSystemProgressEvent;
            startEventImpl = new ProgressBuildEventImpl((Object)externalSystemProgressEvent.getEventId(), object2, l2, string, object.getTotal(), object.getProgress(), object.getUnit());
        } else {
            startEventImpl = new OutputBuildEventImpl((Object)externalSystemProgressEvent.getEventId(), object2, string, true);
        }
        object = externalSystemProgressEvent.getDescriptor().getHint();
        startEventImpl.setHint((String)object);
        return startEventImpl;
    }

    private static com.intellij.build.events.Failure a(Failure failure) {
        SmartList smartList = new SmartList();
        for (Failure failure2 : failure.getCauses()) {
            smartList.add(ExternalSystemUtil.a(failure2));
        }
        return new FailureImpl(failure.getMessage(), failure.getDescription(), (List)smartList);
    }

    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId, @NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        if (taskSettings == null) {
            ExternalSystemUtil.a(41);
        }
        if (executorId == null) {
            ExternalSystemUtil.a(42);
        }
        if (project2 == null) {
            ExternalSystemUtil.a(43);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.a(44);
        }
        ExternalSystemUtil.runTask(taskSettings, executorId, project2, externalSystemId, null, ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }

    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId, @NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @Nullable TaskCallback callback, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (taskSettings == null) {
            ExternalSystemUtil.a(45);
        }
        if (executorId == null) {
            ExternalSystemUtil.a(46);
        }
        if (project2 == null) {
            ExternalSystemUtil.a(47);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.a(48);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.a(49);
        }
        ExternalSystemUtil.runTask(taskSettings, executorId, project2, externalSystemId, callback, progressExecutionMode, true);
    }

    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId, @NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @Nullable TaskCallback callback, @NotNull ProgressExecutionMode progressExecutionMode, boolean activateToolWindowBeforeRun) {
        if (taskSettings == null) {
            ExternalSystemUtil.a(50);
        }
        if (executorId == null) {
            ExternalSystemUtil.a(51);
        }
        if (project2 == null) {
            ExternalSystemUtil.a(52);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.a(53);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.a(54);
        }
        ExternalSystemUtil.runTask(taskSettings, executorId, project2, externalSystemId, callback, progressExecutionMode, activateToolWindowBeforeRun, null);
    }

    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings taskSettings, final @NotNull String executorId, final @NotNull Project project2, @NotNull ProjectSystemId externalSystemId, final @Nullable TaskCallback callback, @NotNull ProgressExecutionMode progressExecutionMode, boolean activateToolWindowBeforeRun, @Nullable UserDataHolderBase userData) {
        Object object;
        ExecutionEnvironment executionEnvironment;
        if (taskSettings == null) {
            ExternalSystemUtil.a(55);
        }
        if (executorId == null) {
            ExternalSystemUtil.a(56);
        }
        if (project2 == null) {
            ExternalSystemUtil.a(57);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.a(58);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.a(59);
        }
        if ((executionEnvironment = ExternalSystemUtil.createExecutionEnvironment(project2, externalSystemId, taskSettings, executorId)) == null) {
            return;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = executionEnvironment.getRunnerAndConfigurationSettings();
        assert (runnerAndConfigurationSettings != null);
        runnerAndConfigurationSettings.setActivateToolWindowBeforeRun(activateToolWindowBeforeRun);
        if (userData != null) {
            object = (ExternalSystemRunConfiguration)runnerAndConfigurationSettings.getConfiguration();
            userData.copyUserDataTo((UserDataHolderBase)object);
        }
        object = new TaskUnderProgress(){
            private static final long a = lb.a(-5618915679760502114L, -1194846555257586351L, MethodHandles.lookup().lookupClass()).a(256923766428401L);

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    7.a(0);
                }
                indicator.setIndeterminate(true);
                final Semaphore semaphore = new Semaphore();
                final Ref ref = new Ref((Object)false);
                Disposable disposable = Disposer.newDisposable();
                project2.getMessageBus().connect(disposable).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){
                    private static final long a = lb.a(8132061049091066151L, 8694301057173168842L, MethodHandles.lookup().lookupClass()).a(63737471850314L);

                    public void processStartScheduled(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal) {
                        if (executorIdLocal == null) {
                            1.a(0);
                        }
                        if (environmentLocal == null) {
                            1.a(1);
                        }
                        if (executorId.equals(executorIdLocal) && executionEnvironment.equals(environmentLocal)) {
                            semaphore.down();
                        }
                    }

                    public void processNotStarted(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal) {
                        if (executorIdLocal == null) {
                            1.a(2);
                        }
                        if (environmentLocal == null) {
                            1.a(3);
                        }
                        if (executorId.equals(executorIdLocal) && executionEnvironment.equals(environmentLocal)) {
                            semaphore.up();
                        }
                    }

                    public void processStarted(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal, @NotNull ProcessHandler handler) {
                        if (executorIdLocal == null) {
                            1.a(4);
                        }
                        if (environmentLocal == null) {
                            1.a(5);
                        }
                        if (handler == null) {
                            1.a(6);
                        }
                        if (executorId.equals(executorIdLocal) && executionEnvironment.equals(environmentLocal)) {
                            handler.addProcessListener((ProcessListener)new ProcessAdapter(){
                                private static final long a = lb.a(-4873617004115710358L, 6832621076983852725L, MethodHandles.lookup().lookupClass()).a(221363623065679L);

                                public void processTerminated(@NotNull ProcessEvent event) {
                                    if (event == null) {
                                        1.a(0);
                                    }
                                    ref.set((Object)(event.getExitCode() == 0 ? 1 : 0));
                                    semaphore.up();
                                }

                                private static /* synthetic */ void a(int n2) {
                                    long l2 = a ^ 0x95596E11628L;
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$7$1$1", "processTerminated"));
                                }
                            });
                        }
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        long l2 = a ^ 0x3EBB61910BC5L;
                        Object[] objectArray3 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "executorIdLocal";
                                break;
                            }
                            case 1: 
                            case 3: 
                            case 5: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "environmentLocal";
                                break;
                            }
                            case 6: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "handler";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$7$1";
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processStartScheduled";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processNotStarted";
                                break;
                            }
                            case 4: 
                            case 5: 
                            case 6: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processStarted";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                try {
                    ApplicationManager.getApplication().invokeAndWait(() -> {
                        try {
                            executionEnvironment.getRunner().execute(executionEnvironment);
                        }
                        catch (ExecutionException executionException) {
                            semaphore.up();
                            b.error((Throwable)executionException);
                        }
                    }, ModalityState.defaultModalityState());
                }
                catch (Exception exception) {
                    b.error((Throwable)exception);
                    Disposer.dispose((Disposable)disposable);
                    return;
                }
                semaphore.waitFor();
                Disposer.dispose((Disposable)disposable);
                if (callback != null) {
                    if (((Boolean)ref.get()).booleanValue()) {
                        callback.onSuccess();
                    } else {
                        callback.onFailure();
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x3851F49DD983L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$7", "execute"));
            }
        };
        String string = AbstractExternalSystemTaskConfigurationType.generateName(project2, taskSettings);
        switch (progressExecutionMode) {
            case NO_PROGRESS_SYNC: {
                object.execute((ProgressIndicator)new EmptyProgressIndicator());
                break;
            }
            case MODAL_SYNC: {
                new Task.Modal(project2, string, true, (TaskUnderProgress)object){
                    final /* synthetic */ TaskUnderProgress val$task;
                    private static final long a = lb.a(-4196704155624615096L, 9059635786738637872L, MethodHandles.lookup().lookupClass()).a(181509063891333L);
                    {
                        this.val$task = taskUnderProgress;
                        super(arg0, arg1, arg2);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            8.a(0);
                        }
                        this.val$task.execute(indicator);
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x6583E516CB59L;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$8", "run"));
                    }
                }.queue();
                break;
            }
            case NO_PROGRESS_ASYNC: {
                ApplicationManager.getApplication().executeOnPooledThread(() -> ExternalSystemUtil.a((TaskUnderProgress)object));
                break;
            }
            case IN_BACKGROUND_ASYNC: {
                new Task.Backgroundable(project2, string, (TaskUnderProgress)object){
                    final /* synthetic */ TaskUnderProgress val$task;
                    private static final long a = lb.a(-554393366375294005L, 3047053970545455708L, MethodHandles.lookup().lookupClass()).a(159059049467022L);
                    {
                        this.val$task = taskUnderProgress;
                        super(arg0, arg1);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            9.a(0);
                        }
                        this.val$task.execute(indicator);
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x264DD61EC882L;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$9", "run"));
                    }
                }.queue();
                break;
            }
            case START_IN_FOREGROUND_ASYNC: {
                new Task.Backgroundable(project2, string, true, PerformInBackgroundOption.DEAF, (TaskUnderProgress)object){
                    final /* synthetic */ TaskUnderProgress val$task;
                    private static final long a = lb.a(-6146734766120169306L, 3704190449035324115L, MethodHandles.lookup().lookupClass()).a(117706401716422L);
                    {
                        this.val$task = taskUnderProgress;
                        super(arg0, arg1, arg2, arg3);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            10.a(0);
                        }
                        this.val$task.execute(indicator);
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x47484B60AF0L;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$10", "run"));
                    }
                }.queue();
            }
        }
    }

    @Nullable
    public static ExecutionEnvironment createExecutionEnvironment(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId) {
        Executor executor;
        if (project2 == null) {
            ExternalSystemUtil.a(60);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.a(61);
        }
        if (taskSettings == null) {
            ExternalSystemUtil.a(62);
        }
        if (executorId == null) {
            ExternalSystemUtil.a(63);
        }
        if ((executor = ExecutorRegistry.getInstance().getExecutorById(executorId)) == null) {
            return null;
        }
        String string = ExternalSystemUtil.getRunnerId(executorId);
        if (string == null) {
            return null;
        }
        ProgramRunner programRunner = ProgramRunner.findRunnerById((String)string);
        if (programRunner == null) {
            return null;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = ExternalSystemUtil.createExternalSystemRunnerAndConfigurationSettings(taskSettings, project2, externalSystemId);
        if (runnerAndConfigurationSettings == null) {
            return null;
        }
        return new ExecutionEnvironment(executor, programRunner, runnerAndConfigurationSettings, project2);
    }

    @Nullable
    public static RunnerAndConfigurationSettings createExternalSystemRunnerAndConfigurationSettings(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        AbstractExternalSystemTaskConfigurationType abstractExternalSystemTaskConfigurationType;
        if (taskSettings == null) {
            ExternalSystemUtil.a(64);
        }
        if (project2 == null) {
            ExternalSystemUtil.a(65);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.a(66);
        }
        if ((abstractExternalSystemTaskConfigurationType = ExternalSystemUtil.findConfigurationType(externalSystemId)) == null) {
            return null;
        }
        String string = AbstractExternalSystemTaskConfigurationType.generateName(project2, taskSettings);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.getInstance((Project)project2).createConfiguration(string, abstractExternalSystemTaskConfigurationType.getFactory());
        ((ExternalSystemRunConfiguration)runnerAndConfigurationSettings.getConfiguration()).getSettings().setFrom(taskSettings);
        return runnerAndConfigurationSettings;
    }

    @Nullable
    public static AbstractExternalSystemTaskConfigurationType findConfigurationType(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            ExternalSystemUtil.a(67);
        }
        for (ConfigurationType configurationType : ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList()) {
            AbstractExternalSystemTaskConfigurationType abstractExternalSystemTaskConfigurationType;
            if (!(configurationType instanceof AbstractExternalSystemTaskConfigurationType) || !externalSystemId.equals((Object)(abstractExternalSystemTaskConfigurationType = (AbstractExternalSystemTaskConfigurationType)configurationType).getExternalSystemId())) continue;
            return abstractExternalSystemTaskConfigurationType;
        }
        return null;
    }

    @Nullable
    public static String getRunnerId(@NotNull String executorId) {
        if (executorId == null) {
            ExternalSystemUtil.a(68);
        }
        return a.get(executorId);
    }

    public static void linkExternalProject(final @NotNull ProjectSystemId externalSystemId, final @NotNull ExternalProjectSettings projectSettings, final @NotNull Project project2, final @Nullable Consumer<? super Boolean> executionResultCallback, boolean isPreviewMode, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (externalSystemId == null) {
            ExternalSystemUtil.a(69);
        }
        if (projectSettings == null) {
            ExternalSystemUtil.a(70);
        }
        if (project2 == null) {
            ExternalSystemUtil.a(71);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.a(72);
        }
        ExternalProjectRefreshCallback externalProjectRefreshCallback = new ExternalProjectRefreshCallback(){
            private static final long a = lb.a(-3229717627994085573L, 6651611947915187295L, MethodHandles.lookup().lookupClass()).a(41586896006636L);

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject == null) {
                    if (executionResultCallback != null) {
                        executionResultCallback.consume((Object)false);
                    }
                    return;
                }
                AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)externalSystemId);
                HashSet hashSet = ContainerUtilRt.newHashSet((Iterable)abstractExternalSystemSettings.getLinkedProjectsSettings());
                hashSet.add(projectSettings);
                abstractExternalSystemSettings.setLinkedProjectsSettings((Collection)hashSet);
                ExternalSystemUtil.ensureToolWindowInitialized(project2, externalSystemId);
                ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProject, project2, true);
                if (executionResultCallback != null) {
                    executionResultCallback.consume((Object)true);
                }
            }

            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    11.a(0);
                }
                if (executionResultCallback != null) {
                    executionResultCallback.consume((Object)false);
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0xF5AAA306CFCL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$11", "onFailure"));
            }
        };
        ExternalSystemUtil.refreshProject(project2, externalSystemId, projectSettings.getExternalProjectPath(), externalProjectRefreshCallback, isPreviewMode, progressExecutionMode);
    }

    @Nullable
    public static VirtualFile refreshAndFindFileByIoFile(@NotNull File file) {
        Application application;
        if (file == null) {
            ExternalSystemUtil.a(73);
        }
        if (!(application = ApplicationManager.getApplication()).isDispatchThread()) assert (!((ApplicationEx)application).holdsReadLock());
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    @Nullable
    public static VirtualFile findLocalFileByPath(String path) {
        VirtualFile virtualFile = StandardFileSystems.local().findFileByPath(path);
        if (virtualFile != null) {
            return virtualFile;
        }
        return !ApplicationManager.getApplication().isReadAccessAllowed() ? ExternalSystemUtil.a(path) : ExternalSystemUtil.d(path);
    }

    @Nullable
    private static VirtualFile a(String string) {
        return (VirtualFile)ExternalSystemApiUtil.doWriteAction(() -> StandardFileSystems.local().refreshAndFindFileByPath(string));
    }

    @Nullable
    private static VirtualFile d(String string) {
        return (VirtualFile)ReadAction.compute(() -> StandardFileSystems.local().findFileByPath(string));
    }

    public static void scheduleExternalViewStructureUpdate(@NotNull Project project2, @NotNull ProjectSystemId systemId) {
        ExternalProjectsView externalProjectsView;
        if (project2 == null) {
            ExternalSystemUtil.a(74);
        }
        if (systemId == null) {
            ExternalSystemUtil.a(75);
        }
        if ((externalProjectsView = ExternalProjectsManagerImpl.getInstance(project2).getExternalProjectsView(systemId)) instanceof ExternalProjectsViewImpl) {
            ((ExternalProjectsViewImpl)externalProjectsView).scheduleStructureUpdate();
        }
    }

    @Nullable
    public static ExternalProjectInfo getExternalProjectInfo(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        ExternalProjectSettings externalProjectSettings;
        if (project2 == null) {
            ExternalSystemUtil.a(76);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.a(77);
        }
        if (externalProjectPath == null) {
            ExternalSystemUtil.a(78);
        }
        if ((externalProjectSettings = ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)projectSystemId).getLinkedProjectSettings(externalProjectPath)) == null) {
            return null;
        }
        return ProjectDataManagerImpl.getInstance().getExternalProjectData(project2, projectSystemId, externalProjectSettings.getExternalProjectPath());
    }

    @NotNull
    public static ExternalSystemExecutionConsoleManager<ExternalSystemRunConfiguration, ExecutionConsole, ProcessHandler> getConsoleManagerFor(@NotNull ExternalSystemTask task) {
        if (task == null) {
            ExternalSystemUtil.a(79);
        }
        for (ExternalSystemExecutionConsoleManager externalSystemExecutionConsoleManager : (ExternalSystemExecutionConsoleManager[])ExternalSystemExecutionConsoleManager.EP_NAME.getExtensions()) {
            if (!externalSystemExecutionConsoleManager.isApplicableFor(task)) continue;
            ExternalSystemExecutionConsoleManager externalSystemExecutionConsoleManager2 = externalSystemExecutionConsoleManager;
            if (externalSystemExecutionConsoleManager2 == null) {
                ExternalSystemUtil.a(80);
            }
            return externalSystemExecutionConsoleManager2;
        }
        DefaultExternalSystemExecutionConsoleManager defaultExternalSystemExecutionConsoleManager = new DefaultExternalSystemExecutionConsoleManager();
        if (defaultExternalSystemExecutionConsoleManager == null) {
            ExternalSystemUtil.a(81);
        }
        return defaultExternalSystemExecutionConsoleManager;
    }

    public static void invokeLater(Project p2, Runnable r2) {
        ExternalSystemUtil.invokeLater(p2, ModalityState.defaultModalityState(), r2);
    }

    public static void invokeLater(Project p2, ModalityState state, Runnable r2) {
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            r2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(DisposeAwareRunnable.create((Runnable)r2, (Project)p2), state);
        }
    }

    public static boolean isNoBackgroundMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    private static /* synthetic */ void a(TaskUnderProgress taskUnderProgress) {
        taskUnderProgress.execute((ProgressIndicator)new EmptyProgressIndicator());
    }

    static {
        c = lb.a(5638138841899307602L, 293996285491688036L, MethodHandles.lookup().lookupClass()).a(102880261305466L);
        long l2 = c ^ 0x3D8D530C7B7BL;
        EXTERNAL_SYSTEM_TASK_ID_KEY = Key.create((String)"com.intellij.openapi.externalSystem.util.taskId");
        b = Logger.getInstance(ExternalSystemUtil.class);
        a = ContainerUtilRt.newHashMap();
        HASHING_STRATEGY = new TObjectHashingStrategy<Pair<ProjectSystemId, File>>(){

            public int computeHashCode(Pair<ProjectSystemId, File> object) {
                return ((ProjectSystemId)object.first).hashCode() + ExternalSystemUtil.fileHashCode((File)object.second);
            }

            public boolean equals(Pair<ProjectSystemId, File> o1, Pair<ProjectSystemId, File> o2) {
                return ((ProjectSystemId)o1.first).equals(o2.first) && ExternalSystemUtil.filesEqual((File)o1.second, (File)o2.second);
            }
        };
        a.put(DefaultRunExecutor.EXECUTOR_ID, "ExternalSystemTaskRunner");
        a.put(DefaultDebugExecutor.EXECUTOR_ID, "ExternalSystemTaskDebugRunner");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x61132EDA64E6L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 33: 
            case 39: 
            case 40: 
            case 80: 
            case 81: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 33: 
            case 39: 
            case 40: 
            case 80: 
            case 81: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 17: 
            case 22: 
            case 31: 
            case 35: 
            case 44: 
            case 48: 
            case 53: 
            case 58: 
            case 61: 
            case 66: 
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 8: 
            case 15: 
            case 20: 
            case 25: 
            case 49: 
            case 54: 
            case 59: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressExecutionMode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specBuilder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 11: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: 
            case 18: 
            case 23: 
            case 26: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpec";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 33: 
            case 39: 
            case 40: 
            case 80: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationManager";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationData";
                break;
            }
            case 41: 
            case 45: 
            case 50: 
            case 55: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskSettings";
                break;
            }
            case 42: 
            case 46: 
            case 51: 
            case 56: 
            case 63: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSettings";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil";
                break;
            }
            case 33: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createFailureResult";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleManagerFor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ensureToolWindowInitialized";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "ensureToolWindowContentInitialized";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "refreshProjects";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "extractDetails";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "refreshProject";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "printFailure";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createFailureResult";
                break;
            }
            case 33: 
            case 39: 
            case 40: 
            case 80: 
            case 81: {
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "runTask";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionEnvironment";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "createExternalSystemRunnerAndConfigurationSettings";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurationType";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getRunnerId";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "linkExternalProject";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByIoFile";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "scheduleExternalViewStructureUpdate";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectInfo";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleManagerFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 33: 
            case 39: 
            case 40: 
            case 80: 
            case 81: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyMultiExternalProjectRefreshCallback
    implements ExternalProjectRefreshCallback {
        private final Project a;

        MyMultiExternalProjectRefreshCallback(Project project2) {
            this.a = project2;
        }

        public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
            if (externalProject == null) {
                return;
            }
            ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProject, this.a, true);
        }
    }

    private static interface TaskUnderProgress {
        public void execute(@NotNull ProgressIndicator var1);
    }
}

