/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import b.a.lb;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemShortcutsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.event.InputEvent;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalSystemNode<T>
extends SimpleNode
implements Comparable<ExternalSystemNode> {
    public static final int BUILTIN_TASKS_DATA_NODE_ORDER = 10;
    public static final int BUILTIN_DEPENDENCIES_DATA_NODE_ORDER = 20;
    public static final int BUILTIN_RUN_CONFIGURATIONS_DATA_NODE_ORDER = 30;
    public static final int BUILTIN_MODULE_DATA_NODE_ORDER = 40;
    @NotNull
    public static final Comparator<ExternalSystemNode> ORDER_AWARE_COMPARATOR;
    protected static final ExternalSystemNode[] NO_CHILDREN;
    private final ExternalProjectsView d;
    private final List<ExternalSystemNode<?>> e;
    protected DataNode<T> myDataNode;
    @Nullable
    private ExternalSystemNode b;
    private ExternalSystemNode[] c;
    private ExternalProjectsStructure.ErrorLevel f;
    private final List<String> a;
    private ExternalProjectsStructure.ErrorLevel g;
    private static final long k;

    public ExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode parent) {
        if (externalProjectsView == null) {
            ExternalSystemNode.a(0);
        }
        this(externalProjectsView, parent, null);
    }

    public ExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode parent, @Nullable DataNode<T> dataNode) {
        if (externalProjectsView == null) {
            ExternalSystemNode.a(1);
        }
        super(externalProjectsView.getProject(), null);
        this.e = ContainerUtil.newArrayList();
        this.f = ExternalProjectsStructure.ErrorLevel.NONE;
        this.a = ContainerUtil.newArrayList();
        this.g = null;
        this.d = externalProjectsView;
        this.myDataNode = dataNode;
        this.b = parent;
    }

    public boolean isAutoExpandNode() {
        SimpleNode simpleNode = this.getParent();
        return simpleNode != null && simpleNode.getChildCount() == 1;
    }

    public void setParent(@Nullable ExternalSystemNode parent) {
        this.b = parent;
    }

    @Nullable
    public T getData() {
        return (T)(this.myDataNode != null ? this.myDataNode.getData() : null);
    }

    public NodeDescriptor getParentDescriptor() {
        return this.b;
    }

    public String getName() {
        String string = this.getExternalProjectsView().getDisplayName(this.myDataNode);
        return string == null ? super.getName() : string;
    }

    protected ExternalProjectsView getExternalProjectsView() {
        return this.d;
    }

    protected ExternalSystemUiAware getUiAware() {
        return this.d.getUiAware();
    }

    protected ExternalProjectsStructure getStructure() {
        return this.d.getStructure();
    }

    protected ExternalSystemShortcutsManager getShortcutsManager() {
        return this.d.getShortcutsManager();
    }

    protected ExternalSystemTaskActivator getTaskActivator() {
        return this.d.getTaskActivator();
    }

    @Nullable
    public <DataType extends ExternalSystemNode> DataType findParent(Class<DataType> parentClass) {
        ExternalSystemNode externalSystemNode = this;
        while ((externalSystemNode = externalSystemNode.b) != null && !parentClass.isInstance(externalSystemNode)) {
        }
        return (DataType)externalSystemNode;
    }

    @Nullable
    public <DataType> DataType findParentData(Class<DataType> parentDataClass) {
        ExternalSystemNode externalSystemNode = this;
        do {
            if ((externalSystemNode = externalSystemNode.b) != null) continue;
            return null;
        } while (externalSystemNode.getData() == null || !parentDataClass.isInstance(externalSystemNode.getData()));
        return (DataType)externalSystemNode.getData();
    }

    public boolean isVisible() {
        return this.getDisplayKind() != ExternalProjectsStructure.DisplayKind.NEVER && (!this.isIgnored() || this.d.getShowIgnored());
    }

    public boolean isIgnored() {
        if (this.myDataNode != null) {
            return this.myDataNode.isIgnored();
        }
        SimpleNode simpleNode = this.getParent();
        return simpleNode instanceof ExternalSystemNode && ((ExternalSystemNode)simpleNode).isIgnored();
    }

    public void setIgnored(boolean ignored) {
        if (this.myDataNode != null) {
            ExternalProjectsManager.getInstance((Project)this.d.getProject()).setIgnored(this.myDataNode, ignored);
        }
    }

    public ExternalProjectsStructure.DisplayKind getDisplayKind() {
        Class<? extends ExternalSystemNode>[] classArray = this.getStructure().getVisibleNodesClasses();
        if (classArray == null) {
            return ExternalProjectsStructure.DisplayKind.NORMAL;
        }
        for (Class<? extends ExternalSystemNode> clazz : classArray) {
            if (!clazz.isInstance(this)) continue;
            return ExternalProjectsStructure.DisplayKind.ALWAYS;
        }
        return ExternalProjectsStructure.DisplayKind.NEVER;
    }

    @NotNull
    public final ExternalSystemNode[] getChildren() {
        if (this.c == null) {
            this.c = this.a();
            this.onChildrenBuilt();
        }
        if (this.c == null) {
            ExternalSystemNode.a(2);
        }
        return this.c;
    }

    protected void onChildrenBuilt() {
    }

    @NotNull
    private ExternalSystemNode[] a() {
        List<ExternalSystemNode> list2 = this.doBuildChildren();
        if (list2.isEmpty()) {
            if (NO_CHILDREN == null) {
                ExternalSystemNode.a(3);
            }
            return NO_CHILDREN;
        }
        this.a(list2, true);
        this.sort(this.e);
        ArrayList arrayList = new ArrayList();
        for (ExternalSystemNode<?> externalSystemNode : this.e) {
            if (!externalSystemNode.isVisible()) continue;
            arrayList.add(externalSystemNode);
        }
        ExternalSystemNode[] externalSystemNodeArray = arrayList.toArray(new ExternalSystemNode[0]);
        if (externalSystemNodeArray == null) {
            ExternalSystemNode.a(4);
        }
        return externalSystemNodeArray;
    }

    public void cleanUpCache() {
        this.c = null;
        this.e.clear();
        this.g = null;
    }

    @Nullable
    protected ExternalSystemNode[] getCached() {
        return this.c;
    }

    protected void sort(List<? extends ExternalSystemNode> list2) {
        Collections.sort(list2, ORDER_AWARE_COMPARATOR);
    }

    public boolean addAll(Collection<? extends ExternalSystemNode> externalSystemNodes) {
        return this.a(externalSystemNodes, false);
    }

    private boolean a(Collection<? extends ExternalSystemNode> collection, boolean bl2) {
        if (collection.isEmpty()) {
            return false;
        }
        for (ExternalSystemNode externalSystemNode : collection) {
            externalSystemNode.setParent(this);
            this.e.add(externalSystemNode);
        }
        if (!bl2) {
            this.childrenChanged();
        }
        return true;
    }

    public boolean add(ExternalSystemNode externalSystemNode) {
        return this.addAll(ContainerUtil.list((Object[])new ExternalSystemNode[]{externalSystemNode}));
    }

    public boolean removeAll(Collection<ExternalSystemNode> externalSystemNodes) {
        return this.b(externalSystemNodes, false);
    }

    private boolean b(Collection<ExternalSystemNode> collection, boolean bl2) {
        if (collection.isEmpty()) {
            return false;
        }
        for (ExternalSystemNode externalSystemNode : collection) {
            externalSystemNode.setParent(null);
            this.e.remove(externalSystemNode);
        }
        if (!bl2) {
            this.childrenChanged();
        }
        return true;
    }

    public void remove(ExternalSystemNode externalSystemNode) {
        this.removeAll(ContainerUtil.list((Object[])new ExternalSystemNode[]{externalSystemNode}));
    }

    protected void childrenChanged() {
        for (ExternalSystemNode externalSystemNode2 = this; externalSystemNode2 != null; externalSystemNode2 = (ExternalSystemNode)externalSystemNode2.getParent()) {
            externalSystemNode2.g = null;
        }
        this.sort(this.e);
        List list2 = ContainerUtil.filter(this.e, externalSystemNode -> externalSystemNode.isVisible());
        this.c = list2.toArray(new ExternalSystemNode[0]);
        this.d.updateUpTo(this);
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    @NotNull
    protected List<? extends ExternalSystemNode> doBuildChildren() {
        if (this.myDataNode != null && !this.myDataNode.getChildren().isEmpty()) {
            ExternalProjectsView externalProjectsView = this.getExternalProjectsView();
            List<ExternalSystemNode<?>> list2 = externalProjectsView.createNodes(externalProjectsView, this, this.myDataNode);
            if (list2 == null) {
                ExternalSystemNode.a(5);
            }
            return list2;
        }
        List<ExternalSystemNode<?>> list3 = this.e;
        if (list3 == null) {
            ExternalSystemNode.a(6);
        }
        return list3;
    }

    protected void setDataNode(DataNode<T> dataNode) {
        this.myDataNode = dataNode;
    }

    public ExternalProjectsStructure.ErrorLevel getTotalErrorLevel() {
        if (this.g == null) {
            this.g = this.b();
        }
        return this.g;
    }

    private ExternalProjectsStructure.ErrorLevel b() {
        ExternalProjectsStructure.ErrorLevel errorLevel = this.getChildrenErrorLevel();
        return errorLevel.compareTo(this.f) > 0 ? errorLevel : this.f;
    }

    public ExternalProjectsStructure.ErrorLevel getChildrenErrorLevel() {
        ExternalProjectsStructure.ErrorLevel errorLevel = ExternalProjectsStructure.ErrorLevel.NONE;
        for (ExternalSystemNode externalSystemNode : this.getChildren()) {
            ExternalProjectsStructure.ErrorLevel errorLevel2 = externalSystemNode.getTotalErrorLevel();
            if (errorLevel2.compareTo(errorLevel) <= 0) continue;
            errorLevel = errorLevel2;
        }
        return errorLevel;
    }

    public void setErrorLevel(ExternalProjectsStructure.ErrorLevel level, String ... errors) {
        if (this.f == level) {
            return;
        }
        this.f = level;
        this.a.clear();
        Collections.addAll(this.a, errors);
        this.d.updateUpTo(this);
    }

    protected void doUpdate() {
        this.setNameAndTooltip(this.getName(), null);
    }

    protected void setNameAndTooltip(String name2, @Nullable String tooltip) {
        this.setNameAndTooltip(name2, tooltip, (String)null);
    }

    protected void setNameAndTooltip(String name2, @Nullable String tooltip, @Nullable String hint) {
        long l2 = k ^ 0x76EB508EE8A3L;
        boolean bl2 = this.isIgnored();
        SimpleTextAttributes simpleTextAttributes = bl2 ? SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES : this.getPlainAttributes();
        this.setNameAndTooltip(name2, tooltip, simpleTextAttributes);
        if (!StringUtil.isEmptyOrSpaces((String)hint)) {
            this.addColoredFragment(" (" + hint + ")", bl2 ? SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    protected void setNameAndTooltip(String name2, @Nullable String tooltip, SimpleTextAttributes attributes) {
        long l2 = k ^ 0x5E491DE43EC8L;
        this.clearColoredText();
        this.addColoredFragment(name2, this.a(attributes));
        String string = (tooltip != null ? tooltip + "\n\r" : "") + StringUtil.join(this.a, (String)"\n\r");
        this.getTemplatePresentation().setTooltip(string);
    }

    private SimpleTextAttributes a(SimpleTextAttributes simpleTextAttributes) {
        ExternalProjectsStructure.ErrorLevel errorLevel = this.getTotalErrorLevel();
        JBColor jBColor = errorLevel == ExternalProjectsStructure.ErrorLevel.NONE ? null : JBColor.RED;
        int n2 = simpleTextAttributes.getStyle();
        if (jBColor != null) {
            n2 |= 8;
        }
        return new SimpleTextAttributes(simpleTextAttributes.getBgColor(), simpleTextAttributes.getFgColor(), (Color)jBColor, n2);
    }

    @Nullable
    @NonNls
    protected String getActionId() {
        return null;
    }

    @Nullable
    @NonNls
    protected String getMenuId() {
        return null;
    }

    protected String message(@NotNull String key, Object ... params) {
        if (key == null) {
            ExternalSystemNode.a(7);
        }
        if (params == null) {
            ExternalSystemNode.a(8);
        }
        return ExternalSystemBundle.message((String)key, (Object[])params);
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @Nullable
    public Navigatable getNavigatable() {
        return null;
    }

    public void handleDoubleClickOrEnter(SimpleTree tree2, InputEvent inputEvent) {
        String string = this.getActionId();
        this.getExternalProjectsView().handleDoubleClickOrEnter(this, string, inputEvent);
    }

    @Override
    public int compareTo(@NotNull ExternalSystemNode node) {
        if (node == null) {
            ExternalSystemNode.a(9);
        }
        return StringUtil.compare((String)this.getName(), (String)node.getName(), (boolean)true);
    }

    static {
        k = lb.a(936895462962739374L, 3174155856942728158L, MethodHandles.lookup().lookupClass()).a(114767699088267L);
        ORDER_AWARE_COMPARATOR = new Comparator<ExternalSystemNode>(){
            private static final long a = lb.a(3022132776359734328L, 2554105179361282185L, MethodHandles.lookup().lookupClass()).a(186797201419366L);

            @Override
            public int compare(@NotNull ExternalSystemNode o1, @NotNull ExternalSystemNode o2) {
                int n2;
                int n3;
                if (o1 == null) {
                    1.a(0);
                }
                if (o2 == null) {
                    1.a(1);
                }
                if ((n3 = this.a(o1)) == (n2 = this.a(o2))) {
                    return o1.compareTo(o2);
                }
                return n3 < n2 ? -1 : 1;
            }

            private int a(@NotNull Comparable comparable) {
                Order order;
                if (comparable == null) {
                    1.a(2);
                }
                if ((order = comparable.getClass().getAnnotation(Order.class)) != null) {
                    return order.value();
                }
                return 0;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                long l2 = a ^ 0x7DB40C584444L;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemNode$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "compare";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getOrder";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        NO_CHILDREN = new ExternalSystemNode[0];
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = k ^ 0xFFEC0BBBFD6L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectsView";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalSystemNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildChildren";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

