/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import b.a.lb;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.GraphUtil;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeList;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.builder.event.GraphBuilderEventManager;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.impl.builder.EdgeCreationPolicyAdapter;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.impl.builder.GraphEditModeFactory;
import com.intellij.openapi.graph.impl.builder.GraphEventManager;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.impl.builder.GraphUpdateModel;
import com.intellij.openapi.graph.impl.builder.YBundlesInitializer;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphBuilderImpl<N, E>
extends GraphBuilder<N, E> {
    static final Logger LOG;
    private final Graph2D j;
    private final Graph2DView g;
    private final Project b;
    private final GraphDataMaps<N, E> k;
    private final GraphUpdateModel f;
    private final GraphDataModel<N, E> a;
    private final GraphPresentationModel<N, E> i;
    private final MergingUpdateQueue l;
    private Overview p;
    private boolean d;
    private boolean e;
    private final EditMode n;
    private final HierarchyManager h;
    private final List<CustomGraphUpdater> m;
    private boolean o;
    private GraphBuilderEventManager c;
    private static final long q;

    public GraphBuilderImpl(Project project2, Graph2D graph, Graph2DView view2, GraphDataModel<N, E> graphDataModel, GraphPresentationModel<N, E> graphPresentationModel) {
        long l2 = q ^ 0x53AC85488E13L;
        this.m = new ArrayList<CustomGraphUpdater>();
        this.o = false;
        this.b = project2;
        this.j = graph;
        this.g = view2;
        this.k = new GraphDataMaps(this.j);
        this.h = GraphManager.getGraphManager().createHierarchyManager((Graph)this.getGraph());
        this.a = graphDataModel;
        this.i = graphPresentationModel;
        this.f = new GraphUpdateModel((Graph)graph);
        this.g.setGraph2D(this.getGraph());
        this.n = this.createEditMode();
        this.l = new MergingUpdateQueue("YFiles", 100, true, this.g.getJComponent());
        this.g.getJComponent().setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
        this.e();
        this.c = new GraphEventManager(this.n, this);
        Disposer.register((Disposable)this, this.a);
        Disposer.register((Disposable)this, this.i);
        Disposer.register((Disposable)this, (Disposable)this.l);
    }

    public final void initialize() {
        this.g();
        this.d = true;
        this.updateGraph();
    }

    public void updateGraph() {
        try {
            this.updateDataModel();
            this.updateView();
        }
        catch (ProcessCanceledException processCanceledException) {
            this.queueUpdate();
        }
    }

    public void updateDataModel() {
        if (!this.b()) {
            this.initialize();
        }
        this.buildModel();
        GraphImplUtil.updateDraggedNodesInfo(this);
        this.a((Graph)this.getGraph());
        this.b((Graph)this.getGraph());
    }

    private void b(Graph graph) {
        Set set = this.getDataMaps().getEdgeObjectDataMap().keySet();
        for (Edge edge : set.toArray(new Edge[set.size()])) {
            if (this.isEdgeWasUpdated(edge)) continue;
            this.getDataMaps().removeEdge(edge);
        }
        for (Edge edge : graph.getEdgeArray()) {
            if (this.isEdgeWasUpdated(edge) || !graph.contains(edge)) continue;
            graph.removeEdge(edge);
        }
    }

    private void a(Graph graph, Edge edge) {
        this.getDataMaps().removeEdge(edge);
        if (graph.contains(edge)) {
            graph.removeEdge(edge);
        }
    }

    private void a(Graph graph) {
        for (Node node : graph.getNodeArray()) {
            if (!this.isNodeWasUpdated(node) && !this.a(node)) {
                this.getDataMaps().removeNode(node);
                graph.removeNode(node);
            }
            if (!this.getHierarchyManager().isFolderNode(node)) continue;
            this.a(this.getHierarchyManager().getInnerGraph(node));
            this.b(this.getHierarchyManager().getInnerGraph(node));
        }
    }

    private void g() {
        this.d();
        this.getGraphPresentationModel().customizeSettings(this.getView(), this.n);
    }

    private void d() {
        Graph2DView graph2DView = this.getView();
        this.n.allowResizeNodes(false);
        this.n.allowNodeCreation(false);
        this.n.showNodeTips(true);
        this.n.showEdgeTips(true);
        this.n.allowEdgeCreation(true);
        this.n.allowMoveLabels(false);
        this.n.allowMovePorts(false);
        this.n.allowMoveSelection(true);
        graph2DView.setAntialiasedPainting(false);
        graph2DView.setFitContentOnResize(true);
        graph2DView.setGridVisible(false);
        graph2DView.setGridResolution(20.0);
        graph2DView.setGridColor(Color.LIGHT_GRAY);
        graph2DView.setGridType(Graph2DView.GRID_POINTS);
        graph2DView.addViewMode((ViewMode)this.n);
    }

    public Overview getOverview() {
        if (this.p == null) {
            this.p = GraphManager.getGraphManager().createOverview(this.getView());
        }
        return this.p;
    }

    protected EditMode createEditMode() {
        GraphEditModeFactory graphEditModeFactory = (GraphEditModeFactory)ServiceManager.getService((Project)this.getProject(), GraphEditModeFactory.class);
        EditMode editMode = graphEditModeFactory.createEditMode(this);
        editMode.setPopupMode((ViewMode)graphEditModeFactory.createPopupMode(this));
        editMode.setCreateEdgeMode(new EdgeCreationPolicyAdapter(this.getGraphPresentationModel().getEdgeCreationPolicy(), this));
        CellEditorMode cellEditorMode = graphEditModeFactory.createCellEditorMode(this);
        editMode.assignNodeLabel(false);
        editMode.setEditNodeMode((ViewMode)cellEditorMode);
        return editMode;
    }

    public void updateView() {
        this.updateRealizers(false);
        this.h();
        this.a();
        this.f();
        for (CustomGraphUpdater customGraphUpdater : this.m) {
            customGraphUpdater.update(this.getGraph(), this.getView());
        }
        this.getGraph().updateViews();
    }

    public void updateRealizers(boolean updateAllNodes) {
        for (Node node : GraphImplUtil.getNodes((Graph)this.getGraph())) {
            if (!GraphImplUtil.isGroupNode(this.getDataMaps(), node) && (updateAllNodes || this.isNodeWasCreated(node))) {
                this.getGraph().setRealizer(node, this.getGraphPresentationModel().getNodeRealizer(this.getNodeObject(node)));
            }
            GraphViewUtil.setRenderedNodeSizes((Graph2D)this.getGraph(), (Graph2DView)this.getView(), (Node)node);
        }
        for (Edge edge : this.getGraph().getEdgeArray()) {
            if (this.isEdgeWasCreated(edge)) {
                this.getGraph().setRealizer(edge, this.getGraphPresentationModel().getEdgeRealizer(this.getEdgeObject(edge)));
                continue;
            }
            this.getGraph().setRealizer(edge, this.getGraph().getRealizer(edge));
        }
    }

    private List<Edge> i() {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        for (Edge edge : this.getGraph().getEdgeArray()) {
            if (!this.isEdgeWasCreated(edge)) continue;
            arrayList.add(edge);
        }
        return arrayList;
    }

    private List<Node> c() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.getGraph().getNodeArray()) {
            if (this.a(node) || !this.isNodeWasCreated(node)) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    private void h() {
        for (Edge edge : this.getGraph().getEdgeArray()) {
            EdgeLabel[] edgeLabelArray;
            EdgeRealizer edgeRealizer = this.getGraph().getRealizer(edge);
            GraphBuilderImpl.a(edgeRealizer);
            for (EdgeLabel edgeLabel : edgeLabelArray = this.getGraphPresentationModel().getEdgeLabels(this.getEdgeObject(edge), GraphImplUtil.getEdgeName(this.getDataMaps(), edge))) {
                edgeRealizer.addLabel(edgeLabel);
            }
        }
    }

    private static void a(EdgeRealizer edgeRealizer) {
        for (int i10 = 0; i10 < edgeRealizer.labelCount(); ++i10) {
            edgeRealizer.removeLabel(edgeRealizer.getLabel(i10));
        }
        edgeRealizer.setLabelText("");
    }

    private void f() {
        if (this.getGraph().getNodeArray().length > 0) {
            GraphUtil.doLayout((GraphBuilder)this);
            GraphViewUtil.updateWorldRect((Graph2DView)this.getView());
            this.getGraph().updateViews();
        }
    }

    public final boolean isUpdating() {
        return this.e;
    }

    public final synchronized void queueUpdate() {
        long l2 = q ^ 0x38D5C18797C8L;
        if (this.isUpdating()) {
            return;
        }
        final Cursor cursor = this.g.getJComponent().getCursor();
        this.g.getJComponent().setCursor(Cursor.getPredefinedCursor(3));
        this.e = true;
        this.l.queue(new Update("Update"){

            public void run() {
                GraphBuilderImpl.this.updateGraph();
                GraphBuilderImpl.this.e = false;
                GraphBuilderImpl.this.g.getJComponent().setCursor(cursor);
            }
        });
    }

    public GraphDataModel<N, E> getGraphDataModel() {
        return this.a;
    }

    @NotNull
    public String getNodeName(Node node) {
        String string = GraphImplUtil.getNodeName(this.getDataMaps(), node);
        if (string == null) {
            GraphBuilderImpl.a(0);
        }
        return string;
    }

    @Nullable
    public N getNodeObject(Node node) {
        return GraphImplUtil.getNodeObject(this.getDataMaps(), node);
    }

    @Nullable
    public E getEdgeObject(Edge edge) {
        return GraphImplUtil.getEdgeObject(this.getDataMaps(), edge);
    }

    public void buildModel() {
        this.getGraphUpdateModel().clearUpdateModel();
        this.createDataModel();
    }

    public void createDataModel() {
        GraphDataModel<N, E> graphDataModel = this.getGraphDataModel();
        Collection collection = graphDataModel.getNodes();
        for (Object e10 : collection) {
            this.addNode(graphDataModel.getNodeName(e10), e10);
        }
        for (Object e10 : graphDataModel.getEdges()) {
            this.addEdge(graphDataModel.getSourceNode(e10), graphDataModel.getTargetNode(e10), graphDataModel.getEdgeName(e10), e10);
        }
    }

    private void a() {
        NodeList nodeList;
        Object object3;
        Node node;
        NodesGroup nodesGroup2;
        Object object22;
        Collection<N> collection = this.getNodeObjects();
        GraphManager graphManager = GraphManager.getGraphManager();
        HashMap hashMap = new HashMap();
        for (Object object22 : collection) {
            nodesGroup2 = this.getGraphDataModel().getGroup(object22);
            if (nodesGroup2 == null) {
                Graph graph;
                node = this.getNode(object22);
                if (node == null || this.getHierarchyManager().isRootGraph(node.getGraph()) || (object3 = this.getHierarchyManager().getParentNode(node)) == null) continue;
                if (this.getHierarchyManager().isFolderNode(object3)) {
                    graph = node.getGraph();
                    nodeList = graphManager.createNodeList();
                    for (Node node2 : graph.getNodeArray()) {
                        if (this.a(node2)) continue;
                        nodeList.add((Object)node2);
                    }
                    this.getHierarchyManager().unfoldSubgraph(graph, nodeList);
                    continue;
                }
                if (!this.getHierarchyManager().isGroupNode(object3)) continue;
                graph = graphManager.createNodeList();
                graph.add((Object)node);
                this.getHierarchyManager().ungroupSubgraph((NodeList)graph);
                continue;
            }
            if (hashMap.get(nodesGroup2) == null) {
                hashMap.put(nodesGroup2, new ArrayList());
            }
            ((ArrayList)hashMap.get(nodesGroup2)).add(object22);
        }
        ArrayList arrayList = new ArrayList();
        for (NodesGroup nodesGroup2 : hashMap.keySet()) {
            boolean bl2;
            node = GraphImplUtil.getOrCreateGroupNode(this.getGraph(), this.h, nodesGroup2, this.getDataMaps());
            this.getGraphUpdateModel().setNodeWasViewed(node);
            object3 = GraphImplUtil.getGroup(this.getDataMaps(), node);
            boolean bl3 = bl2 = object3 != null ? object3.isClosed() : nodesGroup2.isClosed();
            if (bl2 && this.getHierarchyManager().isGroupNode(node)) {
                arrayList.add(node);
            }
            nodeList = graphManager.createNodeList();
            for (Object e10 : (ArrayList)hashMap.get(nodesGroup2)) {
                nodeList.add((Object)this.getNode(e10));
            }
            if (nodeList.size() <= 0 || !this.h.isGroupNode(node)) continue;
            this.h.groupSubgraph(nodeList, node);
        }
        object22 = arrayList.iterator();
        while (object22.hasNext()) {
            nodesGroup2 = (Node)object22.next();
            try {
                this.h.closeGroup((Node)nodesGroup2);
                node = this.getGraph().getRealizer((Node)nodesGroup2);
                if (!(node instanceof GroupNodeRealizer)) continue;
                ((GroupNodeRealizer)node).setGroupClosed(true);
                object3 = this.h.getInnerGraph((Node)nodesGroup2);
                if (!(object3 instanceof Graph2D)) continue;
                this.f();
            }
            catch (Throwable throwable) {
                LOG.error(throwable);
            }
        }
        for (Object object3 : this.getGraph().getNodeArray()) {
            if (this.isNodeWasUpdated((Node)object3) || !this.a((Node)object3)) continue;
            this.getGraph().removeNode(object3);
        }
    }

    private boolean a(Node node) {
        return this.h.isFolderNode(node) || this.h.isGroupNode(node);
    }

    public void addNode(N nodeObject) {
        String string = this.getGraphDataModel().getNodeName(nodeObject);
        this.addNode(string == null ? nodeObject.toString() : string, nodeObject);
    }

    public void addNode(@NotNull String name2, N nodeObject) {
        if (name2 == null) {
            GraphBuilderImpl.a(1);
        }
        this.addNode(name2, nodeObject, nodeObject);
    }

    public void addNode(@NotNull String name2, N nodeObject, Object ... equalityObjects) {
        Node node;
        if (name2 == null) {
            GraphBuilderImpl.a(2);
        }
        if ((node = GraphImplUtil.getExistedNode(this.getDataMaps(), name2, equalityObjects)) != null) {
            if (!this.getGraphUpdateModel().isNodeWasCreated(node)) {
                this.getGraphUpdateModel().setNodeWasViewed(node);
                GraphImplUtil.setNodeName(this.getDataMaps(), node, name2);
            }
        } else {
            node = GraphImplUtil.createNode((Graph)this.getGraph(), this.b(nodeObject), this.getDataMaps(), name2, equalityObjects);
            this.getGraphUpdateModel().setNodeWasCreated(node);
        }
        GraphImplUtil.setNodeObject(this.getDataMaps(), node, nodeObject);
    }

    @Nullable
    private Graph b(N n2) {
        NodesGroup nodesGroup = this.getGraphDataModel().getGroup(n2);
        if (nodesGroup != null) {
            Node node = GraphImplUtil.getOrCreateGroupNode(this.getGraph(), this.getHierarchyManager(), nodesGroup, this.getDataMaps());
            if (this.getHierarchyManager().isFolderNode(node)) {
                return this.getHierarchyManager().getInnerGraph(node);
            }
        }
        return null;
    }

    public Edge addEdge(@NotNull N nodeObject1, @NotNull N nodeObject2, E edgeObject) {
        if (nodeObject1 == null) {
            GraphBuilderImpl.a(3);
        }
        if (nodeObject2 == null) {
            GraphBuilderImpl.a(4);
        }
        return this.addEdge(nodeObject1, nodeObject2, "", edgeObject);
    }

    public Edge addEdge(@NotNull N nodeObject1, @NotNull N nodeObject2, @NotNull String name2, E edgeObject) {
        if (nodeObject1 == null) {
            GraphBuilderImpl.a(5);
        }
        if (nodeObject2 == null) {
            GraphBuilderImpl.a(6);
        }
        if (name2 == null) {
            GraphBuilderImpl.a(7);
        }
        return this.a(nodeObject1, nodeObject2, name2, edgeObject, edgeObject);
    }

    private Edge a(@NotNull N n2, @NotNull N n3, @NotNull String string, E e10, Object ... objectArray) {
        if (n2 == null) {
            GraphBuilderImpl.a(8);
        }
        if (n3 == null) {
            GraphBuilderImpl.a(9);
        }
        if (string == null) {
            GraphBuilderImpl.a(10);
        }
        Node node = this.a(n2);
        Node node2 = this.a(n3);
        return this.a(node, node2, string, e10, objectArray);
    }

    private Edge a(@NotNull Node node, @NotNull Node node2, @NotNull String string, E e10, Object ... objectArray) {
        Edge edge;
        if (node == null) {
            GraphBuilderImpl.a(11);
        }
        if (node2 == null) {
            GraphBuilderImpl.a(12);
        }
        if (string == null) {
            GraphBuilderImpl.a(13);
        }
        if ((edge = GraphImplUtil.getExistedEdge(this.getDataMaps(), node, node2, string, objectArray)) != null) {
            if (!this.getGraphUpdateModel().isEdgeWasCreated(edge)) {
                this.getGraphUpdateModel().setEdgeWasViewed(edge);
            }
        } else {
            edge = GraphImplUtil.createEdge(this.getDataMaps(), node, node2, string, objectArray);
            this.getGraphUpdateModel().setEdgeWasCreated(edge);
        }
        GraphImplUtil.setEdgeObject(this.getDataMaps(), edge, e10);
        return edge;
    }

    private Node a(N n2) {
        long l2 = q ^ 0x62D0CBA6314L;
        Node node = this.getNode(n2);
        if (node == null) {
            this.addNode(n2);
            node = this.getNode(n2);
        }
        if (node == null) {
            LOG.error("null node for " + n2 + " in " + this.a);
        }
        return node;
    }

    public void dispose() {
        this.l.cancelAllUpdates();
        if (this.o) {
            return;
        }
        this.k.dispose();
        this.o = true;
    }

    @Nullable
    public String getNodeName(N nodeObject) {
        Node node = this.getNode(nodeObject);
        return node == null ? null : GraphImplUtil.getNodeName(this.getDataMaps(), node);
    }

    @Nullable
    public String getEdgeName(E edgeObject) {
        Edge edge = this.getEdge(edgeObject);
        return edge == null ? null : GraphImplUtil.getEdgeName(this.getDataMaps(), edge);
    }

    @Nullable
    public Node getNode(N nodeObject) {
        return GraphImplUtil.getNode(this.getDataMaps(), nodeObject);
    }

    @Nullable
    public Edge getEdge(E edgeObject) {
        return GraphImplUtil.getEdge(this.getDataMaps(), edgeObject);
    }

    public boolean isNodeWasCreated(Node node) {
        return node != null && this.getGraphUpdateModel().isNodeWasCreated(node);
    }

    public boolean isEdgeWasCreated(Edge edge) {
        return edge != null && this.getGraphUpdateModel().isEdgeWasCreated(edge);
    }

    public boolean isNodeWasUpdated(Node node) {
        return node != null && this.getGraphUpdateModel().isNodeWasUpdated(node);
    }

    public boolean isEdgeWasUpdated(Edge edge) {
        return edge != null && this.getGraphUpdateModel().isEdgeWasUpdated(edge);
    }

    public final Graph2D getGraph() {
        return this.j;
    }

    public Graph2DView getView() {
        return this.g;
    }

    public Project getProject() {
        return this.b;
    }

    public GraphUpdateModel getGraphUpdateModel() {
        return this.f;
    }

    public GraphPresentationModel<N, E> getGraphPresentationModel() {
        return this.i;
    }

    private boolean b() {
        return this.d;
    }

    private void e() {
        GraphViewUtil.addDataProvider((Graph2DView)this.getView(), (DataProvider)new DataProvider(){
            private static final long a = lb.a(8718774717747681929L, 6985761738995114904L, MethodHandles.lookup().lookupClass()).a(251807069207539L);

            @Nullable
            public Object getData(@NotNull @NonNls String dataId) {
                if (dataId == null) {
                    2.a(0);
                }
                if (dataId.equals(DeleteProvider.GRAPH_DELETE_PROVIDER_KEY)) {
                    return GraphBuilderImpl.this.getGraphPresentationModel().getDeleteProvider();
                }
                if (dataId.equals(GraphBuilder.GRAPH_BUILDER_KEY)) {
                    return GraphBuilderImpl.this;
                }
                return null;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x746905FBFC24L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl$2", "getData"));
            }
        });
    }

    public HierarchyManager getHierarchyManager() {
        return this.h;
    }

    public void addCustomUpdater(CustomGraphUpdater updater) {
        this.m.add(updater);
    }

    public EditMode getEditMode() {
        return this.n;
    }

    public GraphDataMaps<N, E> getDataMaps() {
        return this.k;
    }

    public Collection<N> getNodeObjects() {
        return this.getDataMaps().getNodeObjectDataMap().values();
    }

    public Collection<E> getEdgeObjects() {
        return this.getDataMaps().getEdgeObjectDataMap().values();
    }

    public boolean removeNode(N n2) {
        Node node = this.getNode(n2);
        if (node != null) {
            this.getDataMaps().removeNode(node);
            node.getGraph().removeNode(node);
            return true;
        }
        return false;
    }

    public boolean removeEdge(E e10) {
        Edge edge = this.getEdge(e10);
        if (edge != null) {
            this.getGraph().removeEdge(edge);
            this.getDataMaps().removeEdge(edge);
            return true;
        }
        return false;
    }

    public GraphBuilderEventManager getEventManager() {
        return this.c;
    }

    static {
        q = lb.a(-6338469527237347155L, 4069572703219389361L, MethodHandles.lookup().lookupClass()).a(67167896421591L);
        long l2 = q ^ 0x510AC464237DL;
        LOG = Logger.getInstance((String)"com.intellij.openapi.graph.impl.builder.GraphBuilderImpl");
        YBundlesInitializer.init();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = q ^ 0x1E6B32DB993CL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject1";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

