/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import b.a.lb;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.IconUtil;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ProjectJdksConfigurable
extends MasterDetailsComponent {
    private final ProjectSdksModel b;
    private final Project a;
    private static final long c = lb.a(-6173517041972506216L, 2988152947878112745L, MethodHandles.lookup().lookupClass()).a(193453452119696L);

    public ProjectJdksConfigurable(Project project2) {
        this(project2, ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel());
    }

    public ProjectJdksConfigurable(Project project2, ProjectSdksModel sdksModel) {
        this.a = project2;
        this.b = sdksModel;
        this.initTree();
        this.myToReInitWholePanel = true;
        this.reInitWholePanelIfNeeded();
    }

    protected String getComponentStateKey() {
        long l2 = c ^ 0x1C53205BCA9L;
        return "ProjectJDKs.UI";
    }

    protected MasterDetailsStateService getStateService() {
        return MasterDetailsStateService.getInstance((Project)this.a);
    }

    protected void initTree() {
        super.initTree();
        new TreeSpeedSearch(this.myTree, treePath -> ((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getDisplayName(), true);
        this.myTree.setRootVisible(false);
    }

    public void reset() {
        long l2 = c ^ 0x3B4F2471BE6FL;
        super.reset();
        this.b.reset(this.a);
        this.myRoot.removeAllChildren();
        HashMap hashMap = this.b.getProjectSdks();
        for (Sdk sdk : hashMap.keySet()) {
            JdkConfigurable jdkConfigurable = new JdkConfigurable((ProjectJdkImpl)hashMap.get(sdk), this.b, this.TREE_UPDATER, this.myHistory, this.a);
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)jdkConfigurable), this.myRoot);
        }
        this.selectJdk(this.b.getProjectSdk());
        JBSplitter jBSplitter = this.a();
        if (jBSplitter != null) {
            jBSplitter.setAndLoadSplitterProportionKey("project.jdk.splitter");
        }
    }

    @Nullable
    private JBSplitter a() {
        Component[] componentArray = this.myWholePanel.getComponents();
        return componentArray.length == 1 && componentArray[0] instanceof JBSplitter ? (JBSplitter)componentArray[0] : null;
    }

    public void apply() throws ConfigurationException {
        Ref ref = Ref.create();
        try {
            super.apply();
            boolean bl2 = false;
            for (int i10 = 0; i10 < this.myRoot.getChildCount(); ++i10) {
                NamedConfigurable namedConfigurable = ((MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i10)).getConfigurable();
                if (!namedConfigurable.isModified()) continue;
                namedConfigurable.apply();
                bl2 = true;
            }
            if (this.b.isModified() || bl2) {
                this.b.apply((MasterDetailsComponent)this);
            }
            this.b.setProjectSdk(this.getSelectedJdk());
        }
        catch (ConfigurationException configurationException) {
            ref.set((Object)configurationException);
        }
        if (!ref.isNull()) {
            throw (ConfigurationException)((Object)ref.get());
        }
    }

    public boolean isModified() {
        return super.isModified() || this.b.isModified();
    }

    public void disposeUIResources() {
        this.b.disposeUIResources();
        super.disposeUIResources();
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        long l2 = c ^ 0x2C447BAA2928L;
        if (this.b == null) {
            return null;
        }
        ArrayList<AnAction> arrayList = new ArrayList<AnAction>();
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(ProjectBundle.message((String)"add.new.jdk.text", (Object[])new Object[0]), true);
        defaultActionGroup.getTemplatePresentation().setIcon(IconUtil.getAddIcon());
        this.b.createAddActions(defaultActionGroup, (JComponent)this.myTree, sdk -> {
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)new JdkConfigurable((ProjectJdkImpl)sdk, this.b, this.TREE_UPDATER, this.myHistory, this.a), false), this.myRoot);
            this.selectNodeInTree((DefaultMutableTreeNode)ProjectJdksConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)sdk));
        }, SimpleJavaSdkType.notSimpleJavaSdkType());
        arrayList.add((AnAction)new MasterDetailsComponent.MyActionGroupWrapper((MasterDetailsComponent)this, (ActionGroup)defaultActionGroup));
        arrayList.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this, Conditions.alwaysTrue()));
        return arrayList;
    }

    protected void processRemovedItems() {
        HashSet<Sdk> hashSet = new HashSet<Sdk>();
        for (int i10 = 0; i10 < this.myRoot.getChildCount(); ++i10) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.myRoot.getChildAt(i10);
            NamedConfigurable namedConfigurable = (NamedConfigurable)defaultMutableTreeNode.getUserObject();
            hashSet.add(((JdkConfigurable)namedConfigurable).getEditableObject());
        }
        HashMap hashMap = new HashMap(this.b.getProjectSdks());
        for (NamedConfigurable namedConfigurable : hashMap.values()) {
            if (hashSet.contains(namedConfigurable)) continue;
            this.b.removeSdk((Sdk)namedConfigurable);
        }
    }

    protected boolean wasObjectStored(Object editableObject) {
        return this.b.getProjectSdks().containsKey((Sdk)editableObject);
    }

    @Nullable
    public Sdk getSelectedJdk() {
        return (Sdk)this.getSelectedObject();
    }

    public void selectJdk(Sdk projectJdk) {
        this.selectNodeInTree(projectJdk);
    }

    @Nullable
    public String getDisplayName() {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    protected String getEmptySelectionString() {
        long l2 = c ^ 0x7BB1E3B70C6AL;
        return "Select an SDK to view or edit its details here";
    }

    public void selectJdkVersion(JavaSdkVersion requiredJdkVersion) {
        for (Sdk sdk : this.b.getSdks()) {
            if (!JavaSdk.getInstance().isOfVersionOrHigher(sdk, requiredJdkVersion)) continue;
            this.selectJdk(sdk);
            break;
        }
    }
}

