/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import b.a.lb;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ManifestFilesInfo {
    private static final Logger c;
    private final Map<VirtualFile, ManifestFileConfiguration> a = new HashMap<VirtualFile, ManifestFileConfiguration>();
    private final Map<VirtualFile, ManifestFileConfiguration> b = new HashMap<VirtualFile, ManifestFileConfiguration>();
    private static final long d;

    @Nullable
    public ManifestFileConfiguration getManifestFile(CompositePackagingElement<?> element, ArtifactType artifactType, PackagingElementResolvingContext context) {
        VirtualFile virtualFile = ManifestFileUtil.findManifestFile(element, context, artifactType);
        if (virtualFile == null) {
            return null;
        }
        ManifestFileConfiguration manifestFileConfiguration = this.a.get(virtualFile);
        if (manifestFileConfiguration == null) {
            manifestFileConfiguration = ManifestFileUtil.createManifestFileConfiguration(virtualFile);
            this.b.put(virtualFile, new ManifestFileConfiguration(manifestFileConfiguration));
            this.a.put(virtualFile, manifestFileConfiguration);
        }
        return manifestFileConfiguration;
    }

    public void saveManifestFiles() {
        long l2 = d ^ 0x5C9B37A7462AL;
        for (Map.Entry<VirtualFile, ManifestFileConfiguration> entry : this.a.entrySet()) {
            ManifestFileConfiguration manifestFileConfiguration;
            ManifestFileConfiguration manifestFileConfiguration2 = entry.getValue();
            String string = manifestFileConfiguration2.getManifestFilePath();
            if (string == null || (manifestFileConfiguration = this.b.get(entry.getKey())) != null && manifestFileConfiguration.equals((Object)manifestFileConfiguration2)) continue;
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(string);
            if (virtualFile == null) {
                File file = new File(FileUtil.toSystemDependentName((String)string));
                FileUtil.createIfDoesntExist((File)file);
                virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
                if (virtualFile == null) {
                    c.error("cannot create file: " + file);
                }
            }
            ManifestFileUtil.updateManifest(virtualFile, manifestFileConfiguration2.getMainClass(), manifestFileConfiguration2.getClasspath(), true);
        }
    }

    public boolean isManifestFilesModified() {
        return !this.b.equals(this.a);
    }

    public void clear() {
        this.a.clear();
        this.b.clear();
    }

    static {
        d = lb.a(1849797404523301873L, -4221569617915241964L, MethodHandles.lookup().lookupClass()).a(179746712886416L);
        long l2 = d ^ 0x1CE91056AE36L;
        c = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.artifacts.ManifestFilesInfo");
    }
}

